-- --------------------------------------------------------------------
-- >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
-- --------------------------------------------------------------------
-- Copyright (c) 2005 by Lattice Semiconductor Corporation
-- --------------------------------------------------------------------
--
--
--                     Lattice Semiconductor Corporation
--                     5555 NE Moore Court
--                     Hillsboro, OR 97214
--                     U.S.A.
--
--                     TEL: 1-800-Lattice  (USA and Canada)
--                          1-408-826-6000 (other locations)
--
--                     web: http://www.latticesemi.com/
--                     email: techsupport@latticesemi.com
--
-- --------------------------------------------------------------------
--
-- Simulation Library File for ORCA4
--
-- $Header: /home/dmsys/pvcs/RCSMigTest/rcs/vhdl/pkg/vhdsclibs/data/orca4/src/RCS/ORCA_MIS.vhd,v 1.31 2005/05/19 20:33:55 pradeep Exp $ 
--


--
----- package mem3 -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;

PACKAGE mem3 IS
   TYPE mem_type_5 IS array (Integer range <>) OF std_logic_vector(17 downto 0);
   TYPE mem_type_6 IS array (Integer range <>) OF std_logic_vector(15 downto 0);
   FUNCTION hex2bin (hex: character) RETURN std_logic_vector;
   FUNCTION init_ram (hex: string) RETURN mem_type_5;
   FUNCTION init_ram1 (hex: string) RETURN mem_type_6;
END mem3;

PACKAGE BODY mem3 IS

   FUNCTION hex2bin (hex: character) RETURN std_logic_vector IS
        VARIABLE result : std_logic_vector (3 downto 0);
   BEGIN
        CASE hex IS
          WHEN '0' =>
             result := "0000";
          WHEN '1' =>
             result := "0001";
          WHEN '2' =>
             result := "0010";
          WHEN '3' =>
             result := "0011";
          WHEN '4' =>
             result := "0100";
          WHEN '5' =>
             result := "0101";
          WHEN '6' =>
             result := "0110";
          WHEN '7' =>
             result := "0111";
          WHEN '8' =>
             result := "1000";
          WHEN '9' =>
             result := "1001";
          WHEN 'A'|'a' =>
             result := "1010";
          WHEN 'B'|'b' =>
             result := "1011";
          WHEN 'C'|'c' =>
             result := "1100";
          WHEN 'D'|'d' =>
             result := "1101";
          WHEN 'E'|'e' =>
             result := "1110";
          WHEN 'F'|'f' =>
             result := "1111";
          WHEN 'X'|'x' =>
             result := "XXXX";
          WHEN others =>
             NULL;
        END CASE;
        RETURN result;
   END;

   FUNCTION str5_slv18 (s : string(5 downto 1)) return std_logic_vector is
        VARIABLE result : std_logic_vector(17 downto 0);
   BEGIN
       FOR i in 0 to 3 LOOP
          result(((i+1)*4)-1 downto (i*4)) := hex2bin(s(i+1));
       END LOOP;
          result(17 downto 16) := hex2bin(s(5))(1 downto 0);
       RETURN result;
   END;

   FUNCTION str4_slv16 (s : string(4 downto 1)) return std_logic_vector is
        VARIABLE result : std_logic_vector(15 downto 0);
   BEGIN
       FOR i in 0 to 3 LOOP
          result(((i+1)*4)-1 downto (i*4)) := hex2bin(s(i+1));
       END LOOP;
       RETURN result;
   END;

   FUNCTION init_ram (hex: string) RETURN mem_type_5 IS
        CONSTANT length : integer := hex'length;
        VARIABLE result : mem_type_5 (0 to ((length/5)-1));
   BEGIN
       FOR i in 0 to ((length/5)-1) LOOP
         result(i) := str5_slv18(hex((i+1)*5 downto (i*5)+1));
       END LOOP;
       RETURN result;
   END;

   FUNCTION init_ram1 (hex: string) RETURN mem_type_6 IS
        CONSTANT length : integer := hex'length;
        VARIABLE result : mem_type_6 (0 to ((length/4)-1));
   BEGIN
       FOR i in 0 to ((length/4)-1) LOOP
         result(i) := str4_slv16(hex((i+1)*4 downto (i*4)+1));
       END LOOP;
       RETURN result;
   END;

END mem3 ;


--
----- cell pll1 -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;


-- entity declaration --
ENTITY pll1 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "pll1";
      tpd_clkin_clkout: VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_clkin_lock  : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tipd_clkin      : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      clkin               : IN std_logic;
      clkout, lock        : OUT std_logic);
    ATTRIBUTE Vital_Level0 OF pll1 : ENTITY IS TRUE;

END pll1;

-- architecture body --
ARCHITECTURE v OF pll1 IS
   ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

   SIGNAL clkin_ipd  : std_logic := 'X';

BEGIN

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(clkin_ipd, clkin, tipd_clkin);
   END BLOCK;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VitalBehavior : PROCESS (clkin_ipd)

   -- functionality results
   VARIABLE results : std_logic_vector(1 to 2) := (others => 'X');
   ALIAS clkout_zd : std_ulogic is results(1);
   ALIAS lock_zd   : std_ulogic is results(2);

   -- output glitch detection variables
   VARIABLE clkout_GlitchData : VitalGlitchDataType;
   VARIABLE lock_GlitchData   : VitalGlitchDataType;

   BEGIN

    IF (TimingChecksOn) THEN
    END IF;

    -----------------------------------
    -- Functionality Section.
    -----------------------------------
    IF (clkin_ipd'event AND clkin_ipd = '1') THEN
    clkout_zd := VitalBUF(clkin_ipd);
    lock_zd := '1';
    ELSE
    clkout_zd := VitalBUF(clkin_ipd);
    END IF;

    -----------------------------------
    -- Path Delay Section.
    -----------------------------------
    VitalPathDelay01 (
     OutSignal => clkout,
     OutSignalName => "clkout",
     OutTemp => clkout_zd,
     Paths => (0 => (clkin_ipd'last_event, tpd_clkin_clkout, TRUE)),
     GlitchData => clkout_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);

    VitalPathDelay01 (
     OutSignal => lock,
     OutSignalName => "lock",
     OutTemp => lock_zd,
     Paths => (0 => (clkin_ipd'last_event, tpd_clkin_lock, TRUE)),
     GlitchData => lock_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);

END PROCESS;

END V;



--
----- cell pll2 -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;


-- entity declaration --
ENTITY pll2 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "pll2";
      tpd_clkin_clkout: VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_clkin_lock  : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tipd_clkin      : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      clkin               : IN std_logic;
      clkout, lock        : OUT std_logic);
    ATTRIBUTE Vital_Level0 OF pll2 : ENTITY IS TRUE;

END pll2;

-- architecture body --
ARCHITECTURE v OF pll2 IS
   ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

   SIGNAL clkin_ipd  : std_logic := 'X';

BEGIN

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(clkin_ipd, clkin, tipd_clkin);
   END BLOCK;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VitalBehavior : PROCESS (clkin_ipd)

   -- functionality results
   VARIABLE results : std_logic_vector(1 to 2) := (others => 'X');
   ALIAS clkout_zd : std_ulogic is results(1);
   ALIAS lock_zd   : std_ulogic is results(2);

   -- output glitch detection variables
   VARIABLE clkout_GlitchData : VitalGlitchDataType;
   VARIABLE lock_GlitchData   : VitalGlitchDataType;

   BEGIN

    IF (TimingChecksOn) THEN
    END IF;

    -----------------------------------
    -- Functionality Section.
    -----------------------------------
    IF (clkin_ipd'event AND clkin_ipd = '1') THEN
    clkout_zd := VitalBUF(clkin_ipd);
    lock_zd := '1';
    ELSE
    clkout_zd := VitalBUF(clkin_ipd);
    END IF;

    -----------------------------------
    -- Path Delay Section.
    -----------------------------------
    VitalPathDelay01 (
     OutSignal => clkout,
     OutSignalName => "clkout",
     OutTemp => clkout_zd,
     Paths => (0 => (clkin_ipd'last_event, tpd_clkin_clkout, TRUE)),
     GlitchData => clkout_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);

    VitalPathDelay01 (
     OutSignal => lock,
     OutSignalName => "lock",
     OutTemp => lock_zd,
     Paths => (0 => (clkin_ipd'last_event, tpd_clkin_lock, TRUE)),
     GlitchData => lock_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);

END PROCESS;

END V;


--
----- cell ppll -----
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use work.global.gsrnet;
use work.global.purnet;

-- entity declaration --
ENTITY ppll IS
   GENERIC (
      div0               : Integer   := 1;
      div1               : Integer   := 1;
      div2               : Integer   := 1;
      div3               : Integer   := 1;
      mclkmode           : String    := "BYPASS";
      nclkmode           : String    := "BYPASS";
      vcotap             : Integer   := 4;
      disabled_gsr       : std_logic := '1';
      TimingChecksOn     : Boolean   := TRUE;
      XOn                : Boolean   := FALSE;
      MsgOn              : Boolean   := TRUE;
      InstancePath       : String    := "ppll";
      tpd_clkin_mclk     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_clkin_nclk     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_clkin_lock     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_clkin_intfb    : VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_fb_mclk        : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_fb_nclk        : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_fb_lock        : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_fb_intfb       : VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_clkin         : VitalDelayType01 := (0 ns, 0 ns);
      tipd_fb            : VitalDelayType01 := (0 ns, 0 ns));

   PORT(
      clkin              : in std_logic;
      fb                 : in std_logic;
      mclk               : out std_logic;
      nclk               : out std_logic;
      lock               : out std_logic;
      intfb              : out std_logic);

    ATTRIBUTE Vital_Level0 OF ppll : ENTITY IS TRUE;

END ppll ;

-- ARCHITECTURE body --
ARCHITECTURE V OF ppll IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;
    SIGNAL clkin_ipd          : std_logic := '0';
    SIGNAL fb_ipd             : std_logic := '0';
    SIGNAL set_reset          : std_logic := '0';
    SIGNAL false_int          : std_logic := '0';
    SIGNAL false_mck          : std_logic := '0';
    SIGNAL false_nck          : std_logic := '0';
    SIGNAL false_t_int        : time := 0 ns;
    SIGNAL false_t1_int       : time := 5 ns;
    SIGNAL t_in_clk           : time := 0 ns;
    SIGNAL set_reset_time     : time := 0 ns;
    SIGNAL t_vco              : time := 0 ns;
    SIGNAL ha_vco             : time := 0 ns;
    SIGNAL t_in_clk1          : time := 0 ns;
    SIGNAL t_in_clk2          : time := 0 ns;
    SIGNAL t_in_clk3          : time := 0 ns;
    SIGNAL clock_valid        : std_logic := '0';
    SIGNAL clock_invalid      : std_logic := '0';
    SIGNAL t_fb_clk           : time := 0 ns;
    SIGNAL t_intfb_clock      : time := 0 ns;
    SIGNAL ha_intfb_clk       : time := 0 ns;
    SIGNAL clkfb_per_valid    : std_logic := '0';
    SIGNAL ext_divider        : Real := 1.0 ;
    SIGNAL net_divide         : Real := 1.0 ;
    SIGNAL lock_all           : std_logic := '0';
    SIGNAL vir_mclk           : std_logic := '0';
    SIGNAL vir_nclk           : std_logic := '0';
    SIGNAL vir_lock           : std_logic := '0';
    SIGNAL vir_intfb          : std_logic := '0';
    SIGNAL intfb_out          : std_logic := '0';
    SIGNAL new_int            : std_logic := '0';
    SIGNAL final_mclk         : std_logic := '0';
    SIGNAL final_nclk         : std_logic := '0';
    SIGNAL div0_reg           : Integer   := 0;
    SIGNAL div1_reg           : Integer   := 0;
    SIGNAL div2_reg           : Integer   := 0;
    SIGNAL div3_reg           : Integer   := 0;
    SIGNAL vcotap_reg         : Integer   := 0;
    SIGNAL ratio1             : Integer   := 0;
    SIGNAL virtual_delay1     : time := 0 ps;
    SIGNAL real_delay1        : time := 0 ps;
    SIGNAL real_delay2        : time := 0 ps;
    SIGNAL real_delay         : time := 0 ps;
    SIGNAL total_fb_delay     : time := 0 ps;
    SIGNAL intfb_du_out       : std_logic := '0';
    SIGNAL mn_duty_clk        : std_logic := '0';
    SIGNAL mn_duty_clk1       : std_logic := '0';
    SIGNAL duty_mnclk         : std_logic := '0';
    SIGNAL pshift_mclk        : std_logic := '0';
    SIGNAL final_intfb        : std_logic := '0';
    SIGNAL final_lock         : std_logic := '0';
    SIGNAL duty_lock          : std_logic := '0';

BEGIN

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(clkin_ipd, clkin, tipd_clkin);
   VitalWireDelay(fb_ipd, fb, tipd_fb);
   END BLOCK;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   div0_reg <= div0;
   div1_reg <= div1;
   div2_reg <= div2;
   div3_reg <= div3;
   vcotap_reg <= vcotap;

--   lock_count <= div2_reg * div3_reg;

   GLOBALRESET : PROCESS (purnet, gsrnet)
    BEGIN
      IF (disabled_gsr =  '1') THEN
         set_reset <= purnet;
      ELSE
         set_reset <= purnet AND gsrnet;
      END IF;
    END PROCESS;

--------------------------------------------------------------------
-- Generate False Clocks
--------------------------------------------------------------------
   P1 : PROCESS
   VARIABLE first_time : boolean := true;
   BEGIN
        IF (first_time) THEN
          Wait for 5 ns;
          false_int <= NOT false_int;
          first_time := false;
        ELSE
          false_int <= NOT false_int;
          Wait for false_t1_int;
        END IF;
   END PROCESS;

   P2 : PROCESS (new_int)
   VARIABLE index : Integer := 0;
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (new_int'event) THEN
         IF (first_time) THEN
            IF (new_int = '1') THEN
               false_mck <= '1';
               first_time := false;
               index := 0;
            END IF;
         ELSE
            index := index + 1;
            IF (index = div2) THEN
               false_mck <= NOT false_mck;
               index := 0;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   P3 : PROCESS (new_int)
   VARIABLE index : Integer := 0;
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (new_int'event) THEN
         IF (first_time) THEN
            IF (new_int = '1') THEN
               false_nck <= '1';
               first_time := false;
               index := 0;
            END IF;
         ELSE
            index := index + 1;
            IF (index = div3) THEN
               false_nck <= NOT false_nck;
               index := 0;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   P4 : PROCESS (set_reset, false_int)
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (set_reset = '0') THEN
         new_int  <= '0';
      ELSE
        IF (first_time) THEN
           IF (false_int'event and false_int = '1') THEN
              new_int <= '1';
              first_time := false;
           END IF;
        ELSE
           new_int <= false_int;
        END IF;
      END IF;
   END PROCESS;

---------------------------------------------------------------------
-- Measure input clock and feedback clock period
---------------------------------------------------------------------
   CLKIN_PERIOD : PROCESS (clkin_ipd)
   VARIABLE last_clock_edge, next_clock_edge : time := 0 ps;
   BEGIN
      IF (clkin_ipd'event and clkin_ipd = '1') THEN
           last_clock_edge := next_clock_edge;
           next_clock_edge := NOW;
           IF (last_clock_edge > 0 ps) THEN
                t_in_clk <= next_clock_edge - last_clock_edge;
                t_in_clk1 <= t_in_clk;
                t_in_clk2 <= t_in_clk1;
                t_in_clk3 <= t_in_clk2;
           END IF;
           IF (t_in_clk > 0 ps) THEN
             IF ((t_in_clk = t_in_clk1) and (t_in_clk = t_in_clk2) and (t_in_clk = t_in_clk3)) THEN
                  clock_valid <= '1';
             ELSE
                  clock_valid <= '0';
             END IF;
           END IF;
           IF (t_in_clk > 0 ps) THEN
             IF (t_in_clk = t_in_clk1) THEN
                  clock_invalid <= '0';
             ELSE
                  clock_invalid <= '1';
             END IF;
           END IF;
      END IF;
   END PROCESS;

   RESET_PERIOD : PROCESS (clkin_ipd)
   VARIABLE last_clock_edge, next_clock_edge, reset_in_clk : time := 0 ps;
   BEGIN
      IF (set_reset = '0') THEN
         IF (clkin_ipd'event and clkin_ipd = '1') THEN
              last_clock_edge := next_clock_edge;
              next_clock_edge := NOW;
              IF (last_clock_edge > 0 ps) THEN
                   reset_in_clk := next_clock_edge - last_clock_edge;
                   set_reset_time <= set_reset_time + reset_in_clk;
              END IF;
          END IF;
      ELSE
         set_reset_time <= 0 ps;

      END IF;
   END PROCESS;

   RESET_WARNING : PROCESS (clkin_ipd)
   BEGIN
      IF (clkin_ipd'event) THEN
         IF (set_reset = '0') THEN
            assert (set_reset_time <= t_in_clk * 3)
            report "Global-Reset time too long. Assert global-reset for less than three clock cycles to avoid zero delay oscillation"
            severity WARNING;
         END IF;
      END IF;
   END PROCESS;
 

   P6 : PROCESS (t_in_clk)
   BEGIN
      IF (t_in_clk > 0 ps) THEN
         t_vco  <= ((t_in_clk * div0_reg) / div1_reg);  -- vco oscillating cycle
      END IF;
   END PROCESS;

   ha_vco <= (t_vco / 2);  -- vco oscillating half-cycle

   FB_PERIOD : PROCESS (fb_ipd)
   VARIABLE last_clock_edge : time := 0 ps;
   VARIABLE next_clock_edge : time := 0 ps;
   VARIABLE first_time      : Boolean := true;
   BEGIN
      IF (fb_ipd'event and fb_ipd = '1') THEN
           last_clock_edge := next_clock_edge;
           next_clock_edge := NOW;
           IF (last_clock_edge > 0 ps) THEN
             IF (first_time) THEN
                t_fb_clk <= next_clock_edge - last_clock_edge;
                first_time := false;
             END IF;
           END IF;
      END IF;
      IF (last_clock_edge > 0 ps) THEN
           clkfb_per_valid <= '1';
      END IF;
   END PROCESS;

------------------------------------------------
-- measure the feedback delay value
------------------------------------------------
   GENERATE_FIRST_FD_EDGE : PROCESS (new_int, fb_ipd)
   VARIABLE new_int_first_time : boolean := true;
   VARIABLE fb_first_time : boolean := true;
   VARIABLE first_int_edge : time := 0 ps;
   VARIABLE first_fb_edge : time := 0 ps;
   BEGIN
      if (new_int'event and new_int'last_value = '0' and new_int = '1') then
         if (new_int_first_time) then
            first_int_edge := NOW;
            new_int_first_time := false;
         end if;
      end if;
      if (fb_ipd'event and fb_ipd'last_value = '0' and fb_ipd = '1') then
         if (fb_first_time) then
            first_fb_edge := NOW;
            fb_first_time := false;
         end if;
      end if;
         total_fb_delay <= first_fb_edge - first_int_edge ;
   END PROCESS;

   DELAY1 : PROCESS (total_fb_delay, t_in_clk, ratio1, virtual_delay1)
   BEGIN
      IF ((total_fb_delay > 0 ps) and (t_in_clk > 0 ps)) THEN
          ratio1 <= total_fb_delay / t_in_clk;
          virtual_delay1 <= total_fb_delay - (t_in_clk * ratio1);
          real_delay1 <= t_in_clk - virtual_delay1 ;
      END IF;
   END PROCESS;

-------------------------------------------------
-- Assume Internal dedicated feedback
-------------------------------------------------
   false_t_int <= 2 * false_t1_int;

   INT_FB : PROCESS (t_fb_clk, false_t_int)
   BEGIN
      IF (false_t_int > 0 ps) THEN
         ext_divider <= (real(time'pos(t_fb_clk)) / real(time'pos(false_t_int)));
      END IF;
   END PROCESS;

----------------------------------------------------
-- Generate internal-feedback clock period
----------------------------------------------------
   net_divide <= (real(div1_reg) * ext_divider);

   P5 : PROCESS (net_divide, t_in_clk)
   BEGIN
      IF (net_divide > 0.0) THEN
         t_intfb_clock <= ((t_in_clk * div0) / (net_divide));
      END IF;
   END PROCESS;

   ha_intfb_clk  <= (t_intfb_clock / 2);

-------------------------------------------------------
-- Generate all CLOCKs in DELAY MODE
-------------------------------------------------------
   P8 : PROCESS
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (mclkmode = "DELAY" and nclkmode = "DELAY") THEN
         IF (first_time) THEN
            WAIT until (clock_valid'event and clock_valid = '1');
            intfb_out <= '1';
            first_time := false;
         ELSIF (clock_valid = '1') THEN
            WAIT FOR ha_intfb_clk;
            intfb_out <= NOT intfb_out;
         ELSIF (clock_valid = '0') THEN
            WAIT FOR t_intfb_clock;
            intfb_out <= intfb_out;
            first_time := true;
         END IF;
      ELSE
         Wait;
      END IF;
   END PROCESS;

   real_delay2 <= ((t_in_clk * vcotap_reg) / 8);

   real_delay <= (real_delay1 + real_delay2);

   P11 : PROCESS (set_reset, intfb_out)
   BEGIN
      IF (set_reset = '0') THEN
         vir_intfb <= '0';
      ELSE
         vir_intfb <= transport intfb_out after real_delay;
      END IF;
   END PROCESS;

   P9 : PROCESS (vir_intfb)
   VARIABLE index1 : Integer := 0;
   VARIABLE index2 : Integer := 0;
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (vir_intfb'event) THEN
         IF (first_time) THEN
            IF (vir_intfb = '1') THEN
               vir_mclk <= '1';
               vir_nclk <= '1';
               vir_lock <= '1';
               first_time := false;
               index1 := 0;
               index2 := 0;
            END IF;
         ELSE
            index1 := index1 + 1;
            index2 := index2 + 1;
            IF (index1 = div2_reg) THEN
               vir_mclk <= NOT vir_mclk;
               index1 := 0;
            END IF;
            IF (index2 = div3_reg) THEN
               vir_nclk <= NOT vir_nclk;
               index2 := 0;
            END IF;
         END IF;
      END IF;
   END PROCESS;

-------------------------------------------------------
-- Generate all CLOCKs in DUTYCYCLE and PHSHIFT MODE
-------------------------------------------------------
   P12 : PROCESS
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (first_time) THEN
         WAIT until (clock_valid'event and clock_valid = '1');
         intfb_du_out <= '1';
         mn_duty_clk <= '1';
         first_time := false;
      ELSIF (clock_valid = '1') THEN
         WAIT FOR ha_vco;
         intfb_du_out <= NOT intfb_du_out;
         mn_duty_clk <= NOT mn_duty_clk;
      ELSIF (clock_valid = '0') THEN
         intfb_du_out <= '0';
         mn_duty_clk <= '0';
         first_time := true;
      END IF;
   END PROCESS;

   DELAY2 : PROCESS (mn_duty_clk)
   BEGIN
      IF (real_delay1 > 0 ps) THEN
         mn_duty_clk1 <= transport mn_duty_clk after real_delay1;
      ELSE
         mn_duty_clk1 <= mn_duty_clk;
      END IF;
   END PROCESS;


-------------------------------------------------------
-- Generate LOCK signal
-------------------------------------------------------
   LOCK_IT : PROCESS (set_reset, vir_lock, clock_invalid, clock_valid)
   BEGIN
      IF (set_reset = '0') THEN
         lock_all <= '0';
      ELSE
        IF clock_invalid = '1' THEN
           lock_all <= '0';
        ELSIF clock_valid = '0' THEN
           lock_all <= '0';
        ELSIF clock_valid = '1' THEN
           lock_all <= vir_lock;
        END IF;
      END IF;
   END PROCESS;

-------------------------------------------------------
-- Calculate DUTYCYCLE values and create clocks
-------------------------------------------------------
   DUTY_CK : PROCESS (mn_duty_clk1, clock_valid)
   VARIABLE mnclock_duty : time := 0 ps;
   BEGIN
      IF (vcotap_reg > 0) THEN
         mnclock_duty := ((t_vco * vcotap_reg) / 8);
      END IF;
      IF (mnclock_duty > 0 ps) THEN
         IF (mn_duty_clk1'event and mn_duty_clk1 = '1') THEN
            duty_mnclk <= '1';
            duty_mnclk <= transport '0' after mnclock_duty;
         END IF;

         IF (clock_valid = '0') THEN
            duty_lock <= '0';
         ELSE
            duty_lock <= '1';
         END IF;
      END IF;
   END PROCESS;

-------------------------------------------------------
-- Calculate DELAY values and create clocks
-------------------------------------------------------
   DELAY_CK : PROCESS (mn_duty_clk1)
   VARIABLE mclock_delay : time := 0 ps;
   BEGIN
         mclock_delay := ((t_vco * vcotap_reg) / 8);
         pshift_mclk <= transport mn_duty_clk1 after mclock_delay;
   END PROCESS;

-------------------------------------------------------
-- Select clocks with appropriate modes
-------------------------------------------------------
   P101 : PROCESS (clkin_ipd, duty_mnclk, mn_duty_clk1, pshift_mclk, intfb_du_out, vir_mclk, vir_nclk, vir_intfb, lock_all, duty_lock)
   BEGIN
      IF (mclkmode = "BYPASS" and nclkmode = "BYPASS") THEN
         final_mclk <= clkin_ipd;
         final_nclk <= clkin_ipd;
         final_intfb <= clkin_ipd;
         IF (clkin_ipd'event AND clkin_ipd = '1') THEN
            final_lock <= '1';
         END IF;
      END IF;
      IF (mclkmode = "DUTYCYCLE" and nclkmode = "DUTYCYCLE") THEN
         final_mclk <= duty_mnclk;
         final_nclk <= duty_mnclk;
         final_intfb <= intfb_du_out;
         final_lock <= duty_lock;
      END IF;
      IF (mclkmode = "PHSHIFT" and nclkmode = "PHSHIFT") THEN
         final_mclk <= pshift_mclk;
         final_nclk <= mn_duty_clk1;
         final_intfb <= intfb_du_out;
         final_lock <= duty_lock;
      END IF;
      IF (mclkmode = "DELAY" and nclkmode = "DELAY") THEN
         final_mclk <= vir_mclk;
         final_nclk <= vir_nclk;
         final_intfb <= vir_intfb;
         final_lock <= lock_all;
      END IF;

   END PROCESS;

   VitalBehavior : PROCESS (clock_valid, final_mclk, final_nclk, final_lock, final_intfb, false_mck, false_nck, new_int)

   -- functionality results
   VARIABLE results : std_logic_vector(1 to 4) := (others => '0');
   ALIAS mclk_zd : std_ulogic is results(1);
   ALIAS nclk_zd : std_ulogic is results(2);
   ALIAS lock_zd : std_ulogic is results(3);
   ALIAS intfb_zd : std_ulogic is results(4);

   -- output glitch detection variables
   VARIABLE mclk_GlitchData : VitalGlitchDataType;
   VARIABLE nclk_GlitchData : VitalGlitchDataType;
   VARIABLE lock_GlitchData : VitalGlitchDataType;
   VARIABLE intfb_GlitchData : VitalGlitchDataType;

   BEGIN

    IF (TimingChecksOn) THEN
    END IF;

    -----------------------------------
    -- Functionality Section.
    -----------------------------------
    IF (set_reset = '0') THEN
      mclk_zd := '0';
      nclk_zd := '0';
      lock_zd := '0';
      intfb_zd := '0';
    ELSE
      IF (mclkmode = "BYPASS" and nclkmode = "BYPASS") THEN
            mclk_zd := final_mclk;
            nclk_zd := final_nclk;
            intfb_zd := final_intfb;
            lock_zd := final_lock;
      ELSIF (mclkmode = "DELAY" and nclkmode = "DELAY") THEN
         IF (clock_valid = '0') THEN
            mclk_zd := false_mck;
            nclk_zd := false_nck;
            intfb_zd := new_int;
            lock_zd := final_lock;
         ELSIF (clock_valid = '1') THEN
            mclk_zd := final_mclk;
            nclk_zd := final_nclk;
            intfb_zd := final_intfb;
            lock_zd := final_lock;
         END IF;
      ELSIF ((mclkmode = "PHSHIFT" and nclkmode = "PHSHIFT") or (mclkmode = "DUTYCYCLE" and nclkmode = "DUTYCYCLE")) THEN
         IF (clock_valid = '0') THEN
            mclk_zd := new_int;
            nclk_zd := new_int;
            intfb_zd := new_int;
            lock_zd := final_lock;
         ELSIF (clock_valid = '1') THEN
            mclk_zd := final_mclk;
            nclk_zd := final_nclk;
            intfb_zd := final_intfb;
            lock_zd := final_lock;
         END IF;
      END IF;
    END IF;
    -----------------------------------
    -- Path Delay Section.
    -----------------------------------
    VitalPathDelay01 (
     OutSignal => mclk,
     OutSignalName => "mclk",
     OutTemp => mclk_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_mclk, TRUE)),
     GlitchData => mclk_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);
    VitalPathDelay01 (
     OutSignal => nclk,
     OutSignalName => "nclk",
     OutTemp => nclk_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_nclk, TRUE)),
     GlitchData => nclk_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);
    VitalPathDelay01 (
     OutSignal => lock,
     OutSignalName => "lock",
     OutTemp => lock_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_lock, TRUE)),
     GlitchData => lock_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);
    VitalPathDelay01 (
     OutSignal => intfb,
     OutSignalName => "intfb",
     OutTemp => intfb_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_intfb, TRUE)),
     GlitchData => intfb_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);

END PROCESS;

END V;



--
----- cell hppll -----
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use work.global.gsrnet;
use work.global.purnet;

-- entity declaration --
ENTITY hppll IS
   GENERIC (
      div0               : Integer   := 1;
      div1               : Integer   := 1;
      div2               : Integer   := 1;
      div3               : Integer   := 1;
      mclkmode           : String    := "BYPASS";
      nclkmode           : String    := "BYPASS";
      vcotap             : Integer   := 4;
      disabled_gsr       : std_logic := '1';
      TimingChecksOn     : Boolean   := TRUE;
      XOn                : Boolean   := FALSE;
      MsgOn              : Boolean   := TRUE;
      InstancePath       : String    := "hppll";
      tpd_clkin_mclk     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_clkin_nclk     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_clkin_lock     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_clkin_intfb    : VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_fb_mclk        : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_fb_nclk        : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_fb_lock        : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_fb_intfb       : VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_clkin         : VitalDelayType01 := (0 ns, 0 ns);
      tipd_fb            : VitalDelayType01 := (0 ns, 0 ns));

   PORT(
      clkin              : in std_logic;
      fb                 : in std_logic;
      mclk               : out std_logic;
      nclk               : out std_logic;
      lock               : out std_logic;
      intfb              : out std_logic);

    ATTRIBUTE Vital_Level0 OF hppll : ENTITY IS TRUE;

END hppll ;

-- ARCHITECTURE body --
ARCHITECTURE V OF hppll IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;
    SIGNAL clkin_ipd          : std_logic := '0';
    SIGNAL fb_ipd             : std_logic := '0';
    SIGNAL set_reset          : std_logic := '0';
    SIGNAL false_int          : std_logic := '0';
    SIGNAL false_mck          : std_logic := '0';
    SIGNAL false_nck          : std_logic := '0';
    SIGNAL false_t_int        : time := 0 ns;
    SIGNAL false_t1_int       : time := 5 ns;
    SIGNAL t_in_clk           : time := 0 ns;
    SIGNAL set_reset_time     : time := 0 ns;
    SIGNAL t_vco              : time := 0 ns;
    SIGNAL ha_vco             : time := 0 ns;
    SIGNAL t_in_clk1          : time := 0 ns;
    SIGNAL t_in_clk2          : time := 0 ns;
    SIGNAL t_in_clk3          : time := 0 ns;
    SIGNAL clock_valid        : std_logic := '0';
    SIGNAL clock_invalid      : std_logic := '0';
    SIGNAL t_fb_clk           : time := 0 ns;
    SIGNAL t_intfb_clock      : time := 0 ns;
    SIGNAL ha_intfb_clk       : time := 0 ns;
    SIGNAL clkfb_per_valid    : std_logic := '0';
    SIGNAL ext_divider        : Real := 1.0 ;
    SIGNAL net_divide         : Real := 1.0 ;
    SIGNAL lock_all           : std_logic := '0';
    SIGNAL vir_mclk           : std_logic := '0';
    SIGNAL vir_nclk           : std_logic := '0';
    SIGNAL vir_lock           : std_logic := '0';
    SIGNAL vir_intfb          : std_logic := '0';
    SIGNAL intfb_out          : std_logic := '0';
    SIGNAL new_int            : std_logic := '0';
    SIGNAL final_mclk         : std_logic := '0';
    SIGNAL final_nclk         : std_logic := '0';
    SIGNAL div0_reg           : Integer   := 0;
    SIGNAL div1_reg           : Integer   := 0;
    SIGNAL div2_reg           : Integer   := 0;
    SIGNAL div3_reg           : Integer   := 0;
    SIGNAL vcotap_reg         : Integer   := 0;
    SIGNAL ratio1             : Integer   := 0;
    SIGNAL virtual_delay1     : time := 0 ps;
    SIGNAL real_delay1        : time := 0 ps;
    SIGNAL real_delay2        : time := 0 ps;
    SIGNAL real_delay         : time := 0 ps;
    SIGNAL total_fb_delay     : time := 0 ps;
    SIGNAL intfb_du_out       : std_logic := '0';
    SIGNAL mn_duty_clk        : std_logic := '0';
    SIGNAL mn_duty_clk1       : std_logic := '0';
    SIGNAL duty_mnclk         : std_logic := '0';
    SIGNAL pshift_mclk        : std_logic := '0';
    SIGNAL final_intfb        : std_logic := '0';
    SIGNAL final_lock         : std_logic := '0';
    SIGNAL duty_lock          : std_logic := '0';

BEGIN

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(clkin_ipd, clkin, tipd_clkin);
   VitalWireDelay(fb_ipd, fb, tipd_fb);
   END BLOCK;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   div0_reg <= div0;
   div1_reg <= div1;
   div2_reg <= div2;
   div3_reg <= div3;
   vcotap_reg <= vcotap;

--   lock_count <= div2_reg * div3_reg;

   GLOBALRESET : PROCESS (purnet, gsrnet)
    BEGIN
      IF (disabled_gsr =  '1') THEN
         set_reset <= purnet;
      ELSE
         set_reset <= purnet AND gsrnet;
      END IF;
    END PROCESS;

--------------------------------------------------------------------
-- Generate False Clocks
--------------------------------------------------------------------
   P1 : PROCESS
   VARIABLE first_time : boolean := true;
   BEGIN
        IF (first_time) THEN
          Wait for 5 ns;
          false_int <= NOT false_int;
          first_time := false;
        ELSE
          false_int <= NOT false_int;
          Wait for false_t1_int;
        END IF;
   END PROCESS;

   P2 : PROCESS (new_int)
   VARIABLE index : Integer := 0;
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (new_int'event) THEN
         IF (first_time) THEN
            IF (new_int = '1') THEN
               false_mck <= '1';
               first_time := false;
               index := 0;
            END IF;
         ELSE
            index := index + 1;
            IF (index = div2) THEN
               false_mck <= NOT false_mck;
               index := 0;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   P3 : PROCESS (new_int)
   VARIABLE index : Integer := 0;
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (new_int'event) THEN
         IF (first_time) THEN
            IF (new_int = '1') THEN
               false_nck <= '1';
               first_time := false;
               index := 0;
            END IF;
         ELSE
            index := index + 1;
            IF (index = div3) THEN
               false_nck <= NOT false_nck;
               index := 0;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   P4 : PROCESS (set_reset, false_int)
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (set_reset = '0') THEN
         new_int  <= '0';
      ELSE
        IF (first_time) THEN
           IF (false_int'event and false_int = '1') THEN
              new_int <= '1';
              first_time := false;
           END IF;
        ELSE
           new_int <= false_int;
        END IF;
      END IF;
   END PROCESS;

---------------------------------------------------------------------
-- Measure input clock and feedback clock period
---------------------------------------------------------------------
   CLKIN_PERIOD : PROCESS (clkin_ipd)
   VARIABLE last_clock_edge, next_clock_edge : time := 0 ps;
   BEGIN
      IF (clkin_ipd'event and clkin_ipd = '1') THEN
           last_clock_edge := next_clock_edge;
           next_clock_edge := NOW;
           IF (last_clock_edge > 0 ps) THEN
                t_in_clk <= next_clock_edge - last_clock_edge;
                t_in_clk1 <= t_in_clk;
                t_in_clk2 <= t_in_clk1;
                t_in_clk3 <= t_in_clk2;
           END IF;
           IF (t_in_clk > 0 ps) THEN
             IF ((t_in_clk = t_in_clk1) and (t_in_clk = t_in_clk2) and (t_in_clk = t_in_clk3)) THEN
                  clock_valid <= '1';
             ELSE
                  clock_valid <= '0';
             END IF;
           END IF;
           IF (t_in_clk > 0 ps) THEN
             IF (t_in_clk = t_in_clk1) THEN
                  clock_invalid <= '0';
             ELSE
                  clock_invalid <= '1';
             END IF;
           END IF;
      END IF;
   END PROCESS;

   RESET_PERIOD : PROCESS (clkin_ipd)
   VARIABLE last_clock_edge, next_clock_edge, reset_in_clk : time := 0 ps;
   BEGIN
      IF (set_reset = '0') THEN
         IF (clkin_ipd'event and clkin_ipd = '1') THEN
              last_clock_edge := next_clock_edge;
              next_clock_edge := NOW;
              IF (last_clock_edge > 0 ps) THEN
                   reset_in_clk := next_clock_edge - last_clock_edge;
                   set_reset_time <= set_reset_time + reset_in_clk;
              END IF;
          END IF;
      ELSE
         set_reset_time <= 0 ps;

      END IF;
   END PROCESS;

   RESET_WARNING : PROCESS (clkin_ipd)
   BEGIN
      IF (clkin_ipd'event) THEN
         IF (set_reset = '0') THEN
            assert (set_reset_time <= t_in_clk * 3)
            report "Global-Reset time too long. Assert global-reset for less than three clock cycles to avoid zero delay oscillation"
            severity WARNING;
         END IF;
      END IF;
   END PROCESS;
 

   P6 : PROCESS (t_in_clk)
   BEGIN
      IF (t_in_clk > 0 ps) THEN
         t_vco  <= ((t_in_clk * div0_reg) / div1_reg);  -- vco oscillating cycle
      END IF;
   END PROCESS;

   ha_vco <= (t_vco / 2);  -- vco oscillating half-cycle

   FB_PERIOD : PROCESS (fb_ipd)
   VARIABLE last_clock_edge : time := 0 ps;
   VARIABLE next_clock_edge : time := 0 ps;
   VARIABLE first_time      : Boolean := true;
   BEGIN
      IF (fb_ipd'event and fb_ipd = '1') THEN
           last_clock_edge := next_clock_edge;
           next_clock_edge := NOW;
           IF (last_clock_edge > 0 ps) THEN
             IF (first_time) THEN
                t_fb_clk <= next_clock_edge - last_clock_edge;
                first_time := false;
             END IF;
           END IF;
      END IF;
      IF (last_clock_edge > 0 ps) THEN
           clkfb_per_valid <= '1';
      END IF;
   END PROCESS;

------------------------------------------------
-- measure the feedback delay value
------------------------------------------------
   GENERATE_FIRST_FD_EDGE : PROCESS (new_int, fb_ipd)
   VARIABLE new_int_first_time : boolean := true;
   VARIABLE fb_first_time : boolean := true;
   VARIABLE first_int_edge : time := 0 ps;
   VARIABLE first_fb_edge : time := 0 ps;
   BEGIN
      if (new_int'event and new_int'last_value = '0' and new_int = '1') then
         if (new_int_first_time) then
            first_int_edge := NOW;
            new_int_first_time := false;
         end if;
      end if;
      if (fb_ipd'event and fb_ipd'last_value = '0' and fb_ipd = '1') then
         if (fb_first_time) then
            first_fb_edge := NOW;
            fb_first_time := false;
         end if;
      end if;
         total_fb_delay <= first_fb_edge - first_int_edge ;
   END PROCESS;

   DELAY1 : PROCESS (total_fb_delay, t_in_clk, ratio1, virtual_delay1)
   BEGIN
      IF ((total_fb_delay > 0 ps) and (t_in_clk > 0 ps)) THEN
          ratio1 <= total_fb_delay / t_in_clk;
          virtual_delay1 <= total_fb_delay - (t_in_clk * ratio1);
          real_delay1 <= t_in_clk - virtual_delay1 ;
      END IF;
   END PROCESS;

-------------------------------------------------
-- Assume Internal dedicated feedback
-------------------------------------------------
   false_t_int <= 2 * false_t1_int;

   INT_FB : PROCESS (t_fb_clk, false_t_int)
   BEGIN
      IF (false_t_int > 0 ps) THEN
         ext_divider <= (real(time'pos(t_fb_clk)) / real(time'pos(false_t_int)));
      END IF;
   END PROCESS;

----------------------------------------------------
-- Generate internal-feedback clock period
----------------------------------------------------
   net_divide <= (real(div1_reg) * ext_divider);

   P5 : PROCESS (net_divide, t_in_clk)
   BEGIN
      IF (net_divide > 0.0) THEN
         t_intfb_clock <= ((t_in_clk * div0) / (net_divide));
      END IF;
   END PROCESS;

   ha_intfb_clk  <= (t_intfb_clock / 2);

-------------------------------------------------------
-- Generate all CLOCKs in DELAY MODE
-------------------------------------------------------
   P8 : PROCESS
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (mclkmode = "DELAY" and nclkmode = "DELAY") THEN
         IF (first_time) THEN
            WAIT until (clock_valid'event and clock_valid = '1');
            intfb_out <= '1';
            first_time := false;
         ELSIF (clock_valid = '1') THEN
            WAIT FOR ha_intfb_clk;
            intfb_out <= NOT intfb_out;
         ELSIF (clock_valid = '0') THEN
            WAIT FOR t_intfb_clock;
            intfb_out <= intfb_out;
            first_time := true;
         END IF;
      ELSE
         Wait;
      END IF;
   END PROCESS;

   real_delay2 <= ((t_in_clk * vcotap_reg) / 8);

   real_delay <= (real_delay1 + real_delay2);

   P11 : PROCESS (set_reset, intfb_out)
   BEGIN
      IF (set_reset = '0') THEN
         vir_intfb <= '0';
      ELSE
         vir_intfb <= transport intfb_out after real_delay;
      END IF;
   END PROCESS;

   P9 : PROCESS (vir_intfb)
   VARIABLE index1 : Integer := 0;
   VARIABLE index2 : Integer := 0;
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (vir_intfb'event) THEN
         IF (first_time) THEN
            IF (vir_intfb = '1') THEN
               vir_mclk <= '1';
               vir_nclk <= '1';
               vir_lock <= '1';
               first_time := false;
               index1 := 0;
               index2 := 0;
            END IF;
         ELSE
            index1 := index1 + 1;
            index2 := index2 + 1;
            IF (index1 = div2_reg) THEN
               vir_mclk <= NOT vir_mclk;
               index1 := 0;
            END IF;
            IF (index2 = div3_reg) THEN
               vir_nclk <= NOT vir_nclk;
               index2 := 0;
            END IF;
         END IF;
      END IF;
   END PROCESS;

-------------------------------------------------------
-- Generate all CLOCKs in DUTYCYCLE and PHSHIFT MODE
-------------------------------------------------------
   P12 : PROCESS
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (first_time) THEN
         WAIT until (clock_valid'event and clock_valid = '1');
         intfb_du_out <= '1';
         mn_duty_clk <= '1';
         first_time := false;
      ELSIF (clock_valid = '1') THEN
         WAIT FOR ha_vco;
         intfb_du_out <= NOT intfb_du_out;
         mn_duty_clk <= NOT mn_duty_clk;
      ELSIF (clock_valid = '0') THEN
         intfb_du_out <= '0';
         mn_duty_clk <= '0';
         first_time := true;
      END IF;
   END PROCESS;

   DELAY2 : PROCESS (mn_duty_clk)
   BEGIN
      IF (real_delay1 > 0 ps) THEN
         mn_duty_clk1 <= transport mn_duty_clk after real_delay1;
      ELSE
         mn_duty_clk1 <= mn_duty_clk;
      END IF;
   END PROCESS;


-------------------------------------------------------
-- Generate LOCK signal
-------------------------------------------------------
   LOCK_IT : PROCESS (set_reset, vir_lock, clock_invalid, clock_valid)
   BEGIN
      IF (set_reset = '0') THEN
         lock_all <= '0';
      ELSE
        IF clock_invalid = '1' THEN
           lock_all <= '0';
        ELSIF clock_valid = '0' THEN
           lock_all <= '0';
        ELSIF clock_valid = '1' THEN
           lock_all <= vir_lock;
        END IF;
      END IF;
   END PROCESS;

-------------------------------------------------------
-- Calculate DUTYCYCLE values and create clocks
-------------------------------------------------------
   DUTY_CK : PROCESS (mn_duty_clk1, clock_valid)
   VARIABLE mnclock_duty : time := 0 ps;
   BEGIN
      IF (vcotap_reg > 0) THEN
         mnclock_duty := ((t_vco * vcotap_reg) / 8);
      END IF;
      IF (mnclock_duty > 0 ps) THEN
         IF (mn_duty_clk1'event and mn_duty_clk1 = '1') THEN
            duty_mnclk <= '1';
            duty_mnclk <= transport '0' after mnclock_duty;
         END IF;

         IF (clock_valid = '0') THEN
            duty_lock <= '0';
         ELSE
            duty_lock <= '1';
         END IF;
      END IF;
   END PROCESS;

-------------------------------------------------------
-- Calculate DELAY values and create clocks
-------------------------------------------------------
   DELAY_CK : PROCESS (mn_duty_clk1)
   VARIABLE mclock_delay : time := 0 ps;
   BEGIN
         mclock_delay := ((t_vco * vcotap_reg) / 8);
         pshift_mclk <= transport mn_duty_clk1 after mclock_delay;
   END PROCESS;

-------------------------------------------------------
-- Select clocks with appropriate modes
-------------------------------------------------------
   P101 : PROCESS (clkin_ipd, duty_mnclk, mn_duty_clk1, pshift_mclk, intfb_du_out, vir_mclk, vir_nclk, vir_intfb, lock_all, duty_lock)
   BEGIN
      IF (mclkmode = "BYPASS" and nclkmode = "BYPASS") THEN
         final_mclk <= clkin_ipd;
         final_nclk <= clkin_ipd;
         final_intfb <= clkin_ipd;
         IF (clkin_ipd'event AND clkin_ipd = '1') THEN
            final_lock <= '1';
         END IF;
      END IF;
      IF (mclkmode = "DUTYCYCLE" and nclkmode = "DUTYCYCLE") THEN
         final_mclk <= duty_mnclk;
         final_nclk <= duty_mnclk;
         final_intfb <= intfb_du_out;
         final_lock <= duty_lock;
      END IF;
      IF (mclkmode = "PHSHIFT" and nclkmode = "PHSHIFT") THEN
         final_mclk <= pshift_mclk;
         final_nclk <= mn_duty_clk1;
         final_intfb <= intfb_du_out;
         final_lock <= duty_lock;
      END IF;
      IF (mclkmode = "DELAY" and nclkmode = "DELAY") THEN
         final_mclk <= vir_mclk;
         final_nclk <= vir_nclk;
         final_intfb <= vir_intfb;
         final_lock <= lock_all;
      END IF;

   END PROCESS;

   VitalBehavior : PROCESS (clock_valid, final_mclk, final_nclk, final_lock, final_intfb, false_mck, false_nck, new_int)

   -- functionality results
   VARIABLE results : std_logic_vector(1 to 4) := (others => '0');
   ALIAS mclk_zd : std_ulogic is results(1);
   ALIAS nclk_zd : std_ulogic is results(2);
   ALIAS lock_zd : std_ulogic is results(3);
   ALIAS intfb_zd : std_ulogic is results(4);

   -- output glitch detection variables
   VARIABLE mclk_GlitchData : VitalGlitchDataType;
   VARIABLE nclk_GlitchData : VitalGlitchDataType;
   VARIABLE lock_GlitchData : VitalGlitchDataType;
   VARIABLE intfb_GlitchData : VitalGlitchDataType;

   BEGIN

    IF (TimingChecksOn) THEN
    END IF;

    -----------------------------------
    -- Functionality Section.
    -----------------------------------
    IF (set_reset = '0') THEN
      mclk_zd := '0';
      nclk_zd := '0';
      lock_zd := '0';
      intfb_zd := '0';
    ELSE
      IF (mclkmode = "BYPASS" and nclkmode = "BYPASS") THEN
            mclk_zd := final_mclk;
            nclk_zd := final_nclk;
            intfb_zd := final_intfb;
            lock_zd := final_lock;
      ELSIF (mclkmode = "DELAY" and nclkmode = "DELAY") THEN
         IF (clock_valid = '0') THEN
            mclk_zd := false_mck;
            nclk_zd := false_nck;
            intfb_zd := new_int;
            lock_zd := final_lock;
         ELSIF (clock_valid = '1') THEN
            mclk_zd := final_mclk;
            nclk_zd := final_nclk;
            intfb_zd := final_intfb;
            lock_zd := final_lock;
         END IF;
      ELSIF ((mclkmode = "PHSHIFT" and nclkmode = "PHSHIFT") or (mclkmode = "DUTYCYCLE" and nclkmode = "DUTYCYCLE")) THEN
         IF (clock_valid = '0') THEN
            mclk_zd := new_int;
            nclk_zd := new_int;
            intfb_zd := new_int;
            lock_zd := final_lock;
         ELSIF (clock_valid = '1') THEN
            mclk_zd := final_mclk;
            nclk_zd := final_nclk;
            intfb_zd := final_intfb;
            lock_zd := final_lock;
         END IF;
      END IF;
    END IF;
    -----------------------------------
    -- Path Delay Section.
    -----------------------------------
    VitalPathDelay01 (
     OutSignal => mclk,
     OutSignalName => "mclk",
     OutTemp => mclk_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_mclk, TRUE)),
     GlitchData => mclk_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);
    VitalPathDelay01 (
     OutSignal => nclk,
     OutSignalName => "nclk",
     OutTemp => nclk_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_nclk, TRUE)),
     GlitchData => nclk_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);
    VitalPathDelay01 (
     OutSignal => lock,
     OutSignalName => "lock",
     OutTemp => lock_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_lock, TRUE)),
     GlitchData => lock_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);
    VitalPathDelay01 (
     OutSignal => intfb,
     OutSignalName => "intfb",
     OutTemp => intfb_zd,
     Paths => (0 => (new_int'last_event, tpd_clkin_intfb, TRUE)),
     GlitchData => intfb_GlitchData,
     Mode => OnDetect,
     XOn => XOn,
     MsgOn => MsgOn);

END PROCESS;

END V;



--
-----cell br512x18----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use ieee.std_logic_unsigned.all;
use work.mem3.all;

-- entity declaration --
ENTITY br512x18 IS
   GENERIC (
        BRAMMODE0                  : String  := "NOREG";
        BRAMMODE1                  : String  := "NOREG";
        ARBITERMODE                : String  := "FALSE";
        initval_00 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_01 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_02 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_03 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_04 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_05 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_06 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_07 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_08 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_09 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0a : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0b : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0c : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0d : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0e : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0f : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_10 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_11 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_12 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_13 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_14 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_15 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_16 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_17 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_18 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_19 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1a : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1b : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1c : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1d : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1e : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1f : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "br512x18";

        -- input SIGNAL delays
        tipd_aw08 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar08 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d017 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d016 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d015 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d014 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d013 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d012 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d011 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d010 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d09  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d08  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d07  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d06  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d05  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d04  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d03  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d02  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d01  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d00  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csr0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw18 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar18 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d117 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d116 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d115 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d114 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d113 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d112 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d111 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d110 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d19  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d18  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csr1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw10 : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_ar08_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw08_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw07_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw06_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw05_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw04_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw03_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw02_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw01_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw00_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw18_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw17_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw16_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw15_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw14_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw13_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw12_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw11_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw10_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_csw1_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_csw0_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);

        -- setup and hold constraints
        tsetup_aw08_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw08_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw07_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw07_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw06_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw06_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw05_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw05_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw04_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw04_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw03_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw03_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw02_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw02_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d017_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d017_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d016_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d016_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d015_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d015_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d014_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d014_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d013_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d013_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d012_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d012_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d011_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d011_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d010_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d010_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d09_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d09_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d08_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d08_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_bw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_bw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_bw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_bw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csw0_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csw0_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar08_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar08_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar07_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar07_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar06_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar06_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar05_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar05_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar04_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar04_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar03_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar03_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar02_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar02_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar01_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar01_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar00_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar00_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csr0_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csr0_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw18_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw18_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw17_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw17_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw16_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw16_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw15_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw15_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw14_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw14_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw13_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw13_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw12_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw12_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d117_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d117_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d116_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d116_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d115_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d115_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d114_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d114_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d113_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d113_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d112_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d112_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d111_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d111_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d110_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d110_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d19_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d19_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d18_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d18_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_bw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_bw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_bw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_bw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csw1_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csw1_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar18_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar18_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar17_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar17_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar16_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar16_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar15_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar15_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar14_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar14_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar13_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar13_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar12_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar12_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar11_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar11_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar10_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar10_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csr1_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csr1_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw0            : VitalDelayType := 0.01 ns;
        tpw_ckw0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr0            : VitalDelayType := 0.01 ns;
        tpw_ckr0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckw1            : VitalDelayType := 0.01 ns;
        tpw_ckw1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw1_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr1            : VitalDelayType := 0.01 ns;
        tpw_ckr1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr1_negedge        : VitalDelayType := 0.01 ns);

   PORT(
        aw18, aw17, aw16, aw15, aw14, aw13, aw12, aw11, aw10         : in std_logic ;
        aw08, aw07, aw06, aw05, aw04, aw03, aw02, aw01, aw00         : in std_logic ;
        d117, d116, d115, d114, d113, d112, d111, d110, d19          : in std_logic ;
        d18, d17, d16, d15, d14, d13, d12, d11, d10                  : in std_logic ;
        d017, d016, d015, d014, d013, d012, d011, d010, d09          : in std_logic ;
        d08, d07, d06, d05, d04, d03, d02, d01, d00                  : in std_logic ;
        bw11, bw10, bw01, bw00                                       : in std_logic ;
        ar18, ar17, ar16, ar15, ar14, ar13, ar12, ar11, ar10         : in std_logic ;
        ar08, ar07, ar06, ar05, ar04, ar03, ar02, ar01, ar00         : in std_logic ;
        ckw1, ckw0, ckr1, ckr0, csw1, csw0, csr1, csr0               : in std_logic ;

        q117, q116, q115, q114, q113, q112, q111, q110, q19          : out std_logic ;
        q18, q17, q16, q15, q14, q13, q12, q11, q10                  : out std_logic ;
        q017, q016, q015, q014, q013, q012, q011, q010, q09          : out std_logic ;
        q08, q07, q06, q05, q04, q03, q02, q01, q00, busy            : out std_logic );

      ATTRIBUTE Vital_Level0 OF br512x18 : ENTITY IS TRUE;

END br512x18 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF br512x18 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL mode0_reg   : String(BRAMMODE0'length downto 1);
    SIGNAL mode1_reg   : String(BRAMMODE1'length downto 1);
    SIGNAL arbmode_reg : String(ARBITERMODE'length downto 1);

    SIGNAL aw08_ipd  : std_logic := 'X';
    SIGNAL aw07_ipd  : std_logic := 'X';
    SIGNAL aw06_ipd  : std_logic := 'X';
    SIGNAL aw05_ipd  : std_logic := 'X';
    SIGNAL aw04_ipd  : std_logic := 'X';
    SIGNAL aw03_ipd  : std_logic := 'X';
    SIGNAL aw02_ipd  : std_logic := 'X';
    SIGNAL aw01_ipd  : std_logic := 'X';
    SIGNAL aw00_ipd  : std_logic := 'X';
    SIGNAL ar08_ipd  : std_logic := 'X';
    SIGNAL ar07_ipd  : std_logic := 'X';
    SIGNAL ar06_ipd  : std_logic := 'X';
    SIGNAL ar05_ipd  : std_logic := 'X';
    SIGNAL ar04_ipd  : std_logic := 'X';
    SIGNAL ar03_ipd  : std_logic := 'X';
    SIGNAL ar02_ipd  : std_logic := 'X';
    SIGNAL ar01_ipd  : std_logic := 'X';
    SIGNAL ar00_ipd  : std_logic := 'X';
    SIGNAL d017_ipd  : std_logic := 'X';
    SIGNAL d016_ipd  : std_logic := 'X';
    SIGNAL d015_ipd  : std_logic := 'X';
    SIGNAL d014_ipd  : std_logic := 'X';
    SIGNAL d013_ipd  : std_logic := 'X';
    SIGNAL d012_ipd  : std_logic := 'X';
    SIGNAL d011_ipd  : std_logic := 'X';
    SIGNAL d010_ipd  : std_logic := 'X';
    SIGNAL d09_ipd   : std_logic := 'X';
    SIGNAL d08_ipd   : std_logic := 'X';
    SIGNAL d07_ipd   : std_logic := 'X';
    SIGNAL d06_ipd   : std_logic := 'X';
    SIGNAL d05_ipd   : std_logic := 'X';
    SIGNAL d04_ipd   : std_logic := 'X';
    SIGNAL d03_ipd   : std_logic := 'X';
    SIGNAL d02_ipd   : std_logic := 'X';
    SIGNAL d01_ipd   : std_logic := 'X';
    SIGNAL d00_ipd   : std_logic := 'X';
    SIGNAL ckw0_ipd  : std_logic := 'X';
    SIGNAL ckr0_ipd  : std_logic := 'X';
    SIGNAL csw0_ipd  : std_logic := 'X';
    SIGNAL csr0_ipd  : std_logic := 'X';
    SIGNAL bw01_ipd  : std_logic := 'X';
    SIGNAL bw00_ipd  : std_logic := 'X';
    SIGNAL aw18_ipd  : std_logic := 'X';
    SIGNAL aw17_ipd  : std_logic := 'X';
    SIGNAL aw16_ipd  : std_logic := 'X';
    SIGNAL aw15_ipd  : std_logic := 'X';
    SIGNAL aw14_ipd  : std_logic := 'X';
    SIGNAL aw13_ipd  : std_logic := 'X';
    SIGNAL aw12_ipd  : std_logic := 'X';
    SIGNAL aw11_ipd  : std_logic := 'X';
    SIGNAL aw10_ipd  : std_logic := 'X';
    SIGNAL ar18_ipd  : std_logic := 'X';
    SIGNAL ar17_ipd  : std_logic := 'X';
    SIGNAL ar16_ipd  : std_logic := 'X';
    SIGNAL ar15_ipd  : std_logic := 'X';
    SIGNAL ar14_ipd  : std_logic := 'X';
    SIGNAL ar13_ipd  : std_logic := 'X';
    SIGNAL ar12_ipd  : std_logic := 'X';
    SIGNAL ar11_ipd  : std_logic := 'X';
    SIGNAL ar10_ipd  : std_logic := 'X';
    SIGNAL d117_ipd  : std_logic := 'X';
    SIGNAL d116_ipd  : std_logic := 'X';
    SIGNAL d115_ipd  : std_logic := 'X';
    SIGNAL d114_ipd  : std_logic := 'X';
    SIGNAL d113_ipd  : std_logic := 'X';
    SIGNAL d112_ipd  : std_logic := 'X';
    SIGNAL d111_ipd  : std_logic := 'X';
    SIGNAL d110_ipd  : std_logic := 'X';
    SIGNAL d19_ipd   : std_logic := 'X';
    SIGNAL d18_ipd   : std_logic := 'X';
    SIGNAL d17_ipd   : std_logic := 'X';
    SIGNAL d16_ipd   : std_logic := 'X';
    SIGNAL d15_ipd   : std_logic := 'X';
    SIGNAL d14_ipd   : std_logic := 'X';
    SIGNAL d13_ipd   : std_logic := 'X';
    SIGNAL d12_ipd   : std_logic := 'X';
    SIGNAL d11_ipd   : std_logic := 'X';
    SIGNAL d10_ipd   : std_logic := 'X';
    SIGNAL ckw1_ipd  : std_logic := 'X';
    SIGNAL ckr1_ipd  : std_logic := 'X';
    SIGNAL csw1_ipd  : std_logic := 'X';
    SIGNAL csr1_ipd  : std_logic := 'X';
    SIGNAL bw11_ipd  : std_logic := 'X';
    SIGNAL bw10_ipd  : std_logic := 'X';

    SIGNAL initval   : string(2560 downto 1) := (initval_1f(3 to 82)&initval_1e(3 to 82)&initval_1d(3 to 82)&initval_1c(3 to 82)&
      initval_1b(3 to 82)&initval_1a(3 to 82)&initval_19(3 to 82)&initval_18(3 to 82)&
      initval_17(3 to 82)&initval_16(3 to 82)&initval_15(3 to 82)&initval_14(3 to 82)&
      initval_13(3 to 82)&initval_12(3 to 82)&initval_11(3 to 82)&initval_10(3 to 82)&
      initval_0f(3 to 82)&initval_0e(3 to 82)&initval_0d(3 to 82)&initval_0c(3 to 82)&
      initval_0b(3 to 82)&initval_0a(3 to 82)&initval_09(3 to 82)&initval_08(3 to 82)&
      initval_07(3 to 82)&initval_06(3 to 82)&initval_05(3 to 82)&initval_04(3 to 82)&
      initval_03(3 to 82)&initval_02(3 to 82)&initval_01(3 to 82)&initval_00(3 to 82));
    SIGNAL memory    : mem_type_5(0 to 511) := init_ram (initval);
    SIGNAL busy0     : std_logic := '0';
    SIGNAL aw0_int   : std_logic_vector(8 downto 0) := "XXXXXXXXX";
    SIGNAL aw1_int   : std_logic_vector(8 downto 0) := "XXXXXXXXX";
    SIGNAL ar0_int   : std_logic_vector(8 downto 0) := "XXXXXXXXX";
    SIGNAL ar1_int   : std_logic_vector(8 downto 0) := "XXXXXXXXX";
    SIGNAL d0_int    : std_logic_vector(15 downto 0) := "XXXXXXXXXXXXXXXX";
    SIGNAL d1_int    : std_logic_vector(15 downto 0) := "XXXXXXXXXXXXXXXX";
    SIGNAL q0_tmp    : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_tmp    : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_noreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_noreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_inreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_inreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_outreg : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_outreg : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_ioreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_ioreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL busy_tmp  : std_logic := 'X';
    SIGNAL q0_int    : std_logic_vector(17 downto 0);
    SIGNAL q1_int    : std_logic_vector(17 downto 0);
    SIGNAL csr0_int  : std_logic;
    SIGNAL csr1_int  : std_logic;
    SIGNAL memchg1   : std_logic := '0';
    SIGNAL memchg2   : std_logic := '0';
    SIGNAL memchg3   : std_logic := '0';
    SIGNAL memchg4   : std_logic := '0';
    SIGNAL memchg5   : std_logic := '0';
    SIGNAL memchg6   : std_logic := '0';
    SIGNAL wren0     : std_logic := '0';
    SIGNAL wren1     : std_logic := '0';
    SIGNAL port0_shutoff   : std_logic := '0';
    SIGNAL iorad_0   : integer := 0;
    SIGNAL iorad_1   : integer := 0;
    SIGNAL port0_valid   : std_logic := '0';
BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(aw08_ipd, aw08, tipd_aw08);
   VitalWireDelay(aw07_ipd, aw07, tipd_aw07);
   VitalWireDelay(aw06_ipd, aw06, tipd_aw06);
   VitalWireDelay(aw05_ipd, aw05, tipd_aw05);
   VitalWireDelay(aw04_ipd, aw04, tipd_aw04);
   VitalWireDelay(aw03_ipd, aw03, tipd_aw03);
   VitalWireDelay(aw02_ipd, aw02, tipd_aw02);
   VitalWireDelay(aw01_ipd, aw01, tipd_aw01);
   VitalWireDelay(aw00_ipd, aw00, tipd_aw00);
   VitalWireDelay(ar08_ipd, ar08, tipd_ar08);
   VitalWireDelay(ar07_ipd, ar07, tipd_ar07);
   VitalWireDelay(ar06_ipd, ar06, tipd_ar06);
   VitalWireDelay(ar05_ipd, ar05, tipd_ar05);
   VitalWireDelay(ar04_ipd, ar04, tipd_ar04);
   VitalWireDelay(ar03_ipd, ar03, tipd_ar03);
   VitalWireDelay(ar02_ipd, ar02, tipd_ar02);
   VitalWireDelay(ar01_ipd, ar01, tipd_ar01);
   VitalWireDelay(ar00_ipd, ar00, tipd_ar00);
   VitalWireDelay(d017_ipd, d017, tipd_d017);
   VitalWireDelay(d016_ipd, d016, tipd_d016);
   VitalWireDelay(d015_ipd, d015, tipd_d015);
   VitalWireDelay(d014_ipd, d014, tipd_d014);
   VitalWireDelay(d013_ipd, d013, tipd_d013);
   VitalWireDelay(d012_ipd, d012, tipd_d012);
   VitalWireDelay(d011_ipd, d011, tipd_d011);
   VitalWireDelay(d010_ipd, d010, tipd_d010);
   VitalWireDelay(d09_ipd, d09, tipd_d09);
   VitalWireDelay(d08_ipd, d08, tipd_d08);
   VitalWireDelay(d07_ipd, d07, tipd_d07);
   VitalWireDelay(d06_ipd, d06, tipd_d06);
   VitalWireDelay(d05_ipd, d05, tipd_d05);
   VitalWireDelay(d04_ipd, d04, tipd_d04);
   VitalWireDelay(d03_ipd, d03, tipd_d03);
   VitalWireDelay(d02_ipd, d02, tipd_d02);
   VitalWireDelay(d01_ipd, d01, tipd_d01);
   VitalWireDelay(d00_ipd, d00, tipd_d00);
   VitalWireDelay(ckw0_ipd, ckw0, tipd_ckw0);
   VitalWireDelay(ckr0_ipd, ckr0, tipd_ckr0);
   VitalWireDelay(csw0_ipd, csw0, tipd_csw0);
   VitalWireDelay(csr0_ipd, csr0, tipd_csr0);
   VitalWireDelay(bw01_ipd, bw01, tipd_bw01);
   VitalWireDelay(bw00_ipd, bw00, tipd_bw00);
   VitalWireDelay(aw18_ipd, aw18, tipd_aw18);
   VitalWireDelay(aw17_ipd, aw17, tipd_aw17);
   VitalWireDelay(aw16_ipd, aw16, tipd_aw16);
   VitalWireDelay(aw15_ipd, aw15, tipd_aw15);
   VitalWireDelay(aw14_ipd, aw14, tipd_aw14);
   VitalWireDelay(aw13_ipd, aw13, tipd_aw13);
   VitalWireDelay(aw12_ipd, aw12, tipd_aw12);
   VitalWireDelay(aw11_ipd, aw11, tipd_aw11);
   VitalWireDelay(aw10_ipd, aw10, tipd_aw10);
   VitalWireDelay(ar18_ipd, ar18, tipd_ar18);
   VitalWireDelay(ar17_ipd, ar17, tipd_ar17);
   VitalWireDelay(ar16_ipd, ar16, tipd_ar16);
   VitalWireDelay(ar15_ipd, ar15, tipd_ar15);
   VitalWireDelay(ar14_ipd, ar14, tipd_ar14);
   VitalWireDelay(ar13_ipd, ar13, tipd_ar13);
   VitalWireDelay(ar12_ipd, ar12, tipd_ar12);
   VitalWireDelay(ar11_ipd, ar11, tipd_ar11);
   VitalWireDelay(ar10_ipd, ar10, tipd_ar10);
   VitalWireDelay(d117_ipd, d117, tipd_d117);
   VitalWireDelay(d116_ipd, d116, tipd_d116);
   VitalWireDelay(d115_ipd, d115, tipd_d115);
   VitalWireDelay(d114_ipd, d114, tipd_d114);
   VitalWireDelay(d113_ipd, d113, tipd_d113);
   VitalWireDelay(d112_ipd, d112, tipd_d112);
   VitalWireDelay(d111_ipd, d111, tipd_d111);
   VitalWireDelay(d110_ipd, d110, tipd_d110);
   VitalWireDelay(d19_ipd, d19, tipd_d19);
   VitalWireDelay(d18_ipd, d18, tipd_d18);
   VitalWireDelay(d17_ipd, d17, tipd_d17);
   VitalWireDelay(d16_ipd, d16, tipd_d16);
   VitalWireDelay(d15_ipd, d15, tipd_d15);
   VitalWireDelay(d14_ipd, d14, tipd_d14);
   VitalWireDelay(d13_ipd, d13, tipd_d13);
   VitalWireDelay(d12_ipd, d12, tipd_d12);
   VitalWireDelay(d11_ipd, d11, tipd_d11);
   VitalWireDelay(d10_ipd, d10, tipd_d10);
   VitalWireDelay(ckw1_ipd, ckw1, tipd_ckw1);
   VitalWireDelay(ckr1_ipd, ckr1, tipd_ckr1);
   VitalWireDelay(csw1_ipd, csw1, tipd_csw1);
   VitalWireDelay(csr1_ipd, csr1, tipd_csr1);
   VitalWireDelay(bw11_ipd, bw11, tipd_bw11);
   VitalWireDelay(bw10_ipd, bw10, tipd_bw10);
   END BLOCK;

   mode0_reg <= BRAMMODE0;
   mode1_reg <= BRAMMODE1;
   arbmode_reg <= ARBITERMODE;
   wren0 <= csw0_ipd;
   wren1 <= csw1_ipd;
   aw0_int <= (aw08_ipd, aw07_ipd, aw06_ipd, aw05_ipd, aw04_ipd, aw03_ipd,
               aw02_ipd, aw01_ipd, aw00_ipd);
   aw1_int <= (aw18_ipd, aw17_ipd, aw16_ipd, aw15_ipd, aw14_ipd, aw13_ipd,
               aw12_ipd, aw11_ipd, aw10_ipd);
   ar0_int <= (ar08_ipd, ar07_ipd, ar06_ipd, ar05_ipd, ar04_ipd, ar03_ipd,
               ar02_ipd, ar01_ipd, ar00_ipd);
   ar1_int <= (ar18_ipd, ar17_ipd, ar16_ipd, ar15_ipd, ar14_ipd, ar13_ipd,
               ar12_ipd, ar11_ipd, ar10_ipd);
   d0_int <= (d015_ipd, d014_ipd, d013_ipd, d012_ipd, d011_ipd, d010_ipd, d09_ipd,
              d08_ipd, d07_ipd, d06_ipd, d05_ipd, d04_ipd, d03_ipd, d02_ipd,
              d01_ipd, d00_ipd);
   d1_int <= (d115_ipd, d114_ipd, d113_ipd, d112_ipd, d111_ipd, d110_ipd, d19_ipd,
              d18_ipd, d17_ipd, d16_ipd, d15_ipd, d14_ipd, d13_ipd, d12_ipd,
              d11_ipd, d10_ipd);

   P101 : PROCESS (ckr1_ipd)
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (ckr1_ipd'event AND ckr1_ipd = '1') THEN
         IF (first_time) THEN
            port0_valid <= '1';
            first_time := false;
         END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Arbiter-mode selection
----------------------------------------------------------------

--   ARB : PROCESS (aw0_int, aw1_int, csw0_ipd, csw1_ipd, ckw0_ipd)
   ARB : PROCESS (aw0_int, aw1_int, wren0, wren1, ckw0_ipd)
   VARIABLE address_0 : integer;
   VARIABLE address_1 : integer;
   BEGIN
      address_0 := conv_integer(aw0_int);
      address_1 := conv_integer(aw1_int);
      IF (arbmode_reg = "TRUE") THEN
--        IF (csw0_ipd = '1' and csw1_ipd = '1') THEN
        IF (wren0 = '1' and wren1 = '1') THEN
          IF (address_0 = address_1) THEN
            busy0 <= '1';
          END IF;
        END IF;

        IF (ckw0_ipd'event and ckw0_ipd = '1') THEN
          IF ((address_0 /= address_1) or csw0_ipd = '0' or csw1_ipd = '0') THEN
            busy0 <= '0';
          END IF;
        END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 write address and data latch and write
----------------------------------------------------------------
   WR : PROCESS (ckw0_ipd, ckw1_ipd)
   VARIABLE data_1_0  : std_logic_vector(7 downto 0);
   VARIABLE data_1_8  : std_logic_vector(7 downto 0);
   VARIABLE data_1_16 : std_logic;
   VARIABLE data_1_17 : std_logic;
   VARIABLE data_0_0  : std_logic_vector(7 downto 0);
   VARIABLE data_0_8  : std_logic_vector(7 downto 0);
   VARIABLE data_0_16 : std_logic;
   VARIABLE data_0_17 : std_logic;
   VARIABLE wad_0     : Integer;
   VARIABLE wad_1     : Integer;
   BEGIN
      IF (busy0 = '1') THEN
        IF (ckw1_ipd'event and ckw1_ipd = '1') THEN
          IF (csw1_ipd = '1') THEN
            wad_1 := conv_integer(aw1_int);

            IF (bw10_ipd = '1') THEN
              data_1_0 := d1_int(7 downto 0);
              data_1_16 := d116_ipd;
              memory(wad_1)(7 downto 0) <= data_1_0;
              memory(wad_1)(16) <= data_1_16;
              memchg1 <= not memchg1;
            END IF;
            IF (bw11_ipd = '1') THEN
              data_1_8 := d1_int(15 downto 8);
              data_1_17 := d117_ipd;
              memory(wad_1)(15 downto 8) <= data_1_8;
              memory(wad_1)(17) <= data_1_17;
              memchg2 <= not memchg2;
            END IF;
          END IF;
        END IF;
      ELSE

        IF (ckw0_ipd'event and ckw0_ipd = '1') THEN
          IF (csw0_ipd = '1') THEN
            wad_0 := conv_integer(aw0_int);

            IF (bw00_ipd = '1') THEN
              data_0_0 := d0_int(7 downto 0);
              data_0_16 := d016_ipd;
              memory(wad_0)(7 downto 0) <= data_0_0;
              memory(wad_0)(16) <= data_0_16;
              memchg3 <= not memchg3;
            END IF;
            IF (bw01_ipd = '1') THEN
              data_0_8 := d0_int(15 downto 8);
              data_0_17 := d017_ipd;
              memory(wad_0)(15 downto 8) <= data_0_8;
              memory(wad_0)(17) <= data_0_17;
              memchg4 <= not memchg4;
            END IF;

          END IF;
        END IF;

        IF (ckw1_ipd'event and ckw1_ipd = '1') THEN
          IF (csw1_ipd = '1') THEN
            wad_1 := conv_integer(aw1_int);

            IF (bw10_ipd = '1') THEN
              data_1_0 := d1_int(7 downto 0);
              data_1_16 := d116_ipd;
              memory(wad_1)(7 downto 0) <= data_1_0;
              memory(wad_1)(16) <= data_1_16;
              memchg5 <= not memchg5;
            END IF;
            IF (bw11_ipd = '1') THEN
              data_1_8 := d1_int(15 downto 8);
              data_1_17 := d117_ipd;
              memory(wad_1)(15 downto 8) <= data_1_8;
              memory(wad_1)(17) <= data_1_17;
              memchg6 <= not memchg6;
            END IF;
          END IF;
        END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 NOREG read operation
----------------------------------------------------------------

   NOREG_READ : PROCESS (ar0_int, ar1_int, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6)
   VARIABLE rad_0     : Integer;
   VARIABLE rad_1     : Integer;
   BEGIN
       rad_0 := conv_integer(ar0_int);
       rad_1 := conv_integer(ar1_int);

       q0_noreg <= memory(rad_0);
       q1_noreg <= memory(rad_1);
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 INREG read operation
----------------------------------------------------------------
   INREG_READ : PROCESS (ckr0_ipd, ckr1_ipd, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6)
   VARIABLE rad_0     : Integer := 0;
   VARIABLE rad_1     : Integer := 0;
   BEGIN

      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_ipd = '1') THEN
           rad_0 := conv_integer(ar0_int);
        END IF;
      END IF;
           q0_inreg <= memory(rad_0);

      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_ipd = '1') THEN
           rad_1 := conv_integer(ar1_int);
        END IF;
      END IF;
           q1_inreg <= memory(rad_1);
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 OUTREG read operation
----------------------------------------------------------------
   OUTREG_READ : PROCESS (ar0_int, ar1_int, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6, ckr0_ipd, ckr1_ipd)
   VARIABLE rad_0     : Integer;
   VARIABLE rad_1     : Integer;
   VARIABLE q0_int    : std_logic_vector(17 downto 0);
   VARIABLE q1_int    : std_logic_vector(17 downto 0);
   BEGIN
       rad_0 := conv_integer(ar0_int);
       rad_1 := conv_integer(ar1_int);
       q0_int  := memory(rad_0);
       q1_int  := memory(rad_1);

      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_ipd = '1') THEN
           q0_outreg <= q0_int;
        END IF;
      END IF;
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_ipd = '1') THEN
           q1_outreg <= q1_int;
        END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 IOREG read operation
----------------------------------------------------------------
   IOREG_READ : PROCESS (ckr0_ipd, ckr1_ipd)
--   VARIABLE rad_0     : Integer;
--   VARIABLE rad_1     : Integer;
   BEGIN
      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_ipd = '1') THEN
--           rad_0 := conv_integer(ar0_int);
           iorad_0 <= conv_integer(ar0_int);
--           q0_int <= memory(rad_0);
        END IF;
        csr0_int <= csr0_ipd;
      END IF;
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_ipd = '1') THEN
--           rad_1 := conv_integer(ar1_int);
           iorad_1 <= conv_integer(ar1_int);
--           q1_int <= memory(rad_1);
        END IF;
        csr1_int <= csr1_ipd;
      END IF;

      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_int = '1') THEN
           q0_ioreg <= q0_int;
        END IF;
      END IF;
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_int = '1') THEN
           q1_ioreg <= q1_int;
        END IF;
      END IF;
   END PROCESS;

   IOREG_READ1 : PROCESS (iorad_0, iorad_1, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6)
   BEGIN
       q0_int <= memory(iorad_0);
       q1_int <= memory(iorad_1);
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q0_inreg, q1_inreg, q0_noreg, q1_noreg, q0_outreg, q1_outreg, q0_ioreg, q1_ioreg, busy0)
     VARIABLE q0_zd   : std_logic_vector(17 downto 0);
     VARIABLE q1_zd   : std_logic_vector(17 downto 0);
     VARIABLE busy_zd : std_logic;

     -- timing check results
        VARIABLE tviol_aw08   : x01 := '0';
        VARIABLE tviol_aw07   : x01 := '0';
        VARIABLE tviol_aw06   : x01 := '0';
        VARIABLE tviol_aw05   : x01 := '0';
        VARIABLE tviol_aw04   : x01 := '0';
        VARIABLE tviol_aw03   : x01 := '0';
        VARIABLE tviol_aw02   : x01 := '0';
        VARIABLE tviol_aw01   : x01 := '0';
        VARIABLE tviol_aw00   : x01 := '0';
        VARIABLE tviol_ar08   : x01 := '0';
        VARIABLE tviol_ar07   : x01 := '0';
        VARIABLE tviol_ar06   : x01 := '0';
        VARIABLE tviol_ar05   : x01 := '0';
        VARIABLE tviol_ar04   : x01 := '0';
        VARIABLE tviol_ar03   : x01 := '0';
        VARIABLE tviol_ar02   : x01 := '0';
        VARIABLE tviol_ar01   : x01 := '0';
        VARIABLE tviol_ar00   : x01 := '0';
        VARIABLE tviol_d017   : x01 := '0';
        VARIABLE tviol_d016   : x01 := '0';
        VARIABLE tviol_d015   : x01 := '0';
        VARIABLE tviol_d014   : x01 := '0';
        VARIABLE tviol_d013   : x01 := '0';
        VARIABLE tviol_d012   : x01 := '0';
        VARIABLE tviol_d011   : x01 := '0';
        VARIABLE tviol_d010   : x01 := '0';
        VARIABLE tviol_d09    : x01 := '0';
        VARIABLE tviol_d08    : x01 := '0';
        VARIABLE tviol_d07    : x01 := '0';
        VARIABLE tviol_d06    : x01 := '0';
        VARIABLE tviol_d05    : x01 := '0';
        VARIABLE tviol_d04    : x01 := '0';
        VARIABLE tviol_d03    : x01 := '0';
        VARIABLE tviol_d02    : x01 := '0';
        VARIABLE tviol_d01    : x01 := '0';
        VARIABLE tviol_d00    : x01 := '0';
        VARIABLE tviol_bw01   : x01 := '0';
        VARIABLE tviol_bw00   : x01 := '0';
        VARIABLE tviol_csw0   : x01 := '0';
        VARIABLE tviol_csr0   : x01 := '0';
        VARIABLE tviol_aw18   : x01 := '0';
        VARIABLE tviol_aw17   : x01 := '0';
        VARIABLE tviol_aw16   : x01 := '0';
        VARIABLE tviol_aw15   : x01 := '0';
        VARIABLE tviol_aw14   : x01 := '0';
        VARIABLE tviol_aw13   : x01 := '0';
        VARIABLE tviol_aw12   : x01 := '0';
        VARIABLE tviol_aw11   : x01 := '0';
        VARIABLE tviol_aw10   : x01 := '0';
        VARIABLE tviol_ar18   : x01 := '0';
        VARIABLE tviol_ar17   : x01 := '0';
        VARIABLE tviol_ar16   : x01 := '0';
        VARIABLE tviol_ar15   : x01 := '0';
        VARIABLE tviol_ar14   : x01 := '0';
        VARIABLE tviol_ar13   : x01 := '0';
        VARIABLE tviol_ar12   : x01 := '0';
        VARIABLE tviol_ar11   : x01 := '0';
        VARIABLE tviol_ar10   : x01 := '0';
        VARIABLE tviol_d117   : x01 := '0';
        VARIABLE tviol_d116   : x01 := '0';
        VARIABLE tviol_d115   : x01 := '0';
        VARIABLE tviol_d114   : x01 := '0';
        VARIABLE tviol_d113   : x01 := '0';
        VARIABLE tviol_d112   : x01 := '0';
        VARIABLE tviol_d111   : x01 := '0';
        VARIABLE tviol_d110   : x01 := '0';
        VARIABLE tviol_d19    : x01 := '0';
        VARIABLE tviol_d18    : x01 := '0';
        VARIABLE tviol_d17    : x01 := '0';
        VARIABLE tviol_d16    : x01 := '0';
        VARIABLE tviol_d15    : x01 := '0';
        VARIABLE tviol_d14    : x01 := '0';
        VARIABLE tviol_d13    : x01 := '0';
        VARIABLE tviol_d12    : x01 := '0';
        VARIABLE tviol_d11    : x01 := '0';
        VARIABLE tviol_d10    : x01 := '0';
        VARIABLE tviol_bw11   : x01 := '0';
        VARIABLE tviol_bw10   : x01 := '0';
        VARIABLE tviol_csw1   : x01 := '0';
        VARIABLE tviol_csr1   : x01 := '0';

        VARIABLE aw08_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw07_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw06_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw05_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw04_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw03_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw02_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw01_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw00_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE ar08_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar07_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar06_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar05_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar04_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar03_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar02_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar01_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar00_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE d017_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d016_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d015_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d014_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d013_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d012_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d011_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d010_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d09_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d08_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d07_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d06_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d05_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d04_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d03_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d02_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d01_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d00_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE bw01_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE bw00_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE csw0_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE csr0_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE aw18_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw17_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw16_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw15_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw14_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw13_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw12_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw11_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw10_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE ar18_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar17_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar16_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar15_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar14_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar13_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar12_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar11_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar10_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE d117_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d116_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d115_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d114_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d113_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d112_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d111_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d110_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d19_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d18_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d17_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d16_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d15_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d14_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d13_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d12_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d11_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d10_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE bw11_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE bw10_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE csw1_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE csr1_ckr1_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE q017_GlitchData:      VitalGlitchDataType;
        VARIABLE q016_GlitchData:      VitalGlitchDataType;
        VARIABLE q015_GlitchData:      VitalGlitchDataType;
        VARIABLE q014_GlitchData:      VitalGlitchDataType;
        VARIABLE q013_GlitchData:      VitalGlitchDataType;
        VARIABLE q012_GlitchData:      VitalGlitchDataType;
        VARIABLE q011_GlitchData:      VitalGlitchDataType;
        VARIABLE q010_GlitchData:      VitalGlitchDataType;
        VARIABLE q09_GlitchData :      VitalGlitchDataType;
        VARIABLE q08_GlitchData :      VitalGlitchDataType;
        VARIABLE q07_GlitchData :      VitalGlitchDataType;
        VARIABLE q06_GlitchData :      VitalGlitchDataType;
        VARIABLE q05_GlitchData :      VitalGlitchDataType;
        VARIABLE q04_GlitchData :      VitalGlitchDataType;
        VARIABLE q03_GlitchData :      VitalGlitchDataType;
        VARIABLE q02_GlitchData :      VitalGlitchDataType;
        VARIABLE q01_GlitchData :      VitalGlitchDataType;
        VARIABLE q00_GlitchData :      VitalGlitchDataType;
        VARIABLE q117_GlitchData:      VitalGlitchDataType;
        VARIABLE q116_GlitchData:      VitalGlitchDataType;
        VARIABLE q115_GlitchData:      VitalGlitchDataType;
        VARIABLE q114_GlitchData:      VitalGlitchDataType;
        VARIABLE q113_GlitchData:      VitalGlitchDataType;
        VARIABLE q112_GlitchData:      VitalGlitchDataType;
        VARIABLE q111_GlitchData:      VitalGlitchDataType;
        VARIABLE q110_GlitchData:      VitalGlitchDataType;
        VARIABLE q19_GlitchData :      VitalGlitchDataType;
        VARIABLE q18_GlitchData :      VitalGlitchDataType;
        VARIABLE q17_GlitchData :      VitalGlitchDataType;
        VARIABLE q16_GlitchData :      VitalGlitchDataType;
        VARIABLE q15_GlitchData :      VitalGlitchDataType;
        VARIABLE q14_GlitchData :      VitalGlitchDataType;
        VARIABLE q13_GlitchData :      VitalGlitchDataType;
        VARIABLE q12_GlitchData :      VitalGlitchDataType;
        VARIABLE q11_GlitchData :      VitalGlitchDataType;
        VARIABLE q10_GlitchData :      VitalGlitchDataType;
        VARIABLE busy_GlitchData:      VitalGlitchDataType;

    BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => aw08_ipd,
                TestSignalName => "aw08",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw08_ckw0_noedge_posedge,
                setuplow => tsetup_aw08_ckw0_noedge_posedge,
                HoldHigh => thold_aw08_ckw0_noedge_posedge,
                Holdlow => thold_aw08_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw08_ckw0_TimingDatash,
                Violation => tviol_aw08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw07_ipd,
                TestSignalName => "aw07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw07_ckw0_noedge_posedge,
                setuplow => tsetup_aw07_ckw0_noedge_posedge,
                HoldHigh => thold_aw07_ckw0_noedge_posedge,
                Holdlow => thold_aw07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw07_ckw0_TimingDatash,
                Violation => tviol_aw07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw06_ipd,
                TestSignalName => "aw06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw06_ckw0_noedge_posedge,
                setuplow => tsetup_aw06_ckw0_noedge_posedge,
                HoldHigh => thold_aw06_ckw0_noedge_posedge,
                Holdlow => thold_aw06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw06_ckw0_TimingDatash,
                Violation => tviol_aw06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw05_ipd,
                TestSignalName => "aw05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw05_ckw0_noedge_posedge,
                setuplow => tsetup_aw05_ckw0_noedge_posedge,
                HoldHigh => thold_aw05_ckw0_noedge_posedge,
                Holdlow => thold_aw05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw05_ckw0_TimingDatash,
                Violation => tviol_aw05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw04_ipd,
                TestSignalName => "aw04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw04_ckw0_noedge_posedge,
                setuplow => tsetup_aw04_ckw0_noedge_posedge,
                HoldHigh => thold_aw04_ckw0_noedge_posedge,
                Holdlow => thold_aw04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw04_ckw0_TimingDatash,
                Violation => tviol_aw04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw03_ipd,
                TestSignalName => "aw03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw03_ckw0_noedge_posedge,
                setuplow => tsetup_aw03_ckw0_noedge_posedge,
                HoldHigh => thold_aw03_ckw0_noedge_posedge,
                Holdlow => thold_aw03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw03_ckw0_TimingDatash,
                Violation => tviol_aw03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw02_ipd,
                TestSignalName => "aw02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw02_ckw0_noedge_posedge,
                setuplow => tsetup_aw02_ckw0_noedge_posedge,
                HoldHigh => thold_aw02_ckw0_noedge_posedge,
                Holdlow => thold_aw02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw02_ckw0_TimingDatash,
                Violation => tviol_aw02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw01_ipd,
                TestSignalName => "aw01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw01_ckw0_noedge_posedge,
                setuplow => tsetup_aw01_ckw0_noedge_posedge,
                HoldHigh => thold_aw01_ckw0_noedge_posedge,
                Holdlow => thold_aw01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw01_ckw0_TimingDatash,
                Violation => tviol_aw01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw00_ipd,
                TestSignalName => "aw00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw00_ckw0_noedge_posedge,
                setuplow => tsetup_aw00_ckw0_noedge_posedge,
                HoldHigh => thold_aw00_ckw0_noedge_posedge,
                Holdlow => thold_aw00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw00_ckw0_TimingDatash,
                Violation => tviol_aw00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar08_ipd,
                TestSignalName => "ar08",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar08_ckr0_noedge_posedge,
                setuplow => tsetup_ar08_ckr0_noedge_posedge,
                HoldHigh => thold_ar08_ckr0_noedge_posedge,
                Holdlow => thold_ar08_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar08_ckr0_TimingDatash,
                Violation => tviol_ar08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar07_ipd,
                TestSignalName => "ar07",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar07_ckr0_noedge_posedge,
                setuplow => tsetup_ar07_ckr0_noedge_posedge,
                HoldHigh => thold_ar07_ckr0_noedge_posedge,
                Holdlow => thold_ar07_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar07_ckr0_TimingDatash,
                Violation => tviol_ar07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar06_ipd,
                TestSignalName => "ar06",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar06_ckr0_noedge_posedge,
                setuplow => tsetup_ar06_ckr0_noedge_posedge,
                HoldHigh => thold_ar06_ckr0_noedge_posedge,
                Holdlow => thold_ar06_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar06_ckr0_TimingDatash,
                Violation => tviol_ar06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar05_ipd,
                TestSignalName => "ar05",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar05_ckr0_noedge_posedge,
                setuplow => tsetup_ar05_ckr0_noedge_posedge,
                HoldHigh => thold_ar05_ckr0_noedge_posedge,
                Holdlow => thold_ar05_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar05_ckr0_TimingDatash,
                Violation => tviol_ar05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar04_ipd,
                TestSignalName => "ar04",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar04_ckr0_noedge_posedge,
                setuplow => tsetup_ar04_ckr0_noedge_posedge,
                HoldHigh => thold_ar04_ckr0_noedge_posedge,
                Holdlow => thold_ar04_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar04_ckr0_TimingDatash,
                Violation => tviol_ar04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar03_ipd,
                TestSignalName => "ar03",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar03_ckr0_noedge_posedge,
                setuplow => tsetup_ar03_ckr0_noedge_posedge,
                HoldHigh => thold_ar03_ckr0_noedge_posedge,
                Holdlow => thold_ar03_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar03_ckr0_TimingDatash,
                Violation => tviol_ar03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar02_ipd,
                TestSignalName => "ar02",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar02_ckr0_noedge_posedge,
                setuplow => tsetup_ar02_ckr0_noedge_posedge,
                HoldHigh => thold_ar02_ckr0_noedge_posedge,
                Holdlow => thold_ar02_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar02_ckr0_TimingDatash,
                Violation => tviol_ar02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar01_ipd,
                TestSignalName => "ar01",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar01_ckr0_noedge_posedge,
                SetupLow => tsetup_ar01_ckr0_noedge_posedge,
                HoldHigh => thold_ar01_ckr0_noedge_posedge,
                Holdlow => thold_ar01_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar01_ckr0_TimingDatash,
                Violation => tviol_ar01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar00_ipd,
                TestSignalName => "ar00",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar00_ckr0_noedge_posedge,
                setuplow => tsetup_ar00_ckr0_noedge_posedge,
                HoldHigh => thold_ar00_ckr0_noedge_posedge,
                Holdlow => thold_ar00_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar00_ckr0_TimingDatash,
                Violation => tviol_ar00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d017_ipd,
                TestSignalName => "d017",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d017_ckw0_noedge_posedge,
                setuplow => tsetup_d017_ckw0_noedge_posedge,
                HoldHigh => thold_d017_ckw0_noedge_posedge,
                Holdlow => thold_d017_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d017_ckw0_TimingDatash,
                Violation => tviol_d017,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d016_ipd,
                TestSignalName => "d016",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d016_ckw0_noedge_posedge,
                setuplow => tsetup_d016_ckw0_noedge_posedge,
                HoldHigh => thold_d016_ckw0_noedge_posedge,
                Holdlow => thold_d016_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d016_ckw0_TimingDatash,
                Violation => tviol_d016,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d015_ipd,
                TestSignalName => "d015",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d015_ckw0_noedge_posedge,
                setuplow => tsetup_d015_ckw0_noedge_posedge,
                HoldHigh => thold_d015_ckw0_noedge_posedge,
                Holdlow => thold_d015_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d015_ckw0_TimingDatash,
                Violation => tviol_d015,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d014_ipd,
                TestSignalName => "d014",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d014_ckw0_noedge_posedge,
                setuplow => tsetup_d014_ckw0_noedge_posedge,
                HoldHigh => thold_d014_ckw0_noedge_posedge,
                Holdlow => thold_d014_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d014_ckw0_TimingDatash,
                Violation => tviol_d014,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d013_ipd,
                TestSignalName => "d013",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d013_ckw0_noedge_posedge,
                setuplow => tsetup_d013_ckw0_noedge_posedge,
                HoldHigh => thold_d013_ckw0_noedge_posedge,
                Holdlow => thold_d013_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d013_ckw0_TimingDatash,
                Violation => tviol_d013,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d012_ipd,
                TestSignalName => "d012",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d012_ckw0_noedge_posedge,
                setuplow => tsetup_d012_ckw0_noedge_posedge,
                HoldHigh => thold_d012_ckw0_noedge_posedge,
                Holdlow => thold_d012_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d012_ckw0_TimingDatash,
                Violation => tviol_d012,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d011_ipd,
                TestSignalName => "d011",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d011_ckw0_noedge_posedge,
                setuplow => tsetup_d011_ckw0_noedge_posedge,
                HoldHigh => thold_d011_ckw0_noedge_posedge,
                Holdlow => thold_d011_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d011_ckw0_TimingDatash,
                Violation => tviol_d011,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d010_ipd,
                TestSignalName => "d010",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d010_ckw0_noedge_posedge,
                setuplow => tsetup_d010_ckw0_noedge_posedge,
                HoldHigh => thold_d010_ckw0_noedge_posedge,
                Holdlow => thold_d010_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d010_ckw0_TimingDatash,
                Violation => tviol_d010,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d09_ipd,
                TestSignalName => "d09",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d09_ckw0_noedge_posedge,
                setuplow => tsetup_d09_ckw0_noedge_posedge,
                HoldHigh => thold_d09_ckw0_noedge_posedge,
                Holdlow => thold_d09_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d09_ckw0_TimingDatash,
                Violation => tviol_d09,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d08_ipd,
                TestSignalName => "d08",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d08_ckw0_noedge_posedge,
                setuplow => tsetup_d08_ckw0_noedge_posedge,
                HoldHigh => thold_d08_ckw0_noedge_posedge,
                Holdlow => thold_d08_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d08_ckw0_TimingDatash,
                Violation => tviol_d08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d07_ipd,
                TestSignalName => "d07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d07_ckw0_noedge_posedge,
                setuplow => tsetup_d07_ckw0_noedge_posedge,
                HoldHigh => thold_d07_ckw0_noedge_posedge,
                Holdlow => thold_d07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d07_ckw0_TimingDatash,
                Violation => tviol_d07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d06_ipd,
                TestSignalName => "d06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d06_ckw0_noedge_posedge,
                setuplow => tsetup_d06_ckw0_noedge_posedge,
                HoldHigh => thold_d06_ckw0_noedge_posedge,
                Holdlow => thold_d06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d06_ckw0_TimingDatash,
                Violation => tviol_d06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d05_ipd,
                TestSignalName => "d05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d05_ckw0_noedge_posedge,
                setuplow => tsetup_d05_ckw0_noedge_posedge,
                HoldHigh => thold_d05_ckw0_noedge_posedge,
                Holdlow => thold_d05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d05_ckw0_TimingDatash,
                Violation => tviol_d05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d04_ipd,
                TestSignalName => "d04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d04_ckw0_noedge_posedge,
                setuplow => tsetup_d04_ckw0_noedge_posedge,
                HoldHigh => thold_d04_ckw0_noedge_posedge,
                Holdlow => thold_d04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d04_ckw0_TimingDatash,
                Violation => tviol_d04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d03_ipd,
                TestSignalName => "d03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d03_ckw0_noedge_posedge,
                setuplow => tsetup_d03_ckw0_noedge_posedge,
                HoldHigh => thold_d03_ckw0_noedge_posedge,
                Holdlow => thold_d03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d03_ckw0_TimingDatash,
                Violation => tviol_d03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d02_ipd,
                TestSignalName => "d02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d02_ckw0_noedge_posedge,
                setuplow => tsetup_d02_ckw0_noedge_posedge,
                HoldHigh => thold_d02_ckw0_noedge_posedge,
                Holdlow => thold_d02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d02_ckw0_TimingDatash,
                Violation => tviol_d02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d01_ipd,
                TestSignalName => "d01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d01_ckw0_noedge_posedge,
                setuplow => tsetup_d01_ckw0_noedge_posedge,
                HoldHigh => thold_d01_ckw0_noedge_posedge,
                Holdlow => thold_d01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d01_ckw0_TimingDatash,
                Violation => tviol_d01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d00_ipd,
                TestSignalName => "d00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d00_ckw0_noedge_posedge,
                setuplow => tsetup_d00_ckw0_noedge_posedge,
                HoldHigh => thold_d00_ckw0_noedge_posedge,
                Holdlow => thold_d00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d00_ckw0_TimingDatash,
                Violation => tviol_d00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw01_ipd,
                TestSignalName => "bw01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_bw01_ckw0_noedge_posedge,
                setuplow => tsetup_bw01_ckw0_noedge_posedge,
                HoldHigh => thold_bw01_ckw0_noedge_posedge,
                Holdlow => thold_bw01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw01_ckw0_TimingDatash,
                Violation => tviol_bw01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw00_ipd,
                TestSignalName => "bw00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_bw00_ckw0_noedge_posedge,
                setuplow => tsetup_bw00_ckw0_noedge_posedge,
                HoldHigh => thold_bw00_ckw0_noedge_posedge,
                Holdlow => thold_bw00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw00_ckw0_TimingDatash,
                Violation => tviol_bw00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csw0_ipd,
                TestSignalName => "csw0",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_csw0_ckw0_noedge_posedge,
                setuplow => tsetup_csw0_ckw0_noedge_posedge,
                HoldHigh => thold_csw0_ckw0_noedge_posedge,
                Holdlow => thold_csw0_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csw0_ckw0_TimingDatash,
                Violation => tviol_csw0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csr0_ipd,
                TestSignalName => "csr0",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_csr0_ckr0_noedge_posedge,
                setuplow => tsetup_csr0_ckr0_noedge_posedge,
                HoldHigh => thold_csr0_ckr0_noedge_posedge,
                Holdlow => thold_csr0_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csr0_ckr0_TimingDatash,
                Violation => tviol_csr0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw18_ipd,
                TestSignalName => "aw18",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw18_ckw1_noedge_posedge,
                setuplow => tsetup_aw18_ckw1_noedge_posedge,
                HoldHigh => thold_aw18_ckw1_noedge_posedge,
                Holdlow => thold_aw18_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw18_ckw1_TimingDatash,
                Violation => tviol_aw18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw17_ipd,
                TestSignalName => "aw17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw17_ckw1_noedge_posedge,
                setuplow => tsetup_aw17_ckw1_noedge_posedge,
                HoldHigh => thold_aw17_ckw1_noedge_posedge,
                Holdlow => thold_aw17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw17_ckw1_TimingDatash,
                Violation => tviol_aw17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw16_ipd,
                TestSignalName => "aw16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw16_ckw1_noedge_posedge,
                setuplow => tsetup_aw16_ckw1_noedge_posedge,
                HoldHigh => thold_aw16_ckw1_noedge_posedge,
                Holdlow => thold_aw16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw16_ckw1_TimingDatash,
                Violation => tviol_aw16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw15_ipd,
                TestSignalName => "aw15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw15_ckw1_noedge_posedge,
                setuplow => tsetup_aw15_ckw1_noedge_posedge,
                HoldHigh => thold_aw15_ckw1_noedge_posedge,
                Holdlow => thold_aw15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw15_ckw1_TimingDatash,
                Violation => tviol_aw15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw14_ipd,
                TestSignalName => "aw14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw14_ckw1_noedge_posedge,
                setuplow => tsetup_aw14_ckw1_noedge_posedge,
                HoldHigh => thold_aw14_ckw1_noedge_posedge,
                Holdlow => thold_aw14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw14_ckw1_TimingDatash,
                Violation => tviol_aw14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw13_ipd,
                TestSignalName => "aw13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw13_ckw1_noedge_posedge,
                setuplow => tsetup_aw13_ckw1_noedge_posedge,
                HoldHigh => thold_aw13_ckw1_noedge_posedge,
                Holdlow => thold_aw13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw13_ckw1_TimingDatash,
                Violation => tviol_aw13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw12_ipd,
                TestSignalName => "aw12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw12_ckw1_noedge_posedge,
                setuplow => tsetup_aw12_ckw1_noedge_posedge,
                HoldHigh => thold_aw12_ckw1_noedge_posedge,
                Holdlow => thold_aw12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw12_ckw1_TimingDatash,
                Violation => tviol_aw12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw11_ipd,
                TestSignalName => "aw11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw11_ckw1_noedge_posedge,
                setuplow => tsetup_aw11_ckw1_noedge_posedge,
                HoldHigh => thold_aw11_ckw1_noedge_posedge,
                Holdlow => thold_aw11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw11_ckw1_TimingDatash,
                Violation => tviol_aw11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw10_ipd,
                TestSignalName => "aw10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw10_ckw1_noedge_posedge,
                setuplow => tsetup_aw10_ckw1_noedge_posedge,
                HoldHigh => thold_aw10_ckw1_noedge_posedge,
                Holdlow => thold_aw10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw10_ckw1_TimingDatash,
                Violation => tviol_aw10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar18_ipd,
                TestSignalName => "ar18",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar18_ckr1_noedge_posedge,
                setuplow => tsetup_ar18_ckr1_noedge_posedge,
                HoldHigh => thold_ar18_ckr1_noedge_posedge,
                Holdlow => thold_ar18_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar18_ckr1_TimingDatash,
                Violation => tviol_ar18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar17_ipd,
                TestSignalName => "ar17",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar17_ckr1_noedge_posedge,
                setuplow => tsetup_ar17_ckr1_noedge_posedge,
                HoldHigh => thold_ar17_ckr1_noedge_posedge,
                Holdlow => thold_ar17_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar17_ckr1_TimingDatash,
                Violation => tviol_ar17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar16_ipd,
                TestSignalName => "ar16",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar16_ckr1_noedge_posedge,
                setuplow => tsetup_ar16_ckr1_noedge_posedge,
                HoldHigh => thold_ar16_ckr1_noedge_posedge,
                Holdlow => thold_ar16_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar16_ckr1_TimingDatash,
                Violation => tviol_ar16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar15_ipd,
                TestSignalName => "ar15",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar15_ckr1_noedge_posedge,
                setuplow => tsetup_ar15_ckr1_noedge_posedge,
                HoldHigh => thold_ar15_ckr1_noedge_posedge,
                Holdlow => thold_ar15_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar15_ckr1_TimingDatash,
                Violation => tviol_ar15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar14_ipd,
                TestSignalName => "ar14",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar14_ckr1_noedge_posedge,
                setuplow => tsetup_ar14_ckr1_noedge_posedge,
                HoldHigh => thold_ar14_ckr1_noedge_posedge,
                Holdlow => thold_ar14_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar14_ckr1_TimingDatash,
                Violation => tviol_ar14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar13_ipd,
                TestSignalName => "ar13",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar13_ckr1_noedge_posedge,
                setuplow => tsetup_ar13_ckr1_noedge_posedge,
                HoldHigh => thold_ar13_ckr1_noedge_posedge,
                Holdlow => thold_ar13_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar13_ckr1_TimingDatash,
                Violation => tviol_ar13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar12_ipd,
                TestSignalName => "ar12",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar12_ckr1_noedge_posedge,
                setuplow => tsetup_ar12_ckr1_noedge_posedge,
                HoldHigh => thold_ar12_ckr1_noedge_posedge,
                Holdlow => thold_ar12_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar12_ckr1_TimingDatash,
                Violation => tviol_ar12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar11_ipd,
                TestSignalName => "ar11",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar11_ckr1_noedge_posedge,
                setuplow => tsetup_ar11_ckr1_noedge_posedge,
                HoldHigh => thold_ar11_ckr1_noedge_posedge,
                Holdlow => thold_ar11_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar11_ckr1_TimingDatash,
                Violation => tviol_ar11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar10_ipd,
                TestSignalName => "ar10",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar10_ckr1_noedge_posedge,
                setuplow => tsetup_ar10_ckr1_noedge_posedge,
                HoldHigh => thold_ar10_ckr1_noedge_posedge,
                Holdlow => thold_ar10_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar10_ckr1_TimingDatash,
                Violation => tviol_ar10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d117_ipd,
                TestSignalName => "d117",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d117_ckw1_noedge_posedge,
                setuplow => tsetup_d117_ckw1_noedge_posedge,
                HoldHigh => thold_d117_ckw1_noedge_posedge,
                Holdlow => thold_d117_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d117_ckw1_TimingDatash,
                Violation => tviol_d117,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d116_ipd,
                TestSignalName => "d116",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d116_ckw1_noedge_posedge,
                setuplow => tsetup_d116_ckw1_noedge_posedge,
                HoldHigh => thold_d116_ckw1_noedge_posedge,
                Holdlow => thold_d116_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d116_ckw1_TimingDatash,
                Violation => tviol_d116,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d115_ipd,
                TestSignalName => "d115",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d115_ckw1_noedge_posedge,
                setuplow => tsetup_d115_ckw1_noedge_posedge,
                HoldHigh => thold_d115_ckw1_noedge_posedge,
                Holdlow => thold_d115_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d115_ckw1_TimingDatash,
                Violation => tviol_d115,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d114_ipd,
                TestSignalName => "d114",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d114_ckw1_noedge_posedge,
                setuplow => tsetup_d114_ckw1_noedge_posedge,
                HoldHigh => thold_d114_ckw1_noedge_posedge,
                Holdlow => thold_d114_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d114_ckw1_TimingDatash,
                Violation => tviol_d114,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d113_ipd,
                TestSignalName => "d113",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d113_ckw1_noedge_posedge,
                setuplow => tsetup_d113_ckw1_noedge_posedge,
                HoldHigh => thold_d113_ckw1_noedge_posedge,
                Holdlow => thold_d113_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d113_ckw1_TimingDatash,
                Violation => tviol_d113,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d112_ipd,
                TestSignalName => "d112",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d112_ckw1_noedge_posedge,
                setuplow => tsetup_d112_ckw1_noedge_posedge,
                HoldHigh => thold_d112_ckw1_noedge_posedge,
                Holdlow => thold_d112_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d112_ckw1_TimingDatash,
                Violation => tviol_d112,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d111_ipd,
                TestSignalName => "d111",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d111_ckw1_noedge_posedge,
                setuplow => tsetup_d111_ckw1_noedge_posedge,
                HoldHigh => thold_d111_ckw1_noedge_posedge,
                Holdlow => thold_d111_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d111_ckw1_TimingDatash,
                Violation => tviol_d111,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d110_ipd,
                TestSignalName => "d110",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d110_ckw1_noedge_posedge,
                setuplow => tsetup_d110_ckw1_noedge_posedge,
                HoldHigh => thold_d110_ckw1_noedge_posedge,
                Holdlow => thold_d110_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d110_ckw1_TimingDatash,
                Violation => tviol_d110,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d19_ipd,
                TestSignalName => "d19",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d19_ckw1_noedge_posedge,
                setuplow => tsetup_d19_ckw1_noedge_posedge,
                HoldHigh => thold_d19_ckw1_noedge_posedge,
                Holdlow => thold_d19_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d19_ckw1_TimingDatash,
                Violation => tviol_d19,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d18_ipd,
                TestSignalName => "d18",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d18_ckw1_noedge_posedge,
                setuplow => tsetup_d18_ckw1_noedge_posedge,
                HoldHigh => thold_d18_ckw1_noedge_posedge,
                Holdlow => thold_d18_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d18_ckw1_TimingDatash,
                Violation => tviol_d18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d17_ipd,
                TestSignalName => "d17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d17_ckw1_noedge_posedge,
                setuplow => tsetup_d17_ckw1_noedge_posedge,
                HoldHigh => thold_d17_ckw1_noedge_posedge,
                Holdlow => thold_d17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d17_ckw1_TimingDatash,
                Violation => tviol_d17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d16_ipd,
                TestSignalName => "d16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d16_ckw1_noedge_posedge,
                setuplow => tsetup_d16_ckw1_noedge_posedge,
                HoldHigh => thold_d16_ckw1_noedge_posedge,
                Holdlow => thold_d16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d16_ckw1_TimingDatash,
                Violation => tviol_d16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d15_ipd,
                TestSignalName => "d15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d15_ckw1_noedge_posedge,
                setuplow => tsetup_d15_ckw1_noedge_posedge,
                HoldHigh => thold_d15_ckw1_noedge_posedge,
                Holdlow => thold_d15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d15_ckw1_TimingDatash,
                Violation => tviol_d15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d14_ipd,
                TestSignalName => "d14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d14_ckw1_noedge_posedge,
                setuplow => tsetup_d14_ckw1_noedge_posedge,
                HoldHigh => thold_d14_ckw1_noedge_posedge,
                Holdlow => thold_d14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d14_ckw1_TimingDatash,
                Violation => tviol_d14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d13_ipd,
                TestSignalName => "d13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d13_ckw1_noedge_posedge,
                setuplow => tsetup_d13_ckw1_noedge_posedge,
                HoldHigh => thold_d13_ckw1_noedge_posedge,
                Holdlow => thold_d13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d13_ckw1_TimingDatash,
                Violation => tviol_d13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d12_ipd,
                TestSignalName => "d12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d12_ckw1_noedge_posedge,
                setuplow => tsetup_d12_ckw1_noedge_posedge,
                HoldHigh => thold_d12_ckw1_noedge_posedge,
                Holdlow => thold_d12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d12_ckw1_TimingDatash,
                Violation => tviol_d12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d11_ipd,
                TestSignalName => "d11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d11_ckw1_noedge_posedge,
                setuplow => tsetup_d11_ckw1_noedge_posedge,
                HoldHigh => thold_d11_ckw1_noedge_posedge,
                Holdlow => thold_d11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d11_ckw1_TimingDatash,
                Violation => tviol_d11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d10_ipd,
                TestSignalName => "d10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d10_ckw1_noedge_posedge,
                setuplow => tsetup_d10_ckw1_noedge_posedge,
                HoldHigh => thold_d10_ckw1_noedge_posedge,
                Holdlow => thold_d10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d10_ckw1_TimingDatash,
                Violation => tviol_d10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw11_ipd,
                TestSignalName => "bw11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_bw11_ckw1_noedge_posedge,
                setuplow => tsetup_bw11_ckw1_noedge_posedge,
                HoldHigh => thold_bw11_ckw1_noedge_posedge,
                Holdlow => thold_bw11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw11_ckw1_TimingDatash,
                Violation => tviol_bw11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw10_ipd,
                TestSignalName => "bw10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_bw10_ckw1_noedge_posedge,
                setuplow => tsetup_bw10_ckw1_noedge_posedge,
                HoldHigh => thold_bw10_ckw1_noedge_posedge,
                Holdlow => thold_bw10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw10_ckw1_TimingDatash,
                Violation => tviol_bw10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csw1_ipd,
                TestSignalName => "csw1",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_csw1_ckw1_noedge_posedge,
                setuplow => tsetup_csw1_ckw1_noedge_posedge,
                HoldHigh => thold_csw1_ckw1_noedge_posedge,
                Holdlow => thold_csw1_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csw1_ckw1_TimingDatash,
                Violation => tviol_csw1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csr1_ipd,
                TestSignalName => "csr1",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_csr1_ckr1_noedge_posedge,
                setuplow => tsetup_csr1_ckr1_noedge_posedge,
                HoldHigh => thold_csr1_ckr1_noedge_posedge,
                Holdlow => thold_csr1_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csr1_ckr1_TimingDatash,
                Violation => tviol_csr1,
                MsgSeverity => warning);

   END IF;

   ------------------------
   -- functionality section
   ------------------------
   IF (mode0_reg = "INREG") THEN
        q0_zd := q0_inreg;
   ELSIF (mode0_reg = "OUTREG") THEN
        q0_zd := q0_outreg;
   ELSIF (mode0_reg = "IOREG") THEN
      IF (port0_valid = '1') THEN
          q0_zd := q0_ioreg;
      END IF;
   ELSE
        q0_zd := q0_noreg;
   END IF;

   IF (mode1_reg = "INREG") THEN
        q1_zd := q1_inreg;
   ELSIF (mode1_reg = "OUTREG") THEN
        q1_zd := q1_outreg;
   ELSIF (mode1_reg = "IOREG") THEN
        q1_zd := q1_ioreg;
   ELSE
        q1_zd := q1_noreg;
   END IF;

        busy_zd    := busy0;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q017, OutSignalName => "q017", OutTemp => q0_zd(17),
        Paths      => (0 => (InputChangeTime => ar00_ipd'last_event,
                             PathDelay => tpd_ar00_q017,
                             PathCondition => TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q017, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q017, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q017, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q017, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q017, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q017, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q017, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q017, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q017, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q017, TRUE)),
        GlitchData => q017_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q016, OutSignalName => "q016", OutTemp => q0_zd(16),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q016, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q016, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q016, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q016, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q016, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q016, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q016, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q016, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q016, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q016, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q016, TRUE)),
        GlitchData => q016_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q015, OutSignalName => "q015", OutTemp => q0_zd(15),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q015, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q015, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q015, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q015, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q015, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q015, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q015, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q015, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q015, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q015, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q015, TRUE)),
        GlitchData => q015_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q014, OutSignalName => "q014", OutTemp => q0_zd(14),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q014, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q014, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q014, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q014, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q014, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q014, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q014, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q014, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q014, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q014, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q014, TRUE)),
        GlitchData => q014_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q013, OutSignalName => "q013", OutTemp => q0_zd(13),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q013, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q013, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q013, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q013, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q013, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q013, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q013, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q013, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q013, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q013, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q013, TRUE)),
        GlitchData => q013_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q012, OutSignalName => "q012", OutTemp => q0_zd(12),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q012, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q012, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q012, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q012, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q012, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q012, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q012, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q012, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q012, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q012, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q012, TRUE)),
        GlitchData => q012_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q011, OutSignalName => "q011", OutTemp => q0_zd(11),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q011, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q011, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q011, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q011, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q011, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q011, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q011, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q011, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q011, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q011, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q011, TRUE)),
        GlitchData => q011_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q010, OutSignalName => "q010", OutTemp => q0_zd(10),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q010, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q010, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q010, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q010, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q010, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q010, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q010, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q010, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q010, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q010, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q010, TRUE)),
        GlitchData => q010_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q09, OutSignalName => "q09", OutTemp => q0_zd(9),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q09, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q09, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q09, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q09, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q09, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q09, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q09, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q09, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q09, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q09, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q09, TRUE)),
        GlitchData => q09_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q08, OutSignalName => "q08", OutTemp => q0_zd(8),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q08, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q08, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q08, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q08, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q08, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q08, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q08, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q08, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q08, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q08, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q08, TRUE)),
        GlitchData => q08_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q07, OutSignalName => "q07", OutTemp => q0_zd(7),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q07, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q07, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q07, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q07, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q07, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q07, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q07, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q07, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q07, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q07, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q07, TRUE)),
        GlitchData => q07_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q06, OutSignalName => "q06", OutTemp => q0_zd(6),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q06, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q06, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q06, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q06, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q06, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q06, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q06, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q06, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q06, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q06, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q06, TRUE)),
        GlitchData => q06_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q05, OutSignalName => "q05", OutTemp => q0_zd(5),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q05, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q05, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q05, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q05, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q05, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q05, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q05, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q05, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q05, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q05, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q05, TRUE)),
        GlitchData => q05_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q04, OutSignalName => "q04", OutTemp => q0_zd(4),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q04, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q04, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q04, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q04, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q04, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q04, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q04, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q04, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q04, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q04, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q04, TRUE)),
        GlitchData => q04_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q03, OutSignalName => "q03", OutTemp => q0_zd(3),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q03, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q03, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q03, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q03, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q03, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q03, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q03, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q03, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q03, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q03, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q03, TRUE)),
        GlitchData => q03_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q02, OutSignalName => "q02", OutTemp => q0_zd(2),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q02, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q02, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q02, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q02, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q02, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q02, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q02, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q02, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q02, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q02, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q02, TRUE)),
        GlitchData => q02_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q01, OutSignalName => "q01", OutTemp => q0_zd(1),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q01, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q01, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q01, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q01, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q01, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q01, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q01, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q01, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q01, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q01, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q01, TRUE)),
        GlitchData => q01_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q00, OutSignalName => "q00", OutTemp => q0_zd(0),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q00, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q00, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q00, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q00, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q00, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q00, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q00, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q00, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q00, TRUE),
                       9 => (ckr0_ipd'last_event, tpd_ckr0_q00, TRUE),
                      10 => (ckw0_ipd'last_event, tpd_ckw0_q00, TRUE)),
        GlitchData => q00_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q117, OutSignalName => "q117", OutTemp => q1_zd(17),
        Paths      => (0 => (InputChangeTime => ar10_ipd'last_event,
                             PathDelay => tpd_ar10_q117,
                             PathCondition => TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q117, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q117, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q117, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q117, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q117, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q117, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q117, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q117, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q117, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q117, TRUE)),
        GlitchData => q117_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q116, OutSignalName => "q116", OutTemp => q1_zd(16),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q116, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q116, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q116, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q116, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q116, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q116, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q116, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q116, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q116, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q116, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q116, TRUE)),
        GlitchData => q116_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q115, OutSignalName => "q115", OutTemp => q1_zd(15),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q115, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q115, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q115, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q115, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q115, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q115, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q115, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q115, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q115, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q115, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q115, TRUE)),
        GlitchData => q115_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q114, OutSignalName => "q114", OutTemp => q1_zd(14),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q114, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q114, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q114, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q114, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q114, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q114, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q114, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q114, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q114, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q114, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q114, TRUE)),
        GlitchData => q114_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q113, OutSignalName => "q113", OutTemp => q1_zd(13),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q113, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q113, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q113, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q113, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q113, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q113, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q113, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q113, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q113, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q113, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q113, TRUE)),
        GlitchData => q113_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q112, OutSignalName => "q112", OutTemp => q1_zd(12),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q112, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q112, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q112, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q112, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q112, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q112, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q112, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q112, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q112, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q112, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q112, TRUE)),
        GlitchData => q112_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q111, OutSignalName => "q111", OutTemp => q1_zd(11),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q111, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q111, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q111, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q111, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q111, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q111, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q111, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q111, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q111, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q111, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q111, TRUE)),
        GlitchData => q111_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q110, OutSignalName => "q110", OutTemp => q1_zd(10),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q110, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q110, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q110, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q110, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q110, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q110, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q110, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q110, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q110, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q110, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q110, TRUE)),
        GlitchData => q110_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q19, OutSignalName => "q19", OutTemp => q1_zd(9),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q19, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q19, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q19, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q19, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q19, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q19, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q19, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q19, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q19, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q19, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q19, TRUE)),
        GlitchData => q19_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q18, OutSignalName => "q18", OutTemp => q1_zd(8),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q18, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q18, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q18, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q18, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q18, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q18, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q18, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q18, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q18, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q18, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q18, TRUE)),
        GlitchData => q18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q17, OutSignalName => "q17", OutTemp => q1_zd(7),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q17, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q17, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q17, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q17, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q17, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q17, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q17, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q17, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q17, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q17, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q17, TRUE)),
        GlitchData => q17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q16, OutSignalName => "q16", OutTemp => q1_zd(6),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q16, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q16, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q16, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q16, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q16, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q16, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q16, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q16, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q16, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q16, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q16, TRUE)),
        GlitchData => q16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q15, OutSignalName => "q15", OutTemp => q1_zd(5),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q15, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q15, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q15, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q15, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q15, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q15, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q15, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q15, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q15, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q15, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q15, TRUE)),
        GlitchData => q15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q14, OutSignalName => "q14", OutTemp => q1_zd(4),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q14, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q14, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q14, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q14, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q14, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q14, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q14, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q14, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q14, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q14, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q14, TRUE)),
        GlitchData => q14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q13, OutSignalName => "q13", OutTemp => q1_zd(3),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q13, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q13, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q13, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q13, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q13, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q13, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q13, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q13, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q13, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q13, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q13, TRUE)),
        GlitchData => q13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q12, OutSignalName => "q12", OutTemp => q1_zd(2),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q12, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q12, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q12, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q12, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q12, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q12, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q12, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q12, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q12, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q12, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q12, TRUE)),
        GlitchData => q12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q11, OutSignalName => "q11", OutTemp => q1_zd(1),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q11, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q11, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q11, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q11, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q11, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q11, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q11, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q11, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q11, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q11, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q11, TRUE)),
        GlitchData => q11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q10, OutSignalName => "q10", OutTemp => q1_zd(0),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q10, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q10, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q10, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q10, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q10, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q10, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q10, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q10, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q10, TRUE),
                       9 => (ckr1_ipd'last_event, tpd_ckr1_q10, TRUE),
                      10 => (ckw1_ipd'last_event, tpd_ckw1_q10, TRUE)),
        GlitchData => q10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => busy, OutSignalName => "busy", OutTemp => busy_zd,
        Paths      => (0 => (aw08_ipd'last_event, tpd_aw08_busy, TRUE),
                       1 => (aw07_ipd'last_event, tpd_aw07_busy, TRUE),
                       2 => (aw06_ipd'last_event, tpd_aw06_busy, TRUE),
                       3 => (aw05_ipd'last_event, tpd_aw05_busy, TRUE),
                       4 => (aw04_ipd'last_event, tpd_aw04_busy, TRUE),
                       5 => (aw03_ipd'last_event, tpd_aw03_busy, TRUE),
                       6 => (aw02_ipd'last_event, tpd_aw02_busy, TRUE),
                       7 => (aw01_ipd'last_event, tpd_aw01_busy, TRUE),
                       8 => (aw00_ipd'last_event, tpd_aw00_busy, TRUE),
                       9 => (aw18_ipd'last_event, tpd_aw18_busy, TRUE),
                      10 => (aw17_ipd'last_event, tpd_aw17_busy, TRUE),
                      11 => (aw16_ipd'last_event, tpd_aw16_busy, TRUE),
                      12 => (aw15_ipd'last_event, tpd_aw15_busy, TRUE),
                      13 => (aw14_ipd'last_event, tpd_aw14_busy, TRUE),
                      14 => (aw13_ipd'last_event, tpd_aw13_busy, TRUE),
                      15 => (aw12_ipd'last_event, tpd_aw12_busy, TRUE),
                      16 => (aw11_ipd'last_event, tpd_aw11_busy, TRUE),
                      17 => (aw10_ipd'last_event, tpd_aw10_busy, TRUE),
                      18 => (csw1_ipd'last_event, tpd_csw1_busy, TRUE),
                      19 => (csw0_ipd'last_event, tpd_csw0_busy, TRUE),
                      20 => (ckw0_ipd'last_event, tpd_ckw0_busy, TRUE)),
        GlitchData => busy_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );

   END PROCESS VITAL_OUTPUT;

END V;


--
-----cell br1024x18----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use ieee.std_logic_unsigned.all;
use work.mem3.all;

-- entity declaration --
ENTITY br1024x18 IS
   GENERIC (
        BRAMMODE0                  : String  := "NOREG";
        BRAMMODE1                  : String  := "NOREG";
        ARBITERMODE                : String  := "FALSE";
        initval_00 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_01 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_02 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_03 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_04 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_05 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_06 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_07 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_08 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_09 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0a : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0b : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0c : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0d : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0e : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_0f : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_10 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_11 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_12 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_13 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_14 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_15 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_16 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_17 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_18 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_19 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1a : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1b : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1c : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1d : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1e : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_1f : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_20 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_21 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_22 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_23 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_24 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_25 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_26 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_27 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_28 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_29 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_2a : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_2b : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_2c : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_2d : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_2e : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_2f : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_30 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_31 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_32 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_33 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_34 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_35 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_36 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_37 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_38 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_39 : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_3a : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_3b : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_3c : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_3d : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_3e : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        initval_3f : String := "0xXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "br1024x18";

        -- input SIGNAL delays
        tipd_aw09 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw08 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar09 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar08 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d017 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d016 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d015 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d014 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d013 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d012 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d011 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d010 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d09  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d08  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d07  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d06  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d05  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d04  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d03  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d02  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d01  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d00  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csr0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw19 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw18 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar19 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar18 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ar10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d117 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d116 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d115 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d114 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d113 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d112 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d111 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d110 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d19  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d18  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csr1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_bw10 : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_ar09_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar09_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar08_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar07_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar06_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar05_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar04_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar03_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar02_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar01_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar00_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr0_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar19_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar18_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar17_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar16_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar15_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar14_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar13_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar12_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar11_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ar10_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckr1_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw09_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw08_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw07_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw06_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw05_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw04_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw03_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw02_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw01_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw00_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw19_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw18_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw17_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw16_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw15_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw14_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw13_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw12_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw11_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_aw10_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_csw1_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_csw0_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_busy      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q017      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q016      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q015      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q014      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q013      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q012      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q011      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q010      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q09       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q08       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q07       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q06       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q05       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q04       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q03       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q02       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q01       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw0_q00       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q117      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q116      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q115      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q114      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q113      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q112      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q111      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q110      : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q19       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q18       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q17       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q16       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q15       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q14       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q13       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q12       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q11       : VitalDelayType01 := (0.1 ns, 0.1 ns);
        tpd_ckw1_q10       : VitalDelayType01 := (0.1 ns, 0.1 ns);

        -- setup and hold constraints
        tsetup_aw09_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw08_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw07_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw06_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw05_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw04_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw03_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw02_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d017_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d016_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d015_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d014_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d013_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d012_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d011_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d010_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d09_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d08_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_bw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_bw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csw0_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar09_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar08_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar07_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar06_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar05_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar04_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar03_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar02_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar01_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar00_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csr0_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw19_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw18_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw17_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw16_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw15_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw14_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw13_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw12_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_aw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d117_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d116_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d115_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d114_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d113_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d112_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d111_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d110_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_d19_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d18_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_bw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_bw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csw1_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar19_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar18_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar17_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar16_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar15_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar14_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar13_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar12_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar11_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_ar10_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        tsetup_csr1_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;

        thold_aw09_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw08_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw07_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw06_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw05_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw04_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw03_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw02_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d017_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d016_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d015_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d014_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d013_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d012_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d011_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d010_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d09_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d08_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_bw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_bw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csw0_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar09_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar08_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar07_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar06_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar05_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar04_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar03_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar02_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar01_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar00_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csr0_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw19_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw18_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw17_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw16_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw15_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw14_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw13_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw12_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_aw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d117_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d116_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d115_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d114_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d113_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d112_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d111_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d110_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d19_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d18_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_bw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_bw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csw1_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar19_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar18_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar17_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar16_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar15_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar14_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar13_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar12_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar11_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ar10_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_csr1_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw0            : VitalDelayType := 0.01 ns;
        tpw_ckw0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr0            : VitalDelayType := 0.01 ns;
        tpw_ckr0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckw1            : VitalDelayType := 0.01 ns;
        tpw_ckw1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw1_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr1            : VitalDelayType := 0.01 ns;
        tpw_ckr1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr1_negedge        : VitalDelayType := 0.01 ns);

   PORT(
        aw19, aw18, aw17, aw16, aw15, aw14, aw13, aw12, aw11, aw10   : in std_logic ;
        aw09, aw08, aw07, aw06, aw05, aw04, aw03, aw02, aw01, aw00   : in std_logic ;
        d117, d116, d115, d114, d113, d112, d111, d110, d19          : in std_logic ;
        d18, d17, d16, d15, d14, d13, d12, d11, d10                  : in std_logic ;
        d017, d016, d015, d014, d013, d012, d011, d010, d09          : in std_logic ;
        d08, d07, d06, d05, d04, d03, d02, d01, d00                  : in std_logic ;
        bw11, bw10, bw01, bw00                                       : in std_logic ;
        ar19, ar18, ar17, ar16, ar15, ar14, ar13, ar12, ar11, ar10   : in std_logic ;
        ar09, ar08, ar07, ar06, ar05, ar04, ar03, ar02, ar01, ar00   : in std_logic ;
        ckw1, ckw0, ckr1, ckr0, csw1, csw0, csr1, csr0               : in std_logic ;

        q117, q116, q115, q114, q113, q112, q111, q110, q19          : out std_logic ;
        q18, q17, q16, q15, q14, q13, q12, q11, q10                  : out std_logic ;
        q017, q016, q015, q014, q013, q012, q011, q010, q09          : out std_logic ;
        q08, q07, q06, q05, q04, q03, q02, q01, q00, busy            : out std_logic );

      ATTRIBUTE Vital_Level0 OF br1024x18 : ENTITY IS TRUE;

END br1024x18 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF br1024x18 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL mode0_reg   : String(BRAMMODE0'length downto 1);
    SIGNAL mode1_reg   : String(BRAMMODE1'length downto 1);
    SIGNAL arbmode_reg : String(ARBITERMODE'length downto 1);

    SIGNAL aw09_ipd  : std_logic := 'X';
    SIGNAL aw08_ipd  : std_logic := 'X';
    SIGNAL aw07_ipd  : std_logic := 'X';
    SIGNAL aw06_ipd  : std_logic := 'X';
    SIGNAL aw05_ipd  : std_logic := 'X';
    SIGNAL aw04_ipd  : std_logic := 'X';
    SIGNAL aw03_ipd  : std_logic := 'X';
    SIGNAL aw02_ipd  : std_logic := 'X';
    SIGNAL aw01_ipd  : std_logic := 'X';
    SIGNAL aw00_ipd  : std_logic := 'X';
    SIGNAL ar09_ipd  : std_logic := 'X';
    SIGNAL ar08_ipd  : std_logic := 'X';
    SIGNAL ar07_ipd  : std_logic := 'X';
    SIGNAL ar06_ipd  : std_logic := 'X';
    SIGNAL ar05_ipd  : std_logic := 'X';
    SIGNAL ar04_ipd  : std_logic := 'X';
    SIGNAL ar03_ipd  : std_logic := 'X';
    SIGNAL ar02_ipd  : std_logic := 'X';
    SIGNAL ar01_ipd  : std_logic := 'X';
    SIGNAL ar00_ipd  : std_logic := 'X';
    SIGNAL d017_ipd  : std_logic := 'X';
    SIGNAL d016_ipd  : std_logic := 'X';
    SIGNAL d015_ipd  : std_logic := 'X';
    SIGNAL d014_ipd  : std_logic := 'X';
    SIGNAL d013_ipd  : std_logic := 'X';
    SIGNAL d012_ipd  : std_logic := 'X';
    SIGNAL d011_ipd  : std_logic := 'X';
    SIGNAL d010_ipd  : std_logic := 'X';
    SIGNAL d09_ipd   : std_logic := 'X';
    SIGNAL d08_ipd   : std_logic := 'X';
    SIGNAL d07_ipd   : std_logic := 'X';
    SIGNAL d06_ipd   : std_logic := 'X';
    SIGNAL d05_ipd   : std_logic := 'X';
    SIGNAL d04_ipd   : std_logic := 'X';
    SIGNAL d03_ipd   : std_logic := 'X';
    SIGNAL d02_ipd   : std_logic := 'X';
    SIGNAL d01_ipd   : std_logic := 'X';
    SIGNAL d00_ipd   : std_logic := 'X';
    SIGNAL ckw0_ipd  : std_logic := 'X';
    SIGNAL ckr0_ipd  : std_logic := 'X';
    SIGNAL csw0_ipd  : std_logic := 'X';
    SIGNAL csr0_ipd  : std_logic := 'X';
    SIGNAL bw01_ipd  : std_logic := 'X';
    SIGNAL bw00_ipd  : std_logic := 'X';
    SIGNAL aw19_ipd  : std_logic := 'X';
    SIGNAL aw18_ipd  : std_logic := 'X';
    SIGNAL aw17_ipd  : std_logic := 'X';
    SIGNAL aw16_ipd  : std_logic := 'X';
    SIGNAL aw15_ipd  : std_logic := 'X';
    SIGNAL aw14_ipd  : std_logic := 'X';
    SIGNAL aw13_ipd  : std_logic := 'X';
    SIGNAL aw12_ipd  : std_logic := 'X';
    SIGNAL aw11_ipd  : std_logic := 'X';
    SIGNAL aw10_ipd  : std_logic := 'X';
    SIGNAL ar19_ipd  : std_logic := 'X';
    SIGNAL ar18_ipd  : std_logic := 'X';
    SIGNAL ar17_ipd  : std_logic := 'X';
    SIGNAL ar16_ipd  : std_logic := 'X';
    SIGNAL ar15_ipd  : std_logic := 'X';
    SIGNAL ar14_ipd  : std_logic := 'X';
    SIGNAL ar13_ipd  : std_logic := 'X';
    SIGNAL ar12_ipd  : std_logic := 'X';
    SIGNAL ar11_ipd  : std_logic := 'X';
    SIGNAL ar10_ipd  : std_logic := 'X';
    SIGNAL d117_ipd  : std_logic := 'X';
    SIGNAL d116_ipd  : std_logic := 'X';
    SIGNAL d115_ipd  : std_logic := 'X';
    SIGNAL d114_ipd  : std_logic := 'X';
    SIGNAL d113_ipd  : std_logic := 'X';
    SIGNAL d112_ipd  : std_logic := 'X';
    SIGNAL d111_ipd  : std_logic := 'X';
    SIGNAL d110_ipd  : std_logic := 'X';
    SIGNAL d19_ipd   : std_logic := 'X';
    SIGNAL d18_ipd   : std_logic := 'X';
    SIGNAL d17_ipd   : std_logic := 'X';
    SIGNAL d16_ipd   : std_logic := 'X';
    SIGNAL d15_ipd   : std_logic := 'X';
    SIGNAL d14_ipd   : std_logic := 'X';
    SIGNAL d13_ipd   : std_logic := 'X';
    SIGNAL d12_ipd   : std_logic := 'X';
    SIGNAL d11_ipd   : std_logic := 'X';
    SIGNAL d10_ipd   : std_logic := 'X';
    SIGNAL ckw1_ipd  : std_logic := 'X';
    SIGNAL ckr1_ipd  : std_logic := 'X';
    SIGNAL csw1_ipd  : std_logic := 'X';
    SIGNAL csr1_ipd  : std_logic := 'X';
    SIGNAL bw11_ipd  : std_logic := 'X';
    SIGNAL bw10_ipd  : std_logic := 'X';

    SIGNAL initval   : string(5120 downto 1) := (initval_3f(3 to 82)&initval_3e(3 to 82)&initval_3d(3 to 82)&initval_3c(3 to 82)&
      initval_3b(3 to 82)&initval_3a(3 to 82)&initval_39(3 to 82)&initval_38(3 to 82)&
      initval_37(3 to 82)&initval_36(3 to 82)&initval_35(3 to 82)&initval_34(3 to 82)&
      initval_33(3 to 82)&initval_32(3 to 82)&initval_31(3 to 82)&initval_30(3 to 82)&
      initval_2f(3 to 82)&initval_2e(3 to 82)&initval_2d(3 to 82)&initval_2c(3 to 82)&
      initval_2b(3 to 82)&initval_2a(3 to 82)&initval_29(3 to 82)&initval_28(3 to 82)&
      initval_27(3 to 82)&initval_26(3 to 82)&initval_25(3 to 82)&initval_24(3 to 82)&
      initval_23(3 to 82)&initval_22(3 to 82)&initval_21(3 to 82)&initval_20(3 to 82)&
      initval_1f(3 to 82)&initval_1e(3 to 82)&initval_1d(3 to 82)&initval_1c(3 to 82)&
      initval_1b(3 to 82)&initval_1a(3 to 82)&initval_19(3 to 82)&initval_18(3 to 82)&
      initval_17(3 to 82)&initval_16(3 to 82)&initval_15(3 to 82)&initval_14(3 to 82)&
      initval_13(3 to 82)&initval_12(3 to 82)&initval_11(3 to 82)&initval_10(3 to 82)&
      initval_0f(3 to 82)&initval_0e(3 to 82)&initval_0d(3 to 82)&initval_0c(3 to 82)&
      initval_0b(3 to 82)&initval_0a(3 to 82)&initval_09(3 to 82)&initval_08(3 to 82)&
      initval_07(3 to 82)&initval_06(3 to 82)&initval_05(3 to 82)&initval_04(3 to 82)&
      initval_03(3 to 82)&initval_02(3 to 82)&initval_01(3 to 82)&initval_00(3 to 82));
    SIGNAL memory    : mem_type_5(0 to 1023) := init_ram (initval);
    SIGNAL busy0     : std_logic := '0';
    SIGNAL aw0_int   : std_logic_vector(9 downto 0) := "XXXXXXXXXX";
    SIGNAL aw1_int   : std_logic_vector(9 downto 0) := "XXXXXXXXXX";
    SIGNAL ar0_int   : std_logic_vector(9 downto 0) := "XXXXXXXXXX";
    SIGNAL ar1_int   : std_logic_vector(9 downto 0) := "XXXXXXXXXX";
    SIGNAL d0_int    : std_logic_vector(15 downto 0) := "XXXXXXXXXXXXXXXX";
    SIGNAL d1_int    : std_logic_vector(15 downto 0) := "XXXXXXXXXXXXXXXX";
    SIGNAL q0_tmp    : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_tmp    : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_noreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_noreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_inreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_inreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_outreg : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_outreg : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q0_ioreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL q1_ioreg  : std_logic_vector(17 downto 0) := "XXXXXXXXXXXXXXXXXX";
    SIGNAL busy_tmp  : std_logic := 'X';
    SIGNAL q0_int    : std_logic_vector(17 downto 0);
    SIGNAL q1_int    : std_logic_vector(17 downto 0);
    SIGNAL csr0_int  : std_logic;
    SIGNAL csr1_int  : std_logic;
    SIGNAL memchg1   : std_logic := '0';
    SIGNAL memchg2   : std_logic := '0';
    SIGNAL memchg3   : std_logic := '0';
    SIGNAL memchg4   : std_logic := '0';
    SIGNAL memchg5   : std_logic := '0';
    SIGNAL memchg6   : std_logic := '0';
    SIGNAL iorad_0   : Integer := 0;
    SIGNAL iorad_1   : Integer := 0;
    SIGNAL wren0     : std_logic := '0';
    SIGNAL wren1     : std_logic := '0';

BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(aw09_ipd, aw09, tipd_aw09);
   VitalWireDelay(aw08_ipd, aw08, tipd_aw08);
   VitalWireDelay(aw07_ipd, aw07, tipd_aw07);
   VitalWireDelay(aw06_ipd, aw06, tipd_aw06);
   VitalWireDelay(aw05_ipd, aw05, tipd_aw05);
   VitalWireDelay(aw04_ipd, aw04, tipd_aw04);
   VitalWireDelay(aw03_ipd, aw03, tipd_aw03);
   VitalWireDelay(aw02_ipd, aw02, tipd_aw02);
   VitalWireDelay(aw01_ipd, aw01, tipd_aw01);
   VitalWireDelay(aw00_ipd, aw00, tipd_aw00);
   VitalWireDelay(ar09_ipd, ar09, tipd_ar09);
   VitalWireDelay(ar08_ipd, ar08, tipd_ar08);
   VitalWireDelay(ar07_ipd, ar07, tipd_ar07);
   VitalWireDelay(ar06_ipd, ar06, tipd_ar06);
   VitalWireDelay(ar05_ipd, ar05, tipd_ar05);
   VitalWireDelay(ar04_ipd, ar04, tipd_ar04);
   VitalWireDelay(ar03_ipd, ar03, tipd_ar03);
   VitalWireDelay(ar02_ipd, ar02, tipd_ar02);
   VitalWireDelay(ar01_ipd, ar01, tipd_ar01);
   VitalWireDelay(ar00_ipd, ar00, tipd_ar00);
   VitalWireDelay(d017_ipd, d017, tipd_d017);
   VitalWireDelay(d016_ipd, d016, tipd_d016);
   VitalWireDelay(d015_ipd, d015, tipd_d015);
   VitalWireDelay(d014_ipd, d014, tipd_d014);
   VitalWireDelay(d013_ipd, d013, tipd_d013);
   VitalWireDelay(d012_ipd, d012, tipd_d012);
   VitalWireDelay(d011_ipd, d011, tipd_d011);
   VitalWireDelay(d010_ipd, d010, tipd_d010);
   VitalWireDelay(d09_ipd, d09, tipd_d09);
   VitalWireDelay(d08_ipd, d08, tipd_d08);
   VitalWireDelay(d07_ipd, d07, tipd_d07);
   VitalWireDelay(d06_ipd, d06, tipd_d06);
   VitalWireDelay(d05_ipd, d05, tipd_d05);
   VitalWireDelay(d04_ipd, d04, tipd_d04);
   VitalWireDelay(d03_ipd, d03, tipd_d03);
   VitalWireDelay(d02_ipd, d02, tipd_d02);
   VitalWireDelay(d01_ipd, d01, tipd_d01);
   VitalWireDelay(d00_ipd, d00, tipd_d00);
   VitalWireDelay(ckw0_ipd, ckw0, tipd_ckw0);
   VitalWireDelay(ckr0_ipd, ckr0, tipd_ckr0);
   VitalWireDelay(csw0_ipd, csw0, tipd_csw0);
   VitalWireDelay(csr0_ipd, csr0, tipd_csr0);
   VitalWireDelay(bw01_ipd, bw01, tipd_bw01);
   VitalWireDelay(bw00_ipd, bw00, tipd_bw00);
   VitalWireDelay(aw19_ipd, aw19, tipd_aw19);
   VitalWireDelay(aw18_ipd, aw18, tipd_aw18);
   VitalWireDelay(aw17_ipd, aw17, tipd_aw17);
   VitalWireDelay(aw16_ipd, aw16, tipd_aw16);
   VitalWireDelay(aw15_ipd, aw15, tipd_aw15);
   VitalWireDelay(aw14_ipd, aw14, tipd_aw14);
   VitalWireDelay(aw13_ipd, aw13, tipd_aw13);
   VitalWireDelay(aw12_ipd, aw12, tipd_aw12);
   VitalWireDelay(aw11_ipd, aw11, tipd_aw11);
   VitalWireDelay(aw10_ipd, aw10, tipd_aw10);
   VitalWireDelay(ar19_ipd, ar19, tipd_ar19);
   VitalWireDelay(ar18_ipd, ar18, tipd_ar18);
   VitalWireDelay(ar17_ipd, ar17, tipd_ar17);
   VitalWireDelay(ar16_ipd, ar16, tipd_ar16);
   VitalWireDelay(ar15_ipd, ar15, tipd_ar15);
   VitalWireDelay(ar14_ipd, ar14, tipd_ar14);
   VitalWireDelay(ar13_ipd, ar13, tipd_ar13);
   VitalWireDelay(ar12_ipd, ar12, tipd_ar12);
   VitalWireDelay(ar11_ipd, ar11, tipd_ar11);
   VitalWireDelay(ar10_ipd, ar10, tipd_ar10);
   VitalWireDelay(d117_ipd, d117, tipd_d117);
   VitalWireDelay(d116_ipd, d116, tipd_d116);
   VitalWireDelay(d115_ipd, d115, tipd_d115);
   VitalWireDelay(d114_ipd, d114, tipd_d114);
   VitalWireDelay(d113_ipd, d113, tipd_d113);
   VitalWireDelay(d112_ipd, d112, tipd_d112);
   VitalWireDelay(d111_ipd, d111, tipd_d111);
   VitalWireDelay(d110_ipd, d110, tipd_d110);
   VitalWireDelay(d19_ipd, d19, tipd_d19);
   VitalWireDelay(d18_ipd, d18, tipd_d18);
   VitalWireDelay(d17_ipd, d17, tipd_d17);
   VitalWireDelay(d16_ipd, d16, tipd_d16);
   VitalWireDelay(d15_ipd, d15, tipd_d15);
   VitalWireDelay(d14_ipd, d14, tipd_d14);
   VitalWireDelay(d13_ipd, d13, tipd_d13);
   VitalWireDelay(d12_ipd, d12, tipd_d12);
   VitalWireDelay(d11_ipd, d11, tipd_d11);
   VitalWireDelay(d10_ipd, d10, tipd_d10);
   VitalWireDelay(ckw1_ipd, ckw1, tipd_ckw1);
   VitalWireDelay(ckr1_ipd, ckr1, tipd_ckr1);
   VitalWireDelay(csw1_ipd, csw1, tipd_csw1);
   VitalWireDelay(csr1_ipd, csr1, tipd_csr1);
   VitalWireDelay(bw11_ipd, bw11, tipd_bw11);
   VitalWireDelay(bw10_ipd, bw10, tipd_bw10);
   END BLOCK;

   mode0_reg <= BRAMMODE0;
   mode1_reg <= BRAMMODE1;
   arbmode_reg <= ARBITERMODE;
   wren0 <= csw0_ipd;
   wren1 <= csw1_ipd;
   aw0_int <= (aw09_ipd, aw08_ipd, aw07_ipd, aw06_ipd, aw05_ipd, aw04_ipd, aw03_ipd,
               aw02_ipd, aw01_ipd, aw00_ipd);
   aw1_int <= (aw19_ipd, aw18_ipd, aw17_ipd, aw16_ipd, aw15_ipd, aw14_ipd, aw13_ipd,
               aw12_ipd, aw11_ipd, aw10_ipd);
   ar0_int <= (ar09_ipd, ar08_ipd, ar07_ipd, ar06_ipd, ar05_ipd, ar04_ipd, ar03_ipd,
               ar02_ipd, ar01_ipd, ar00_ipd);
   ar1_int <= (ar19_ipd, ar18_ipd, ar17_ipd, ar16_ipd, ar15_ipd, ar14_ipd, ar13_ipd,
               ar12_ipd, ar11_ipd, ar10_ipd);
   d0_int <= (d015_ipd, d014_ipd, d013_ipd, d012_ipd, d011_ipd, d010_ipd, d09_ipd,
              d08_ipd, d07_ipd, d06_ipd, d05_ipd, d04_ipd, d03_ipd, d02_ipd,
              d01_ipd, d00_ipd);
   d1_int <= (d115_ipd, d114_ipd, d113_ipd, d112_ipd, d111_ipd, d110_ipd, d19_ipd,
              d18_ipd, d17_ipd, d16_ipd, d15_ipd, d14_ipd, d13_ipd, d12_ipd,
              d11_ipd, d10_ipd);

----------------------------------------------------------------
-- Arbiter-mode selection
----------------------------------------------------------------
   ARB : PROCESS (aw0_int, aw1_int, wren0, wren1, ckw0_ipd)
   VARIABLE address_0 : integer;
   VARIABLE address_1 : integer;
   BEGIN
      address_0 := conv_integer(aw0_int);
      address_1 := conv_integer(aw1_int);
      IF (arbmode_reg = "TRUE") THEN
        IF (wren0 = '1' and wren1 = '1') THEN
          IF (address_0 = address_1) THEN
            busy0 <= '1';
          END IF;
        END IF;

        IF (ckw0_ipd'event and ckw0_ipd = '1') THEN
          IF ((address_0 /= address_1) or csw0_ipd = '0' or csw1_ipd = '0') THEN
            busy0 <= '0';
          END IF;
        END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 write address and data latch and write
----------------------------------------------------------------
   WR : PROCESS (ckw0_ipd, ckw1_ipd)
   VARIABLE data_1_0  : std_logic_vector(7 downto 0);
   VARIABLE data_1_8  : std_logic_vector(7 downto 0);
   VARIABLE data_1_16 : std_logic;
   VARIABLE data_1_17 : std_logic;
   VARIABLE data_0_0  : std_logic_vector(7 downto 0);
   VARIABLE data_0_8  : std_logic_vector(7 downto 0);
   VARIABLE data_0_16 : std_logic;
   VARIABLE data_0_17 : std_logic;
   VARIABLE wad_0     : Integer;
   VARIABLE wad_1     : Integer;
   BEGIN
      IF (busy0 = '1') THEN
        IF (ckw1_ipd'event and ckw1_ipd = '1') THEN
          IF (csw1_ipd = '1') THEN
            wad_1 := conv_integer(aw1_int);

            IF (bw10_ipd = '1') THEN
              data_1_0 := d1_int(7 downto 0);
              data_1_16 := d116_ipd;
              memory(wad_1)(7 downto 0) <= data_1_0;
              memory(wad_1)(16) <= data_1_16;
              memchg1 <= not memchg1;
            END IF;
            IF (bw11_ipd = '1') THEN
              data_1_8 := d1_int(15 downto 8);
              data_1_17 := d117_ipd;
              memory(wad_1)(15 downto 8) <= data_1_8;
              memory(wad_1)(17) <= data_1_17;
              memchg2 <= not memchg2;
            END IF;
          END IF;
        END IF;
      ELSE

        IF (ckw0_ipd'event and ckw0_ipd = '1') THEN
          IF (csw0_ipd = '1') THEN
            wad_0 := conv_integer(aw0_int);

            IF (bw00_ipd = '1') THEN
              data_0_0 := d0_int(7 downto 0);
              data_0_16 := d016_ipd;
              memory(wad_0)(7 downto 0) <= data_0_0;
              memory(wad_0)(16) <= data_0_16;
              memchg3 <= not memchg3;
            END IF;
            IF (bw01_ipd = '1') THEN
              data_0_8 := d0_int(15 downto 8);
              data_0_17 := d017_ipd;
              memory(wad_0)(15 downto 8) <= data_0_8;
              memory(wad_0)(17) <= data_0_17;
              memchg4 <= not memchg4;
            END IF;

          END IF;
        END IF;

        IF (ckw1_ipd'event and ckw1_ipd = '1') THEN
          IF (csw1_ipd = '1') THEN
            wad_1 := conv_integer(aw1_int);

            IF (bw10_ipd = '1') THEN
              data_1_0 := d1_int(7 downto 0);
              data_1_16 := d116_ipd;
              memory(wad_1)(7 downto 0) <= data_1_0;
              memory(wad_1)(16) <= data_1_16;
              memchg5 <= not memchg5;
            END IF;
            IF (bw11_ipd = '1') THEN
              data_1_8 := d1_int(15 downto 8);
              data_1_17 := d117_ipd;
              memory(wad_1)(15 downto 8) <= data_1_8;
              memory(wad_1)(17) <= data_1_17;
              memchg6 <= not memchg6;
            END IF;
          END IF;
        END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 NOREG read operation
----------------------------------------------------------------

   NOREG_READ : PROCESS (ar0_int, ar1_int, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6)
   VARIABLE rad_0     : Integer;
   VARIABLE rad_1     : Integer;
   BEGIN
       rad_0 := conv_integer(ar0_int);
       rad_1 := conv_integer(ar1_int);

       q0_noreg <= memory(rad_0);
       q1_noreg <= memory(rad_1);
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 INREG read operation
----------------------------------------------------------------
   INREG_READ : PROCESS (ckr0_ipd, ckr1_ipd, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6)
   VARIABLE rad_0     : Integer := 0;
   VARIABLE rad_1     : Integer := 0;
   BEGIN

      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_ipd = '1') THEN
           rad_0 := conv_integer(ar0_int);
        END IF;
      END IF;
           q0_inreg <= memory(rad_0);

      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_ipd = '1') THEN
           rad_1 := conv_integer(ar1_int);
        END IF;
      END IF;
           q1_inreg <= memory(rad_1);
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 OUTREG read operation
----------------------------------------------------------------
   OUTREG_READ : PROCESS (ar0_int, ar1_int, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6, ckr0_ipd, ckr1_ipd)
   VARIABLE rad_0     : Integer;
   VARIABLE rad_1     : Integer;
   VARIABLE q0_int    : std_logic_vector(17 downto 0);
   VARIABLE q1_int    : std_logic_vector(17 downto 0);
   BEGIN
       rad_0 := conv_integer(ar0_int);
       rad_1 := conv_integer(ar1_int);
       q0_int  := memory(rad_0);
       q1_int  := memory(rad_1);

      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_ipd = '1') THEN
           q0_outreg <= q0_int;
        END IF;
      END IF;
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_ipd = '1') THEN
           q1_outreg <= q1_int;
        END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- Port0 and Port1 IOREG read operation
----------------------------------------------------------------
   IOREG_READ : PROCESS (ckr0_ipd, ckr1_ipd)
--   VARIABLE rad_0     : Integer;
--   VARIABLE rad_1     : Integer;
   BEGIN
      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_ipd = '1') THEN
           iorad_0 <= conv_integer(ar0_int);
        END IF;
        csr0_int <= csr0_ipd;
      END IF;
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_ipd = '1') THEN
           iorad_1 <= conv_integer(ar1_int);
        END IF;
        csr1_int <= csr1_ipd;
      END IF;

      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
        IF (csr0_int = '1') THEN
           q0_ioreg <= q0_int;
        END IF;
      END IF;
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
        IF (csr1_int = '1') THEN
           q1_ioreg <= q1_int;
        END IF;
      END IF;
   END PROCESS;

   IOREG_READ1 : PROCESS (iorad_0, iorad_1, memchg1, memchg2, memchg3, memchg4, memchg5, memchg6
)
   BEGIN
       q0_int <= memory(iorad_0);
       q1_int <= memory(iorad_1);
   END PROCESS;


   VITAL_OUTPUT : PROCESS (q0_inreg, q1_inreg, q0_noreg, q1_noreg, q0_outreg, q1_outreg, q0_ioreg, q1_ioreg, busy0)
     VARIABLE q0_zd   : std_logic_vector(17 downto 0);
     VARIABLE q1_zd   : std_logic_vector(17 downto 0);
     VARIABLE busy_zd : std_logic;
 
     -- timing check results
        VARIABLE tviol_aw09   : x01 := '0';
        VARIABLE tviol_aw08   : x01 := '0';
        VARIABLE tviol_aw07   : x01 := '0';
        VARIABLE tviol_aw06   : x01 := '0';
        VARIABLE tviol_aw05   : x01 := '0';
        VARIABLE tviol_aw04   : x01 := '0';
        VARIABLE tviol_aw03   : x01 := '0';
        VARIABLE tviol_aw02   : x01 := '0';
        VARIABLE tviol_aw01   : x01 := '0';
        VARIABLE tviol_aw00   : x01 := '0';
        VARIABLE tviol_ar09   : x01 := '0';
        VARIABLE tviol_ar08   : x01 := '0';
        VARIABLE tviol_ar07   : x01 := '0';
        VARIABLE tviol_ar06   : x01 := '0';
        VARIABLE tviol_ar05   : x01 := '0';
        VARIABLE tviol_ar04   : x01 := '0';
        VARIABLE tviol_ar03   : x01 := '0';
        VARIABLE tviol_ar02   : x01 := '0';
        VARIABLE tviol_ar01   : x01 := '0';
        VARIABLE tviol_ar00   : x01 := '0';
        VARIABLE tviol_d017   : x01 := '0';
        VARIABLE tviol_d016   : x01 := '0';
        VARIABLE tviol_d015   : x01 := '0';
        VARIABLE tviol_d014   : x01 := '0';
        VARIABLE tviol_d013   : x01 := '0';
        VARIABLE tviol_d012   : x01 := '0';
        VARIABLE tviol_d011   : x01 := '0';
        VARIABLE tviol_d010   : x01 := '0';
        VARIABLE tviol_d09    : x01 := '0';
        VARIABLE tviol_d08    : x01 := '0';
        VARIABLE tviol_d07    : x01 := '0';
        VARIABLE tviol_d06    : x01 := '0';
        VARIABLE tviol_d05    : x01 := '0';
        VARIABLE tviol_d04    : x01 := '0';
        VARIABLE tviol_d03    : x01 := '0';
        VARIABLE tviol_d02    : x01 := '0';
        VARIABLE tviol_d01    : x01 := '0';
        VARIABLE tviol_d00    : x01 := '0';
        VARIABLE tviol_bw01   : x01 := '0';
        VARIABLE tviol_bw00   : x01 := '0';
        VARIABLE tviol_csw0   : x01 := '0';
        VARIABLE tviol_csr0   : x01 := '0';
        VARIABLE tviol_aw19   : x01 := '0';
        VARIABLE tviol_aw18   : x01 := '0';
        VARIABLE tviol_aw17   : x01 := '0';
        VARIABLE tviol_aw16   : x01 := '0';
        VARIABLE tviol_aw15   : x01 := '0';
        VARIABLE tviol_aw14   : x01 := '0';
        VARIABLE tviol_aw13   : x01 := '0';
        VARIABLE tviol_aw12   : x01 := '0';
        VARIABLE tviol_aw11   : x01 := '0';
        VARIABLE tviol_aw10   : x01 := '0';
        VARIABLE tviol_ar19   : x01 := '0';
        VARIABLE tviol_ar18   : x01 := '0';
        VARIABLE tviol_ar17   : x01 := '0';
        VARIABLE tviol_ar16   : x01 := '0';
        VARIABLE tviol_ar15   : x01 := '0';
        VARIABLE tviol_ar14   : x01 := '0';
        VARIABLE tviol_ar13   : x01 := '0';
        VARIABLE tviol_ar12   : x01 := '0';
        VARIABLE tviol_ar11   : x01 := '0';
        VARIABLE tviol_ar10   : x01 := '0';
        VARIABLE tviol_d117   : x01 := '0';
        VARIABLE tviol_d116   : x01 := '0';
        VARIABLE tviol_d115   : x01 := '0';
        VARIABLE tviol_d114   : x01 := '0';
        VARIABLE tviol_d113   : x01 := '0';
        VARIABLE tviol_d112   : x01 := '0';
        VARIABLE tviol_d111   : x01 := '0';
        VARIABLE tviol_d110   : x01 := '0';
        VARIABLE tviol_d19    : x01 := '0';
        VARIABLE tviol_d18    : x01 := '0';
        VARIABLE tviol_d17    : x01 := '0';
        VARIABLE tviol_d16    : x01 := '0';
        VARIABLE tviol_d15    : x01 := '0';
        VARIABLE tviol_d14    : x01 := '0';
        VARIABLE tviol_d13    : x01 := '0';
        VARIABLE tviol_d12    : x01 := '0';
        VARIABLE tviol_d11    : x01 := '0';
        VARIABLE tviol_d10    : x01 := '0';
        VARIABLE tviol_bw11   : x01 := '0';
        VARIABLE tviol_bw10   : x01 := '0';
        VARIABLE tviol_csw1   : x01 := '0';
        VARIABLE tviol_csr1   : x01 := '0';

        VARIABLE aw09_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw08_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw07_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw06_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw05_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw04_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw03_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw02_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw01_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE aw00_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE ar09_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar08_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar07_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar06_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar05_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar04_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar03_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar02_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar01_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE ar00_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE d017_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d016_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d015_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d014_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d013_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d012_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d011_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d010_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE d09_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d08_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d07_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d06_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d05_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d04_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d03_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d02_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d01_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d00_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE bw01_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE bw00_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE csw0_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE csr0_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE aw19_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw18_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw17_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw16_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw15_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw14_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw13_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw12_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw11_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE aw10_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE ar19_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar18_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar17_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar16_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar15_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar14_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar13_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar12_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar11_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE ar10_ckr1_TimingDatash : VitalTimingDataType;
        VARIABLE d117_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d116_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d115_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d114_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d113_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d112_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d111_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d110_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE d19_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d18_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d17_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d16_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d15_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d14_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d13_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d12_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d11_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d10_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE bw11_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE bw10_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE csw1_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE csr1_ckr1_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE q017_GlitchData:      VitalGlitchDataType;
        VARIABLE q016_GlitchData:      VitalGlitchDataType;
        VARIABLE q015_GlitchData:      VitalGlitchDataType;
        VARIABLE q014_GlitchData:      VitalGlitchDataType;
        VARIABLE q013_GlitchData:      VitalGlitchDataType;
        VARIABLE q012_GlitchData:      VitalGlitchDataType;
        VARIABLE q011_GlitchData:      VitalGlitchDataType;
        VARIABLE q010_GlitchData:      VitalGlitchDataType;
        VARIABLE q09_GlitchData :      VitalGlitchDataType;
        VARIABLE q08_GlitchData :      VitalGlitchDataType;
        VARIABLE q07_GlitchData :      VitalGlitchDataType;
        VARIABLE q06_GlitchData :      VitalGlitchDataType;
        VARIABLE q05_GlitchData :      VitalGlitchDataType;
        VARIABLE q04_GlitchData :      VitalGlitchDataType;
        VARIABLE q03_GlitchData :      VitalGlitchDataType;
        VARIABLE q02_GlitchData :      VitalGlitchDataType;
        VARIABLE q01_GlitchData :      VitalGlitchDataType;
        VARIABLE q00_GlitchData :      VitalGlitchDataType;
        VARIABLE q117_GlitchData:      VitalGlitchDataType;
        VARIABLE q116_GlitchData:      VitalGlitchDataType;
        VARIABLE q115_GlitchData:      VitalGlitchDataType;
        VARIABLE q114_GlitchData:      VitalGlitchDataType;
        VARIABLE q113_GlitchData:      VitalGlitchDataType;
        VARIABLE q112_GlitchData:      VitalGlitchDataType;
        VARIABLE q111_GlitchData:      VitalGlitchDataType;
        VARIABLE q110_GlitchData:      VitalGlitchDataType;
        VARIABLE q19_GlitchData :      VitalGlitchDataType;
        VARIABLE q18_GlitchData :      VitalGlitchDataType;
        VARIABLE q17_GlitchData :      VitalGlitchDataType;
        VARIABLE q16_GlitchData :      VitalGlitchDataType;
        VARIABLE q15_GlitchData :      VitalGlitchDataType;
        VARIABLE q14_GlitchData :      VitalGlitchDataType;
        VARIABLE q13_GlitchData :      VitalGlitchDataType;
        VARIABLE q12_GlitchData :      VitalGlitchDataType;
        VARIABLE q11_GlitchData :      VitalGlitchDataType;
        VARIABLE q10_GlitchData :      VitalGlitchDataType;
        VARIABLE busy_GlitchData:      VitalGlitchDataType;

    BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => aw09_ipd,
                TestSignalName => "aw09",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw09_ckw0_noedge_posedge,
                setuplow => tsetup_aw09_ckw0_noedge_posedge,
                HoldHigh => thold_aw09_ckw0_noedge_posedge,
                Holdlow => thold_aw09_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw09_ckw0_TimingDatash,
                Violation => tviol_aw09,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw08_ipd,
                TestSignalName => "aw08",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw08_ckw0_noedge_posedge,
                setuplow => tsetup_aw08_ckw0_noedge_posedge,
                HoldHigh => thold_aw08_ckw0_noedge_posedge,
                Holdlow => thold_aw08_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw08_ckw0_TimingDatash,
                Violation => tviol_aw08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw07_ipd,
                TestSignalName => "aw07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw07_ckw0_noedge_posedge,
                setuplow => tsetup_aw07_ckw0_noedge_posedge,
                HoldHigh => thold_aw07_ckw0_noedge_posedge,
                Holdlow => thold_aw07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw07_ckw0_TimingDatash,
                Violation => tviol_aw07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw06_ipd,
                TestSignalName => "aw06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw06_ckw0_noedge_posedge,
                setuplow => tsetup_aw06_ckw0_noedge_posedge,
                HoldHigh => thold_aw06_ckw0_noedge_posedge,
                Holdlow => thold_aw06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw06_ckw0_TimingDatash,
                Violation => tviol_aw06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw05_ipd,
                TestSignalName => "aw05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw05_ckw0_noedge_posedge,
                setuplow => tsetup_aw05_ckw0_noedge_posedge,
                HoldHigh => thold_aw05_ckw0_noedge_posedge,
                Holdlow => thold_aw05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw05_ckw0_TimingDatash,
                Violation => tviol_aw05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw04_ipd,
                TestSignalName => "aw04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw04_ckw0_noedge_posedge,
                setuplow => tsetup_aw04_ckw0_noedge_posedge,
                HoldHigh => thold_aw04_ckw0_noedge_posedge,
                Holdlow => thold_aw04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw04_ckw0_TimingDatash,
                Violation => tviol_aw04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw03_ipd,
                TestSignalName => "aw03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw03_ckw0_noedge_posedge,
                setuplow => tsetup_aw03_ckw0_noedge_posedge,
                HoldHigh => thold_aw03_ckw0_noedge_posedge,
                Holdlow => thold_aw03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw03_ckw0_TimingDatash,
                Violation => tviol_aw03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw02_ipd,
                TestSignalName => "aw02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw02_ckw0_noedge_posedge,
                setuplow => tsetup_aw02_ckw0_noedge_posedge,
                HoldHigh => thold_aw02_ckw0_noedge_posedge,
                Holdlow => thold_aw02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw02_ckw0_TimingDatash,
                Violation => tviol_aw02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw01_ipd,
                TestSignalName => "aw01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw01_ckw0_noedge_posedge,
                setuplow => tsetup_aw01_ckw0_noedge_posedge,
                HoldHigh => thold_aw01_ckw0_noedge_posedge,
                Holdlow => thold_aw01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw01_ckw0_TimingDatash,
                Violation => tviol_aw01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw00_ipd,
                TestSignalName => "aw00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw00_ckw0_noedge_posedge,
                setuplow => tsetup_aw00_ckw0_noedge_posedge,
                HoldHigh => thold_aw00_ckw0_noedge_posedge,
                Holdlow => thold_aw00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw00_ckw0_TimingDatash,
                Violation => tviol_aw00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar09_ipd,
                TestSignalName => "ar09",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar09_ckr0_noedge_posedge,
                setuplow => tsetup_ar09_ckr0_noedge_posedge,
                HoldHigh => thold_ar09_ckr0_noedge_posedge,
                Holdlow => thold_ar09_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar09_ckr0_TimingDatash,
                Violation => tviol_ar09,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar08_ipd,
                TestSignalName => "ar08",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar08_ckr0_noedge_posedge,
                setuplow => tsetup_ar08_ckr0_noedge_posedge,
                HoldHigh => thold_ar08_ckr0_noedge_posedge,
                Holdlow => thold_ar08_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar08_ckr0_TimingDatash,
                Violation => tviol_ar08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar07_ipd,
                TestSignalName => "ar07",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar07_ckr0_noedge_posedge,
                setuplow => tsetup_ar07_ckr0_noedge_posedge,
                HoldHigh => thold_ar07_ckr0_noedge_posedge,
                Holdlow => thold_ar07_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar07_ckr0_TimingDatash,
                Violation => tviol_ar07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar06_ipd,
                TestSignalName => "ar06",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar06_ckr0_noedge_posedge,
                setuplow => tsetup_ar06_ckr0_noedge_posedge,
                HoldHigh => thold_ar06_ckr0_noedge_posedge,
                Holdlow => thold_ar06_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar06_ckr0_TimingDatash,
                Violation => tviol_ar06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar05_ipd,
                TestSignalName => "ar05",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar05_ckr0_noedge_posedge,
                setuplow => tsetup_ar05_ckr0_noedge_posedge,
                HoldHigh => thold_ar05_ckr0_noedge_posedge,
                Holdlow => thold_ar05_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar05_ckr0_TimingDatash,
                Violation => tviol_ar05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar04_ipd,
                TestSignalName => "ar04",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar04_ckr0_noedge_posedge,
                setuplow => tsetup_ar04_ckr0_noedge_posedge,
                HoldHigh => thold_ar04_ckr0_noedge_posedge,
                Holdlow => thold_ar04_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar04_ckr0_TimingDatash,
                Violation => tviol_ar04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar03_ipd,
                TestSignalName => "ar03",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar03_ckr0_noedge_posedge,
                setuplow => tsetup_ar03_ckr0_noedge_posedge,
                HoldHigh => thold_ar03_ckr0_noedge_posedge,
                Holdlow => thold_ar03_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar03_ckr0_TimingDatash,
                Violation => tviol_ar03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar02_ipd,
                TestSignalName => "ar02",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar02_ckr0_noedge_posedge,
                setuplow => tsetup_ar02_ckr0_noedge_posedge,
                HoldHigh => thold_ar02_ckr0_noedge_posedge,
                Holdlow => thold_ar02_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar02_ckr0_TimingDatash,
                Violation => tviol_ar02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar01_ipd,
                TestSignalName => "ar01",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar01_ckr0_noedge_posedge,
                setuplow => tsetup_ar01_ckr0_noedge_posedge,
                HoldHigh => thold_ar01_ckr0_noedge_posedge,
                Holdlow => thold_ar01_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar01_ckr0_TimingDatash,
                Violation => tviol_ar01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar00_ipd,
                TestSignalName => "ar00",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_ar00_ckr0_noedge_posedge,
                setuplow => tsetup_ar00_ckr0_noedge_posedge,
                HoldHigh => thold_ar00_ckr0_noedge_posedge,
                Holdlow => thold_ar00_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar00_ckr0_TimingDatash,
                Violation => tviol_ar00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d017_ipd,
                TestSignalName => "d017",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d017_ckw0_noedge_posedge,
                setuplow => tsetup_d017_ckw0_noedge_posedge,
                HoldHigh => thold_d017_ckw0_noedge_posedge,
                Holdlow => thold_d017_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d017_ckw0_TimingDatash,
                Violation => tviol_d017,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d016_ipd,
                TestSignalName => "d016",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d016_ckw0_noedge_posedge,
                setuplow => tsetup_d016_ckw0_noedge_posedge,
                HoldHigh => thold_d016_ckw0_noedge_posedge,
                Holdlow => thold_d016_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d016_ckw0_TimingDatash,
                Violation => tviol_d016,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d015_ipd,
                TestSignalName => "d015",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d015_ckw0_noedge_posedge,
                setuplow => tsetup_d015_ckw0_noedge_posedge,
                HoldHigh => thold_d015_ckw0_noedge_posedge,
                Holdlow => thold_d015_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d015_ckw0_TimingDatash,
                Violation => tviol_d015,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d014_ipd,
                TestSignalName => "d014",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d014_ckw0_noedge_posedge,
                setuplow => tsetup_d014_ckw0_noedge_posedge,
                HoldHigh => thold_d014_ckw0_noedge_posedge,
                Holdlow => thold_d014_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d014_ckw0_TimingDatash,
                Violation => tviol_d014,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d013_ipd,
                TestSignalName => "d013",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d013_ckw0_noedge_posedge,
                setuplow => tsetup_d013_ckw0_noedge_posedge,
                HoldHigh => thold_d013_ckw0_noedge_posedge,
                Holdlow => thold_d013_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d013_ckw0_TimingDatash,
                Violation => tviol_d013,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d012_ipd,
                TestSignalName => "d012",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d012_ckw0_noedge_posedge,
                setuplow => tsetup_d012_ckw0_noedge_posedge,
                HoldHigh => thold_d012_ckw0_noedge_posedge,
                Holdlow => thold_d012_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d012_ckw0_TimingDatash,
                Violation => tviol_d012,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d011_ipd,
                TestSignalName => "d011",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d011_ckw0_noedge_posedge,
                setuplow => tsetup_d011_ckw0_noedge_posedge,
                HoldHigh => thold_d011_ckw0_noedge_posedge,
                Holdlow => thold_d011_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d011_ckw0_TimingDatash,
                Violation => tviol_d011,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d010_ipd,
                TestSignalName => "d010",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d010_ckw0_noedge_posedge,
                setuplow => tsetup_d010_ckw0_noedge_posedge,
                HoldHigh => thold_d010_ckw0_noedge_posedge,
                Holdlow => thold_d010_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d010_ckw0_TimingDatash,
                Violation => tviol_d010,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d09_ipd,
                TestSignalName => "d09",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d09_ckw0_noedge_posedge,
                setuplow => tsetup_d09_ckw0_noedge_posedge,
                HoldHigh => thold_d09_ckw0_noedge_posedge,
                Holdlow => thold_d09_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d09_ckw0_TimingDatash,
                Violation => tviol_d09,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d08_ipd,
                TestSignalName => "d08",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d08_ckw0_noedge_posedge,
                setuplow => tsetup_d08_ckw0_noedge_posedge,
                HoldHigh => thold_d08_ckw0_noedge_posedge,
                Holdlow => thold_d08_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d08_ckw0_TimingDatash,
                Violation => tviol_d08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d07_ipd,
                TestSignalName => "d07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d07_ckw0_noedge_posedge,
                setuplow => tsetup_d07_ckw0_noedge_posedge,
                HoldHigh => thold_d07_ckw0_noedge_posedge,
                Holdlow => thold_d07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d07_ckw0_TimingDatash,
                Violation => tviol_d07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d06_ipd,
                TestSignalName => "d06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d06_ckw0_noedge_posedge,
                setuplow => tsetup_d06_ckw0_noedge_posedge,
                HoldHigh => thold_d06_ckw0_noedge_posedge,
                Holdlow => thold_d06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d06_ckw0_TimingDatash,
                Violation => tviol_d06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d05_ipd,
                TestSignalName => "d05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d05_ckw0_noedge_posedge,
                setuplow => tsetup_d05_ckw0_noedge_posedge,
                HoldHigh => thold_d05_ckw0_noedge_posedge,
                Holdlow => thold_d05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d05_ckw0_TimingDatash,
                Violation => tviol_d05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d04_ipd,
                TestSignalName => "d04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d04_ckw0_noedge_posedge,
                setuplow => tsetup_d04_ckw0_noedge_posedge,
                HoldHigh => thold_d04_ckw0_noedge_posedge,
                Holdlow => thold_d04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d04_ckw0_TimingDatash,
                Violation => tviol_d04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d03_ipd,
                TestSignalName => "d03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d03_ckw0_noedge_posedge,
                setuplow => tsetup_d03_ckw0_noedge_posedge,
                HoldHigh => thold_d03_ckw0_noedge_posedge,
                Holdlow => thold_d03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d03_ckw0_TimingDatash,
                Violation => tviol_d03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d02_ipd,
                TestSignalName => "d02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d02_ckw0_noedge_posedge,
                setuplow => tsetup_d02_ckw0_noedge_posedge,
                HoldHigh => thold_d02_ckw0_noedge_posedge,
                Holdlow => thold_d02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d02_ckw0_TimingDatash,
                Violation => tviol_d02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d01_ipd,
                TestSignalName => "d01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d01_ckw0_noedge_posedge,
                setuplow => tsetup_d01_ckw0_noedge_posedge,
                HoldHigh => thold_d01_ckw0_noedge_posedge,
                Holdlow => thold_d01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d01_ckw0_TimingDatash,
                Violation => tviol_d01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d00_ipd,
                TestSignalName => "d00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d00_ckw0_noedge_posedge,
                setuplow => tsetup_d00_ckw0_noedge_posedge,
                HoldHigh => thold_d00_ckw0_noedge_posedge,
                Holdlow => thold_d00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d00_ckw0_TimingDatash,
                Violation => tviol_d00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw01_ipd,
                TestSignalName => "bw01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_bw01_ckw0_noedge_posedge,
                setuplow => tsetup_bw01_ckw0_noedge_posedge,
                HoldHigh => thold_bw01_ckw0_noedge_posedge,
                Holdlow => thold_bw01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw01_ckw0_TimingDatash,
                Violation => tviol_bw01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw00_ipd,
                TestSignalName => "bw00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_bw00_ckw0_noedge_posedge,
                setuplow => tsetup_bw00_ckw0_noedge_posedge,
                HoldHigh => thold_bw00_ckw0_noedge_posedge,
                Holdlow => thold_bw00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw00_ckw0_TimingDatash,
                Violation => tviol_bw00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csw0_ipd,
                TestSignalName => "csw0",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_csw0_ckw0_noedge_posedge,
                setuplow => tsetup_csw0_ckw0_noedge_posedge,
                HoldHigh => thold_csw0_ckw0_noedge_posedge,
                Holdlow => thold_csw0_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csw0_ckw0_TimingDatash,
                Violation => tviol_csw0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csr0_ipd,
                TestSignalName => "csr0",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_csr0_ckr0_noedge_posedge,
                setuplow => tsetup_csr0_ckr0_noedge_posedge,
                HoldHigh => thold_csr0_ckr0_noedge_posedge,
                Holdlow => thold_csr0_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csr0_ckr0_TimingDatash,
                Violation => tviol_csr0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw19_ipd,
                TestSignalName => "aw19",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw19_ckw1_noedge_posedge,
                setuplow => tsetup_aw19_ckw1_noedge_posedge,
                HoldHigh => thold_aw19_ckw1_noedge_posedge,
                Holdlow => thold_aw19_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw19_ckw1_TimingDatash,
                Violation => tviol_aw19,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw18_ipd,
                TestSignalName => "aw18",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw18_ckw1_noedge_posedge,
                setuplow => tsetup_aw18_ckw1_noedge_posedge,
                HoldHigh => thold_aw18_ckw1_noedge_posedge,
                Holdlow => thold_aw18_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw18_ckw1_TimingDatash,
                Violation => tviol_aw18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw17_ipd,
                TestSignalName => "aw17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw17_ckw1_noedge_posedge,
                setuplow => tsetup_aw17_ckw1_noedge_posedge,
                HoldHigh => thold_aw17_ckw1_noedge_posedge,
                Holdlow => thold_aw17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw17_ckw1_TimingDatash,
                Violation => tviol_aw17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw16_ipd,
                TestSignalName => "aw16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw16_ckw1_noedge_posedge,
                setuplow => tsetup_aw16_ckw1_noedge_posedge,
                HoldHigh => thold_aw16_ckw1_noedge_posedge,
                Holdlow => thold_aw16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw16_ckw1_TimingDatash,
                Violation => tviol_aw16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw15_ipd,
                TestSignalName => "aw15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw15_ckw1_noedge_posedge,
                setuplow => tsetup_aw15_ckw1_noedge_posedge,
                HoldHigh => thold_aw15_ckw1_noedge_posedge,
                Holdlow => thold_aw15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw15_ckw1_TimingDatash,
                Violation => tviol_aw15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw14_ipd,
                TestSignalName => "aw14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw14_ckw1_noedge_posedge,
                setuplow => tsetup_aw14_ckw1_noedge_posedge,
                HoldHigh => thold_aw14_ckw1_noedge_posedge,
                Holdlow => thold_aw14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw14_ckw1_TimingDatash,
                Violation => tviol_aw14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw13_ipd,
                TestSignalName => "aw13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw13_ckw1_noedge_posedge,
                setuplow => tsetup_aw13_ckw1_noedge_posedge,
                HoldHigh => thold_aw13_ckw1_noedge_posedge,
                Holdlow => thold_aw13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw13_ckw1_TimingDatash,
                Violation => tviol_aw13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw12_ipd,
                TestSignalName => "aw12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw12_ckw1_noedge_posedge,
                setuplow => tsetup_aw12_ckw1_noedge_posedge,
                HoldHigh => thold_aw12_ckw1_noedge_posedge,
                Holdlow => thold_aw12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw12_ckw1_TimingDatash,
                Violation => tviol_aw12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw11_ipd,
                TestSignalName => "aw11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw11_ckw1_noedge_posedge,
                setuplow => tsetup_aw11_ckw1_noedge_posedge,
                HoldHigh => thold_aw11_ckw1_noedge_posedge,
                Holdlow => thold_aw11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw11_ckw1_TimingDatash,
                Violation => tviol_aw11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw10_ipd,
                TestSignalName => "aw10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw10_ckw1_noedge_posedge,
                setuplow => tsetup_aw10_ckw1_noedge_posedge,
                HoldHigh => thold_aw10_ckw1_noedge_posedge,
                Holdlow => thold_aw10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw10_ckw1_TimingDatash,
                Violation => tviol_aw10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar19_ipd,
                TestSignalName => "ar19",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar19_ckr1_noedge_posedge,
                setuplow => tsetup_ar19_ckr1_noedge_posedge,
                HoldHigh => thold_ar19_ckr1_noedge_posedge,
                Holdlow => thold_ar19_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar19_ckr1_TimingDatash,
                Violation => tviol_ar19,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar18_ipd,
                TestSignalName => "ar18",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar18_ckr1_noedge_posedge,
                setuplow => tsetup_ar18_ckr1_noedge_posedge,
                HoldHigh => thold_ar18_ckr1_noedge_posedge,
                Holdlow => thold_ar18_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar18_ckr1_TimingDatash,
                Violation => tviol_ar18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar17_ipd,
                TestSignalName => "ar17",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar17_ckr1_noedge_posedge,
                setuplow => tsetup_ar17_ckr1_noedge_posedge,
                HoldHigh => thold_ar17_ckr1_noedge_posedge,
                Holdlow => thold_ar17_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar17_ckr1_TimingDatash,
                Violation => tviol_ar17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar16_ipd,
                TestSignalName => "ar16",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar16_ckr1_noedge_posedge,
                setuplow => tsetup_ar16_ckr1_noedge_posedge,
                HoldHigh => thold_ar16_ckr1_noedge_posedge,
                Holdlow => thold_ar16_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar16_ckr1_TimingDatash,
                Violation => tviol_ar16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar15_ipd,
                TestSignalName => "ar15",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar15_ckr1_noedge_posedge,
                setuplow => tsetup_ar15_ckr1_noedge_posedge,
                HoldHigh => thold_ar15_ckr1_noedge_posedge,
                Holdlow => thold_ar15_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar15_ckr1_TimingDatash,
                Violation => tviol_ar15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar14_ipd,
                TestSignalName => "ar14",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar14_ckr1_noedge_posedge,
                setuplow => tsetup_ar14_ckr1_noedge_posedge,
                HoldHigh => thold_ar14_ckr1_noedge_posedge,
                Holdlow => thold_ar14_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar14_ckr1_TimingDatash,
                Violation => tviol_ar14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar13_ipd,
                TestSignalName => "ar13",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar13_ckr1_noedge_posedge,
                setuplow => tsetup_ar13_ckr1_noedge_posedge,
                HoldHigh => thold_ar13_ckr1_noedge_posedge,
                Holdlow => thold_ar13_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar13_ckr1_TimingDatash,
                Violation => tviol_ar13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar12_ipd,
                TestSignalName => "ar12",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar12_ckr1_noedge_posedge,
                setuplow => tsetup_ar12_ckr1_noedge_posedge,
                HoldHigh => thold_ar12_ckr1_noedge_posedge,
                Holdlow => thold_ar12_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar12_ckr1_TimingDatash,
                Violation => tviol_ar12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar11_ipd,
                TestSignalName => "ar11",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar11_ckr1_noedge_posedge,
                setuplow => tsetup_ar11_ckr1_noedge_posedge,
                HoldHigh => thold_ar11_ckr1_noedge_posedge,
                Holdlow => thold_ar11_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar11_ckr1_TimingDatash,
                Violation => tviol_ar11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ar10_ipd,
                TestSignalName => "ar10",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_ar10_ckr1_noedge_posedge,
                setuplow => tsetup_ar10_ckr1_noedge_posedge,
                HoldHigh => thold_ar10_ckr1_noedge_posedge,
                Holdlow => thold_ar10_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ar10_ckr1_TimingDatash,
                Violation => tviol_ar10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d117_ipd,
                TestSignalName => "d117",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d117_ckw1_noedge_posedge,
                setuplow => tsetup_d117_ckw1_noedge_posedge,
                HoldHigh => thold_d117_ckw1_noedge_posedge,
                Holdlow => thold_d117_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d117_ckw1_TimingDatash,
                Violation => tviol_d117,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d116_ipd,
                TestSignalName => "d116",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d116_ckw1_noedge_posedge,
                setuplow => tsetup_d116_ckw1_noedge_posedge,
                HoldHigh => thold_d116_ckw1_noedge_posedge,
                Holdlow => thold_d116_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d116_ckw1_TimingDatash,
                Violation => tviol_d116,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d115_ipd,
                TestSignalName => "d115",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d115_ckw1_noedge_posedge,
                setuplow => tsetup_d115_ckw1_noedge_posedge,
                HoldHigh => thold_d115_ckw1_noedge_posedge,
                Holdlow => thold_d115_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d115_ckw1_TimingDatash,
                Violation => tviol_d115,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d114_ipd,
                TestSignalName => "d114",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d114_ckw1_noedge_posedge,
                setuplow => tsetup_d114_ckw1_noedge_posedge,
                HoldHigh => thold_d114_ckw1_noedge_posedge,
                Holdlow => thold_d114_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d114_ckw1_TimingDatash,
                Violation => tviol_d114,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d113_ipd,
                TestSignalName => "d113",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d113_ckw1_noedge_posedge,
                setuplow => tsetup_d113_ckw1_noedge_posedge,
                HoldHigh => thold_d113_ckw1_noedge_posedge,
                Holdlow => thold_d113_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d113_ckw1_TimingDatash,
                Violation => tviol_d113,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d112_ipd,
                TestSignalName => "d112",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d112_ckw1_noedge_posedge,
                setuplow => tsetup_d112_ckw1_noedge_posedge,
                HoldHigh => thold_d112_ckw1_noedge_posedge,
                Holdlow => thold_d112_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d112_ckw1_TimingDatash,
                Violation => tviol_d112,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d111_ipd,
                TestSignalName => "d111",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d111_ckw1_noedge_posedge,
                setuplow => tsetup_d111_ckw1_noedge_posedge,
                HoldHigh => thold_d111_ckw1_noedge_posedge,
                Holdlow => thold_d111_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d111_ckw1_TimingDatash,
                Violation => tviol_d111,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d110_ipd,
                TestSignalName => "d110",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d110_ckw1_noedge_posedge,
                setuplow => tsetup_d110_ckw1_noedge_posedge,
                HoldHigh => thold_d110_ckw1_noedge_posedge,
                Holdlow => thold_d110_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d110_ckw1_TimingDatash,
                Violation => tviol_d110,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d19_ipd,
                TestSignalName => "d19",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d19_ckw1_noedge_posedge,
                setuplow => tsetup_d19_ckw1_noedge_posedge,
                HoldHigh => thold_d19_ckw1_noedge_posedge,
                Holdlow => thold_d19_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d19_ckw1_TimingDatash,
                Violation => tviol_d19,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d18_ipd,
                TestSignalName => "d18",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d18_ckw1_noedge_posedge,
                setuplow => tsetup_d18_ckw1_noedge_posedge,
                HoldHigh => thold_d18_ckw1_noedge_posedge,
                Holdlow => thold_d18_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d18_ckw1_TimingDatash,
                Violation => tviol_d18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d17_ipd,
                TestSignalName => "d17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d17_ckw1_noedge_posedge,
                setuplow => tsetup_d17_ckw1_noedge_posedge,
                HoldHigh => thold_d17_ckw1_noedge_posedge,
                Holdlow => thold_d17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d17_ckw1_TimingDatash,
                Violation => tviol_d17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d16_ipd,
                TestSignalName => "d16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d16_ckw1_noedge_posedge,
                setuplow => tsetup_d16_ckw1_noedge_posedge,
                HoldHigh => thold_d16_ckw1_noedge_posedge,
                Holdlow => thold_d16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d16_ckw1_TimingDatash,
                Violation => tviol_d16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d15_ipd,
                TestSignalName => "d15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d15_ckw1_noedge_posedge,
                setuplow => tsetup_d15_ckw1_noedge_posedge,
                HoldHigh => thold_d15_ckw1_noedge_posedge,
                Holdlow => thold_d15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d15_ckw1_TimingDatash,
                Violation => tviol_d15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d14_ipd,
                TestSignalName => "d14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d14_ckw1_noedge_posedge,
                setuplow => tsetup_d14_ckw1_noedge_posedge,
                HoldHigh => thold_d14_ckw1_noedge_posedge,
                Holdlow => thold_d14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d14_ckw1_TimingDatash,
                Violation => tviol_d14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d13_ipd,
                TestSignalName => "d13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d13_ckw1_noedge_posedge,
                setuplow => tsetup_d13_ckw1_noedge_posedge,
                HoldHigh => thold_d13_ckw1_noedge_posedge,
                Holdlow => thold_d13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d13_ckw1_TimingDatash,
                Violation => tviol_d13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d12_ipd,
                TestSignalName => "d12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d12_ckw1_noedge_posedge,
                setuplow => tsetup_d12_ckw1_noedge_posedge,
                HoldHigh => thold_d12_ckw1_noedge_posedge,
                Holdlow => thold_d12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d12_ckw1_TimingDatash,
                Violation => tviol_d12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d11_ipd,
                TestSignalName => "d11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d11_ckw1_noedge_posedge,
                setuplow => tsetup_d11_ckw1_noedge_posedge,
                HoldHigh => thold_d11_ckw1_noedge_posedge,
                Holdlow => thold_d11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d11_ckw1_TimingDatash,
                Violation => tviol_d11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d10_ipd,
                TestSignalName => "d10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d10_ckw1_noedge_posedge,
                setuplow => tsetup_d10_ckw1_noedge_posedge,
                HoldHigh => thold_d10_ckw1_noedge_posedge,
                Holdlow => thold_d10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d10_ckw1_TimingDatash,
                Violation => tviol_d10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw11_ipd,
                TestSignalName => "bw11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_bw11_ckw1_noedge_posedge,
                setuplow => tsetup_bw11_ckw1_noedge_posedge,
                HoldHigh => thold_bw11_ckw1_noedge_posedge,
                Holdlow => thold_bw11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw11_ckw1_TimingDatash,
                Violation => tviol_bw11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => bw10_ipd,
                TestSignalName => "bw10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_bw10_ckw1_noedge_posedge,
                setuplow => tsetup_bw10_ckw1_noedge_posedge,
                HoldHigh => thold_bw10_ckw1_noedge_posedge,
                Holdlow => thold_bw10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => bw10_ckw1_TimingDatash,
                Violation => tviol_bw10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csw1_ipd,
                TestSignalName => "csw1",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_csw1_ckw1_noedge_posedge,
                setuplow => tsetup_csw1_ckw1_noedge_posedge,
                HoldHigh => thold_csw1_ckw1_noedge_posedge,
                Holdlow => thold_csw1_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csw1_ckw1_TimingDatash,
                Violation => tviol_csw1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csr1_ipd,
                TestSignalName => "csr1",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_csr1_ckr1_noedge_posedge,
                setuplow => tsetup_csr1_ckr1_noedge_posedge,
                HoldHigh => thold_csr1_ckr1_noedge_posedge,
                Holdlow => thold_csr1_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csr1_ckr1_TimingDatash,
                Violation => tviol_csr1,
                MsgSeverity => warning);

   END IF;

   ------------------------
   -- functionality section
   ------------------------
   IF (mode0_reg = "INREG") THEN
        q0_zd := q0_inreg;
   ELSIF (mode0_reg = "OUTREG") THEN
        q0_zd := q0_outreg;
   ELSIF (mode0_reg = "IOREG") THEN
        q0_zd := q0_ioreg;
   ELSE
        q0_zd := q0_noreg;
   END IF;

   IF (mode1_reg = "INREG") THEN
        q1_zd := q1_inreg;
   ELSIF (mode1_reg = "OUTREG") THEN
        q1_zd := q1_outreg;
   ELSIF (mode1_reg = "IOREG") THEN
        q1_zd := q1_ioreg;
   ELSE
        q1_zd := q1_noreg;
   END IF;

        busy_zd    := busy0;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q017, OutSignalName => "q017", OutTemp => q0_zd(17),
        Paths      => (0 => (InputChangeTime => ar00_ipd'last_event, 
                             PathDelay => tpd_ar00_q017, 
                             PathCondition => TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q017, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q017, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q017, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q017, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q017, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q017, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q017, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q017, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q017, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q017, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q017, TRUE)),
        GlitchData => q017_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q016, OutSignalName => "q016", OutTemp => q0_zd(16),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q016, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q016, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q016, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q016, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q016, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q016, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q016, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q016, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q016, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q016, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q016, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q016, TRUE)),
        GlitchData => q016_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q015, OutSignalName => "q015", OutTemp => q0_zd(15),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q015, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q015, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q015, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q015, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q015, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q015, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q015, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q015, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q015, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q015, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q015, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q015, TRUE)),
        GlitchData => q015_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q014, OutSignalName => "q014", OutTemp => q0_zd(14),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q014, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q014, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q014, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q014, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q014, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q014, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q014, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q014, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q014, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q014, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q014, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q014, TRUE)),
        GlitchData => q014_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q013, OutSignalName => "q013", OutTemp => q0_zd(13),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q013, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q013, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q013, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q013, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q013, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q013, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q013, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q013, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q013, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q013, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q013, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q013, TRUE)),
        GlitchData => q013_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q012, OutSignalName => "q012", OutTemp => q0_zd(12),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q012, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q012, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q012, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q012, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q012, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q012, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q012, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q012, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q012, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q012, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q012, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q012, TRUE)),
        GlitchData => q012_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q011, OutSignalName => "q011", OutTemp => q0_zd(11),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q011, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q011, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q011, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q011, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q011, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q011, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q011, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q011, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q011, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q011, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q011, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q011, TRUE)),
        GlitchData => q011_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q010, OutSignalName => "q010", OutTemp => q0_zd(10),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q010, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q010, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q010, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q010, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q010, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q010, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q010, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q010, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q010, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q010, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q010, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q010, TRUE)),
        GlitchData => q010_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q09, OutSignalName => "q09", OutTemp => q0_zd(9),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q09, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q09, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q09, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q09, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q09, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q09, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q09, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q09, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q09, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q09, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q09, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q09, TRUE)),
        GlitchData => q09_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q08, OutSignalName => "q08", OutTemp => q0_zd(8),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q08, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q08, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q08, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q08, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q08, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q08, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q08, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q08, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q08, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q08, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q08, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q08, TRUE)),
        GlitchData => q08_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q07, OutSignalName => "q07", OutTemp => q0_zd(7),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q07, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q07, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q07, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q07, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q07, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q07, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q07, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q07, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q07, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q07, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q07, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q07, TRUE)),
        GlitchData => q07_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q06, OutSignalName => "q06", OutTemp => q0_zd(6),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q06, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q06, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q06, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q06, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q06, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q06, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q06, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q06, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q06, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q06, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q06, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q06, TRUE)),
        GlitchData => q06_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q05, OutSignalName => "q05", OutTemp => q0_zd(5),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q05, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q05, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q05, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q05, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q05, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q05, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q05, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q05, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q05, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q05, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q05, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q05, TRUE)),
        GlitchData => q05_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q04, OutSignalName => "q04", OutTemp => q0_zd(4),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q04, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q04, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q04, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q04, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q04, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q04, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q04, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q04, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q04, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q04, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q04, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q04, TRUE)),
        GlitchData => q04_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q03, OutSignalName => "q03", OutTemp => q0_zd(3),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q03, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q03, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q03, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q03, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q03, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q03, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q03, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q03, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q03, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q03, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q03, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q03, TRUE)),
        GlitchData => q03_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q02, OutSignalName => "q02", OutTemp => q0_zd(2),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q02, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q02, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q02, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q02, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q02, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q02, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q02, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q02, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q02, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q02, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q02, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q02, TRUE)),
        GlitchData => q02_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q01, OutSignalName => "q01", OutTemp => q0_zd(1),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q01, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q01, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q01, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q01, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q01, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q01, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q01, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q01, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q01, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q01, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q01, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q01, TRUE)),
        GlitchData => q01_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q00, OutSignalName => "q00", OutTemp => q0_zd(0),
        Paths      => (0 => (ar00_ipd'last_event, tpd_ar00_q00, TRUE),
                       1 => (ar01_ipd'last_event, tpd_ar01_q00, TRUE),
                       2 => (ar02_ipd'last_event, tpd_ar02_q00, TRUE),
                       3 => (ar03_ipd'last_event, tpd_ar03_q00, TRUE),
                       4 => (ar04_ipd'last_event, tpd_ar04_q00, TRUE),
                       5 => (ar05_ipd'last_event, tpd_ar05_q00, TRUE),
                       6 => (ar06_ipd'last_event, tpd_ar06_q00, TRUE),
                       7 => (ar07_ipd'last_event, tpd_ar07_q00, TRUE),
                       8 => (ar08_ipd'last_event, tpd_ar08_q00, TRUE),
                       9 => (ar09_ipd'last_event, tpd_ar09_q00, TRUE),
                      10 => (ckr0_ipd'last_event, tpd_ckr0_q00, TRUE),
                      11 => (ckw0_ipd'last_event, tpd_ckw0_q00, TRUE)),
        GlitchData => q00_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q117, OutSignalName => "q117", OutTemp => q1_zd(17),
        Paths      => (0 => (InputChangeTime => ar10_ipd'last_event, 
                             PathDelay => tpd_ar10_q117, 
                             PathCondition => TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q117, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q117, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q117, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q117, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q117, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q117, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q117, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q117, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q117, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q117, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q117, TRUE)),
        GlitchData => q117_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q116, OutSignalName => "q116", OutTemp => q1_zd(16),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q116, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q116, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q116, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q116, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q116, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q116, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q116, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q116, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q116, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q116, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q116, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q116, TRUE)),
        GlitchData => q116_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q115, OutSignalName => "q115", OutTemp => q1_zd(15),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q115, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q115, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q115, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q115, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q115, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q115, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q115, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q115, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q115, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q115, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q115, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q115, TRUE)),
        GlitchData => q115_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q114, OutSignalName => "q114", OutTemp => q1_zd(14),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q114, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q114, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q114, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q114, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q114, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q114, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q114, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q114, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q114, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q114, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q114, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q114, TRUE)),
        GlitchData => q114_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q113, OutSignalName => "q113", OutTemp => q1_zd(13),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q113, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q113, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q113, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q113, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q113, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q113, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q113, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q113, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q113, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q113, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q113, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q113, TRUE)),
        GlitchData => q113_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q112, OutSignalName => "q112", OutTemp => q1_zd(12),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q112, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q112, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q112, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q112, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q112, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q112, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q112, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q112, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q112, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q112, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q112, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q112, TRUE)),
        GlitchData => q112_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q111, OutSignalName => "q111", OutTemp => q1_zd(11),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q111, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q111, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q111, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q111, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q111, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q111, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q111, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q111, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q111, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q111, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q111, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q111, TRUE)),
        GlitchData => q111_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q110, OutSignalName => "q110", OutTemp => q1_zd(10),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q110, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q110, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q110, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q110, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q110, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q110, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q110, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q110, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q110, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q110, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q110, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q110, TRUE)),
        GlitchData => q110_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q19, OutSignalName => "q19", OutTemp => q1_zd(9),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q19, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q19, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q19, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q19, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q19, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q19, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q19, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q19, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q19, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q19, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q19, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q19, TRUE)),
        GlitchData => q19_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q18, OutSignalName => "q18", OutTemp => q1_zd(8),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q18, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q18, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q18, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q18, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q18, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q18, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q18, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q18, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q18, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q18, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q18, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q18, TRUE)),
        GlitchData => q18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q17, OutSignalName => "q17", OutTemp => q1_zd(7),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q17, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q17, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q17, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q17, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q17, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q17, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q17, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q17, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q17, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q17, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q17, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q17, TRUE)),
        GlitchData => q17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q16, OutSignalName => "q16", OutTemp => q1_zd(6),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q16, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q16, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q16, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q16, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q16, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q16, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q16, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q16, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q16, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q16, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q16, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q16, TRUE)),
        GlitchData => q16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q15, OutSignalName => "q15", OutTemp => q1_zd(5),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q15, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q15, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q15, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q15, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q15, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q15, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q15, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q15, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q15, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q15, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q15, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q15, TRUE)),
        GlitchData => q15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q14, OutSignalName => "q14", OutTemp => q1_zd(4),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q14, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q14, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q14, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q14, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q14, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q14, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q14, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q14, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q14, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q14, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q14, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q14, TRUE)),
        GlitchData => q14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q13, OutSignalName => "q13", OutTemp => q1_zd(3),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q13, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q13, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q13, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q13, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q13, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q13, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q13, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q13, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q13, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q13, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q13, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q13, TRUE)),
        GlitchData => q13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q12, OutSignalName => "q12", OutTemp => q1_zd(2),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q12, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q12, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q12, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q12, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q12, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q12, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q12, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q12, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q12, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q12, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q12, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q12, TRUE)),
        GlitchData => q12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q11, OutSignalName => "q11", OutTemp => q1_zd(1),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q11, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q11, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q11, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q11, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q11, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q11, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q11, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q11, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q11, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q11, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q11, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q11, TRUE)),
        GlitchData => q11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q10, OutSignalName => "q10", OutTemp => q1_zd(0),
        Paths      => (0 => (ar10_ipd'last_event, tpd_ar10_q10, TRUE),
                       1 => (ar11_ipd'last_event, tpd_ar11_q10, TRUE),
                       2 => (ar12_ipd'last_event, tpd_ar12_q10, TRUE),
                       3 => (ar13_ipd'last_event, tpd_ar13_q10, TRUE),
                       4 => (ar14_ipd'last_event, tpd_ar14_q10, TRUE),
                       5 => (ar15_ipd'last_event, tpd_ar15_q10, TRUE),
                       6 => (ar16_ipd'last_event, tpd_ar16_q10, TRUE),
                       7 => (ar17_ipd'last_event, tpd_ar17_q10, TRUE),
                       8 => (ar18_ipd'last_event, tpd_ar18_q10, TRUE),
                       9 => (ar19_ipd'last_event, tpd_ar19_q10, TRUE),
                      10 => (ckr1_ipd'last_event, tpd_ckr1_q10, TRUE),
                      11 => (ckw1_ipd'last_event, tpd_ckw1_q10, TRUE)),
        GlitchData => q10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => busy, OutSignalName => "busy", OutTemp => busy_zd,
        Paths      => (0 => (aw08_ipd'last_event, tpd_aw08_busy, TRUE),
                       1 => (aw07_ipd'last_event, tpd_aw07_busy, TRUE),
                       2 => (aw06_ipd'last_event, tpd_aw06_busy, TRUE),
                       3 => (aw05_ipd'last_event, tpd_aw05_busy, TRUE),
                       4 => (aw04_ipd'last_event, tpd_aw04_busy, TRUE),
                       5 => (aw03_ipd'last_event, tpd_aw03_busy, TRUE),
                       6 => (aw02_ipd'last_event, tpd_aw02_busy, TRUE),
                       7 => (aw01_ipd'last_event, tpd_aw01_busy, TRUE),
                       8 => (aw00_ipd'last_event, tpd_aw00_busy, TRUE),
                       9 => (aw18_ipd'last_event, tpd_aw18_busy, TRUE),
                      10 => (aw17_ipd'last_event, tpd_aw17_busy, TRUE),                     
                      11 => (aw16_ipd'last_event, tpd_aw16_busy, TRUE),                     
                      12 => (aw15_ipd'last_event, tpd_aw15_busy, TRUE),                     
                      13 => (aw14_ipd'last_event, tpd_aw14_busy, TRUE),                     
                      14 => (aw13_ipd'last_event, tpd_aw13_busy, TRUE),                     
                      15 => (aw12_ipd'last_event, tpd_aw12_busy, TRUE),                     
                      16 => (aw11_ipd'last_event, tpd_aw11_busy, TRUE),                     
                      17 => (aw10_ipd'last_event, tpd_aw10_busy, TRUE),                     
                      18 => (csw1_ipd'last_event, tpd_csw1_busy, TRUE),
                      19 => (csw0_ipd'last_event, tpd_csw0_busy, TRUE),
                      20 => (ckw0_ipd'last_event, tpd_ckw0_busy, TRUE),
                      21 => (aw09_ipd'last_event, tpd_aw09_busy, TRUE),
                      22 => (aw19_ipd'last_event, tpd_aw19_busy, TRUE)),
        GlitchData => busy_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );

   END PROCESS VITAL_OUTPUT;

END V;


--
-----cell ff512x18----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;

-- entity declaration --
ENTITY ff512x18 IS
   GENERIC (
      FFMODE                     : String   := "NOREG";
      INHIBITMODE                : String   := "TRUE";
      ASYNCMODE                  : String   := "FALSE";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "ff512x18";

        -- input SIGNAL delays
        tipd_d17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d9   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d8   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d7   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d6   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d5   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d4   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d3   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d2   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d1   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d0   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rstn : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf8  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf7  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf6  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf5  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf4  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf3  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf2  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe8  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe7  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe6  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe5  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe4  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe3  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe2  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe0  : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_d17_q17      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d16_q16      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d15_q15      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d14_q14      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d13_q13      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d12_q12      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d11_q11      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d10_q10      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d9_q9        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d8_q8        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d7_q7        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d6_q6        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d5_q5        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d4_q4        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d3_q3        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d2_q2        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d1_q1        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_d0_q0        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q17      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q16      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q15      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q14      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q13      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q12      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q11      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q10      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q9       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q8       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q7       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q6       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q5       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q4       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q3       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q2       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_q0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q17      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q16      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q15      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q14      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q13      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q12      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q11      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q10      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q9       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q8       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q7       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q6       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q5       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q4       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q3       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q2       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q17      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q16      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q15      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q14      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q13      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q12      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q11      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q10      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q9       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q8       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q7       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q6       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q5       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q4       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q3       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q2       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_q0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_wre_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q17      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q16      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q15      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q14      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q13      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q12      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q11      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q10      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q9       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q8       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q7       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q6       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q5       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q4       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q3       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q2       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_q0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rde_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q17     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q16     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q15     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q14     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q13     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q12     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q11     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q10     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q9      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q8      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q7      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q6      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q5      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q4      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q3      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q2      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q1      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_q0      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_ef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_ff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_pef     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_rstn_pff     : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf8_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf7_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf6_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf5_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf4_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf3_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf2_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf1_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pf0_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe8_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe7_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe6_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe5_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe4_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe3_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe2_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe1_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_pe0_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_d17_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d17_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d16_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d16_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d15_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d15_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d14_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d14_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d13_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d13_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d12_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d12_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d11_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d11_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d10_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d10_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d9_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d9_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d8_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d8_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d7_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d7_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d6_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d6_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d5_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d5_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d4_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d4_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d3_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d3_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d2_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d2_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d1_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d1_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d0_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d0_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_wre_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde_ckr_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde_ckr_noedge_posedge  : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw            : VitalDelayType := 0.01 ns;
        tpw_ckw_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr            : VitalDelayType := 0.01 ns;
        tpw_ckr_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr_negedge        : VitalDelayType := 0.01 ns);

   PORT(
      d17, d16, d15, d14, d13, d12, d11, d10, d9                   : in std_logic ;
      d8, d7, d6, d5, d4, d3, d2, d1, d0                           : in std_logic ;
      ckw, ckr, wre, rde, rstn                                     : in std_logic ;
      pf8, pf7, pf6, pf5, pf4, pf3, pf2, pf1, pf0                  : in std_logic ;
      pe8, pe7, pe6, pe5, pe4, pe3, pe2, pe1, pe0                  : in std_logic ;

      q17, q16, q15, q14, q13, q12, q11, q10, q9                   : out std_logic ;
      q8, q7, q6, q5, q4, q3, q2, q1, q0                           : out std_logic ;
      ef, ff, pef, pff                                             : out std_logic );

    ATTRIBUTE Vital_Level0 OF ff512x18 : ENTITY IS TRUE;

END ff512x18 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF ff512x18 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL d17_ipd     : std_logic := 'X';
    SIGNAL d16_ipd     : std_logic := 'X';
    SIGNAL d15_ipd     : std_logic := 'X';
    SIGNAL d14_ipd     : std_logic := 'X';
    SIGNAL d13_ipd     : std_logic := 'X';
    SIGNAL d12_ipd     : std_logic := 'X';
    SIGNAL d11_ipd     : std_logic := 'X';
    SIGNAL d10_ipd     : std_logic := 'X';
    SIGNAL d9_ipd      : std_logic := 'X';
    SIGNAL d8_ipd      : std_logic := 'X';
    SIGNAL d7_ipd      : std_logic := 'X';
    SIGNAL d6_ipd      : std_logic := 'X';
    SIGNAL d5_ipd      : std_logic := 'X';
    SIGNAL d4_ipd      : std_logic := 'X';
    SIGNAL d3_ipd      : std_logic := 'X';
    SIGNAL d2_ipd      : std_logic := 'X';
    SIGNAL d1_ipd      : std_logic := 'X';
    SIGNAL d0_ipd      : std_logic := 'X';
    SIGNAL ckw_ipd     : std_logic := 'X';
    SIGNAL ckr_ipd     : std_logic := 'X';
    SIGNAL wre_ipd     : std_logic := 'X';
    SIGNAL rde_ipd     : std_logic := 'X';
    SIGNAL rstn_ipd    : std_logic := 'X';
    SIGNAL pf8_ipd     : std_logic := 'X';
    SIGNAL pf7_ipd     : std_logic := 'X';
    SIGNAL pf6_ipd     : std_logic := 'X';
    SIGNAL pf5_ipd     : std_logic := 'X';
    SIGNAL pf4_ipd     : std_logic := 'X';
    SIGNAL pf3_ipd     : std_logic := 'X';
    SIGNAL pf2_ipd     : std_logic := 'X';
    SIGNAL pf1_ipd     : std_logic := 'X';
    SIGNAL pf0_ipd     : std_logic := 'X';
    SIGNAL pe8_ipd     : std_logic := 'X';
    SIGNAL pe7_ipd     : std_logic := 'X';
    SIGNAL pe6_ipd     : std_logic := 'X';
    SIGNAL pe5_ipd     : std_logic := 'X';
    SIGNAL pe4_ipd     : std_logic := 'X';
    SIGNAL pe3_ipd     : std_logic := 'X';
    SIGNAL pe2_ipd     : std_logic := 'X';
    SIGNAL pe1_ipd     : std_logic := 'X';
    SIGNAL pe0_ipd     : std_logic := 'X';

    TYPE mem_type IS array (Integer range <>) OF std_logic_vector(17 downto 0);
    SIGNAL mem           : mem_type(0 to 511);
    SIGNAL q0b           : std_logic_vector(17 downto 0) := "000000000000000000";
    SIGNAL q2b           : std_logic_vector(17 downto 0) := "000000000000000000";
    SIGNAL data          : std_logic_vector(17 downto 0);
    SIGNAL pe_ptr        : integer;
    SIGNAL pf_ptr        : integer;
    SIGNAL RADDR                : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL write_address        : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL read_address         : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL fifo_words_used_syncr         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_used_syncw         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words                    : std_logic_vector(9 downto 0) := "1000000000";
    SIGNAL int_write_address         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_plus1         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_syncb         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_synca         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_plus1         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_syncb         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_synca         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_sync         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_sync         : std_logic_vector(10 downto 0);
    SIGNAL ef_reset            : std_logic := '0';
    SIGNAL rd_reset            : std_logic := '0';
    SIGNAL ef_reset_rd            : std_logic := '0';
    SIGNAL fifo_wre            : std_logic := '0';
    SIGNAL fifo_rde            : std_logic := '0';
    SIGNAL ef_int            : std_logic := '0';
    SIGNAL pef_int            : std_logic := '0';
    SIGNAL pff_int            : std_logic := '0';
    SIGNAL ff_int            : std_logic := '0';
    SIGNAL ef_sync            : std_logic := '0';
    SIGNAL pef_sync            : std_logic := '0';
    SIGNAL pff_sync            : std_logic := '0';
    SIGNAL ff_sync            : std_logic := '0';
    SIGNAL fifo_full            : std_logic := '0';
    SIGNAL fifo_empty           : std_logic := '1';
    SIGNAL fifo_pe              : std_logic := '1';
    SIGNAL fifo_pf              : std_logic := '0';
    SIGNAL memchg               : std_logic := '0';
    SIGNAL fifo_reset               : std_logic := '0';
    SIGNAL rd_reset_int               : std_logic := '0';
    SIGNAL int_reset               : std_logic := '0';
    SIGNAL int_reset1               : std_logic := '0';
    SIGNAL asyncmode_reg        : String(ASYNCMODE'length downto 1);
    SIGNAL inhibitmode_reg      : String(INHIBITMODE'length downto 1);
    SIGNAL ffmode_reg           : String(FFMODE'length downto 1);
  BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(d17_ipd, d17, tipd_d17);
   VitalWireDelay(d16_ipd, d16, tipd_d16);
   VitalWireDelay(d15_ipd, d15, tipd_d15);
   VitalWireDelay(d14_ipd, d14, tipd_d14);
   VitalWireDelay(d13_ipd, d13, tipd_d13);
   VitalWireDelay(d12_ipd, d12, tipd_d12);
   VitalWireDelay(d11_ipd, d11, tipd_d11);
   VitalWireDelay(d10_ipd, d10, tipd_d10);
   VitalWireDelay(d9_ipd, d9, tipd_d9);
   VitalWireDelay(d8_ipd, d8, tipd_d8);
   VitalWireDelay(d7_ipd, d7, tipd_d7);
   VitalWireDelay(d6_ipd, d6, tipd_d6);
   VitalWireDelay(d5_ipd, d5, tipd_d5);
   VitalWireDelay(d4_ipd, d4, tipd_d4);
   VitalWireDelay(d3_ipd, d3, tipd_d3);
   VitalWireDelay(d2_ipd, d2, tipd_d2);
   VitalWireDelay(d1_ipd, d1, tipd_d1);
   VitalWireDelay(d0_ipd, d0, tipd_d0);
   VitalWireDelay(ckw_ipd, ckw, tipd_ckw);
   VitalWireDelay(ckr_ipd, ckr, tipd_ckr);
   VitalWireDelay(wre_ipd, wre, tipd_wre);
   VitalWireDelay(rde_ipd, rde, tipd_rde);
   VitalWireDelay(rstn_ipd, rstn, tipd_rstn);
   VitalWireDelay(pf8_ipd, pf8, tipd_pf8);
   VitalWireDelay(pf7_ipd, pf7, tipd_pf7);
   VitalWireDelay(pf6_ipd, pf6, tipd_pf6);
   VitalWireDelay(pf5_ipd, pf5, tipd_pf5);
   VitalWireDelay(pf4_ipd, pf4, tipd_pf4);
   VitalWireDelay(pf3_ipd, pf3, tipd_pf3);
   VitalWireDelay(pf2_ipd, pf2, tipd_pf2);
   VitalWireDelay(pf1_ipd, pf1, tipd_pf1);
   VitalWireDelay(pf0_ipd, pf0, tipd_pf0);
   VitalWireDelay(pe8_ipd, pe8, tipd_pe8);
   VitalWireDelay(pe7_ipd, pe7, tipd_pe7);
   VitalWireDelay(pe6_ipd, pe6, tipd_pe6);
   VitalWireDelay(pe5_ipd, pe5, tipd_pe5);
   VitalWireDelay(pe4_ipd, pe4, tipd_pe4);
   VitalWireDelay(pe3_ipd, pe3, tipd_pe3);
   VitalWireDelay(pe2_ipd, pe2, tipd_pe2);
   VitalWireDelay(pe1_ipd, pe1, tipd_pe1);
   VitalWireDelay(pe0_ipd, pe0, tipd_pe0);
   END BLOCK;

   ffmode_reg <= FFMODE;
   asyncmode_reg <= ASYNCMODE;
   inhibitmode_reg <= INHIBITMODE;
   pe_ptr <= conv_integer('0' & pe8_ipd & pe7_ipd & pe6_ipd & pe5_ipd & pe4_ipd & pe3_ipd & pe2_ipd & pe1_ipd & pe0_ipd);
   pf_ptr <= conv_integer('0' & pf8_ipd & pf7_ipd & pf6_ipd & pf5_ipd & pf4_ipd & pf3_ipd & pf2_ipd & pf1_ipd & pf0_ipd);
   data <= (d17_ipd & d16_ipd & d15_ipd & d14_ipd & d13_ipd & d12_ipd & d11_ipd & d10_ipd & d9_ipd & d8_ipd & d7_ipd & d6_ipd & d5_ipd & d4_ipd & d3_ipd & d2_ipd & d1_ipd & d0_ipd);

   fifo_reset <= not rstn_ipd;
   rd_reset_int <= (fifo_reset or rd_reset);

   P2 : PROCESS (ef_reset_rd, ef_reset)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_reset <= ef_reset_rd;
      ELSE
         int_reset <= ef_reset;
      END IF;
   END PROCESS;

   int_reset1 <= (not (int_reset and rd_reset));

-- generate sync versions of the number of words used in read and write ck domains
   fifo_words_used_syncr <= ((int_write_address_sync(10) xor int_read_address(10)) & int_write_address_sync(9 downto 0) - ('0' & int_read_address(9 downto 0)));

   fifo_words_used_syncw <= ((int_read_address_sync(10) xor int_write_address(10)) & int_write_address(9 downto 0) - ('0' & int_read_address_sync(9 downto 0)));

   int_write_address_sync <= int_write_address_syncb when asyncmode_reg = "TRUE" else int_write_address;

   int_read_address_sync <= int_read_address_syncb when asyncmode_reg = "TRUE" else int_read_address;

   ef_int <= '1' when ((fifo_words_used_syncr(10 downto 1) = "0000000000") and (int_reset1 = '1')) else '0';

   pef_int <= '1' when (fifo_words_used_syncr(9 downto 0) < pe_ptr) else '0';

   fifo_empty <= ef_sync when (ffmode_reg = "OUTREG") else ef_int;
   fifo_pe <= pef_sync when (ffmode_reg = "OUTREG") else pef_int;

   ff_int <= '1' when (fifo_words_used_syncw = fifo_words) else '0';
   pff_int <= '1' when (fifo_words_used_syncw(9 downto 0) >= pf_ptr) else '0';

   fifo_full <= ff_sync when (ffmode_reg = "OUTREG") else ff_int;
   fifo_pf <= pff_sync when (ffmode_reg = "OUTREG") else pff_int;

   ef <= fifo_empty;
   ff <= fifo_full;
   pef <= fifo_pe;
   pff <= fifo_pf;

   P3 : PROCESS (wre_ipd, ff_int, fifo_pf)
   BEGIN
      IF (inhibitmode_reg = "TRUE") THEN
         fifo_wre <= wre_ipd and (not (ff_int and fifo_pf));
      ELSE
         fifo_wre <= wre_ipd;
      END IF;
   END PROCESS;

   P4 : PROCESS (rde_ipd, fifo_empty, fifo_pe)
   BEGIN
      IF (inhibitmode_reg = "TRUE") THEN
         fifo_rde <= rde_ipd and (not (fifo_empty and fifo_pe));
      ELSE
         fifo_rde <= rde_ipd;
      END IF;
   END PROCESS;

   P5 : PROCESS (ckw_ipd, fifo_reset)
   BEGIN
      IF (fifo_reset = '1') THEN
         ef_reset <= '0';
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            ef_reset <= '1';
         END IF;
      END IF;
   END PROCESS;

   P6 : PROCESS (ckr_ipd)
   BEGIN
      IF (ckr_ipd'event and ckr_ipd = '1') THEN
         ef_reset_rd <= ef_reset;
      END IF;
   END PROCESS;

   P7 : PROCESS (ckr_ipd, fifo_reset)
   BEGIN
      IF (fifo_reset = '1') THEN
         rd_reset <= '1';
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF ((fifo_rde = '1') and (((ef_reset_rd = '1') and (asyncmode_reg = "TRUE")) or ((ef_reset = '1') and not(asyncmode_reg = "TRUE")))) THEN
            rd_reset <= '0';
         END IF;
      END IF;
   END PROCESS;

   P8 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         ef_sync <= '1';
         pef_sync <= '1';
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         ef_sync <= ef_int;
         pef_sync <= pef_int;
      END IF;
   END PROCESS;

   P9 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         ff_sync <= '0';
         pff_sync <= '0';
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         ff_sync <= ff_int;
         pff_sync <= pff_int;
      END IF;
   END PROCESS;

--------------------------------------------------------
-- Generate FIFO write address and read address
--------------------------------------------------------
   int_write_address_plus1 <= int_write_address + 1;
   int_read_address_plus1 <= int_read_address + 1;

   P10 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            int_write_address <= int_write_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P11 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address_synca <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            int_write_address_synca <= int_write_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P12 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address_syncb <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         int_write_address_syncb <= int_write_address_synca;
      END IF;
   END PROCESS;

   P13 : PROCESS (ckr_ipd, rd_reset_int)
   BEGIN
      IF (rd_reset_int = '1') THEN
         int_read_address <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            int_read_address <= int_read_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P14 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_read_address_synca <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            int_read_address_synca <= int_read_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P15 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_read_address_syncb <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         int_read_address_syncb <= int_read_address_synca;
      END IF;
   END PROCESS;

   read_address <= int_read_address(8 downto 0);
   write_address <= int_write_address(8 downto 0);

   P16 : PROCESS (int_write_address_syncb, int_write_address)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_write_address_sync <= int_write_address_syncb;
      ELSE
         int_write_address_sync <= int_write_address;
      END IF;
   END PROCESS;

   P17 : PROCESS (int_read_address_syncb, int_read_address)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_read_address_sync <= int_read_address_syncb;
      ELSE
         int_read_address_sync <= int_read_address;
      END IF;
   END PROCESS;

   P18 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         RADDR <= "000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            RADDR <= read_address;
         END IF;
      END IF;
   END PROCESS;

   P19 : PROCESS (read_address, memchg)
   BEGIN
      q0b <= mem(conv_integer(read_address));
   END PROCESS;

   P20 : PROCESS (ckw_ipd, rstn_ipd)
   VARIABLE WADDR : std_logic_vector(8 downto 0) := "000000000";
   BEGIN
      IF (rstn_ipd = '0') THEN
         WADDR := "000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            WADDR := write_address;
            mem(conv_integer(WADDR)) <= data;
            memchg <= not memchg;
         END IF;
      END IF;
   END PROCESS;

   P21 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         q2b <= "000000000000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         q2b <= q0b;
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q2b, q0b)
     VARIABLE q_zd   : std_logic_vector(17 downto 0);

     -- timing check results
        VARIABLE tviol_d17    : x01 := '0';
        VARIABLE tviol_d16    : x01 := '0';
        VARIABLE tviol_d15    : x01 := '0';
        VARIABLE tviol_d14    : x01 := '0';
        VARIABLE tviol_d13    : x01 := '0';
        VARIABLE tviol_d12    : x01 := '0';
        VARIABLE tviol_d11    : x01 := '0';
        VARIABLE tviol_d10    : x01 := '0';
        VARIABLE tviol_d9     : x01 := '0';
        VARIABLE tviol_d8     : x01 := '0';
        VARIABLE tviol_d7     : x01 := '0';
        VARIABLE tviol_d6     : x01 := '0';
        VARIABLE tviol_d5     : x01 := '0';
        VARIABLE tviol_d4     : x01 := '0';
        VARIABLE tviol_d3     : x01 := '0';
        VARIABLE tviol_d2     : x01 := '0';
        VARIABLE tviol_d1     : x01 := '0';
        VARIABLE tviol_d0     : x01 := '0';
        VARIABLE tviol_wre    : x01 := '0';
        VARIABLE tviol_rde    : x01 := '0';

        VARIABLE d17_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d16_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d15_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d14_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d13_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d12_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d11_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d10_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d9_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d8_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d7_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d6_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d5_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d4_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d3_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d2_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d1_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d0_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE wre_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE rde_ckr_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE q17_GlitchData  :   VitalGlitchDataType;
        VARIABLE q16_GlitchData  :   VitalGlitchDataType;
        VARIABLE q15_GlitchData  :   VitalGlitchDataType;
        VARIABLE q14_GlitchData  :   VitalGlitchDataType;
        VARIABLE q13_GlitchData  :   VitalGlitchDataType;
        VARIABLE q12_GlitchData  :   VitalGlitchDataType;
        VARIABLE q11_GlitchData  :   VitalGlitchDataType;
        VARIABLE q10_GlitchData  :   VitalGlitchDataType;
        VARIABLE q9_GlitchData   :   VitalGlitchDataType;
        VARIABLE q8_GlitchData   :   VitalGlitchDataType;
        VARIABLE q7_GlitchData   :   VitalGlitchDataType;
        VARIABLE q6_GlitchData   :   VitalGlitchDataType;
        VARIABLE q5_GlitchData   :   VitalGlitchDataType;
        VARIABLE q4_GlitchData   :   VitalGlitchDataType;
        VARIABLE q3_GlitchData   :   VitalGlitchDataType;
        VARIABLE q2_GlitchData   :   VitalGlitchDataType;
        VARIABLE q1_GlitchData   :   VitalGlitchDataType;
        VARIABLE q0_GlitchData   :   VitalGlitchDataType;

    BEGIN

   ------------------------
   -- functionality section
   ------------------------
      IF (ffmode_reg = "OUTREG") THEN
         q_zd := q2b;
      ELSE
         q_zd := q0b;
      END IF;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q17, OutSignalName => "q17", OutTemp => q_zd(17),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q17,
                             PathCondition => TRUE)),
        GlitchData => q17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q16, OutSignalName => "q16", OutTemp => q_zd(16),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q16,
                             PathCondition => TRUE)),
        GlitchData => q16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q15, OutSignalName => "q15", OutTemp => q_zd(15),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q15,
                             PathCondition => TRUE)),
        GlitchData => q15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q14, OutSignalName => "q14", OutTemp => q_zd(14),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q14,
                             PathCondition => TRUE)),
        GlitchData => q14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q13, OutSignalName => "q13", OutTemp => q_zd(13),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q13,
                             PathCondition => TRUE)),
        GlitchData => q13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q12, OutSignalName => "q12", OutTemp => q_zd(12),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q12,
                             PathCondition => TRUE)),
        GlitchData => q12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q11, OutSignalName => "q11", OutTemp => q_zd(11),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q11,
                             PathCondition => TRUE)),
        GlitchData => q11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q10, OutSignalName => "q10", OutTemp => q_zd(10),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q10,
                             PathCondition => TRUE)),
        GlitchData => q10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q9, OutSignalName => "q9", OutTemp => q_zd(9),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q9,
                             PathCondition => TRUE)),
        GlitchData => q9_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q8, OutSignalName => "q8", OutTemp => q_zd(8),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q8,
                             PathCondition => TRUE)),
        GlitchData => q8_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q7, OutSignalName => "q7", OutTemp => q_zd(7),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q7,
                             PathCondition => TRUE)),
        GlitchData => q7_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q6, OutSignalName => "q6", OutTemp => q_zd(6),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q6,
                             PathCondition => TRUE)),
        GlitchData => q6_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q5, OutSignalName => "q5", OutTemp => q_zd(5),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q5,
                             PathCondition => TRUE)),
        GlitchData => q5_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q4, OutSignalName => "q4", OutTemp => q_zd(4),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q4,
                             PathCondition => TRUE)),
        GlitchData => q4_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q3, OutSignalName => "q3", OutTemp => q_zd(3),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q3,
                             PathCondition => TRUE)),
        GlitchData => q3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q2, OutSignalName => "q2", OutTemp => q_zd(2),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q2,
                             PathCondition => TRUE)),
        GlitchData => q2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q1, OutSignalName => "q1", OutTemp => q_zd(1),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q1,
                             PathCondition => TRUE)),
        GlitchData => q1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q0, OutSignalName => "q0", OutTemp => q_zd(0),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q0,
                             PathCondition => TRUE)),
        GlitchData => q0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
   END PROCESS VITAL_OUTPUT;

END V;


--
-------cell ff256X36----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;

-- entity declaration --
ENTITY ff256X36 IS
   GENERIC (
      FFMODE                     : String  := "NOREG";
      INHIBITMODE                : String  := "TRUE";
      ASYNCMODE                  : String  := "FALSE";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "ff256X36";

        -- input SIGNAL delays
        tipd_d35  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d34  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d33  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d32  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d31  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d30  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d29  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d28  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d27  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d26  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d25  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d24  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d23  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d22  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d21  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d20  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d19  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d18  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d9   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d8   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d7   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d6   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d5   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d4   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d3   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d2   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d1   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d0   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rstn : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf7  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf6  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf5  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf4  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf3  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf2  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe7  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe6  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe5  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe4  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe3  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe2  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe0  : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_ckr_q35      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q34      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q33      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q32      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q31      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q30      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q29      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q28      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q27      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q26      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q25      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q24      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q23      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q22      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q21      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q20      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q19      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q18      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q17      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q16      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q15      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q14      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q13      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q12      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q11      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q10      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q9       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q8       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q7       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q6       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q5       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q4       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q3       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q2       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_d35_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d35_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d34_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d34_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d33_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d33_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d32_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d32_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d31_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d31_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d30_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d30_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d29_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d29_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d28_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d28_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d27_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d27_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d26_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d26_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d25_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d25_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d24_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d24_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d23_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d23_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d22_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d22_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d21_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d21_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d20_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d20_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d19_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d19_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d18_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d18_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d17_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d17_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d16_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d16_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d15_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d15_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d14_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d14_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d13_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d13_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d12_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d12_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d11_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d11_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d10_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_d10_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d9_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d9_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d8_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d8_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d7_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d7_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d6_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d6_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d5_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d5_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d4_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d4_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d3_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d3_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d2_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d2_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d1_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d1_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d0_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d0_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_wre_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde_ckr_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde_ckr_noedge_posedge  : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw            : VitalDelayType := 0.01 ns;
        tpw_ckw_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr            : VitalDelayType := 0.01 ns;
        tpw_ckr_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr_negedge        : VitalDelayType := 0.01 ns);


   PORT(
      d35, d34, d33, d32, d31, d30, d29, d28, d27                  : in std_logic ;
      d26, d25, d24, d23, d22, d21, d20, d19, d18                  : in std_logic ;
      d17, d16, d15, d14, d13, d12, d11, d10, d9                   : in std_logic ;
      d8, d7, d6, d5, d4, d3, d2, d1, d0                           : in std_logic ;
      ckw, ckr, wre, rde, rstn                                     : in std_logic ;
      pf7, pf6, pf5, pf4, pf3, pf2, pf1, pf0                       : in std_logic ;
      pe7, pe6, pe5, pe4, pe3, pe2, pe1, pe0                       : in std_logic ;

      q35, q34, q33, q32, q31, q30, q29, q28, q27                  : out std_logic ;
      q26, q25, q24, q23, q22, q21, q20, q19, q18                  : out std_logic ;
      q17, q16, q15, q14, q13, q12, q11, q10, q9                   : out std_logic ;
      q8, q7, q6, q5, q4, q3, q2, q1, q0                           : out std_logic ;
      ef, ff, pef, pff                                             : out std_logic );

    ATTRIBUTE Vital_Level0 OF ff256X36 : ENTITY IS TRUE;

END ff256X36 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF ff256X36 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL d35_ipd     : std_logic := 'X';
    SIGNAL d34_ipd     : std_logic := 'X';
    SIGNAL d33_ipd     : std_logic := 'X';
    SIGNAL d32_ipd     : std_logic := 'X';
    SIGNAL d31_ipd     : std_logic := 'X';
    SIGNAL d30_ipd     : std_logic := 'X';
    SIGNAL d29_ipd     : std_logic := 'X';
    SIGNAL d28_ipd     : std_logic := 'X';
    SIGNAL d27_ipd     : std_logic := 'X';
    SIGNAL d26_ipd     : std_logic := 'X';
    SIGNAL d25_ipd     : std_logic := 'X';
    SIGNAL d24_ipd     : std_logic := 'X';
    SIGNAL d23_ipd     : std_logic := 'X';
    SIGNAL d22_ipd     : std_logic := 'X';
    SIGNAL d21_ipd     : std_logic := 'X';
    SIGNAL d20_ipd     : std_logic := 'X';
    SIGNAL d19_ipd     : std_logic := 'X';
    SIGNAL d18_ipd     : std_logic := 'X';
    SIGNAL d17_ipd     : std_logic := 'X';
    SIGNAL d16_ipd     : std_logic := 'X';
    SIGNAL d15_ipd     : std_logic := 'X';
    SIGNAL d14_ipd     : std_logic := 'X';
    SIGNAL d13_ipd     : std_logic := 'X';
    SIGNAL d12_ipd     : std_logic := 'X';
    SIGNAL d11_ipd     : std_logic := 'X';
    SIGNAL d10_ipd     : std_logic := 'X';
    SIGNAL d9_ipd      : std_logic := 'X';
    SIGNAL d8_ipd      : std_logic := 'X';
    SIGNAL d7_ipd      : std_logic := 'X';
    SIGNAL d6_ipd      : std_logic := 'X';
    SIGNAL d5_ipd      : std_logic := 'X';
    SIGNAL d4_ipd      : std_logic := 'X';
    SIGNAL d3_ipd      : std_logic := 'X';
    SIGNAL d2_ipd      : std_logic := 'X';
    SIGNAL d1_ipd      : std_logic := 'X';
    SIGNAL d0_ipd      : std_logic := 'X';
    SIGNAL ckw_ipd     : std_logic := 'X';
    SIGNAL ckr_ipd     : std_logic := 'X';
    SIGNAL wre_ipd     : std_logic := 'X';
    SIGNAL rde_ipd     : std_logic := 'X';
    SIGNAL rstn_ipd    : std_logic := 'X';
    SIGNAL pf7_ipd     : std_logic := 'X';
    SIGNAL pf6_ipd     : std_logic := 'X';
    SIGNAL pf5_ipd     : std_logic := 'X';
    SIGNAL pf4_ipd     : std_logic := 'X';
    SIGNAL pf3_ipd     : std_logic := 'X';
    SIGNAL pf2_ipd     : std_logic := 'X';
    SIGNAL pf1_ipd     : std_logic := 'X';
    SIGNAL pf0_ipd     : std_logic := 'X';
    SIGNAL pe7_ipd     : std_logic := 'X';
    SIGNAL pe6_ipd     : std_logic := 'X';
    SIGNAL pe5_ipd     : std_logic := 'X';
    SIGNAL pe4_ipd     : std_logic := 'X';
    SIGNAL pe3_ipd     : std_logic := 'X';
    SIGNAL pe2_ipd     : std_logic := 'X';
    SIGNAL pe1_ipd     : std_logic := 'X';
    SIGNAL pe0_ipd     : std_logic := 'X';

    TYPE mem_type IS array (Integer range <>) OF std_logic_vector(35 downto 0);
    SIGNAL mem         : mem_type(0 to 255);
    SIGNAL q0b           : std_logic_vector(35 downto 0) := "000000000000000000000000000000000000";
    SIGNAL q2b           : std_logic_vector(35 downto 0) := "000000000000000000000000000000000000";
    SIGNAL data          : std_logic_vector(35 downto 0);
    SIGNAL pe_ptr        : integer;
    SIGNAL pf_ptr        : integer;
    SIGNAL RADDR                : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL write_address        : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL read_address         : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL fifo_words_used_syncr         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_used_syncw         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words                    : std_logic_vector(8 downto 0) := "100000000";
    SIGNAL int_write_address         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_plus1         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_syncb         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_synca         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_plus1         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_syncb         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_synca         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_sync         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_sync         : std_logic_vector(10 downto 0);
    SIGNAL ef_reset            : std_logic := '0';
    SIGNAL rd_reset            : std_logic := '0';
    SIGNAL ef_reset_rd            : std_logic := '0';
    SIGNAL fifo_wre            : std_logic := '0';
    SIGNAL fifo_rde            : std_logic := '0';
    SIGNAL ef_int            : std_logic := '0';
    SIGNAL pef_int            : std_logic := '0';
    SIGNAL pff_int            : std_logic := '0';
    SIGNAL ff_int            : std_logic := '0';
    SIGNAL ef_sync            : std_logic := '0';
    SIGNAL pef_sync            : std_logic := '0';
    SIGNAL pff_sync            : std_logic := '0';
    SIGNAL ff_sync            : std_logic := '0';
    SIGNAL fifo_full            : std_logic := '0';
    SIGNAL fifo_empty           : std_logic := '1';
    SIGNAL fifo_pe              : std_logic := '1';
    SIGNAL fifo_pf              : std_logic := '0';
    SIGNAL memchg               : std_logic := '0';
    SIGNAL fifo_reset               : std_logic := '0';
    SIGNAL rd_reset_int               : std_logic := '0';
    SIGNAL int_reset               : std_logic := '0';
    SIGNAL int_reset1               : std_logic := '0';
    SIGNAL asyncmode_reg        : String(ASYNCMODE'length downto 1);
    SIGNAL inhibitmode_reg      : String(INHIBITMODE'length downto 1);
    SIGNAL ffmode_reg           : String(FFMODE'length downto 1);
  BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(d35_ipd, d35, tipd_d35);
   VitalWireDelay(d34_ipd, d34, tipd_d34);
   VitalWireDelay(d33_ipd, d33, tipd_d33);
   VitalWireDelay(d32_ipd, d32, tipd_d32);
   VitalWireDelay(d31_ipd, d31, tipd_d31);
   VitalWireDelay(d30_ipd, d30, tipd_d30);
   VitalWireDelay(d29_ipd, d29, tipd_d29);
   VitalWireDelay(d28_ipd, d28, tipd_d28);
   VitalWireDelay(d27_ipd, d27, tipd_d27);
   VitalWireDelay(d26_ipd, d26, tipd_d26);
   VitalWireDelay(d25_ipd, d25, tipd_d25);
   VitalWireDelay(d24_ipd, d24, tipd_d24);
   VitalWireDelay(d23_ipd, d23, tipd_d23);
   VitalWireDelay(d22_ipd, d22, tipd_d22);
   VitalWireDelay(d21_ipd, d21, tipd_d21);
   VitalWireDelay(d20_ipd, d20, tipd_d20);
   VitalWireDelay(d19_ipd, d19, tipd_d19);
   VitalWireDelay(d18_ipd, d18, tipd_d18);
   VitalWireDelay(d17_ipd, d17, tipd_d17);
   VitalWireDelay(d16_ipd, d16, tipd_d16);
   VitalWireDelay(d15_ipd, d15, tipd_d15);
   VitalWireDelay(d14_ipd, d14, tipd_d14);
   VitalWireDelay(d13_ipd, d13, tipd_d13);
   VitalWireDelay(d12_ipd, d12, tipd_d12);
   VitalWireDelay(d11_ipd, d11, tipd_d11);
   VitalWireDelay(d10_ipd, d10, tipd_d10);
   VitalWireDelay(d9_ipd, d9, tipd_d9);
   VitalWireDelay(d8_ipd, d8, tipd_d8);
   VitalWireDelay(d7_ipd, d7, tipd_d7);
   VitalWireDelay(d6_ipd, d6, tipd_d6);
   VitalWireDelay(d5_ipd, d5, tipd_d5);
   VitalWireDelay(d4_ipd, d4, tipd_d4);
   VitalWireDelay(d3_ipd, d3, tipd_d3);
   VitalWireDelay(d2_ipd, d2, tipd_d2);
   VitalWireDelay(d1_ipd, d1, tipd_d1);
   VitalWireDelay(d0_ipd, d0, tipd_d0);
   VitalWireDelay(ckw_ipd, ckw, tipd_ckw);
   VitalWireDelay(ckr_ipd, ckr, tipd_ckr);
   VitalWireDelay(wre_ipd, wre, tipd_wre);
   VitalWireDelay(rde_ipd, rde, tipd_rde);
   VitalWireDelay(rstn_ipd, rstn, tipd_rstn);
   VitalWireDelay(pf7_ipd, pf7, tipd_pf7);
   VitalWireDelay(pf6_ipd, pf6, tipd_pf6);
   VitalWireDelay(pf5_ipd, pf5, tipd_pf5);
   VitalWireDelay(pf4_ipd, pf4, tipd_pf4);
   VitalWireDelay(pf3_ipd, pf3, tipd_pf3);
   VitalWireDelay(pf2_ipd, pf2, tipd_pf2);
   VitalWireDelay(pf1_ipd, pf1, tipd_pf1);
   VitalWireDelay(pf0_ipd, pf0, tipd_pf0);
   VitalWireDelay(pe7_ipd, pe7, tipd_pe7);
   VitalWireDelay(pe6_ipd, pe6, tipd_pe6);
   VitalWireDelay(pe5_ipd, pe5, tipd_pe5);
   VitalWireDelay(pe4_ipd, pe4, tipd_pe4);
   VitalWireDelay(pe3_ipd, pe3, tipd_pe3);
   VitalWireDelay(pe2_ipd, pe2, tipd_pe2);
   VitalWireDelay(pe1_ipd, pe1, tipd_pe1);
   VitalWireDelay(pe0_ipd, pe0, tipd_pe0);
   END BLOCK;

   ffmode_reg <= FFMODE;
   asyncmode_reg <= ASYNCMODE;
   inhibitmode_reg <= INHIBITMODE;

   pe_ptr <= conv_integer('0' & '0' & pe7_ipd & pe6_ipd & pe5_ipd & pe4_ipd & pe3_ipd & pe2_ipd & pe1_ipd & pe0_ipd);
   pf_ptr <= conv_integer('0' & '0' & pf7_ipd & pf6_ipd & pf5_ipd & pf4_ipd & pf3_ipd & pf2_ipd & pf1_ipd & pf0_ipd);
   data <= (d35_ipd & d34_ipd & d33_ipd & d32_ipd & d31_ipd & d30_ipd & d29_ipd & d28_ipd & d27_ipd & d26_ipd & d25_ipd & d24_ipd & d23_ipd & d22_ipd & d21_ipd & d20_ipd & d19_ipd & d18_ipd & d17_ipd & d16_ipd & d15_ipd & d14_ipd & d13_ipd & d12_ipd & d11_ipd & d10_ipd & d9_ipd & d8_ipd & d7_ipd & d6_ipd & d5_ipd & d4_ipd & d3_ipd & d2_ipd & d1_ipd & d0_ipd);

   fifo_reset <= not rstn_ipd;
   rd_reset_int <= (fifo_reset or rd_reset);

   P2 : PROCESS (ef_reset_rd, ef_reset)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_reset <= ef_reset_rd;
      ELSE
         int_reset <= ef_reset;
      END IF;
   END PROCESS;

   int_reset1 <= (not (int_reset and rd_reset));

-- generate sync versions of the number of words used in read and write ck domains
   fifo_words_used_syncr <= ((int_write_address_sync(10) xor int_read_address(10)) & int_write_address_sync(9 downto 0) - ('0' & int_read_address(9 downto 0)));

   fifo_words_used_syncw <= ((int_read_address_sync(10) xor int_write_address(10)) & int_write_address(9 downto 0) - ('0' & int_read_address_sync(9 downto 0)));

   int_write_address_sync <= int_write_address_syncb when asyncmode_reg = "TRUE" else int_write_address;

   int_read_address_sync <= int_read_address_syncb when asyncmode_reg = "TRUE" else int_read_address;

   ef_int <= '1' when ((fifo_words_used_syncr(10 downto 1) = "0000000000") and (int_reset1 = '1')) else '0';

   pef_int <= '1' when (fifo_words_used_syncr(9 downto 0) < pe_ptr) else '0';

   fifo_empty <= ef_sync when (ffmode_reg = "OUTREG") else ef_int;
   fifo_pe <= pef_sync when (ffmode_reg = "OUTREG") else pef_int;

   ff_int <= '1' when (fifo_words_used_syncw = fifo_words) else '0';
   pff_int <= '1' when (fifo_words_used_syncw(9 downto 0) >= pf_ptr) else '0';

   fifo_full <= ff_sync when (ffmode_reg = "OUTREG") else ff_int;
   fifo_pf <= pff_sync when (ffmode_reg = "OUTREG") else pff_int;

   ef <= fifo_empty;
   ff <= fifo_full;
   pef <= fifo_pe;
   pff <= fifo_pf;

   P3 : PROCESS (wre_ipd, ff_int, fifo_pf)
   BEGIN
      IF (inhibitmode_reg = "TRUE") THEN
         fifo_wre <= wre_ipd and (not (ff_int and fifo_pf));
      ELSE
         fifo_wre <= wre_ipd;
      END IF;
   END PROCESS;

   P4 : PROCESS (rde_ipd, fifo_empty, fifo_pe)
   BEGIN
      IF (inhibitmode_reg = "TRUE") THEN
         fifo_rde <= rde_ipd and (not (fifo_empty and fifo_pe));
      ELSE
         fifo_rde <= rde_ipd;
      END IF;
   END PROCESS;

   P5 : PROCESS (ckw_ipd, fifo_reset)
   BEGIN
      IF (fifo_reset = '1') THEN
         ef_reset <= '0';
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            ef_reset <= '1';
         END IF;
      END IF;
   END PROCESS;

   P6 : PROCESS (ckr_ipd)
   BEGIN
      IF (ckr_ipd'event and ckr_ipd = '1') THEN
         ef_reset_rd <= ef_reset;
      END IF;
   END PROCESS;

   P7 : PROCESS (ckr_ipd, fifo_reset)
   BEGIN
      IF (fifo_reset = '1') THEN
         rd_reset <= '1';
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF ((fifo_rde = '1') and (((ef_reset_rd = '1') and (asyncmode_reg = "TRUE")) or ((ef_reset = '1') and not(asyncmode_reg = "TRUE")))) THEN
            rd_reset <= '0';
         END IF;
      END IF;
   END PROCESS;

   P8 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         ef_sync <= '1';
         pef_sync <= '1';
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         ef_sync <= ef_int;
         pef_sync <= pef_int;
      END IF;
   END PROCESS;

   P9 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         ff_sync <= '0';
         pff_sync <= '0';
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         ff_sync <= ff_int;
         pff_sync <= pff_int;
      END IF;
   END PROCESS;

--------------------------------------------------------
-- Generate FIFO write address and read address
--------------------------------------------------------
   int_write_address_plus1 <= int_write_address + 1;
   int_read_address_plus1 <= int_read_address + 1;

   P10 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            int_write_address <= int_write_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P11 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address_synca <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            int_write_address_synca <= int_write_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P12 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address_syncb <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         int_write_address_syncb <= int_write_address_synca;
      END IF;
   END PROCESS;

   P13 : PROCESS (ckr_ipd, rd_reset_int)
   BEGIN
      IF (rd_reset_int = '1') THEN
         int_read_address <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            int_read_address <= int_read_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P14 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_read_address_synca <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            int_read_address_synca <= int_read_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P15 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_read_address_syncb <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         int_read_address_syncb <= int_read_address_synca;
      END IF;
   END PROCESS;

   read_address <= int_read_address(7 downto 0);
   write_address <= int_write_address(7 downto 0);

   P16 : PROCESS (int_write_address_syncb, int_write_address)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_write_address_sync <= int_write_address_syncb;
      ELSE
         int_write_address_sync <= int_write_address;
      END IF;
   END PROCESS;

   P17 : PROCESS (int_read_address_syncb, int_read_address)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_read_address_sync <= int_read_address_syncb;
      ELSE
         int_read_address_sync <= int_read_address;
      END IF;
   END PROCESS;

   P18 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         RADDR <= "00000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            RADDR <= read_address;
         END IF;
      END IF;
   END PROCESS;

   P19 : PROCESS (read_address, memchg)
   BEGIN
      q0b <= mem(conv_integer(read_address));
   END PROCESS;

   P20 : PROCESS (ckw_ipd, rstn_ipd)
   VARIABLE WADDR : std_logic_vector(7 downto 0) := "00000000";
   BEGIN
      IF (rstn_ipd = '0') THEN
         WADDR := "00000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            WADDR := write_address;
            mem(conv_integer(WADDR)) <= data;
            memchg <= not memchg;
         END IF;
      END IF;
   END PROCESS;

   P21 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         q2b <= "000000000000000000000000000000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         q2b <= q0b;
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q0b, q2b)   
     VARIABLE q_zd   : std_logic_vector(35 downto 0);
     -- timing check results
        VARIABLE tviol_d35    : x01 := '0';
        VARIABLE tviol_d34    : x01 := '0';
        VARIABLE tviol_d33    : x01 := '0';
        VARIABLE tviol_d32    : x01 := '0';
        VARIABLE tviol_d31    : x01 := '0';
        VARIABLE tviol_d30    : x01 := '0';
        VARIABLE tviol_d29    : x01 := '0';
        VARIABLE tviol_d28    : x01 := '0';
        VARIABLE tviol_d27    : x01 := '0';
        VARIABLE tviol_d26    : x01 := '0';
        VARIABLE tviol_d25    : x01 := '0';
        VARIABLE tviol_d24    : x01 := '0';
        VARIABLE tviol_d23    : x01 := '0';
        VARIABLE tviol_d22    : x01 := '0';
        VARIABLE tviol_d21    : x01 := '0';
        VARIABLE tviol_d20    : x01 := '0';
        VARIABLE tviol_d19    : x01 := '0';
        VARIABLE tviol_d18    : x01 := '0';
        VARIABLE tviol_d17    : x01 := '0';
        VARIABLE tviol_d16    : x01 := '0';
        VARIABLE tviol_d15    : x01 := '0';
        VARIABLE tviol_d14    : x01 := '0';
        VARIABLE tviol_d13    : x01 := '0';
        VARIABLE tviol_d12    : x01 := '0';
        VARIABLE tviol_d11    : x01 := '0';
        VARIABLE tviol_d10    : x01 := '0';
        VARIABLE tviol_d9     : x01 := '0';
        VARIABLE tviol_d8     : x01 := '0';
        VARIABLE tviol_d7     : x01 := '0';
        VARIABLE tviol_d6     : x01 := '0';
        VARIABLE tviol_d5     : x01 := '0';
        VARIABLE tviol_d4     : x01 := '0';
        VARIABLE tviol_d3     : x01 := '0';
        VARIABLE tviol_d2     : x01 := '0';
        VARIABLE tviol_d1     : x01 := '0';
        VARIABLE tviol_d0     : x01 := '0';
        VARIABLE tviol_wre    : x01 := '0';
        VARIABLE tviol_rde    : x01 := '0';

        VARIABLE d35_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d34_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d33_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d32_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d31_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d30_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d29_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d28_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d27_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d26_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d25_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d24_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d23_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d22_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d21_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d20_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d19_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d18_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d17_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d16_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d15_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d14_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d13_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d12_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d11_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d10_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE d9_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d8_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d7_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d6_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d5_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d4_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d3_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d2_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d1_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d0_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE wre_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE rde_ckr_TimingDatash : VitalTimingDataType;

     -- output glitch results
        VARIABLE q35_GlitchData  :   VitalGlitchDataType;
        VARIABLE q34_GlitchData  :   VitalGlitchDataType;
        VARIABLE q33_GlitchData  :   VitalGlitchDataType;
        VARIABLE q32_GlitchData  :   VitalGlitchDataType;
        VARIABLE q31_GlitchData  :   VitalGlitchDataType;
        VARIABLE q30_GlitchData  :   VitalGlitchDataType;
        VARIABLE q29_GlitchData  :   VitalGlitchDataType;
        VARIABLE q28_GlitchData  :   VitalGlitchDataType;
        VARIABLE q27_GlitchData  :   VitalGlitchDataType;
        VARIABLE q26_GlitchData  :   VitalGlitchDataType;
        VARIABLE q25_GlitchData  :   VitalGlitchDataType;
        VARIABLE q24_GlitchData  :   VitalGlitchDataType;
        VARIABLE q23_GlitchData  :   VitalGlitchDataType;
        VARIABLE q22_GlitchData  :   VitalGlitchDataType;
        VARIABLE q21_GlitchData  :   VitalGlitchDataType;
        VARIABLE q20_GlitchData  :   VitalGlitchDataType;
        VARIABLE q19_GlitchData  :   VitalGlitchDataType;
        VARIABLE q18_GlitchData  :   VitalGlitchDataType;
        VARIABLE q17_GlitchData  :   VitalGlitchDataType;
        VARIABLE q16_GlitchData  :   VitalGlitchDataType;
        VARIABLE q15_GlitchData  :   VitalGlitchDataType;
        VARIABLE q14_GlitchData  :   VitalGlitchDataType;
        VARIABLE q13_GlitchData  :   VitalGlitchDataType;
        VARIABLE q12_GlitchData  :   VitalGlitchDataType;
        VARIABLE q11_GlitchData  :   VitalGlitchDataType;
        VARIABLE q10_GlitchData  :   VitalGlitchDataType;
        VARIABLE q9_GlitchData   :   VitalGlitchDataType;
        VARIABLE q8_GlitchData   :   VitalGlitchDataType;
        VARIABLE q7_GlitchData   :   VitalGlitchDataType;
        VARIABLE q6_GlitchData   :   VitalGlitchDataType;
        VARIABLE q5_GlitchData   :   VitalGlitchDataType;
        VARIABLE q4_GlitchData   :   VitalGlitchDataType;
        VARIABLE q3_GlitchData   :   VitalGlitchDataType;
        VARIABLE q2_GlitchData   :   VitalGlitchDataType;
        VARIABLE q1_GlitchData   :   VitalGlitchDataType;
        VARIABLE q0_GlitchData   :   VitalGlitchDataType;
   BEGIN
      IF (ffmode_reg = "OUTREG") THEN
         q_zd := q2b;
      ELSE
         q_zd := q0b;
      END IF;
         
   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q35, OutSignalName => "q35", OutTemp => q_zd(35),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q35,
                             PathCondition => TRUE)),
        GlitchData => q35_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q34, OutSignalName => "q34", OutTemp => q_zd(34),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q34,
                             PathCondition => TRUE)),
        GlitchData => q34_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q33, OutSignalName => "q33", OutTemp => q_zd(33),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q33,
                             PathCondition => TRUE)),
        GlitchData => q33_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q32, OutSignalName => "q32", OutTemp => q_zd(32),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q32,
                             PathCondition => TRUE)),
        GlitchData => q32_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q31, OutSignalName => "q31", OutTemp => q_zd(31),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q31,
                             PathCondition => TRUE)),
        GlitchData => q31_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q30, OutSignalName => "q30", OutTemp => q_zd(30),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q30,
                             PathCondition => TRUE)),
        GlitchData => q30_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q29, OutSignalName => "q29", OutTemp => q_zd(29),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q29,
                             PathCondition => TRUE)),
        GlitchData => q29_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q28, OutSignalName => "q28", OutTemp => q_zd(28),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q28,
                             PathCondition => TRUE)),
        GlitchData => q28_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q27, OutSignalName => "q27", OutTemp => q_zd(27),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q27,
                             PathCondition => TRUE)),
        GlitchData => q27_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q26, OutSignalName => "q26", OutTemp => q_zd(26),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q26,
                             PathCondition => TRUE)),
        GlitchData => q26_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q25, OutSignalName => "q25", OutTemp => q_zd(25),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q25,
                             PathCondition => TRUE)),
        GlitchData => q25_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q24, OutSignalName => "q24", OutTemp => q_zd(24),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q24,
                             PathCondition => TRUE)),
        GlitchData => q24_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q23, OutSignalName => "q23", OutTemp => q_zd(23),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q23,
                             PathCondition => TRUE)),
        GlitchData => q23_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q22, OutSignalName => "q22", OutTemp => q_zd(22),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q22,
                             PathCondition => TRUE)),
        GlitchData => q22_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q21, OutSignalName => "q21", OutTemp => q_zd(21),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q21,
                             PathCondition => TRUE)),
        GlitchData => q21_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q20, OutSignalName => "q20", OutTemp => q_zd(20),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q20,
                             PathCondition => TRUE)),
        GlitchData => q20_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q19, OutSignalName => "q19", OutTemp => q_zd(19),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q19,
                             PathCondition => TRUE)),
        GlitchData => q19_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q18, OutSignalName => "q18", OutTemp => q_zd(18),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q18,
                             PathCondition => TRUE)),
        GlitchData => q18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q17, OutSignalName => "q17", OutTemp => q_zd(17),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q17,
                             PathCondition => TRUE)),
        GlitchData => q17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q16, OutSignalName => "q16", OutTemp => q_zd(16),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q16,
                             PathCondition => TRUE)),
        GlitchData => q16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q15, OutSignalName => "q15", OutTemp => q_zd(15),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q15,
                             PathCondition => TRUE)),
        GlitchData => q15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q14, OutSignalName => "q14", OutTemp => q_zd(14),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q14,
                             PathCondition => TRUE)),
        GlitchData => q14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q13, OutSignalName => "q13", OutTemp => q_zd(13),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q13,
                             PathCondition => TRUE)),
        GlitchData => q13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q12, OutSignalName => "q12", OutTemp => q_zd(12),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q12,
                             PathCondition => TRUE)),
        GlitchData => q12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q11, OutSignalName => "q11", OutTemp => q_zd(11),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q11,
                             PathCondition => TRUE)),
        GlitchData => q11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q10, OutSignalName => "q10", OutTemp => q_zd(10),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q10,
                             PathCondition => TRUE)),
        GlitchData => q10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q9, OutSignalName => "q9", OutTemp => q_zd(9),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q9,
                             PathCondition => TRUE)),
        GlitchData => q9_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q8, OutSignalName => "q8", OutTemp => q_zd(8),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q8,
                             PathCondition => TRUE)),
        GlitchData => q8_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q7, OutSignalName => "q7", OutTemp => q_zd(7),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q7,
                             PathCondition => TRUE)),
        GlitchData => q7_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q6, OutSignalName => "q6", OutTemp => q_zd(6),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q6,
                             PathCondition => TRUE)),
        GlitchData => q6_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q5, OutSignalName => "q5", OutTemp => q_zd(5),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q5,
                             PathCondition => TRUE)),
        GlitchData => q5_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q4, OutSignalName => "q4", OutTemp => q_zd(4),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q4,
                             PathCondition => TRUE)),
        GlitchData => q4_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q3, OutSignalName => "q3", OutTemp => q_zd(3),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q3,
                             PathCondition => TRUE)),
        GlitchData => q3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q2, OutSignalName => "q2", OutTemp => q_zd(2),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q2,
                             PathCondition => TRUE)),
        GlitchData => q2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q1, OutSignalName => "q1", OutTemp => q_zd(1),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q1,
                             PathCondition => TRUE)),
        GlitchData => q1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q0, OutSignalName => "q0", OutTemp => q_zd(0),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q0,
                             PathCondition => TRUE)),
        GlitchData => q0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
   END PROCESS VITAL_OUTPUT;

END V;


--
-----cell ff1024x9----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;

-- entity declaration --
ENTITY ff1024x9 IS
   GENERIC (
      FFMODE                     : String  := "NOREG";
      INHIBITMODE                : String  := "TRUE";
      ASYNCMODE                  : String  := "FALSE";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "ff1024x9";

        -- input SIGNAL delays
        tipd_d8   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d7   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d6   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d5   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d4   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d3   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d2   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d1   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d0   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rstn : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf9  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf8  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf7  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf6  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf5  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf4  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf3  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf2  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe9  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe8  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe7  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe6  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe5  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe4  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe3  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe2  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe0  : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_ckr_q8       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q7       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q6       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q5       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q4       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q3       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q2       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_q0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_ef       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_ff       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_pef      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw_pff      : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_d8_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d8_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d7_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d7_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d6_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d6_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d5_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d5_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d4_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d4_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d3_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d3_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d2_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d2_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d1_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d1_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d0_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d0_ckw_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_wre_ckw_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre_ckw_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde_ckr_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde_ckr_noedge_posedge  : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw            : VitalDelayType := 0.01 ns;
        tpw_ckw_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr            : VitalDelayType := 0.01 ns;
        tpw_ckr_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr_negedge        : VitalDelayType := 0.01 ns);

   PORT(
      d8, d7, d6, d5, d4, d3, d2, d1, d0                           : in std_logic ;
      ckw, ckr, wre, rde, rstn                                     : in std_logic ;
      pf9, pf8, pf7, pf6, pf5, pf4, pf3, pf2, pf1, pf0             : in std_logic ;
      pe9, pe8, pe7, pe6, pe5, pe4, pe3, pe2, pe1, pe0             : in std_logic ;

      q8, q7, q6, q5, q4, q3, q2, q1, q0                           : out std_logic ;
      ef, ff, pef, pff                                             : out std_logic );

    ATTRIBUTE Vital_Level0 OF ff1024x9 : ENTITY IS TRUE;

END ff1024x9 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF ff1024x9 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL d8_ipd      : std_logic := 'X';
    SIGNAL d7_ipd      : std_logic := 'X';
    SIGNAL d6_ipd      : std_logic := 'X';
    SIGNAL d5_ipd      : std_logic := 'X';
    SIGNAL d4_ipd      : std_logic := 'X';
    SIGNAL d3_ipd      : std_logic := 'X';
    SIGNAL d2_ipd      : std_logic := 'X';
    SIGNAL d1_ipd      : std_logic := 'X';
    SIGNAL d0_ipd      : std_logic := 'X';
    SIGNAL ckw_ipd     : std_logic := 'X';
    SIGNAL ckr_ipd     : std_logic := 'X';
    SIGNAL wre_ipd     : std_logic := 'X';
    SIGNAL rde_ipd     : std_logic := 'X';
    SIGNAL rstn_ipd    : std_logic := 'X';
    SIGNAL pf9_ipd     : std_logic := 'X';
    SIGNAL pf8_ipd     : std_logic := 'X';
    SIGNAL pf7_ipd     : std_logic := 'X';
    SIGNAL pf6_ipd     : std_logic := 'X';
    SIGNAL pf5_ipd     : std_logic := 'X';
    SIGNAL pf4_ipd     : std_logic := 'X';
    SIGNAL pf3_ipd     : std_logic := 'X';
    SIGNAL pf2_ipd     : std_logic := 'X';
    SIGNAL pf1_ipd     : std_logic := 'X';
    SIGNAL pf0_ipd     : std_logic := 'X';
    SIGNAL pe9_ipd     : std_logic := 'X';
    SIGNAL pe8_ipd     : std_logic := 'X';
    SIGNAL pe7_ipd     : std_logic := 'X';
    SIGNAL pe6_ipd     : std_logic := 'X';
    SIGNAL pe5_ipd     : std_logic := 'X';
    SIGNAL pe4_ipd     : std_logic := 'X';
    SIGNAL pe3_ipd     : std_logic := 'X';
    SIGNAL pe2_ipd     : std_logic := 'X';
    SIGNAL pe1_ipd     : std_logic := 'X';
    SIGNAL pe0_ipd     : std_logic := 'X';

    TYPE mem_type IS array (Integer range <>) OF std_logic_vector(8 downto 0);
    SIGNAL mem           : mem_type(0 to 1023);
    SIGNAL q0b           : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL q2b           : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL data          : std_logic_vector(8 downto 0);
    SIGNAL pe_ptr        : integer;
    SIGNAL pf_ptr        : integer;
    SIGNAL RADDR                : std_logic_vector(9 downto 0) := "0000000000";
    SIGNAL write_address        : std_logic_vector(9 downto 0) := "0000000000";
    SIGNAL read_address         : std_logic_vector(9 downto 0) := "0000000000";
    SIGNAL fifo_words_used_syncr         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_used_syncw         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words                    : std_logic_vector(10 downto 0) := "10000000000";
    SIGNAL int_write_address         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_plus1         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_syncb         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_synca         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_plus1         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_syncb         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_synca         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_sync         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_sync         : std_logic_vector(10 downto 0);
    SIGNAL ef_reset            : std_logic := '0';
    SIGNAL rd_reset            : std_logic := '0';
    SIGNAL ef_reset_rd            : std_logic := '0';
    SIGNAL fifo_wre            : std_logic := '0';
    SIGNAL fifo_rde            : std_logic := '0';
    SIGNAL ef_int            : std_logic := '0';
    SIGNAL pef_int            : std_logic := '0';
    SIGNAL pff_int            : std_logic := '0';
    SIGNAL ff_int            : std_logic := '0';
    SIGNAL ef_sync            : std_logic := '0';
    SIGNAL pef_sync            : std_logic := '0';
    SIGNAL pff_sync            : std_logic := '0';
    SIGNAL ff_sync            : std_logic := '0';
    SIGNAL fifo_full            : std_logic := '0';
    SIGNAL fifo_empty           : std_logic := '1';
    SIGNAL fifo_pe              : std_logic := '1';
    SIGNAL fifo_pf              : std_logic := '0';
    SIGNAL memchg               : std_logic := '0';
    SIGNAL fifo_reset               : std_logic := '0';
    SIGNAL rd_reset_int               : std_logic := '0';
    SIGNAL int_reset               : std_logic := '0';
    SIGNAL int_reset1               : std_logic := '0';
    SIGNAL asyncmode_reg        : String(ASYNCMODE'length downto 1);
    SIGNAL inhibitmode_reg      : String(INHIBITMODE'length downto 1);
    SIGNAL ffmode_reg           : String(FFMODE'length downto 1);
  BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(d8_ipd, d8, tipd_d8);
   VitalWireDelay(d7_ipd, d7, tipd_d7);
   VitalWireDelay(d6_ipd, d6, tipd_d6);
   VitalWireDelay(d5_ipd, d5, tipd_d5);
   VitalWireDelay(d4_ipd, d4, tipd_d4);
   VitalWireDelay(d3_ipd, d3, tipd_d3);
   VitalWireDelay(d2_ipd, d2, tipd_d2);
   VitalWireDelay(d1_ipd, d1, tipd_d1);
   VitalWireDelay(d0_ipd, d0, tipd_d0);
   VitalWireDelay(ckw_ipd, ckw, tipd_ckw);
   VitalWireDelay(ckr_ipd, ckr, tipd_ckr);
   VitalWireDelay(wre_ipd, wre, tipd_wre);
   VitalWireDelay(rde_ipd, rde, tipd_rde);
   VitalWireDelay(rstn_ipd, rstn, tipd_rstn);
   VitalWireDelay(pf9_ipd, pf9, tipd_pf9);
   VitalWireDelay(pf8_ipd, pf8, tipd_pf8);
   VitalWireDelay(pf7_ipd, pf7, tipd_pf7);
   VitalWireDelay(pf6_ipd, pf6, tipd_pf6);
   VitalWireDelay(pf5_ipd, pf5, tipd_pf5);
   VitalWireDelay(pf4_ipd, pf4, tipd_pf4);
   VitalWireDelay(pf3_ipd, pf3, tipd_pf3);
   VitalWireDelay(pf2_ipd, pf2, tipd_pf2);
   VitalWireDelay(pf1_ipd, pf1, tipd_pf1);
   VitalWireDelay(pf0_ipd, pf0, tipd_pf0);
   VitalWireDelay(pe9_ipd, pe9, tipd_pe9);
   VitalWireDelay(pe8_ipd, pe8, tipd_pe8);
   VitalWireDelay(pe7_ipd, pe7, tipd_pe7);
   VitalWireDelay(pe6_ipd, pe6, tipd_pe6);
   VitalWireDelay(pe5_ipd, pe5, tipd_pe5);
   VitalWireDelay(pe4_ipd, pe4, tipd_pe4);
   VitalWireDelay(pe3_ipd, pe3, tipd_pe3);
   VitalWireDelay(pe2_ipd, pe2, tipd_pe2);
   VitalWireDelay(pe1_ipd, pe1, tipd_pe1);
   VitalWireDelay(pe0_ipd, pe0, tipd_pe0);
   END BLOCK;

   ffmode_reg <= FFMODE;
   asyncmode_reg <= ASYNCMODE;
   inhibitmode_reg <= INHIBITMODE;

   pe_ptr <= conv_integer(pe9_ipd & pe8_ipd & pe7_ipd & pe6_ipd & pe5_ipd & pe4_ipd & pe3_ipd & pe2_ipd & pe1_ipd & pe0_ipd);
   pf_ptr <= conv_integer(pf9_ipd & pf8_ipd & pf7_ipd & pf6_ipd & pf5_ipd & pf4_ipd & pf3_ipd & pf2_ipd & pf1_ipd & pf0_ipd);
   data <= (d8_ipd & d7_ipd & d6_ipd & d5_ipd & d4_ipd & d3_ipd & d2_ipd & d1_ipd & d0_ipd);


   fifo_reset <= not rstn_ipd;
   rd_reset_int <= (fifo_reset or rd_reset);

   P2 : PROCESS (ef_reset_rd, ef_reset)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_reset <= ef_reset_rd;
      ELSE
         int_reset <= ef_reset;
      END IF;
   END PROCESS;

   int_reset1 <= (not (int_reset and rd_reset));

-- generate sync versions of the number of words used in read and write ck domains
   fifo_words_used_syncr <= ((int_write_address_sync(10) xor int_read_address(10)) & int_write_address_sync(9 downto 0) - ('0' & int_read_address(9 downto 0)));

   fifo_words_used_syncw <= ((int_read_address_sync(10) xor int_write_address(10)) & int_write_address(9 downto 0) - ('0' & int_read_address_sync(9 downto 0)));

   int_write_address_sync <= int_write_address_syncb when asyncmode_reg = "TRUE" else int_write_address;

   int_read_address_sync <= int_read_address_syncb when asyncmode_reg = "TRUE" else int_read_address;

   ef_int <= '1' when ((fifo_words_used_syncr(10 downto 1) = "0000000000") and (int_reset1 = '1')) else '0';

   pef_int <= '1' when (fifo_words_used_syncr(9 downto 0) < pe_ptr) else '0';

   fifo_empty <= ef_sync when (ffmode_reg = "OUTREG") else ef_int;
   fifo_pe <= pef_sync when (ffmode_reg = "OUTREG") else pef_int;

   ff_int <= '1' when (fifo_words_used_syncw = fifo_words) else '0';
   pff_int <= '1' when (fifo_words_used_syncw(9 downto 0) >= pf_ptr) else '0';

   fifo_full <= ff_sync when (ffmode_reg = "OUTREG") else ff_int;
   fifo_pf <= pff_sync when (ffmode_reg = "OUTREG") else pff_int;

   ef <= fifo_empty;
   ff <= fifo_full;
   pef <= fifo_pe;
   pff <= fifo_pf;

   P3 : PROCESS (wre_ipd, ff_int, fifo_pf)
   BEGIN
      IF (inhibitmode_reg = "TRUE") THEN
         fifo_wre <= wre_ipd and (not (ff_int and fifo_pf));
      ELSE
         fifo_wre <= wre_ipd;
      END IF;
   END PROCESS;

   P4 : PROCESS (rde_ipd, fifo_empty, fifo_pe)
   BEGIN
      IF (inhibitmode_reg = "TRUE") THEN
         fifo_rde <= rde_ipd and (not (fifo_empty and fifo_pe));
      ELSE
         fifo_rde <= rde_ipd;
      END IF;
   END PROCESS;

   P5 : PROCESS (ckw_ipd, fifo_reset)
   BEGIN
      IF (fifo_reset = '1') THEN
         ef_reset <= '0';
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            ef_reset <= '1';
         END IF;
      END IF;
   END PROCESS;

   P6 : PROCESS (ckr_ipd)
   BEGIN
      IF (ckr_ipd'event and ckr_ipd = '1') THEN
         ef_reset_rd <= ef_reset;
      END IF;
   END PROCESS;

   P7 : PROCESS (ckr_ipd, fifo_reset)
   BEGIN
      IF (fifo_reset = '1') THEN
         rd_reset <= '1';
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF ((fifo_rde = '1') and (((ef_reset_rd = '1') and (asyncmode_reg = "TRUE")) or ((ef_reset = '1') and not(asyncmode_reg = "TRUE")))) THEN
            rd_reset <= '0';
         END IF;
      END IF;
   END PROCESS;

   P8 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         ef_sync <= '1';
         pef_sync <= '1';
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         ef_sync <= ef_int;
         pef_sync <= pef_int;
      END IF;
   END PROCESS;

   P9 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         ff_sync <= '0';
         pff_sync <= '0';
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         ff_sync <= ff_int;
         pff_sync <= pff_int;
      END IF;
   END PROCESS;

--------------------------------------------------------
-- Generate FIFO write address and read address
--------------------------------------------------------
   int_write_address_plus1 <= int_write_address + 1;
   int_read_address_plus1 <= int_read_address + 1;

   P10 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            int_write_address <= int_write_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P11 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address_synca <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            int_write_address_synca <= int_write_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P12 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_write_address_syncb <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         int_write_address_syncb <= int_write_address_synca;
      END IF;
   END PROCESS;

   P13 : PROCESS (ckr_ipd, rd_reset_int)
   BEGIN
      IF (rd_reset_int = '1') THEN
         int_read_address <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            int_read_address <= int_read_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P14 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_read_address_synca <= "00000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            int_read_address_synca <= int_read_address_plus1;
         END IF;
      END IF;
   END PROCESS;

   P15 : PROCESS (ckw_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         int_read_address_syncb <= "00000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         int_read_address_syncb <= int_read_address_synca;
      END IF;
   END PROCESS;

   read_address <= int_read_address(9 downto 0);
   write_address <= int_write_address(9 downto 0);

   P16 : PROCESS (int_write_address_syncb, int_write_address)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_write_address_sync <= int_write_address_syncb;
      ELSE
         int_write_address_sync <= int_write_address;
      END IF;
   END PROCESS;

   P17 : PROCESS (int_read_address_syncb, int_read_address)
   BEGIN
      IF (asyncmode_reg = "TRUE") THEN
         int_read_address_sync <= int_read_address_syncb;
      ELSE
         int_read_address_sync <= int_read_address;
      END IF;
   END PROCESS;

   P18 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         RADDR <= "0000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         IF (fifo_rde = '1') THEN
            RADDR <= read_address;
         END IF;
      END IF;
   END PROCESS;

   P19 : PROCESS (read_address, memchg)
   BEGIN
      q0b <= mem(conv_integer(read_address));
   END PROCESS;

   P20 : PROCESS (ckw_ipd, rstn_ipd)
   VARIABLE WADDR : std_logic_vector(9 downto 0) := "0000000000";
   BEGIN
      IF (rstn_ipd = '0') THEN
         WADDR := "0000000000";
      ELSIF (ckw_ipd'event and ckw_ipd = '1') THEN
         IF (fifo_wre = '1') THEN
            WADDR := write_address;
            mem(conv_integer(WADDR)) <= data;
            memchg <= not memchg;
         END IF;
      END IF;
   END PROCESS;

   P21 : PROCESS (ckr_ipd, rstn_ipd)
   BEGIN
      IF (rstn_ipd = '0') THEN
         q2b <= "000000000";
      ELSIF (ckr_ipd'event and ckr_ipd = '1') THEN
         q2b <= q0b;
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q2b, q0b)
     VARIABLE q_zd   : std_logic_vector(8 downto 0);

     -- timing check results
        VARIABLE tviol_d8     : x01 := '0';
        VARIABLE tviol_d7     : x01 := '0';
        VARIABLE tviol_d6     : x01 := '0';
        VARIABLE tviol_d5     : x01 := '0';
        VARIABLE tviol_d4     : x01 := '0';
        VARIABLE tviol_d3     : x01 := '0';
        VARIABLE tviol_d2     : x01 := '0';
        VARIABLE tviol_d1     : x01 := '0';
        VARIABLE tviol_d0     : x01 := '0';
        VARIABLE tviol_wre    : x01 := '0';
        VARIABLE tviol_rde    : x01 := '0';

        VARIABLE d8_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d7_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d6_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d5_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d4_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d3_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d2_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d1_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE d0_ckw_TimingDatash  : VitalTimingDataType;
        VARIABLE wre_ckw_TimingDatash : VitalTimingDataType;
        VARIABLE rde_ckr_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE q8_GlitchData   :   VitalGlitchDataType;
        VARIABLE q7_GlitchData   :   VitalGlitchDataType;
        VARIABLE q6_GlitchData   :   VitalGlitchDataType;
        VARIABLE q5_GlitchData   :   VitalGlitchDataType;
        VARIABLE q4_GlitchData   :   VitalGlitchDataType;
        VARIABLE q3_GlitchData   :   VitalGlitchDataType;
        VARIABLE q2_GlitchData   :   VitalGlitchDataType;
        VARIABLE q1_GlitchData   :   VitalGlitchDataType;
        VARIABLE q0_GlitchData   :   VitalGlitchDataType;

    BEGIN

   ------------------------
   -- functionality section
   ------------------------
      IF (ffmode_reg = "OUTREG") THEN
         q_zd := q2b;
      ELSE
         q_zd := q0b;
      END IF;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q8, OutSignalName => "q8", OutTemp => q_zd(8),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q8,
                             PathCondition => TRUE)),
        GlitchData => q8_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q7, OutSignalName => "q7", OutTemp => q_zd(7),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q7,
                             PathCondition => TRUE)),
        GlitchData => q7_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q6, OutSignalName => "q6", OutTemp => q_zd(6),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q6,
                             PathCondition => TRUE)),
        GlitchData => q6_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q5, OutSignalName => "q5", OutTemp => q_zd(5),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q5,
                             PathCondition => TRUE)),
        GlitchData => q5_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q4, OutSignalName => "q4", OutTemp => q_zd(4),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q4,
                             PathCondition => TRUE)),
        GlitchData => q4_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q3, OutSignalName => "q3", OutTemp => q_zd(3),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q3,
                             PathCondition => TRUE)),
        GlitchData => q3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q2, OutSignalName => "q2", OutTemp => q_zd(2),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q2,
                             PathCondition => TRUE)),
        GlitchData => q2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q1, OutSignalName => "q1", OutTemp => q_zd(1),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q1,
                             PathCondition => TRUE)),
        GlitchData => q1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q0, OutSignalName => "q0", OutTemp => q_zd(0),
        Paths      => (0 => (InputChangeTime => ckr_ipd'last_event,
                             PathDelay => tpd_ckr_q0,
                             PathCondition => TRUE)),
        GlitchData => q0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
   END PROCESS VITAL_OUTPUT;


END V;


--
-----cell ff2x512x9----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;

-- entity declaration --
ENTITY ff2x512x9 IS
   GENERIC (
      FFMODE0                    : String  := "NOREG";
      FFMODE1                    : String  := "NOREG";
      INHIBITMODE0               : String  := "TRUE";
      INHIBITMODE1               : String  := "TRUE";
      ASYNCMODE0                 : String  := "FALSE";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "ff2x512x9";

        -- input SIGNAL delays
        tipd_d08   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d07   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d06   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d05   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d04   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d03   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d02   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d01   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d00   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rstn0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf08  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf07  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf06  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf05  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf04  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf03  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf02  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf01  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf00  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe08  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe07  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe06  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe05  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe04  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe03  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe02  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe01  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe00  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d18   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d17   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d16   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d15   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d14   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d13   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d12   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d11   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d10   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rstn1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf18  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pf10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe18  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_pe10  : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_ckr0_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_ef0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_ff0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_pef0      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_pff0      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_ef0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_ff0       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_pef0      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_pff0      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_ef1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_ff1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_pef1      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_pff1      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_ef1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_ff1       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_pef1      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_pff1      : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_d08_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d08_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d07_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d06_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d05_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d04_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d03_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d02_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d01_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d00_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_wre0_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre0_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde0_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde0_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_d18_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d18_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d17_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d16_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d15_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d14_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d13_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d12_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d11_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d10_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_wre1_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre1_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde1_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde1_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw0            : VitalDelayType := 0.01 ns;
        tpw_ckw0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr0            : VitalDelayType := 0.01 ns;
        tpw_ckr0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckw1            : VitalDelayType := 0.01 ns;
        tpw_ckw1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw1_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr1            : VitalDelayType := 0.01 ns;
        tpw_ckr1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr1_negedge        : VitalDelayType := 0.01 ns);

   PORT(
      d08, d07, d06, d05, d04, d03, d02, d01, d00                  : in std_logic ;
      ckw0, ckr0, wre0, rde0, rstn0                                : in std_logic ;
      pf08, pf07, pf06, pf05, pf04, pf03, pf02, pf01, pf00         : in std_logic ;
      pe08, pe07, pe06, pe05, pe04, pe03, pe02, pe01, pe00         : in std_logic ;
      d18, d17, d16, d15, d14, d13, d12, d11, d10                  : in std_logic ;
      ckw1, ckr1, wre1, rde1, rstn1                                : in std_logic ;
      pf18, pf17, pf16, pf15, pf14, pf13, pf12, pf11, pf10         : in std_logic ;
      pe18, pe17, pe16, pe15, pe14, pe13, pe12, pe11, pe10         : in std_logic ;

      q08, q07, q06, q05, q04, q03, q02, q01, q00                  : out std_logic ;
      ef0, ff0, pef0, pff0                                         : out std_logic ;
      q18, q17, q16, q15, q14, q13, q12, q11, q10                  : out std_logic ;
      ef1, ff1, pef1, pff1                                         : out std_logic );

    ATTRIBUTE Vital_Level0 OF ff2x512x9 : ENTITY IS TRUE;

END ff2x512x9 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF ff2x512x9 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL d08_ipd      : std_logic := 'X';
    SIGNAL d07_ipd      : std_logic := 'X';
    SIGNAL d06_ipd      : std_logic := 'X';
    SIGNAL d05_ipd      : std_logic := 'X';
    SIGNAL d04_ipd      : std_logic := 'X';
    SIGNAL d03_ipd      : std_logic := 'X';
    SIGNAL d02_ipd      : std_logic := 'X';
    SIGNAL d01_ipd      : std_logic := 'X';
    SIGNAL d00_ipd      : std_logic := 'X';
    SIGNAL ckw0_ipd     : std_logic := 'X';
    SIGNAL ckr0_ipd     : std_logic := 'X';
    SIGNAL wre0_ipd     : std_logic := 'X';
    SIGNAL rde0_ipd     : std_logic := 'X';
    SIGNAL rstn0_ipd    : std_logic := 'X';
    SIGNAL pf08_ipd     : std_logic := 'X';
    SIGNAL pf07_ipd     : std_logic := 'X';
    SIGNAL pf06_ipd     : std_logic := 'X';
    SIGNAL pf05_ipd     : std_logic := 'X';
    SIGNAL pf04_ipd     : std_logic := 'X';
    SIGNAL pf03_ipd     : std_logic := 'X';
    SIGNAL pf02_ipd     : std_logic := 'X';
    SIGNAL pf01_ipd     : std_logic := 'X';
    SIGNAL pf00_ipd     : std_logic := 'X';
    SIGNAL pe08_ipd     : std_logic := 'X';
    SIGNAL pe07_ipd     : std_logic := 'X';
    SIGNAL pe06_ipd     : std_logic := 'X';
    SIGNAL pe05_ipd     : std_logic := 'X';
    SIGNAL pe04_ipd     : std_logic := 'X';
    SIGNAL pe03_ipd     : std_logic := 'X';
    SIGNAL pe02_ipd     : std_logic := 'X';
    SIGNAL pe01_ipd     : std_logic := 'X';
    SIGNAL pe00_ipd     : std_logic := 'X';
    SIGNAL d18_ipd      : std_logic := 'X';
    SIGNAL d17_ipd      : std_logic := 'X';
    SIGNAL d16_ipd      : std_logic := 'X';
    SIGNAL d15_ipd      : std_logic := 'X';
    SIGNAL d14_ipd      : std_logic := 'X';
    SIGNAL d13_ipd      : std_logic := 'X';
    SIGNAL d12_ipd      : std_logic := 'X';
    SIGNAL d11_ipd      : std_logic := 'X';
    SIGNAL d10_ipd      : std_logic := 'X';
    SIGNAL ckw1_ipd     : std_logic := 'X';
    SIGNAL ckr1_ipd     : std_logic := 'X';
    SIGNAL wre1_ipd     : std_logic := 'X';
    SIGNAL rde1_ipd     : std_logic := 'X';
    SIGNAL rstn1_ipd    : std_logic := 'X';
    SIGNAL pf18_ipd     : std_logic := 'X';
    SIGNAL pf17_ipd     : std_logic := 'X';
    SIGNAL pf16_ipd     : std_logic := 'X';
    SIGNAL pf15_ipd     : std_logic := 'X';
    SIGNAL pf14_ipd     : std_logic := 'X';
    SIGNAL pf13_ipd     : std_logic := 'X';
    SIGNAL pf12_ipd     : std_logic := 'X';
    SIGNAL pf11_ipd     : std_logic := 'X';
    SIGNAL pf10_ipd     : std_logic := 'X';
    SIGNAL pe18_ipd     : std_logic := 'X';
    SIGNAL pe17_ipd     : std_logic := 'X';
    SIGNAL pe16_ipd     : std_logic := 'X';
    SIGNAL pe15_ipd     : std_logic := 'X';
    SIGNAL pe14_ipd     : std_logic := 'X';
    SIGNAL pe13_ipd     : std_logic := 'X';
    SIGNAL pe12_ipd     : std_logic := 'X';
    SIGNAL pe11_ipd     : std_logic := 'X';
    SIGNAL pe10_ipd     : std_logic := 'X';

    TYPE mem_type IS array (Integer range <>) OF std_logic_vector(8 downto 0);
    SIGNAL mem_A          : mem_type(0 to 511);
    SIGNAL mem_B          : mem_type(0 to 511);
    SIGNAL q0b_A          : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL q2b_A          : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL data_A         : std_logic_vector(8 downto 0);
    SIGNAL q0b_B          : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL q2b_B          : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL data_B         : std_logic_vector(8 downto 0);
    SIGNAL pe_ptr_A        : integer;
    SIGNAL pf_ptr_A        : integer;
    SIGNAL RADDR_A                : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL write_address_A        : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL read_address_A         : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL fifo_words_used_syncr_A         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_used_syncw_A         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_A                    : std_logic_vector(9 downto 0) := "1000000000";
    SIGNAL int_write_address_A         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_plus1_A         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_syncb_A         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_synca_A         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_A         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_plus1_A         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_syncb_A         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_synca_A         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_sync_A         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_sync_A         : std_logic_vector(10 downto 0);
    SIGNAL ef_reset_A            : std_logic := '0';
    SIGNAL rd_reset_A            : std_logic := '0';
    SIGNAL ef_reset_rd_A            : std_logic := '0';
    SIGNAL fifo_wre_A            : std_logic := '0';
    SIGNAL fifo_rde_A            : std_logic := '0';
    SIGNAL ef_int_A            : std_logic := '0';
    SIGNAL pef_int_A            : std_logic := '0';
    SIGNAL pff_int_A            : std_logic := '0';
    SIGNAL ff_int_A            : std_logic := '0';
    SIGNAL ef_sync_A            : std_logic := '0';
    SIGNAL pef_sync_A            : std_logic := '0';
    SIGNAL pff_sync_A            : std_logic := '0';
    SIGNAL ff_sync_A            : std_logic := '0';
    SIGNAL fifo_full_A            : std_logic := '0';
    SIGNAL fifo_empty_A           : std_logic := '1';
    SIGNAL fifo_pe_A              : std_logic := '1';
    SIGNAL fifo_pf_A              : std_logic := '0';
    SIGNAL fifo_reset_A               : std_logic := '0';
    SIGNAL rd_reset_int_A               : std_logic := '0';
    SIGNAL int_reset_A               : std_logic := '0';
    SIGNAL int_reset1_A               : std_logic := '0';
    SIGNAL memchg_A               : std_logic := '0';
    SIGNAL memchg_B               : std_logic := '0';
    SIGNAL ffmode_A_reg           : String(FFMODE0'length downto 1);
    SIGNAL ffmode_B_reg           : String(FFMODE1'length downto 1);
    SIGNAL asyncmode_A_reg        : String(ASYNCMODE0'length downto 1);
    SIGNAL asyncmode_B_reg        : String(5 downto 1):= "FALSE";
    SIGNAL inhibitmode_A_reg      : String(INHIBITMODE0'length downto 1);
    SIGNAL inhibitmode_B_reg      : String(INHIBITMODE1'length downto 1);

    SIGNAL pe_ptr_B        : integer;
    SIGNAL pf_ptr_B        : integer;
    SIGNAL RADDR_B                : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL write_address_B        : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL read_address_B         : std_logic_vector(8 downto 0) := "000000000";
    SIGNAL fifo_words_used_syncr_B         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_used_syncw_B         : std_logic_vector(10 downto 0);
    SIGNAL fifo_words_B                    : std_logic_vector(9 downto 0) := "1000000000";
    SIGNAL int_write_address_B         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_plus1_B         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_syncb_B         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_synca_B         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_B         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_plus1_B         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_syncb_B         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_synca_B         : std_logic_vector(10 downto 0);
    SIGNAL int_write_address_sync_B         : std_logic_vector(10 downto 0);
    SIGNAL int_read_address_sync_B         : std_logic_vector(10 downto 0);
    SIGNAL ef_reset_B            : std_logic := '0';
    SIGNAL rd_reset_B            : std_logic := '0';
    SIGNAL ef_reset_rd_B            : std_logic := '0';
    SIGNAL fifo_wre_B            : std_logic := '0';
    SIGNAL fifo_rde_B            : std_logic := '0';
    SIGNAL ef_int_B            : std_logic := '0';
    SIGNAL pef_int_B            : std_logic := '0';
    SIGNAL pff_int_B            : std_logic := '0';
    SIGNAL ff_int_B            : std_logic := '0';
    SIGNAL ef_sync_B            : std_logic := '0';
    SIGNAL pef_sync_B            : std_logic := '0';
    SIGNAL pff_sync_B            : std_logic := '0';
    SIGNAL ff_sync_B            : std_logic := '0';
    SIGNAL fifo_full_B            : std_logic := '0';
    SIGNAL fifo_empty_B           : std_logic := '1';
    SIGNAL fifo_pe_B              : std_logic := '1';
    SIGNAL fifo_pf_B              : std_logic := '0';
    SIGNAL fifo_reset_B               : std_logic := '0';
    SIGNAL rd_reset_int_B               : std_logic := '0';
    SIGNAL int_reset_B               : std_logic := '0';
    SIGNAL int_reset1_B               : std_logic := '0';
    SIGNAL port0_valid   : std_logic := '0';
  BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(d08_ipd, d08, tipd_d08);
   VitalWireDelay(d07_ipd, d07, tipd_d07);
   VitalWireDelay(d06_ipd, d06, tipd_d06);
   VitalWireDelay(d05_ipd, d05, tipd_d05);
   VitalWireDelay(d04_ipd, d04, tipd_d04);
   VitalWireDelay(d03_ipd, d03, tipd_d03);
   VitalWireDelay(d02_ipd, d02, tipd_d02);
   VitalWireDelay(d01_ipd, d01, tipd_d01);
   VitalWireDelay(d00_ipd, d00, tipd_d00);
   VitalWireDelay(ckw0_ipd, ckw0, tipd_ckw0);
   VitalWireDelay(ckr0_ipd, ckr0, tipd_ckr0);
   VitalWireDelay(wre0_ipd, wre0, tipd_wre0);
   VitalWireDelay(rde0_ipd, rde0, tipd_rde0);
   VitalWireDelay(rstn0_ipd, rstn0, tipd_rstn0);
   VitalWireDelay(pf08_ipd, pf08, tipd_pf08);
   VitalWireDelay(pf07_ipd, pf07, tipd_pf07);
   VitalWireDelay(pf06_ipd, pf06, tipd_pf06);
   VitalWireDelay(pf05_ipd, pf05, tipd_pf05);
   VitalWireDelay(pf04_ipd, pf04, tipd_pf04);
   VitalWireDelay(pf03_ipd, pf03, tipd_pf03);
   VitalWireDelay(pf02_ipd, pf02, tipd_pf02);
   VitalWireDelay(pf01_ipd, pf01, tipd_pf01);
   VitalWireDelay(pf00_ipd, pf00, tipd_pf00);
   VitalWireDelay(pe08_ipd, pe08, tipd_pe08);
   VitalWireDelay(pe07_ipd, pe07, tipd_pe07);
   VitalWireDelay(pe06_ipd, pe06, tipd_pe06);
   VitalWireDelay(pe05_ipd, pe05, tipd_pe05);
   VitalWireDelay(pe04_ipd, pe04, tipd_pe04);
   VitalWireDelay(pe03_ipd, pe03, tipd_pe03);
   VitalWireDelay(pe02_ipd, pe02, tipd_pe02);
   VitalWireDelay(pe01_ipd, pe01, tipd_pe01);
   VitalWireDelay(pe00_ipd, pe00, tipd_pe00);
   VitalWireDelay(d18_ipd, d18, tipd_d18);
   VitalWireDelay(d17_ipd, d17, tipd_d17);
   VitalWireDelay(d16_ipd, d16, tipd_d16);
   VitalWireDelay(d15_ipd, d15, tipd_d15);
   VitalWireDelay(d14_ipd, d14, tipd_d14);
   VitalWireDelay(d13_ipd, d13, tipd_d13);
   VitalWireDelay(d12_ipd, d12, tipd_d12);
   VitalWireDelay(d11_ipd, d11, tipd_d11);
   VitalWireDelay(d10_ipd, d10, tipd_d10);
   VitalWireDelay(ckw1_ipd, ckw1, tipd_ckw1);
   VitalWireDelay(ckr1_ipd, ckr1, tipd_ckr1);
   VitalWireDelay(wre1_ipd, wre1, tipd_wre1);
   VitalWireDelay(rde1_ipd, rde1, tipd_rde1);
   VitalWireDelay(rstn1_ipd, rstn1, tipd_rstn1);
   VitalWireDelay(pf18_ipd, pf18, tipd_pf18);
   VitalWireDelay(pf17_ipd, pf17, tipd_pf17);
   VitalWireDelay(pf16_ipd, pf16, tipd_pf16);
   VitalWireDelay(pf15_ipd, pf15, tipd_pf15);
   VitalWireDelay(pf14_ipd, pf14, tipd_pf14);
   VitalWireDelay(pf13_ipd, pf13, tipd_pf13);
   VitalWireDelay(pf12_ipd, pf12, tipd_pf12);
   VitalWireDelay(pf11_ipd, pf11, tipd_pf11);
   VitalWireDelay(pf10_ipd, pf10, tipd_pf10);
   VitalWireDelay(pe18_ipd, pe18, tipd_pe18);
   VitalWireDelay(pe17_ipd, pe17, tipd_pe17);
   VitalWireDelay(pe16_ipd, pe16, tipd_pe16);
   VitalWireDelay(pe15_ipd, pe15, tipd_pe15);
   VitalWireDelay(pe14_ipd, pe14, tipd_pe14);
   VitalWireDelay(pe13_ipd, pe13, tipd_pe13);
   VitalWireDelay(pe12_ipd, pe12, tipd_pe12);
   VitalWireDelay(pe11_ipd, pe11, tipd_pe11);
   VitalWireDelay(pe10_ipd, pe10, tipd_pe10);
   END BLOCK;

   ffmode_A_reg <= FFMODE0;
   ffmode_B_reg <= FFMODE1;
   asyncmode_A_reg <= ASYNCMODE0;
   inhibitmode_A_reg <= INHIBITMODE0;
   inhibitmode_B_reg <= INHIBITMODE1;

   pe_ptr_A <= conv_integer('0' & pe08_ipd & pe07_ipd & pe06_ipd & pe05_ipd & pe04_ipd & pe03_ipd & pe02_ipd & pe01_ipd & pe00_ipd);
   pf_ptr_A <= conv_integer('0' & pf08_ipd & pf07_ipd & pf06_ipd & pf05_ipd & pf04_ipd & pf03_ipd & pf02_ipd & pf01_ipd & pf00_ipd);
   data_A <= (d08_ipd & d07_ipd & d06_ipd & d05_ipd & d04_ipd & d03_ipd & d02_ipd & d01_ipd & d00_ipd);
   pe_ptr_B <= conv_integer('0' & pe18_ipd & pe17_ipd & pe16_ipd & pe15_ipd & pe14_ipd & pe13_ipd & pe12_ipd & pe11_ipd & pe10_ipd);
   pf_ptr_B <= conv_integer('0' & pf18_ipd & pf17_ipd & pf16_ipd & pf15_ipd & pf14_ipd & pf13_ipd & pf12_ipd & pf11_ipd & pf10_ipd);
   data_B <= (d18_ipd & d17_ipd & d16_ipd & d15_ipd & d14_ipd & d13_ipd & d12_ipd & d11_ipd & d10_ipd);

   fifo_reset_A <= not rstn0_ipd;
   rd_reset_int_A <= (fifo_reset_A or rd_reset_A);

   P101 : PROCESS (ckr1_ipd)
   VARIABLE first_time : boolean := true;
   BEGIN
      IF (ckr1_ipd'event AND ckr1_ipd = '1') THEN
         IF (first_time) THEN
            port0_valid <= '1';
            first_time := false;
         END IF;
      END IF;
   END PROCESS;

   P2 : PROCESS (ef_reset_rd_A, ef_reset_A)
   BEGIN
      IF (asyncmode_A_reg = "TRUE") THEN
         int_reset_A <= ef_reset_rd_A;
      ELSE
         int_reset_A <= ef_reset_A;
      END IF;
   END PROCESS;

   int_reset1_A <= (not (int_reset_A and rd_reset_A));

-- generate sync versions of the number of words used in read and write ck domains
   fifo_words_used_syncr_A <= ((int_write_address_sync_A(10) xor int_read_address_A(10)) & int_write_address_sync_A(9 downto 0) - ('0' & int_read_address_A(9 downto 0)));

   fifo_words_used_syncw_A <= ((int_read_address_sync_A(10) xor int_write_address_A(10)) & int_write_address_A(9 downto 0) - ('0' & int_read_address_sync_A(9 downto 0)));

   int_write_address_sync_A <= int_write_address_syncb_A when asyncmode_A_reg = "TRUE" else int_write_address_A;

   int_read_address_sync_A <= int_read_address_syncb_A when asyncmode_A_reg = "TRUE" else int_read_address_A;

   ef_int_A <= '1' when ((fifo_words_used_syncr_A(10 downto 1) = "0000000000") and (int_reset1_A = '1')) else '0';

   pef_int_A <= '1' when (fifo_words_used_syncr_A(9 downto 0) < pe_ptr_A) else '0';

   fifo_empty_A <= ef_sync_A when (ffmode_A_reg = "OUTREG") else ef_int_A;
   fifo_pe_A <= pef_sync_A when (ffmode_A_reg = "OUTREG") else pef_int_A;

   ff_int_A <= '1' when (fifo_words_used_syncw_A = fifo_words_A) else '0';
   pff_int_A <= '1' when (fifo_words_used_syncw_A(9 downto 0) >= pf_ptr_A) else '0';

   fifo_full_A <= ff_sync_A when (ffmode_A_reg = "OUTREG") else ff_int_A;
   fifo_pf_A <= pff_sync_A when (ffmode_A_reg = "OUTREG") else pff_int_A;

   ef0 <= fifo_empty_A;
   ff0 <= fifo_full_A;
   pef0 <= fifo_pe_A;
   pff0 <= fifo_pf_A;

   P3 : PROCESS (wre0_ipd, ff_int_A, fifo_pf_A)
   BEGIN
      IF (inhibitmode_A_reg = "TRUE") THEN
         fifo_wre_A <= wre0_ipd and (not (ff_int_A and fifo_pf_A));
      ELSE
         fifo_wre_A <= wre0_ipd;
      END IF;
   END PROCESS;

   P4 : PROCESS (rde0_ipd, fifo_empty_A, fifo_pe_A)
   BEGIN
      IF (inhibitmode_A_reg = "TRUE") THEN
         fifo_rde_A <= rde0_ipd and (not (fifo_empty_A and fifo_pe_A));
      ELSE
         fifo_rde_A <= rde0_ipd;
      END IF;
   END PROCESS;

   P5 : PROCESS (ckw0_ipd, fifo_reset_A)
   BEGIN
      IF (fifo_reset_A = '1') THEN
         ef_reset_A <= '0';
      ELSIF (ckw0_ipd'event and ckw0_ipd = '1') THEN
         IF (fifo_wre_A = '1') THEN
            ef_reset_A <= '1';
         END IF;
      END IF;
   END PROCESS;

   P6 : PROCESS (ckr0_ipd)
   BEGIN
      IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         ef_reset_rd_A <= ef_reset_A;
      END IF;
   END PROCESS;

   P7 : PROCESS (ckr0_ipd, fifo_reset_A)
   BEGIN
      IF (fifo_reset_A = '1') THEN
         rd_reset_A <= '1';
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         IF ((fifo_rde_A = '1') and (((ef_reset_rd_A = '1') and (asyncmode_A_reg = "TRUE")) or ((ef_reset_A = '1') and not(asyncmode_A_reg = "TRUE")))) THEN
            rd_reset_A <= '0';
         END IF;
      END IF;
   END PROCESS;

   P8 : PROCESS (ckr0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         ef_sync_A <= '1';
         pef_sync_A <= '1';
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         ef_sync_A <= ef_int_A;
         pef_sync_A <= pef_int_A;
      END IF;
   END PROCESS;

   P9 : PROCESS (ckw0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         ff_sync_A <= '0';
         pff_sync_A <= '0';
      ELSIF (ckw0_ipd'event and ckw0_ipd = '1') THEN
         ff_sync_A <= ff_int_A;
         pff_sync_A <= pff_int_A;
      END IF;
   END PROCESS;

--------------------------------------------------------
-- Generate FIFO write address and read address
--------------------------------------------------------
   int_write_address_plus1_A <= int_write_address_A + 1;
   int_read_address_plus1_A <= int_read_address_A + 1;

   P10 : PROCESS (ckw0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         int_write_address_A <= "00000000000";
      ELSIF (ckw0_ipd'event and ckw0_ipd = '1') THEN
         IF (fifo_wre_A = '1') THEN
            int_write_address_A <= int_write_address_plus1_A;
         END IF;
      END IF;
   END PROCESS;

   P11 : PROCESS (ckw0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         int_write_address_synca_A <= "00000000000";
      ELSIF (ckw0_ipd'event and ckw0_ipd = '1') THEN
         IF (fifo_wre_A = '1') THEN
            int_write_address_synca_A <= int_write_address_plus1_A;
         END IF;
      END IF;
   END PROCESS;

   P12 : PROCESS (ckr0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         int_write_address_syncb_A <= "00000000000";
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         int_write_address_syncb_A <= int_write_address_synca_A;
      END IF;
   END PROCESS;

   P13 : PROCESS (ckr0_ipd, rd_reset_int_A)
   BEGIN
      IF (rd_reset_int_A = '1') THEN
         int_read_address_A <= "00000000000";
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         IF (fifo_rde_A = '1') THEN
            int_read_address_A <= int_read_address_plus1_A;
         END IF;
      END IF;
   END PROCESS;

   P14 : PROCESS (ckr0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         int_read_address_synca_A <= "00000000000";
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         IF (fifo_rde_A = '1') THEN
            int_read_address_synca_A <= int_read_address_plus1_A;
         END IF;
      END IF;
   END PROCESS;

   P15 : PROCESS (ckw0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         int_read_address_syncb_A <= "00000000000";
      ELSIF (ckw0_ipd'event and ckw0_ipd = '1') THEN
         int_read_address_syncb_A <= int_read_address_synca_A;
      END IF;
   END PROCESS;

   read_address_A <= int_read_address_A(8 downto 0);
   write_address_A <= int_write_address_A(8 downto 0);

   P16 : PROCESS (int_write_address_syncb_A, int_write_address_A)
   BEGIN
      IF (asyncmode_A_reg = "TRUE") THEN
         int_write_address_sync_A <= int_write_address_syncb_A;
      ELSE
         int_write_address_sync_A <= int_write_address_A;
      END IF;
   END PROCESS;

   P17 : PROCESS (int_read_address_syncb_A, int_read_address_A)
   BEGIN
      IF (asyncmode_A_reg = "TRUE") THEN
         int_read_address_sync_A <= int_read_address_syncb_A;
      ELSE
         int_read_address_sync_A <= int_read_address_A;
      END IF;
   END PROCESS;

   P18 : PROCESS (ckr0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         RADDR_A <= "000000000";
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         IF (fifo_rde_A = '1') THEN
            RADDR_A <= read_address_A;
         END IF;
      END IF;
   END PROCESS;

   P19 : PROCESS (read_address_A, memchg_A)
   BEGIN
      q0b_A <= mem_A(conv_integer(read_address_A));
   END PROCESS;

   P20 : PROCESS (ckw0_ipd, rstn0_ipd)
   VARIABLE WADDR_A : std_logic_vector(8 downto 0) := "000000000";
   BEGIN
      IF (rstn0_ipd = '0') THEN
         WADDR_A := "000000000";
      ELSIF (ckw0_ipd'event and ckw0_ipd = '1') THEN
         IF (fifo_wre_A = '1') THEN
            WADDR_A := write_address_A;
            mem_A(conv_integer(WADDR_A)) <= data_A;
            memchg_A <= not memchg_A;
         END IF;
      END IF;
   END PROCESS;

   P21 : PROCESS (ckr0_ipd, rstn0_ipd)
   BEGIN
      IF (rstn0_ipd = '0') THEN
         q2b_A <= "000000000";
      ELSIF (ckr0_ipd'event and ckr0_ipd = '1') THEN
         q2b_A <= q0b_A;
      END IF;
   END PROCESS;


   fifo_reset_B <= not rstn1_ipd;
   rd_reset_int_B <= (fifo_reset_B or rd_reset_B);

   P102 : PROCESS (ef_reset_rd_B, ef_reset_B)
   BEGIN
--      IF (asyncmode_B_reg = "TRUE") THEN
--         int_reset_B <= ef_reset_rd_B;
--      ELSE
         int_reset_B <= ef_reset_B;
--      END IF;
   END PROCESS;

   int_reset1_B <= (not (int_reset_B and rd_reset_B));

-- generate sync versions of the number of words used in read and write ck domains
   fifo_words_used_syncr_B <= ((int_write_address_sync_B(10) xor int_read_address_B(10)) & int_write_address_sync_B(9 downto 0) - ('0' & int_read_address_B(9 downto 0)));

   fifo_words_used_syncw_B <= ((int_read_address_sync_B(10) xor int_write_address_B(10)) & int_write_address_B(9 downto 0) - ('0' & int_read_address_sync_B(9 downto 0)));

--   int_write_address_sync_B <= int_write_address_syncb_B when asyncmode_B_reg = "TRUE" else int_write_address_B;
   int_write_address_sync_B <= int_write_address_B;

--   int_read_address_sync_B <= int_read_address_syncb_B when asyncmode_B_reg = "TRUE" else int_read_address_B;
   int_read_address_sync_B <= int_read_address_B;

   ef_int_B <= '1' when ((fifo_words_used_syncr_B(10 downto 1) = "0000000000") and (int_reset1_B = '1')) else '0';

   pef_int_B <= '1' when (fifo_words_used_syncr_B(9 downto 0) < pe_ptr_B) else '0';

   fifo_empty_B <= ef_sync_B when (ffmode_B_reg = "OUTREG") else ef_int_B;
   fifo_pe_B <= pef_sync_B when (ffmode_B_reg = "OUTREG") else pef_int_B;

   ff_int_B <= '1' when (fifo_words_used_syncw_B = fifo_words_B) else '0';
   pff_int_B <= '1' when (fifo_words_used_syncw_B(9 downto 0) >= pf_ptr_B) else '0';

   fifo_full_B <= ff_sync_B when (ffmode_B_reg = "OUTREG") else ff_int_B;
   fifo_pf_B <= pff_sync_B when (ffmode_B_reg = "OUTREG") else pff_int_B;

   ef0 <= fifo_empty_B;
   ff0 <= fifo_full_B;
   pef0 <= fifo_pe_B;
   pff0 <= fifo_pf_B;

   P103 : PROCESS (wre1_ipd, ff_int_B, fifo_pf_B)
   BEGIN
      IF (inhibitmode_B_reg = "TRUE") THEN
         fifo_wre_B <= wre1_ipd and (not (ff_int_B and fifo_pf_B));
      ELSE
         fifo_wre_B <= wre1_ipd;
      END IF;
   END PROCESS;

   P104 : PROCESS (rde1_ipd, fifo_empty_B, fifo_pe_B)
   BEGIN
      IF (inhibitmode_B_reg = "TRUE") THEN
         fifo_rde_B <= rde1_ipd and (not (fifo_empty_B and fifo_pe_B));
      ELSE
         fifo_rde_B <= rde1_ipd;
      END IF;
   END PROCESS;

   P105 : PROCESS (ckw1_ipd, fifo_reset_B)
   BEGIN
      IF (fifo_reset_B = '1') THEN
         ef_reset_B <= '0';
      ELSIF (ckw1_ipd'event and ckw1_ipd = '1') THEN
         IF (fifo_wre_B = '1') THEN
            ef_reset_B <= '1';
         END IF;
      END IF;
   END PROCESS;

   P106 : PROCESS (ckr1_ipd)
   BEGIN
      IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         ef_reset_rd_B <= ef_reset_B;
      END IF;
   END PROCESS;

   P107 : PROCESS (ckr1_ipd, fifo_reset_B)
   BEGIN
      IF (fifo_reset_B = '1') THEN
         rd_reset_B <= '1';
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
--         IF ((fifo_rde_B = '1') and (((ef_reset_rd_B = '1') and (asyncmode_B_reg = "TRUE")) or ((ef_reset_B = '1') and not(asyncmode_B_reg = "TRUE")))) THEN
         IF ((fifo_rde_B = '1') and (ef_reset_B = '1') and (asyncmode_B_reg = "FALSE")) THEN
            rd_reset_B <= '0';
         END IF;
      END IF;
   END PROCESS;

   P108 : PROCESS (ckr1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         ef_sync_B <= '1';
         pef_sync_B <= '1';
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         ef_sync_B <= ef_int_B;
         pef_sync_B <= pef_int_B;
      END IF;
   END PROCESS;

   P109 : PROCESS (ckw1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         ff_sync_B <= '0';
         pff_sync_B <= '0';
      ELSIF (ckw1_ipd'event and ckw1_ipd = '1') THEN
         ff_sync_B <= ff_int_B;
         pff_sync_B <= pff_int_B;
      END IF;
   END PROCESS;

--------------------------------------------------------
-- Generate FIFO write address and read address
--------------------------------------------------------
   int_write_address_plus1_B <= int_write_address_B + 1;
   int_read_address_plus1_B <= int_read_address_B + 1;

   P1010 : PROCESS (ckw1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         int_write_address_B <= "00000000000";
      ELSIF (ckw1_ipd'event and ckw1_ipd = '1') THEN
         IF (fifo_wre_B = '1') THEN
            int_write_address_B <= int_write_address_plus1_B;
         END IF;
      END IF;
   END PROCESS;

   P1011 : PROCESS (ckw1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         int_write_address_synca_B <= "00000000000";
      ELSIF (ckw1_ipd'event and ckw1_ipd = '1') THEN
         IF (fifo_wre_B = '1') THEN
            int_write_address_synca_B <= int_write_address_plus1_B;
         END IF;
      END IF;
   END PROCESS;

   P1012 : PROCESS (ckr1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         int_write_address_syncb_B <= "00000000000";
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         int_write_address_syncb_B <= int_write_address_synca_B;
      END IF;
   END PROCESS;

   P1013 : PROCESS (ckr1_ipd, rd_reset_int_B)
   BEGIN
      IF (rd_reset_int_B = '1') THEN
         int_read_address_B <= "00000000000";
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         IF (fifo_rde_B = '1') THEN
            int_read_address_B <= int_read_address_plus1_B;
         END IF;
      END IF;
   END PROCESS;

   P1014 : PROCESS (ckr1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         int_read_address_synca_B <= "00000000000";
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         IF (fifo_rde_B = '1') THEN
            int_read_address_synca_B <= int_read_address_plus1_B;
         END IF;
      END IF;
   END PROCESS;

   P1015 : PROCESS (ckw1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         int_read_address_syncb_B <= "00000000000";
      ELSIF (ckw1_ipd'event and ckw1_ipd = '1') THEN
         int_read_address_syncb_B <= int_read_address_synca_B;
      END IF;
   END PROCESS;

   read_address_B <= int_read_address_B(8 downto 0);
   write_address_B <= int_write_address_B(8 downto 0);

   P1016 : PROCESS (int_write_address_syncb_B, int_write_address_B)
   BEGIN
--      IF (asyncmode_B_reg = "TRUE") THEN
--         int_write_address_sync_B <= int_write_address_syncb_B;
--      ELSE
         int_write_address_sync_B <= int_write_address_B;
--      END IF;
   END PROCESS;

   P1017 : PROCESS (int_read_address_syncb_B, int_read_address_B)
   BEGIN
--      IF (asyncmode_B_reg = "TRUE") THEN
--         int_read_address_sync_B <= int_read_address_syncb_B;
--      ELSE
         int_read_address_sync_B <= int_read_address_B;
--      END IF;
   END PROCESS;

   P1018 : PROCESS (ckr1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         RADDR_B <= "000000000";
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         IF (fifo_rde_B = '1') THEN
            RADDR_B <= read_address_B;
         END IF;
      END IF;
   END PROCESS;

   P1019 : PROCESS (read_address_B, memchg_B)
   BEGIN
      q0b_B <= mem_B(conv_integer(read_address_B));
   END PROCESS;

   P1020 : PROCESS (ckw1_ipd, rstn1_ipd)
   VARIABLE WADDR_B : std_logic_vector(8 downto 0) := "000000000";
   BEGIN
      IF (rstn1_ipd = '0') THEN
         WADDR_B := "000000000";
      ELSIF (ckw1_ipd'event and ckw1_ipd = '1') THEN
         IF (fifo_wre_B = '1') THEN
            WADDR_B := write_address_B;
            mem_B(conv_integer(WADDR_B)) <= data_B;
            memchg_B <= not memchg_B;
         END IF;
      END IF;
   END PROCESS;

   P1021 : PROCESS (ckr1_ipd, rstn1_ipd)
   BEGIN
      IF (rstn1_ipd = '0') THEN
         q2b_B <= "000000000";
      ELSIF (ckr1_ipd'event and ckr1_ipd = '1') THEN
         q2b_B <= q0b_B;
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q2b_A, q0b_A, q2b_B, q0b_B)
     VARIABLE q0_zd   : std_logic_vector(8 downto 0);
     VARIABLE q1_zd   : std_logic_vector(8 downto 0);

     -- timing check results
        VARIABLE tviol_d08     : x01 := '0';
        VARIABLE tviol_d07     : x01 := '0';
        VARIABLE tviol_d06     : x01 := '0';
        VARIABLE tviol_d05     : x01 := '0';
        VARIABLE tviol_d04     : x01 := '0';
        VARIABLE tviol_d03     : x01 := '0';
        VARIABLE tviol_d02     : x01 := '0';
        VARIABLE tviol_d01     : x01 := '0';
        VARIABLE tviol_d00     : x01 := '0';
        VARIABLE tviol_wre0    : x01 := '0';
        VARIABLE tviol_rde0    : x01 := '0';
        VARIABLE tviol_d18     : x01 := '0';
        VARIABLE tviol_d17     : x01 := '0';
        VARIABLE tviol_d16     : x01 := '0';
        VARIABLE tviol_d15     : x01 := '0';
        VARIABLE tviol_d14     : x01 := '0';
        VARIABLE tviol_d13     : x01 := '0';
        VARIABLE tviol_d12     : x01 := '0';
        VARIABLE tviol_d11     : x01 := '0';
        VARIABLE tviol_d10     : x01 := '0';
        VARIABLE tviol_wre1    : x01 := '0';
        VARIABLE tviol_rde1    : x01 := '0';

        VARIABLE d08_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d07_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d06_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d05_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d04_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d03_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d02_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d01_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d00_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE wre0_ckw0_TimingDatash : VitalTimingDataType;
        VARIABLE rde0_ckr0_TimingDatash : VitalTimingDataType;
        VARIABLE d18_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d17_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d16_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d15_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d14_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d13_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d12_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d11_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d10_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE wre1_ckw1_TimingDatash : VitalTimingDataType;
        VARIABLE rde1_ckr1_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE q08_GlitchData   :   VitalGlitchDataType;
        VARIABLE q07_GlitchData   :   VitalGlitchDataType;
        VARIABLE q06_GlitchData   :   VitalGlitchDataType;
        VARIABLE q05_GlitchData   :   VitalGlitchDataType;
        VARIABLE q04_GlitchData   :   VitalGlitchDataType;
        VARIABLE q03_GlitchData   :   VitalGlitchDataType;
        VARIABLE q02_GlitchData   :   VitalGlitchDataType;
        VARIABLE q01_GlitchData   :   VitalGlitchDataType;
        VARIABLE q00_GlitchData   :   VitalGlitchDataType;
        VARIABLE q18_GlitchData   :   VitalGlitchDataType;
        VARIABLE q17_GlitchData   :   VitalGlitchDataType;
        VARIABLE q16_GlitchData   :   VitalGlitchDataType;
        VARIABLE q15_GlitchData   :   VitalGlitchDataType;
        VARIABLE q14_GlitchData   :   VitalGlitchDataType;
        VARIABLE q13_GlitchData   :   VitalGlitchDataType;
        VARIABLE q12_GlitchData   :   VitalGlitchDataType;
        VARIABLE q11_GlitchData   :   VitalGlitchDataType;
        VARIABLE q10_GlitchData   :   VitalGlitchDataType;

    BEGIN

   ------------------------
   -- functionality section
   ------------------------
      IF (ffmode_A_reg = "OUTREG") THEN
         IF (asyncmode_A_reg = "TRUE") THEN
            IF (port0_valid = '1') THEN
               q0_zd := q2b_A;
            END IF;
         ELSIF (asyncmode_A_reg = "FALSE") THEN
            q0_zd := q2b_A;
         END IF;
      ELSE
         q0_zd := q0b_A;
      END IF;

      IF (ffmode_B_reg = "OUTREG") THEN
         q1_zd := q2b_B;
      ELSE
         q1_zd := q0b_B;
      END IF;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q08, OutSignalName => "q08", OutTemp => q0_zd(8),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q08,
                             PathCondition => TRUE)),
        GlitchData => q08_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q07, OutSignalName => "q07", OutTemp => q0_zd(7),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q07,
                             PathCondition => TRUE)),
        GlitchData => q07_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q06, OutSignalName => "q06", OutTemp => q0_zd(6),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q06,
                             PathCondition => TRUE)),
        GlitchData => q06_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q05, OutSignalName => "q05", OutTemp => q0_zd(5),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q05,
                             PathCondition => TRUE)),
        GlitchData => q05_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q04, OutSignalName => "q04", OutTemp => q0_zd(4),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q04,
                             PathCondition => TRUE)),
        GlitchData => q04_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q03, OutSignalName => "q03", OutTemp => q0_zd(3),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q03,
                             PathCondition => TRUE)),
        GlitchData => q03_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q02, OutSignalName => "q02", OutTemp => q0_zd(2),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q02,
                             PathCondition => TRUE)),
        GlitchData => q02_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q01, OutSignalName => "q01", OutTemp => q0_zd(1),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q01,
                             PathCondition => TRUE)),
        GlitchData => q01_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q00, OutSignalName => "q00", OutTemp => q0_zd(0),
        Paths      => (0 => (InputChangeTime => ckr0_ipd'last_event,
                             PathDelay => tpd_ckr0_q00,
                             PathCondition => TRUE)),
        GlitchData => q00_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q18, OutSignalName => "q18", OutTemp => q1_zd(8),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q18,
                             PathCondition => TRUE)),
        GlitchData => q18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q17, OutSignalName => "q17", OutTemp => q1_zd(7),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q17,
                             PathCondition => TRUE)),
        GlitchData => q17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q16, OutSignalName => "q16", OutTemp => q1_zd(6),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q16,
                             PathCondition => TRUE)),
        GlitchData => q16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q15, OutSignalName => "q15", OutTemp => q1_zd(5),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q15,
                             PathCondition => TRUE)),
        GlitchData => q15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q14, OutSignalName => "q14", OutTemp => q1_zd(4),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q14,
                             PathCondition => TRUE)),
        GlitchData => q14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q13, OutSignalName => "q13", OutTemp => q1_zd(3),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q13,
                             PathCondition => TRUE)),
        GlitchData => q13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q12, OutSignalName => "q12", OutTemp => q1_zd(2),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q12,
                             PathCondition => TRUE)),
        GlitchData => q12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q11, OutSignalName => "q11", OutTemp => q1_zd(1),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q11,
                             PathCondition => TRUE)),
        GlitchData => q11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q10, OutSignalName => "q10", OutTemp => q1_zd(0),
        Paths      => (0 => (InputChangeTime => ckr1_ipd'last_event,
                             PathDelay => tpd_ckr1_q10,
                             PathCondition => TRUE)),
        GlitchData => q10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
   END PROCESS VITAL_OUTPUT;

END V;


--
-----cell cmult16----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use ieee.std_logic_unsigned.all;
use work.mem3.all;

-- entity declaration --
ENTITY cmult16 IS
   GENERIC (
        CMULTMODE                  : String  := "NOREG";
        initval_00 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_01 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_02 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_03 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_04 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_05 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_06 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_07 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_08 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_09 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_0a : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_0b : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_0c : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_0d : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_0e : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_0f : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_10 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_11 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_12 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_13 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_14 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_15 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_16 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_17 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_18 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_19 : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_1a : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_1b : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_1c : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_1d : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_1e : String := "0X0000000000000000000000000000000000000000000000000000000000000000";
        initval_1f : String := "0X0000000000000000000000000000000000000000000000000000000000000000";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "cmult16";

        -- input SIGNAL delays
        tipd_aw08 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m9   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m8   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m7   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m6   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m5   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m4   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m3   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m2   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m1   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_m0   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d015 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d014 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d013 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d012 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d011 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d010 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d09  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d08  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d07  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d06  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d05  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d04  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d03  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d02  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d01  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d00  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_mck  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_en   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw18 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_aw10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d115 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d114 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d113 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d112 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d111 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d110 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d19  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d18  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d17  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d16  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d15  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d14  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d13  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d12  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d11  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_d10  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_csw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_m0_p0          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p1          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p2          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p3          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p4          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p5          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m0_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p1          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p2          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p3          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p4          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p5          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m1_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p2          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p3          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p4          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p5          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m2_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p3          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p4          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p5          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m3_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p4          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p5          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m4_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p5          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m5_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p6          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m6_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p7          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m7_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p8          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m8_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p9          : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p10         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p11         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p12         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p13         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p14         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p15         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p16         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p17         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p18         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p19         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p20         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p21         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p22         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m9_p23         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m10_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m11_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m12_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m13_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m14_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_m15_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p0         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p1         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p16        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p17        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p18        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p19        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p20        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p21        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p22        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_mck_p23        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p0        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p1        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p2        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p3        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p4        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p5        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p6        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p7        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p8        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p9        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p20       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p21       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p22       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw0_p23       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p0        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p1        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p2        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p3        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p4        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p5        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p6        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p7        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p8        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p9        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p20       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p21       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p22       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckw1_p23       : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_m0_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m0_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m1_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m1_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m2_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m2_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m3_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m3_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m4_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m4_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m5_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m5_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m6_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m6_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m7_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m7_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m8_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m8_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m9_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_m9_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_m10_mck_noedge_posedge    : VitalDelayType := 0.01 ns;
        thold_m10_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        tsetup_m11_mck_noedge_posedge    : VitalDelayType := 0.01 ns;
        thold_m11_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        tsetup_m12_mck_noedge_posedge    : VitalDelayType := 0.01 ns;
        thold_m12_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        tsetup_m13_mck_noedge_posedge    : VitalDelayType := 0.01 ns;
        thold_m13_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        tsetup_m14_mck_noedge_posedge    : VitalDelayType := 0.01 ns;
        thold_m14_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        tsetup_m15_mck_noedge_posedge    : VitalDelayType := 0.01 ns;
        thold_m15_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        tsetup_en_mck_noedge_posedge     : VitalDelayType := 0.01 ns;
        thold_en_mck_noedge_posedge      : VitalDelayType := 0.01 ns;
        tsetup_aw00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw00_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw01_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw02_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw03_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw04_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw05_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw06_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw07_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw08_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw08_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d00_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d00_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d01_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d01_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d02_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d02_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d03_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d03_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d04_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d04_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d05_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d05_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d06_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d06_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d07_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d07_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d08_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d08_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d09_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d09_ckw0_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d010_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d010_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d011_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d011_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d012_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d012_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d013_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d013_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d014_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d014_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d015_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d015_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_csw0_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_csw0_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw10_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw11_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw12_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw13_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw14_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw15_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw16_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw17_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_aw18_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_aw18_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d10_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d10_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d11_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d11_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d12_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d12_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d13_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d13_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d14_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d14_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d15_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d15_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d16_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d16_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d17_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d17_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d18_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d18_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d19_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_d19_ckw1_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_d110_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d110_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d111_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d111_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d112_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d112_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d113_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d113_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d114_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d114_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_d115_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_d115_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_csw1_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_csw1_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw0            : VitalDelayType := 0.01 ns;
        tpw_ckw0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckw1            : VitalDelayType := 0.01 ns;
        tpw_ckw1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw1_negedge        : VitalDelayType := 0.01 ns;
        tperiod_mck             : VitalDelayType := 0.01 ns;
        tpw_mck_posedge         : VitalDelayType := 0.01 ns;
        tpw_mck_negedge         : VitalDelayType := 0.01 ns);

   PORT(
        m15, m14, m13, m12, m11, m10, m9, m8                         : in std_logic ;
        m7, m6, m5, m4, m3, m2, m1, m0, mck, en                      : in std_logic ;
        aw08, aw07, aw06, aw05, aw04, aw03, aw02, aw01, aw00         : in std_logic ;
        d015, d014, d013, d012, d011, d010, d09, d08                 : in std_logic ;
        d07, d06, d05, d04, d03, d02, d01, d00, ckw0, csw0           : in std_logic ;
        aw18, aw17, aw16, aw15, aw14, aw13, aw12, aw11, aw10         : in std_logic ;
        d115, d114, d113, d112, d111, d110, d19, d18                 : in std_logic ;
        d17, d16, d15, d14, d13, d12, d11, d10, ckw1, csw1           : in std_logic ;

        p23, p22, p21, p20, p19, p18, p17, p16, p15, p14, p13        : out std_logic ;
        p12, p11, p10, p9, p8, p7, p6, p5, p4, p3, p2, p1, p0        : out std_logic );

      ATTRIBUTE Vital_Level0 OF cmult16 : ENTITY IS TRUE;

END cmult16 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF cmult16 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL mode_reg   : String(CMULTMODE'length downto 1);

    SIGNAL aw08_ipd  : std_logic := 'X';
    SIGNAL aw07_ipd  : std_logic := 'X';
    SIGNAL aw06_ipd  : std_logic := 'X';
    SIGNAL aw05_ipd  : std_logic := 'X';
    SIGNAL aw04_ipd  : std_logic := 'X';
    SIGNAL aw03_ipd  : std_logic := 'X';
    SIGNAL aw02_ipd  : std_logic := 'X';
    SIGNAL aw01_ipd  : std_logic := 'X';
    SIGNAL aw00_ipd  : std_logic := 'X';
    SIGNAL m15_ipd   : std_logic := 'X';
    SIGNAL m14_ipd   : std_logic := 'X';
    SIGNAL m13_ipd   : std_logic := 'X';
    SIGNAL m12_ipd   : std_logic := 'X';
    SIGNAL m11_ipd   : std_logic := 'X';
    SIGNAL m10_ipd   : std_logic := 'X';
    SIGNAL m9_ipd    : std_logic := 'X';
    SIGNAL m8_ipd    : std_logic := 'X';
    SIGNAL m7_ipd    : std_logic := 'X';
    SIGNAL m6_ipd    : std_logic := 'X';
    SIGNAL m5_ipd    : std_logic := 'X';
    SIGNAL m4_ipd    : std_logic := 'X';
    SIGNAL m3_ipd    : std_logic := 'X';
    SIGNAL m2_ipd    : std_logic := 'X';
    SIGNAL m1_ipd    : std_logic := 'X';
    SIGNAL m0_ipd    : std_logic := 'X';
    SIGNAL d015_ipd  : std_logic := 'X';
    SIGNAL d014_ipd  : std_logic := 'X';
    SIGNAL d013_ipd  : std_logic := 'X';
    SIGNAL d012_ipd  : std_logic := 'X';
    SIGNAL d011_ipd  : std_logic := 'X';
    SIGNAL d010_ipd  : std_logic := 'X';
    SIGNAL d09_ipd   : std_logic := 'X';
    SIGNAL d08_ipd   : std_logic := 'X';
    SIGNAL d07_ipd   : std_logic := 'X';
    SIGNAL d06_ipd   : std_logic := 'X';
    SIGNAL d05_ipd   : std_logic := 'X';
    SIGNAL d04_ipd   : std_logic := 'X';
    SIGNAL d03_ipd   : std_logic := 'X';
    SIGNAL d02_ipd   : std_logic := 'X';
    SIGNAL d01_ipd   : std_logic := 'X';
    SIGNAL d00_ipd   : std_logic := 'X';
    SIGNAL ckw0_ipd  : std_logic := 'X';
    SIGNAL mck_ipd   : std_logic := 'X';
    SIGNAL en_ipd   : std_logic := 'X';
    SIGNAL csw0_ipd  : std_logic := 'X';
    SIGNAL aw18_ipd  : std_logic := 'X';
    SIGNAL aw17_ipd  : std_logic := 'X';
    SIGNAL aw16_ipd  : std_logic := 'X';
    SIGNAL aw15_ipd  : std_logic := 'X';
    SIGNAL aw14_ipd  : std_logic := 'X';
    SIGNAL aw13_ipd  : std_logic := 'X';
    SIGNAL aw12_ipd  : std_logic := 'X';
    SIGNAL aw11_ipd  : std_logic := 'X';
    SIGNAL aw10_ipd  : std_logic := 'X';
    SIGNAL d115_ipd  : std_logic := 'X';
    SIGNAL d114_ipd  : std_logic := 'X';
    SIGNAL d113_ipd  : std_logic := 'X';
    SIGNAL d112_ipd  : std_logic := 'X';
    SIGNAL d111_ipd  : std_logic := 'X';
    SIGNAL d110_ipd  : std_logic := 'X';
    SIGNAL d19_ipd   : std_logic := 'X';
    SIGNAL d18_ipd   : std_logic := 'X';
    SIGNAL d17_ipd   : std_logic := 'X';
    SIGNAL d16_ipd   : std_logic := 'X';
    SIGNAL d15_ipd   : std_logic := 'X';
    SIGNAL d14_ipd   : std_logic := 'X';
    SIGNAL d13_ipd   : std_logic := 'X';
    SIGNAL d12_ipd   : std_logic := 'X';
    SIGNAL d11_ipd   : std_logic := 'X';
    SIGNAL d10_ipd   : std_logic := 'X';
    SIGNAL ckw1_ipd  : std_logic := 'X';
    SIGNAL csw1_ipd  : std_logic := 'X';

    SIGNAL initval1  : string(1024 downto 1) :=
      (initval_0f(3 to 66)&initval_0e(3 to 66)&initval_0d(3 to 66)&initval_0c(3 to 66)&
      initval_0b(3 to 66)&initval_0a(3 to 66)&initval_09(3 to 66)&initval_08(3 to 66)&
      initval_07(3 to 66)&initval_06(3 to 66)&initval_05(3 to 66)&initval_04(3 to 66)&
      initval_03(3 to 66)&initval_02(3 to 66)&initval_01(3 to 66)&initval_00(3 to 66));
    SIGNAL initval2  : string(1024 downto 1) :=
      (initval_1f(3 to 66)&initval_1e(3 to 66)&initval_1d(3 to 66)&initval_1c(3 to 66)&
      initval_1b(3 to 66)&initval_1a(3 to 66)&initval_19(3 to 66)&initval_18(3 to 66)&
      initval_17(3 to 66)&initval_16(3 to 66)&initval_15(3 to 66)&initval_14(3 to 66)&
      initval_13(3 to 66)&initval_12(3 to 66)&initval_11(3 to 66)&initval_10(3 to 66));
    SIGNAL memory1   : mem_type_6(0 to 255) := init_ram1 (initval1);
    SIGNAL memory2   : mem_type_6(0 to 255) := init_ram1 (initval2);
    SIGNAL aw0_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL aw1_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL ar0_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL ar1_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL d0_int    : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL d1_int    : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL memchg1   : std_logic := '0';
    SIGNAL memchg2   : std_logic := '0';
    SIGNAL en_reg    : std_logic := 'X';

    SIGNAL q0_int    : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL q1_int    : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL q2_int    : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL q_out     : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL q         : std_logic_vector(23 downto 0) := "000000000000000000000000";
    SIGNAL rad_reg_0 : Integer := 0;
    SIGNAL rad_reg_1 : Integer := 0;

BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(aw08_ipd, aw08, tipd_aw08);
   VitalWireDelay(aw07_ipd, aw07, tipd_aw07);
   VitalWireDelay(aw06_ipd, aw06, tipd_aw06);
   VitalWireDelay(aw05_ipd, aw05, tipd_aw05);
   VitalWireDelay(aw04_ipd, aw04, tipd_aw04);
   VitalWireDelay(aw03_ipd, aw03, tipd_aw03);
   VitalWireDelay(aw02_ipd, aw02, tipd_aw02);
   VitalWireDelay(aw01_ipd, aw01, tipd_aw01);
   VitalWireDelay(aw00_ipd, aw00, tipd_aw00);
   VitalWireDelay(m15_ipd, m15, tipd_m15);
   VitalWireDelay(m14_ipd, m14, tipd_m14);
   VitalWireDelay(m13_ipd, m13, tipd_m13);
   VitalWireDelay(m12_ipd, m12, tipd_m12);
   VitalWireDelay(m11_ipd, m11, tipd_m11);
   VitalWireDelay(m10_ipd, m10, tipd_m10);
   VitalWireDelay(m9_ipd, m9, tipd_m9);
   VitalWireDelay(m8_ipd, m8, tipd_m8);
   VitalWireDelay(m7_ipd, m7, tipd_m7);
   VitalWireDelay(m6_ipd, m6, tipd_m6);
   VitalWireDelay(m5_ipd, m5, tipd_m5);
   VitalWireDelay(m4_ipd, m4, tipd_m4);
   VitalWireDelay(m3_ipd, m3, tipd_m3);
   VitalWireDelay(m2_ipd, m2, tipd_m2);
   VitalWireDelay(m1_ipd, m1, tipd_m1);
   VitalWireDelay(m0_ipd, m0, tipd_m0);
   VitalWireDelay(d015_ipd, d015, tipd_d015);
   VitalWireDelay(d014_ipd, d014, tipd_d014);
   VitalWireDelay(d013_ipd, d013, tipd_d013);
   VitalWireDelay(d012_ipd, d012, tipd_d012);
   VitalWireDelay(d011_ipd, d011, tipd_d011);
   VitalWireDelay(d010_ipd, d010, tipd_d010);
   VitalWireDelay(d09_ipd, d09, tipd_d09);
   VitalWireDelay(d08_ipd, d08, tipd_d08);
   VitalWireDelay(d07_ipd, d07, tipd_d07);
   VitalWireDelay(d06_ipd, d06, tipd_d06);
   VitalWireDelay(d05_ipd, d05, tipd_d05);
   VitalWireDelay(d04_ipd, d04, tipd_d04);
   VitalWireDelay(d03_ipd, d03, tipd_d03);
   VitalWireDelay(d02_ipd, d02, tipd_d02);
   VitalWireDelay(d01_ipd, d01, tipd_d01);
   VitalWireDelay(d00_ipd, d00, tipd_d00);
   VitalWireDelay(ckw0_ipd, ckw0, tipd_ckw0);
   VitalWireDelay(mck_ipd, mck, tipd_mck);
   VitalWireDelay(csw0_ipd, csw0, tipd_csw0);
   VitalWireDelay(en_ipd, en, tipd_en);
   VitalWireDelay(aw18_ipd, aw18, tipd_aw18);
   VitalWireDelay(aw17_ipd, aw17, tipd_aw17);
   VitalWireDelay(aw16_ipd, aw16, tipd_aw16);
   VitalWireDelay(aw15_ipd, aw15, tipd_aw15);
   VitalWireDelay(aw14_ipd, aw14, tipd_aw14);
   VitalWireDelay(aw13_ipd, aw13, tipd_aw13);
   VitalWireDelay(aw12_ipd, aw12, tipd_aw12);
   VitalWireDelay(aw11_ipd, aw11, tipd_aw11);
   VitalWireDelay(aw10_ipd, aw10, tipd_aw10);
   VitalWireDelay(d115_ipd, d115, tipd_d115);
   VitalWireDelay(d114_ipd, d114, tipd_d114);
   VitalWireDelay(d113_ipd, d113, tipd_d113);
   VitalWireDelay(d112_ipd, d112, tipd_d112);
   VitalWireDelay(d111_ipd, d111, tipd_d111);
   VitalWireDelay(d110_ipd, d110, tipd_d110);
   VitalWireDelay(d19_ipd, d19, tipd_d19);
   VitalWireDelay(d18_ipd, d18, tipd_d18);
   VitalWireDelay(d17_ipd, d17, tipd_d17);
   VitalWireDelay(d16_ipd, d16, tipd_d16);
   VitalWireDelay(d15_ipd, d15, tipd_d15);
   VitalWireDelay(d14_ipd, d14, tipd_d14);
   VitalWireDelay(d13_ipd, d13, tipd_d13);
   VitalWireDelay(d12_ipd, d12, tipd_d12);
   VitalWireDelay(d11_ipd, d11, tipd_d11);
   VitalWireDelay(d10_ipd, d10, tipd_d10);
   VitalWireDelay(ckw1_ipd, ckw1, tipd_ckw1);
   VitalWireDelay(csw1_ipd, csw1, tipd_csw1);
   END BLOCK;

   mode_reg <= CMULTMODE;
   aw0_int <= (aw07_ipd, aw06_ipd, aw05_ipd, aw04_ipd, aw03_ipd,
               aw02_ipd, aw01_ipd, aw00_ipd);
   aw1_int <= (aw17_ipd, aw16_ipd, aw15_ipd, aw14_ipd, aw13_ipd,
               aw12_ipd, aw11_ipd, aw10_ipd);
   ar0_int <= (m7_ipd, m6_ipd, m5_ipd, m4_ipd, m3_ipd, m2_ipd, m1_ipd, m0_ipd);
   ar1_int <= (m15_ipd, m14_ipd, m13_ipd, m12_ipd, m11_ipd, m10_ipd, m9_ipd, m8_ipd);
   d0_int <= (d015_ipd, d014_ipd, d013_ipd, d012_ipd, d011_ipd, d010_ipd, d09_ipd,
              d08_ipd, d07_ipd, d06_ipd, d05_ipd, d04_ipd, d03_ipd, d02_ipd,
              d01_ipd, d00_ipd);
   d1_int <= (d115_ipd, d114_ipd, d113_ipd, d112_ipd, d111_ipd, d110_ipd, d19_ipd,
              d18_ipd, d17_ipd, d16_ipd, d15_ipd, d14_ipd, d13_ipd, d12_ipd,
              d11_ipd, d10_ipd);

----------------------------------------------------------------
-- Port0 and Port1 write address and data latch and write
----------------------------------------------------------------
   WR : PROCESS (ckw0_ipd, ckw1_ipd)
   VARIABLE data1  : std_logic_vector(15 downto 0);
   VARIABLE data2  : std_logic_vector(15 downto 0);
   VARIABLE wad_0     : Integer;
   VARIABLE wad_1     : Integer;
   BEGIN
        IF (ckw0_ipd'event and ckw0_ipd = '1') THEN
          IF (csw0_ipd = '1') THEN
              wad_0 := conv_integer(aw0_int);
              data1 := d0_int(15 downto 0);
              IF (aw08_ipd = '0') THEN
                 memory1(wad_0)(15 downto 0) <= data1;
              ELSIF (aw08_ipd = '1') THEN
                 memory2(wad_0)(15 downto 0) <= data1;
              END IF;
              memchg1 <= not memchg1;
          END IF;
        END IF;

        IF (ckw1_ipd'event and ckw1_ipd = '1') THEN
          IF (csw1_ipd = '1') THEN
              wad_1 := conv_integer(aw1_int);
              data2 := d1_int(15 downto 0);
              IF (aw18_ipd = '0') THEN
                 memory1(wad_1)(15 downto 0) <= data2;
              ELSIF (aw18_ipd = '1') THEN
                 memory2(wad_1)(15 downto 0) <= data2;
              END IF;
              memchg2 <= not memchg2;
          END IF;
        END IF;
   END PROCESS;

----------------------------------------------------------------
-- Register Enable signal
----------------------------------------------------------------
   REG_EN : PROCESS (mck_ipd)
   BEGIN
      IF (mode_reg = "IOREG") THEN
         IF (mck_ipd'event and mck_ipd = '1') THEN
            en_reg <= en_ipd;
         END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- NOREG read operation
----------------------------------------------------------------

   NOREG_READ : PROCESS (rad_reg_0, rad_reg_1, memchg1, memchg2)
   BEGIN
       q0_int <= memory1(rad_reg_0)(7 downto 0);
       q1_int(7 downto 0) <= memory1(rad_reg_0)(15 downto 8);
       q2_int <= memory2(rad_reg_1);
   END PROCESS;

   q_out <= q1_int + q2_int;
----------------------------------------------------------------
-- INREG and IOREG read operation
----------------------------------------------------------------
   INREG_READ : PROCESS (mck_ipd, ar0_int, ar1_int)
   BEGIN
      IF (mode_reg = "INREG" or mode_reg = "IOREG") THEN
         IF (mck_ipd'event and mck_ipd = '1') THEN
           IF (en_ipd = '1') THEN
              rad_reg_0 <= conv_integer(ar0_int);
              rad_reg_1 <= conv_integer(ar1_int);
           END IF;
         END IF;
      ELSE
         rad_reg_0 <= conv_integer(ar0_int);
         rad_reg_1 <= conv_integer(ar1_int);
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- OUTREG and IOREG read operation
----------------------------------------------------------------
   OUTREG_READ : PROCESS (mck_ipd, q0_int, q_out)
   BEGIN
      IF (mode_reg = "IOREG") THEN
         IF (mck_ipd'event and mck_ipd = '1') THEN
           IF (en_reg = '1') THEN
              q(7 downto 0) <= q0_int;
              q(23 downto 8) <= q_out(15 downto 0);
           END IF;
         END IF;
      ELSIF (mode_reg = "OUTREG") THEN
         IF (mck_ipd'event and mck_ipd = '1') THEN
           IF (en_ipd = '1') THEN
              q(7 downto 0) <= q0_int;
              q(23 downto 8) <= q_out(15 downto 0);
           END IF;
         END IF;
      ELSE
         q(7 downto 0) <= q0_int;
         q(23 downto 8) <= q_out(15 downto 0);
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q)
     VARIABLE p_zd   : std_logic_vector(23 downto 0);

     -- timing check results
        VARIABLE tviol_m0     : x01 := '0';
        VARIABLE tviol_m1     : x01 := '0';
        VARIABLE tviol_m2     : x01 := '0';
        VARIABLE tviol_m3     : x01 := '0';
        VARIABLE tviol_m4     : x01 := '0';
        VARIABLE tviol_m5     : x01 := '0';
        VARIABLE tviol_m6     : x01 := '0';
        VARIABLE tviol_m7     : x01 := '0';
        VARIABLE tviol_m8     : x01 := '0';
        VARIABLE tviol_m9     : x01 := '0';
        VARIABLE tviol_m10    : x01 := '0';
        VARIABLE tviol_m11    : x01 := '0';
        VARIABLE tviol_m12    : x01 := '0';
        VARIABLE tviol_m13    : x01 := '0';
        VARIABLE tviol_m14    : x01 := '0';
        VARIABLE tviol_m15    : x01 := '0';
        VARIABLE tviol_en     : x01 := '0';
        VARIABLE tviol_aw00   : x01 := '0';
        VARIABLE tviol_aw01   : x01 := '0';
        VARIABLE tviol_aw02   : x01 := '0';
        VARIABLE tviol_aw03   : x01 := '0';
        VARIABLE tviol_aw04   : x01 := '0';
        VARIABLE tviol_aw05   : x01 := '0';
        VARIABLE tviol_aw06   : x01 := '0';
        VARIABLE tviol_aw07   : x01 := '0';
        VARIABLE tviol_aw08   : x01 := '0';
        VARIABLE tviol_d00    : x01 := '0';
        VARIABLE tviol_d01    : x01 := '0';
        VARIABLE tviol_d02    : x01 := '0';
        VARIABLE tviol_d03    : x01 := '0';
        VARIABLE tviol_d04    : x01 := '0';
        VARIABLE tviol_d05    : x01 := '0';
        VARIABLE tviol_d06    : x01 := '0';
        VARIABLE tviol_d07    : x01 := '0';
        VARIABLE tviol_d08    : x01 := '0';
        VARIABLE tviol_d09    : x01 := '0';
        VARIABLE tviol_d010   : x01 := '0';
        VARIABLE tviol_d011   : x01 := '0';
        VARIABLE tviol_d012   : x01 := '0';
        VARIABLE tviol_d013   : x01 := '0';
        VARIABLE tviol_d014   : x01 := '0';
        VARIABLE tviol_d015   : x01 := '0';
        VARIABLE tviol_csw0   : x01 := '0';
        VARIABLE tviol_aw10   : x01 := '0';
        VARIABLE tviol_aw11   : x01 := '0';
        VARIABLE tviol_aw12   : x01 := '0';
        VARIABLE tviol_aw13   : x01 := '0';
        VARIABLE tviol_aw14   : x01 := '0';
        VARIABLE tviol_aw15   : x01 := '0';
        VARIABLE tviol_aw16   : x01 := '0';
        VARIABLE tviol_aw17   : x01 := '0';
        VARIABLE tviol_aw18   : x01 := '0';
        VARIABLE tviol_d10    : x01 := '0';
        VARIABLE tviol_d11    : x01 := '0';
        VARIABLE tviol_d12    : x01 := '0';
        VARIABLE tviol_d13    : x01 := '0';
        VARIABLE tviol_d14    : x01 := '0';
        VARIABLE tviol_d15    : x01 := '0';
        VARIABLE tviol_d16    : x01 := '0';
        VARIABLE tviol_d17    : x01 := '0';
        VARIABLE tviol_d18    : x01 := '0';
        VARIABLE tviol_d19    : x01 := '0';
        VARIABLE tviol_d110   : x01 := '0';
        VARIABLE tviol_d111   : x01 := '0';
        VARIABLE tviol_d112   : x01 := '0';
        VARIABLE tviol_d113   : x01 := '0';
        VARIABLE tviol_d114   : x01 := '0';
        VARIABLE tviol_d115   : x01 := '0';
        VARIABLE tviol_csw1   : x01 := '0';

        VARIABLE m0_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m1_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m2_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m3_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m4_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m5_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m6_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m7_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m8_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m9_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE m10_mck_TimingDatash    : VitalTimingDataType;
        VARIABLE m11_mck_TimingDatash    : VitalTimingDataType;
        VARIABLE m12_mck_TimingDatash    : VitalTimingDataType;
        VARIABLE m13_mck_TimingDatash    : VitalTimingDataType;
        VARIABLE m14_mck_TimingDatash    : VitalTimingDataType;
        VARIABLE m15_mck_TimingDatash    : VitalTimingDataType;
        VARIABLE en_mck_TimingDatash     : VitalTimingDataType;
        VARIABLE aw00_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw01_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw02_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw03_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw04_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw05_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw06_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw07_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw08_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d00_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d01_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d02_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d03_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d04_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d05_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d06_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d07_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d08_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d09_ckw0_TimingDatash   : VitalTimingDataType;
        VARIABLE d010_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d011_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d012_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d013_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d014_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE d015_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE csw0_ckw0_TimingDatash  : VitalTimingDataType;
        VARIABLE aw10_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw11_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw12_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw13_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw14_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw15_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw16_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw17_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE aw18_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d10_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d11_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d12_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d13_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d14_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d15_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d16_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d17_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d18_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d19_ckw1_TimingDatash   : VitalTimingDataType;
        VARIABLE d110_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d111_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d112_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d113_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d114_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE d115_ckw1_TimingDatash  : VitalTimingDataType;
        VARIABLE csw1_ckw1_TimingDatash  : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE p0_GlitchData   :   VitalGlitchDataType;
        VARIABLE p1_GlitchData   :   VitalGlitchDataType;
        VARIABLE p2_GlitchData   :   VitalGlitchDataType;
        VARIABLE p3_GlitchData   :   VitalGlitchDataType;
        VARIABLE p4_GlitchData   :   VitalGlitchDataType;
        VARIABLE p5_GlitchData   :   VitalGlitchDataType;
        VARIABLE p6_GlitchData   :   VitalGlitchDataType;
        VARIABLE p7_GlitchData   :   VitalGlitchDataType;
        VARIABLE p8_GlitchData   :   VitalGlitchDataType;
        VARIABLE p9_GlitchData   :   VitalGlitchDataType;
        VARIABLE p10_GlitchData  :   VitalGlitchDataType;
        VARIABLE p11_GlitchData  :   VitalGlitchDataType;
        VARIABLE p12_GlitchData  :   VitalGlitchDataType;
        VARIABLE p13_GlitchData  :   VitalGlitchDataType;
        VARIABLE p14_GlitchData  :   VitalGlitchDataType;
        VARIABLE p15_GlitchData  :   VitalGlitchDataType;
        VARIABLE p16_GlitchData  :   VitalGlitchDataType;
        VARIABLE p17_GlitchData  :   VitalGlitchDataType;
        VARIABLE p18_GlitchData  :   VitalGlitchDataType;
        VARIABLE p19_GlitchData  :   VitalGlitchDataType;
        VARIABLE p20_GlitchData  :   VitalGlitchDataType;
        VARIABLE p21_GlitchData  :   VitalGlitchDataType;
        VARIABLE p22_GlitchData  :   VitalGlitchDataType;
        VARIABLE p23_GlitchData  :   VitalGlitchDataType;

    BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => m0_ipd,
                TestSignalName => "m0",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m0_mck_noedge_posedge,
                HoldHigh => thold_m0_mck_noedge_posedge,
                SetupLow => tsetup_m0_mck_noedge_posedge,
                HoldLow => thold_m0_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m0_mck_TimingDatash,
                Violation => tviol_m0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m1_ipd,
                TestSignalName => "m1",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m1_mck_noedge_posedge,
                HoldHigh => thold_m1_mck_noedge_posedge,
                SetupLow => tsetup_m1_mck_noedge_posedge,
                HoldLow => thold_m1_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m1_mck_TimingDatash,
                Violation => tviol_m1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m2_ipd,
                TestSignalName => "m2",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m2_mck_noedge_posedge,
                HoldHigh => thold_m2_mck_noedge_posedge,
                SetupLow => tsetup_m2_mck_noedge_posedge,
                HoldLow => thold_m2_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m2_mck_TimingDatash,
                Violation => tviol_m2,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m3_ipd,
                TestSignalName => "m3",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m3_mck_noedge_posedge,
                HoldHigh => thold_m3_mck_noedge_posedge,
                SetupLow => tsetup_m3_mck_noedge_posedge,
                HoldLow => thold_m3_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m3_mck_TimingDatash,
                Violation => tviol_m3,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m4_ipd,
                TestSignalName => "m4",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m4_mck_noedge_posedge,
                HoldHigh => thold_m4_mck_noedge_posedge,
                SetupLow => tsetup_m4_mck_noedge_posedge,
                HoldLow => thold_m4_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m4_mck_TimingDatash,
                Violation => tviol_m4,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m5_ipd,
                TestSignalName => "m5",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m5_mck_noedge_posedge,
                HoldHigh => thold_m5_mck_noedge_posedge,
                SetupLow => tsetup_m5_mck_noedge_posedge,
                HoldLow => thold_m5_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m5_mck_TimingDatash,
                Violation => tviol_m5,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m6_ipd,
                TestSignalName => "m6",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m6_mck_noedge_posedge,
                HoldHigh => thold_m6_mck_noedge_posedge,
                SetupLow => tsetup_m6_mck_noedge_posedge,
                HoldLow => thold_m6_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m6_mck_TimingDatash,
                Violation => tviol_m6,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m7_ipd,
                TestSignalName => "m7",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m7_mck_noedge_posedge,
                HoldHigh => thold_m7_mck_noedge_posedge,
                SetupLow => tsetup_m7_mck_noedge_posedge,
                HoldLow => thold_m7_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m7_mck_TimingDatash,
                Violation => tviol_m7,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m8_ipd,
                TestSignalName => "m8",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m8_mck_noedge_posedge,
                HoldHigh => thold_m8_mck_noedge_posedge,
                SetupLow => tsetup_m8_mck_noedge_posedge,
                HoldLow => thold_m8_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m8_mck_TimingDatash,
                Violation => tviol_m8,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m9_ipd,
                TestSignalName => "m9",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m9_mck_noedge_posedge,
                HoldHigh => thold_m9_mck_noedge_posedge,
                SetupLow => tsetup_m9_mck_noedge_posedge,
                HoldLow => thold_m9_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m9_mck_TimingDatash,
                Violation => tviol_m9,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m10_ipd,
                TestSignalName => "m10",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m10_mck_noedge_posedge,
                HoldHigh => thold_m10_mck_noedge_posedge,
                SetupLow => tsetup_m10_mck_noedge_posedge,
                HoldLow => thold_m10_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m10_mck_TimingDatash,
                Violation => tviol_m10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m11_ipd,
                TestSignalName => "m11",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m11_mck_noedge_posedge,
                HoldHigh => thold_m11_mck_noedge_posedge,
                SetupLow => tsetup_m11_mck_noedge_posedge,
                HoldLow => thold_m11_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m11_mck_TimingDatash,
                Violation => tviol_m11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m12_ipd,
                TestSignalName => "m12",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m12_mck_noedge_posedge,
                HoldHigh => thold_m12_mck_noedge_posedge,
                SetupLow => tsetup_m12_mck_noedge_posedge,
                HoldLow => thold_m12_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m12_mck_TimingDatash,
                Violation => tviol_m12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m13_ipd,
                TestSignalName => "m13",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m13_mck_noedge_posedge,
                HoldHigh => thold_m13_mck_noedge_posedge,
                SetupLow => tsetup_m13_mck_noedge_posedge,
                HoldLow => thold_m13_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m13_mck_TimingDatash,
                Violation => tviol_m13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m14_ipd,
                TestSignalName => "m14",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m14_mck_noedge_posedge,
                HoldHigh => thold_m14_mck_noedge_posedge,
                SetupLow => tsetup_m14_mck_noedge_posedge,
                HoldLow => thold_m14_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m14_mck_TimingDatash,
                Violation => tviol_m14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => m15_ipd,
                TestSignalName => "m15",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_m15_mck_noedge_posedge,
                HoldHigh => thold_m15_mck_noedge_posedge,
                SetupLow => tsetup_m15_mck_noedge_posedge,
                HoldLow => thold_m15_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => m15_mck_TimingDatash,
                Violation => tviol_m15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => en_ipd,
                TestSignalName => "en",
                RefSignal => mck_ipd,
                RefSignalName => "mck",
                SetupHigh => tsetup_en_mck_noedge_posedge,
                HoldHigh => thold_en_mck_noedge_posedge,
                SetupLow => tsetup_en_mck_noedge_posedge,
                HoldLow => thold_en_mck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => en_mck_TimingDatash,
                Violation => tviol_en,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw00_ipd,
                TestSignalName => "aw00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw00_ckw0_noedge_posedge,
                HoldHigh => thold_aw00_ckw0_noedge_posedge,
                SetupLow => tsetup_aw00_ckw0_noedge_posedge,
                HoldLow => thold_aw00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw00_ckw0_TimingDatash,
                Violation => tviol_aw00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw01_ipd,
                TestSignalName => "aw01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw01_ckw0_noedge_posedge,
                HoldHigh => thold_aw01_ckw0_noedge_posedge,
                SetupLow => tsetup_aw01_ckw0_noedge_posedge,
                HoldLow => thold_aw01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw01_ckw0_TimingDatash,
                Violation => tviol_aw01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw02_ipd,
                TestSignalName => "aw02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw02_ckw0_noedge_posedge,
                HoldHigh => thold_aw02_ckw0_noedge_posedge,
                SetupLow => tsetup_aw02_ckw0_noedge_posedge,
                HoldLow => thold_aw02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw02_ckw0_TimingDatash,
                Violation => tviol_aw02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw03_ipd,
                TestSignalName => "aw03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw03_ckw0_noedge_posedge,
                HoldHigh => thold_aw03_ckw0_noedge_posedge,
                SetupLow => tsetup_aw03_ckw0_noedge_posedge,
                HoldLow => thold_aw03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw03_ckw0_TimingDatash,
                Violation => tviol_aw03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw04_ipd,
                TestSignalName => "aw04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw04_ckw0_noedge_posedge,
                HoldHigh => thold_aw04_ckw0_noedge_posedge,
                SetupLow => tsetup_aw04_ckw0_noedge_posedge,
                HoldLow => thold_aw04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw04_ckw0_TimingDatash,
                Violation => tviol_aw04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw05_ipd,
                TestSignalName => "aw05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw05_ckw0_noedge_posedge,
                HoldHigh => thold_aw05_ckw0_noedge_posedge,
                SetupLow => tsetup_aw05_ckw0_noedge_posedge,
                HoldLow => thold_aw05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw05_ckw0_TimingDatash,
                Violation => tviol_aw05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw06_ipd,
                TestSignalName => "aw06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw06_ckw0_noedge_posedge,
                HoldHigh => thold_aw06_ckw0_noedge_posedge,
                SetupLow => tsetup_aw06_ckw0_noedge_posedge,
                HoldLow => thold_aw06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw06_ckw0_TimingDatash,
                Violation => tviol_aw06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw07_ipd,
                TestSignalName => "aw07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw07_ckw0_noedge_posedge,
                HoldHigh => thold_aw07_ckw0_noedge_posedge,
                SetupLow => tsetup_aw07_ckw0_noedge_posedge,
                HoldLow => thold_aw07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw07_ckw0_TimingDatash,
                Violation => tviol_aw07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw08_ipd,
                TestSignalName => "aw08",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_aw08_ckw0_noedge_posedge,
                HoldHigh => thold_aw08_ckw0_noedge_posedge,
                SetupLow => tsetup_aw08_ckw0_noedge_posedge,
                HoldLow => thold_aw08_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw08_ckw0_TimingDatash,
                Violation => tviol_aw08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d00_ipd,
                TestSignalName => "d00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d00_ckw0_noedge_posedge,
                HoldHigh => thold_d00_ckw0_noedge_posedge,
                SetupLow => tsetup_d00_ckw0_noedge_posedge,
                HoldLow => thold_d00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d00_ckw0_TimingDatash,
                Violation => tviol_d00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d01_ipd,
                TestSignalName => "d01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d01_ckw0_noedge_posedge,
                HoldHigh => thold_d01_ckw0_noedge_posedge,
                SetupLow => tsetup_d01_ckw0_noedge_posedge,
                HoldLow => thold_d01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d01_ckw0_TimingDatash,
                Violation => tviol_d01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d02_ipd,
                TestSignalName => "d02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d02_ckw0_noedge_posedge,
                HoldHigh => thold_d02_ckw0_noedge_posedge,
                SetupLow => tsetup_d02_ckw0_noedge_posedge,
                HoldLow => thold_d02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d02_ckw0_TimingDatash,
                Violation => tviol_d02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d03_ipd,
                TestSignalName => "d03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d03_ckw0_noedge_posedge,
                HoldHigh => thold_d03_ckw0_noedge_posedge,
                SetupLow => tsetup_d03_ckw0_noedge_posedge,
                HoldLow => thold_d03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d03_ckw0_TimingDatash,
                Violation => tviol_d03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d04_ipd,
                TestSignalName => "d04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d04_ckw0_noedge_posedge,
                HoldHigh => thold_d04_ckw0_noedge_posedge,
                SetupLow => tsetup_d04_ckw0_noedge_posedge,
                HoldLow => thold_d04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d04_ckw0_TimingDatash,
                Violation => tviol_d04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d05_ipd,
                TestSignalName => "d05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d05_ckw0_noedge_posedge,
                HoldHigh => thold_d05_ckw0_noedge_posedge,
                SetupLow => tsetup_d05_ckw0_noedge_posedge,
                HoldLow => thold_d05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d05_ckw0_TimingDatash,
                Violation => tviol_d05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d06_ipd,
                TestSignalName => "d06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d06_ckw0_noedge_posedge,
                HoldHigh => thold_d06_ckw0_noedge_posedge,
                SetupLow => tsetup_d06_ckw0_noedge_posedge,
                HoldLow => thold_d06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d06_ckw0_TimingDatash,
                Violation => tviol_d06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d07_ipd,
                TestSignalName => "d07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d07_ckw0_noedge_posedge,
                HoldHigh => thold_d07_ckw0_noedge_posedge,
                SetupLow => tsetup_d07_ckw0_noedge_posedge,
                HoldLow => thold_d07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d07_ckw0_TimingDatash,
                Violation => tviol_d07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d08_ipd,
                TestSignalName => "d08",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d08_ckw0_noedge_posedge,
                HoldHigh => thold_d08_ckw0_noedge_posedge,
                SetupLow => tsetup_d08_ckw0_noedge_posedge,
                HoldLow => thold_d08_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d08_ckw0_TimingDatash,
                Violation => tviol_d08,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d09_ipd,
                TestSignalName => "d09",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d09_ckw0_noedge_posedge,
                HoldHigh => thold_d09_ckw0_noedge_posedge,
                SetupLow => tsetup_d09_ckw0_noedge_posedge,
                HoldLow => thold_d09_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d09_ckw0_TimingDatash,
                Violation => tviol_d09,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d010_ipd,
                TestSignalName => "d010",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d010_ckw0_noedge_posedge,
                HoldHigh => thold_d010_ckw0_noedge_posedge,
                SetupLow => tsetup_d010_ckw0_noedge_posedge,
                HoldLow => thold_d010_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d010_ckw0_TimingDatash,
                Violation => tviol_d010,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d011_ipd,
                TestSignalName => "d011",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d011_ckw0_noedge_posedge,
                HoldHigh => thold_d011_ckw0_noedge_posedge,
                SetupLow => tsetup_d011_ckw0_noedge_posedge,
                HoldLow => thold_d011_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d011_ckw0_TimingDatash,
                Violation => tviol_d011,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d012_ipd,
                TestSignalName => "d012",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d012_ckw0_noedge_posedge,
                HoldHigh => thold_d012_ckw0_noedge_posedge,
                SetupLow => tsetup_d012_ckw0_noedge_posedge,
                HoldLow => thold_d012_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d012_ckw0_TimingDatash,
                Violation => tviol_d012,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d013_ipd,
                TestSignalName => "d013",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d013_ckw0_noedge_posedge,
                HoldHigh => thold_d013_ckw0_noedge_posedge,
                SetupLow => tsetup_d013_ckw0_noedge_posedge,
                HoldLow => thold_d013_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d013_ckw0_TimingDatash,
                Violation => tviol_d013,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d014_ipd,
                TestSignalName => "d014",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d014_ckw0_noedge_posedge,
                HoldHigh => thold_d014_ckw0_noedge_posedge,
                SetupLow => tsetup_d014_ckw0_noedge_posedge,
                HoldLow => thold_d014_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d014_ckw0_TimingDatash,
                Violation => tviol_d014,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d015_ipd,
                TestSignalName => "d015",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_d015_ckw0_noedge_posedge,
                HoldHigh => thold_d015_ckw0_noedge_posedge,
                SetupLow => tsetup_d015_ckw0_noedge_posedge,
                HoldLow => thold_d015_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d015_ckw0_TimingDatash,
                Violation => tviol_d015,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csw0_ipd,
                TestSignalName => "csw0",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_csw0_ckw0_noedge_posedge,
                HoldHigh => thold_csw0_ckw0_noedge_posedge,
                SetupLow => tsetup_csw0_ckw0_noedge_posedge,
                HoldLow => thold_csw0_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csw0_ckw0_TimingDatash,
                Violation => tviol_csw0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw10_ipd,
                TestSignalName => "aw10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw10_ckw1_noedge_posedge,
                HoldHigh => thold_aw10_ckw1_noedge_posedge,
                SetupLow => tsetup_aw10_ckw1_noedge_posedge,
                HoldLow => thold_aw10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw10_ckw1_TimingDatash,
                Violation => tviol_aw10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw11_ipd,
                TestSignalName => "aw11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw11_ckw1_noedge_posedge,
                HoldHigh => thold_aw11_ckw1_noedge_posedge,
                SetupLow => tsetup_aw11_ckw1_noedge_posedge,
                HoldLow => thold_aw11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw11_ckw1_TimingDatash,
                Violation => tviol_aw11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw12_ipd,
                TestSignalName => "aw12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw12_ckw1_noedge_posedge,
                HoldHigh => thold_aw12_ckw1_noedge_posedge,
                SetupLow => tsetup_aw12_ckw1_noedge_posedge,
                HoldLow => thold_aw12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw12_ckw1_TimingDatash,
                Violation => tviol_aw12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw13_ipd,
                TestSignalName => "aw13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw13_ckw1_noedge_posedge,
                HoldHigh => thold_aw13_ckw1_noedge_posedge,
                SetupLow => tsetup_aw13_ckw1_noedge_posedge,
                HoldLow => thold_aw13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw13_ckw1_TimingDatash,
                Violation => tviol_aw13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw14_ipd,
                TestSignalName => "aw14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw14_ckw1_noedge_posedge,
                HoldHigh => thold_aw14_ckw1_noedge_posedge,
                SetupLow => tsetup_aw14_ckw1_noedge_posedge,
                HoldLow => thold_aw14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw14_ckw1_TimingDatash,
                Violation => tviol_aw14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw15_ipd,
                TestSignalName => "aw15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw15_ckw1_noedge_posedge,
                HoldHigh => thold_aw15_ckw1_noedge_posedge,
                SetupLow => tsetup_aw15_ckw1_noedge_posedge,
                HoldLow => thold_aw15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw15_ckw1_TimingDatash,
                Violation => tviol_aw15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw16_ipd,
                TestSignalName => "aw16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw16_ckw1_noedge_posedge,
                HoldHigh => thold_aw16_ckw1_noedge_posedge,
                SetupLow => tsetup_aw16_ckw1_noedge_posedge,
                HoldLow => thold_aw16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw16_ckw1_TimingDatash,
                Violation => tviol_aw16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw17_ipd,
                TestSignalName => "aw17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw17_ckw1_noedge_posedge,
                HoldHigh => thold_aw17_ckw1_noedge_posedge,
                SetupLow => tsetup_aw17_ckw1_noedge_posedge,
                HoldLow => thold_aw17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw17_ckw1_TimingDatash,
                Violation => tviol_aw17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => aw18_ipd,
                TestSignalName => "aw18",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_aw18_ckw1_noedge_posedge,
                HoldHigh => thold_aw18_ckw1_noedge_posedge,
                SetupLow => tsetup_aw18_ckw1_noedge_posedge,
                HoldLow => thold_aw18_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => aw18_ckw1_TimingDatash,
                Violation => tviol_aw18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d10_ipd,
                TestSignalName => "d10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d10_ckw1_noedge_posedge,
                HoldHigh => thold_d10_ckw1_noedge_posedge,
                SetupLow => tsetup_d10_ckw1_noedge_posedge,
                HoldLow => thold_d10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d10_ckw1_TimingDatash,
                Violation => tviol_d10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d11_ipd,
                TestSignalName => "d11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d11_ckw1_noedge_posedge,
                HoldHigh => thold_d11_ckw1_noedge_posedge,
                SetupLow => tsetup_d11_ckw1_noedge_posedge,
                HoldLow => thold_d11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d11_ckw1_TimingDatash,
                Violation => tviol_d11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d12_ipd,
                TestSignalName => "d12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d12_ckw1_noedge_posedge,
                HoldHigh => thold_d12_ckw1_noedge_posedge,
                SetupLow => tsetup_d12_ckw1_noedge_posedge,
                HoldLow => thold_d12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d12_ckw1_TimingDatash,
                Violation => tviol_d12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d13_ipd,
                TestSignalName => "d13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d13_ckw1_noedge_posedge,
                HoldHigh => thold_d13_ckw1_noedge_posedge,
                SetupLow => tsetup_d13_ckw1_noedge_posedge,
                HoldLow => thold_d13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d13_ckw1_TimingDatash,
                Violation => tviol_d13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d14_ipd,
                TestSignalName => "d14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d14_ckw1_noedge_posedge,
                HoldHigh => thold_d14_ckw1_noedge_posedge,
                SetupLow => tsetup_d14_ckw1_noedge_posedge,
                HoldLow => thold_d14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d14_ckw1_TimingDatash,
                Violation => tviol_d14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d15_ipd,
                TestSignalName => "d15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d15_ckw1_noedge_posedge,
                HoldHigh => thold_d15_ckw1_noedge_posedge,
                SetupLow => tsetup_d15_ckw1_noedge_posedge,
                HoldLow => thold_d15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d15_ckw1_TimingDatash,
                Violation => tviol_d15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d16_ipd,
                TestSignalName => "d16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d16_ckw1_noedge_posedge,
                HoldHigh => thold_d16_ckw1_noedge_posedge,
                SetupLow => tsetup_d16_ckw1_noedge_posedge,
                HoldLow => thold_d16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d16_ckw1_TimingDatash,
                Violation => tviol_d16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d17_ipd,
                TestSignalName => "d17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d17_ckw1_noedge_posedge,
                HoldHigh => thold_d17_ckw1_noedge_posedge,
                SetupLow => tsetup_d17_ckw1_noedge_posedge,
                HoldLow => thold_d17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d17_ckw1_TimingDatash,
                Violation => tviol_d17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d18_ipd,
                TestSignalName => "d18",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d18_ckw1_noedge_posedge,
                HoldHigh => thold_d18_ckw1_noedge_posedge,
                SetupLow => tsetup_d18_ckw1_noedge_posedge,
                HoldLow => thold_d18_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d18_ckw1_TimingDatash,
                Violation => tviol_d18,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d19_ipd,
                TestSignalName => "d19",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d19_ckw1_noedge_posedge,
                HoldHigh => thold_d19_ckw1_noedge_posedge,
                SetupLow => tsetup_d19_ckw1_noedge_posedge,
                HoldLow => thold_d19_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d19_ckw1_TimingDatash,
                Violation => tviol_d19,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d110_ipd,
                TestSignalName => "d110",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d110_ckw1_noedge_posedge,
                HoldHigh => thold_d110_ckw1_noedge_posedge,
                SetupLow => tsetup_d110_ckw1_noedge_posedge,
                HoldLow => thold_d110_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d110_ckw1_TimingDatash,
                Violation => tviol_d110,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d111_ipd,
                TestSignalName => "d111",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d111_ckw1_noedge_posedge,
                HoldHigh => thold_d111_ckw1_noedge_posedge,
                SetupLow => tsetup_d111_ckw1_noedge_posedge,
                HoldLow => thold_d111_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d111_ckw1_TimingDatash,
                Violation => tviol_d111,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d112_ipd,
                TestSignalName => "d112",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d112_ckw1_noedge_posedge,
                HoldHigh => thold_d112_ckw1_noedge_posedge,
                SetupLow => tsetup_d112_ckw1_noedge_posedge,
                HoldLow => thold_d112_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d112_ckw1_TimingDatash,
                Violation => tviol_d112,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d113_ipd,
                TestSignalName => "d113",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d113_ckw1_noedge_posedge,
                HoldHigh => thold_d113_ckw1_noedge_posedge,
                SetupLow => tsetup_d113_ckw1_noedge_posedge,
                HoldLow => thold_d113_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d113_ckw1_TimingDatash,
                Violation => tviol_d113,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d114_ipd,
                TestSignalName => "d114",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d114_ckw1_noedge_posedge,
                HoldHigh => thold_d114_ckw1_noedge_posedge,
                SetupLow => tsetup_d114_ckw1_noedge_posedge,
                HoldLow => thold_d114_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d114_ckw1_TimingDatash,
                Violation => tviol_d114,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d115_ipd,
                TestSignalName => "d115",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_d115_ckw1_noedge_posedge,
                HoldHigh => thold_d115_ckw1_noedge_posedge,
                SetupLow => tsetup_d115_ckw1_noedge_posedge,
                HoldLow => thold_d115_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d115_ckw1_TimingDatash,
                Violation => tviol_d115,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => csw1_ipd,
                TestSignalName => "csw1",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_csw1_ckw1_noedge_posedge,
                HoldHigh => thold_csw1_ckw1_noedge_posedge,
                SetupLow => tsetup_csw1_ckw1_noedge_posedge,
                HoldLow => thold_csw1_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => csw1_ckw1_TimingDatash,
                Violation => tviol_csw1,
                MsgSeverity => warning);

   END IF;

   ------------------------
   -- functionality section
   ------------------------
        p_zd := q;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => p0, OutSignalName => "p0", OutTemp => p_zd(0),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p0,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p0, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p0, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p0, TRUE)),
        GlitchData => p0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p1, OutSignalName => "p1", OutTemp => p_zd(1),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p1,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p1, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p1, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p1, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p1, TRUE)),
        GlitchData => p1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p2, OutSignalName => "p2", OutTemp => p_zd(2),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p2,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p2, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p2, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p2, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p2, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p2, TRUE)),
        GlitchData => p2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p3, OutSignalName => "p3", OutTemp => p_zd(3),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p3,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p3, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p3, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p3, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p3, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p3, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p3, TRUE)),
        GlitchData => p3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p4, OutSignalName => "p4", OutTemp => p_zd(4),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p4,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p4, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p4, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p4, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p4, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p4, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p4, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p4, TRUE)),
        GlitchData => p4_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p5, OutSignalName => "p5", OutTemp => p_zd(5),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p5,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p5, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p5, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p5, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p5, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p5, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p5, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p5, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p5, TRUE)),
        GlitchData => p5_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p6, OutSignalName => "p6", OutTemp => p_zd(6),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p6,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p6, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p6, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p6, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p6, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p6, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p6, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p6, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p6, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p6, TRUE)),
        GlitchData => p6_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p7, OutSignalName => "p7", OutTemp => p_zd(7),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p7,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p7, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p7, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p7, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p7, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p7, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p7, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p7, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p7, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p7, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p7, TRUE)),
        GlitchData => p7_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p8, OutSignalName => "p8", OutTemp => p_zd(8),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p8,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p8, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p8, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p8, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p8, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p8, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p8, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p8, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p8, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p8, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p8, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p8, TRUE)),
        GlitchData => p8_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p9, OutSignalName => "p9", OutTemp => p_zd(9),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p9,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p9, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p9, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p9, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p9, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p9, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p9, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p9, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p9, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p9, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p9, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p9, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p9, TRUE)),
        GlitchData => p9_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p10, OutSignalName => "p10", OutTemp => p_zd(10),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p10,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p10, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p10, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p10, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p10, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p10, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p10, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p10, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p10, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p10, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p10, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p10, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p10, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p10, TRUE)),
        GlitchData => p10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p11, OutSignalName => "p11", OutTemp => p_zd(11),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p11,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p11, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p11, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p11, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p11, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p11, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p11, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p11, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p11, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p11, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p11, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p11, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p11, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p11, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p11, TRUE)),
        GlitchData => p11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p12, OutSignalName => "p12", OutTemp => p_zd(12),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p12,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p12, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p12, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p12, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p12, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p12, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p12, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p12, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p12, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p12, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p12, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p12, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p12, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p12, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p12, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p12, TRUE)),
        GlitchData => p12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p13, OutSignalName => "p13", OutTemp => p_zd(13),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p13,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p13, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p13, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p13, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p13, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p13, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p13, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p13, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p13, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p13, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p13, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p13, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p13, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p13, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p13, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p13, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p13, TRUE)),
        GlitchData => p13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p14, OutSignalName => "p14", OutTemp => p_zd(14),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p14,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p14, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p14, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p14, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p14, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p14, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p14, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p14, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p14, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p14, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p14, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p14, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p14, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p14, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p14, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p14, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p14, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p14, TRUE)),
        GlitchData => p14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p15, OutSignalName => "p15", OutTemp => p_zd(15),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p15,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p15, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p15, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p15, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p15, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p15, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p15, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p15, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p15, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p15, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p15, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p15, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p15, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p15, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p15, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p15, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p15, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p15, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p15, TRUE)),
        GlitchData => p15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p16, OutSignalName => "p16", OutTemp => p_zd(16),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p16,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p16, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p16, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p16, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p16, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p16, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p16, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p16, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p16, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p16, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p16, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p16, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p16, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p16, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p16, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p16, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p16, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p16, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p16, TRUE)),
        GlitchData => p16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p17, OutSignalName => "p17", OutTemp => p_zd(17),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p17,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p17, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p17, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p17, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p17, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p17, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p17, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p17, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p17, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p17, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p17, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p17, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p17, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p17, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p17, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p17, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p17, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p17, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p17, TRUE)),
        GlitchData => p17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p18, OutSignalName => "p18", OutTemp => p_zd(18),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p18,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p18, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p18, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p18, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p18, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p18, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p18, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p18, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p18, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p18, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p18, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p18, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p18, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p18, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p18, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p18, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p18, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p18, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p18, TRUE)),
        GlitchData => p18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p18, OutSignalName => "p18", OutTemp => p_zd(18),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p18,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p18, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p18, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p18, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p18, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p18, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p18, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p18, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p18, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p18, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p18, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p18, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p18, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p18, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p18, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p18, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p18, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p18, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p18, TRUE)),
        GlitchData => p18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p19, OutSignalName => "p19", OutTemp => p_zd(19),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p19,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p19, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p19, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p19, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p19, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p19, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p19, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p19, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p19, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p19, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p19, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p19, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p19, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p19, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p19, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p19, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p19, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p19, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p19, TRUE)),
        GlitchData => p19_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p20, OutSignalName => "p20", OutTemp => p_zd(20),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p20,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p20, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p20, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p20, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p20, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p20, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p20, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p20, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p20, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p20, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p20, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p20, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p20, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p20, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p20, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p20, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p20, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p20, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p20, TRUE)),
        GlitchData => p20_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p21, OutSignalName => "p21", OutTemp => p_zd(21),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p21,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p21, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p21, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p21, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p21, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p21, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p21, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p21, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p21, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p21, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p21, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p21, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p21, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p21, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p21, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p21, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p21, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p21, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p21, TRUE)),
        GlitchData => p21_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p22, OutSignalName => "p22", OutTemp => p_zd(22),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p22,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p22, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p22, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p22, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p22, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p22, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p22, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p22, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p22, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p22, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p22, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p22, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p22, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p22, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p22, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p22, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p22, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p22, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p22, TRUE)),
        GlitchData => p22_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p23, OutSignalName => "p23", OutTemp => p_zd(23),
        Paths      => (0 => (InputChangeTime => m0_ipd'last_event,
                             PathDelay => tpd_m0_p23,
                             PathCondition => TRUE),
                       1 => (mck_ipd'last_event, tpd_mck_p23, TRUE),
                       2 => (ckw0_ipd'last_event, tpd_ckw0_p23, TRUE),
                       3 => (ckw1_ipd'last_event, tpd_ckw1_p23, TRUE),
                       4 => (m1_ipd'last_event, tpd_m1_p23, TRUE),
                       5 => (m2_ipd'last_event, tpd_m2_p23, TRUE),
                       6 => (m3_ipd'last_event, tpd_m3_p23, TRUE),
                       7 => (m4_ipd'last_event, tpd_m4_p23, TRUE),
                       8 => (m5_ipd'last_event, tpd_m5_p23, TRUE),
                       9 => (m6_ipd'last_event, tpd_m6_p23, TRUE),
                      10 => (m7_ipd'last_event, tpd_m7_p23, TRUE),
                      11 => (m8_ipd'last_event, tpd_m8_p23, TRUE),
                      12 => (m9_ipd'last_event, tpd_m9_p23, TRUE),
                      13 => (m10_ipd'last_event, tpd_m10_p23, TRUE),
                      14 => (m11_ipd'last_event, tpd_m11_p23, TRUE),
                      15 => (m12_ipd'last_event, tpd_m12_p23, TRUE),
                      16 => (m13_ipd'last_event, tpd_m13_p23, TRUE),
                      17 => (m14_ipd'last_event, tpd_m14_p23, TRUE),
                      18 => (m15_ipd'last_event, tpd_m15_p23, TRUE)),
        GlitchData => p23_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );

   END PROCESS;

END V;


--
-----cell mult8x8----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use ieee.std_logic_unsigned.all;
use work.mem3.all;

-- entity declaration --
ENTITY mult8x8 IS
   GENERIC (
        MULTMODE                   : String  := "NOREG";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "mult8x8";

        -- input SIGNAL delays
        tipd_a7   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a6   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a5   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a4   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a3   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a2   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a1   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_a0   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b7   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b6   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b5   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b4   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b3   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b2   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b1   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_b0   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ck   : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_en   : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_a7_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a7_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a6_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a5_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a4_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a3_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a2_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a1_p1         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p1         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_a0_p0         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b7_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b6_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b5_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b4_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b3_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b2_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b1_p1         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p1         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_b0_p0         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p15        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p14        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p13        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p12        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p11        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p10        : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p9         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p8         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p7         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p6         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p5         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p4         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p3         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p2         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p1         : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ck_p0         : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_a7_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a7_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a6_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a6_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a5_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a5_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a4_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a4_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a3_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a3_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a2_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a2_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a1_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a1_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_a0_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_a0_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b7_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b7_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b6_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b6_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b5_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b5_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b4_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b4_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b3_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b3_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b2_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b2_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b1_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b1_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_b0_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_b0_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
        tsetup_en_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
        thold_en_ck_noedge_posedge    : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ck            : VitalDelayType := 0.01 ns;
        tpw_ck_posedge        : VitalDelayType := 0.01 ns;
        tpw_ck_negedge        : VitalDelayType := 0.01 ns);

   PORT(
        a7, a6, a5, a4, a3, a2, a1, a0         : in std_logic ;
        b7, b6, b5, b4, b3, b2, b1, b0         : in std_logic ;
        ck, en                                 : in std_logic ;
        p15, p14, p13, p12, p11, p10, p9       : out std_logic ;
        p8, p7, p6, p5, p4, p3, p2, p1, p0     : out std_logic );

      ATTRIBUTE Vital_Level0 OF mult8x8 : ENTITY IS TRUE;

END mult8x8 ;

-- ARCHITECTURE body --
ARCHITECTURE V OF mult8x8 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL mode_reg    : String(MULTMODE'length downto 1);

    SIGNAL a7_ipd    : std_logic := '0';
    SIGNAL a6_ipd    : std_logic := '0';
    SIGNAL a5_ipd    : std_logic := '0';
    SIGNAL a4_ipd    : std_logic := '0';
    SIGNAL a3_ipd    : std_logic := '0';
    SIGNAL a2_ipd    : std_logic := '0';
    SIGNAL a1_ipd    : std_logic := '0';
    SIGNAL a0_ipd    : std_logic := '0';
    SIGNAL b7_ipd    : std_logic := '0';
    SIGNAL b6_ipd    : std_logic := '0';
    SIGNAL b5_ipd    : std_logic := '0';
    SIGNAL b4_ipd    : std_logic := '0';
    SIGNAL b3_ipd    : std_logic := '0';
    SIGNAL b2_ipd    : std_logic := '0';
    SIGNAL b1_ipd    : std_logic := '0';
    SIGNAL b0_ipd    : std_logic := '0';
    SIGNAL ck_ipd    : std_logic := 'X';
    SIGNAL en_ipd    : std_logic := 'X';
    SIGNAL en_reg    : std_logic := 'X';
    SIGNAL ar_int    : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL br_int    : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL ar_reg    : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL br_reg    : std_logic_vector(7 downto 0) := "00000000";
    SIGNAL p_int     : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL p_reg     : std_logic_vector(15 downto 0) := "0000000000000000";

BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(a7_ipd, a7, tipd_a7);
   VitalWireDelay(a6_ipd, a6, tipd_a6);
   VitalWireDelay(a5_ipd, a5, tipd_a5);
   VitalWireDelay(a4_ipd, a4, tipd_a4);
   VitalWireDelay(a3_ipd, a3, tipd_a3);
   VitalWireDelay(a2_ipd, a2, tipd_a2);
   VitalWireDelay(a1_ipd, a1, tipd_a1);
   VitalWireDelay(a0_ipd, a0, tipd_a0);
   VitalWireDelay(b7_ipd, b7, tipd_b7);
   VitalWireDelay(b6_ipd, b6, tipd_b6);
   VitalWireDelay(b5_ipd, b5, tipd_b5);
   VitalWireDelay(b4_ipd, b4, tipd_b4);
   VitalWireDelay(b3_ipd, b3, tipd_b3);
   VitalWireDelay(b2_ipd, b2, tipd_b2);
   VitalWireDelay(b1_ipd, b1, tipd_b1);
   VitalWireDelay(b0_ipd, b0, tipd_b0);
   VitalWireDelay(ck_ipd, ck, tipd_ck);
   VitalWireDelay(en_ipd, en, tipd_en);
   END BLOCK;

   mode_reg <= MULTMODE;
   ar_int <= (a7_ipd, a6_ipd, a5_ipd, a4_ipd, a3_ipd, a2_ipd, a1_ipd, a0_ipd);
   br_int <= (b7_ipd, b6_ipd, b5_ipd, b4_ipd, b3_ipd, b2_ipd, b1_ipd, b0_ipd);

----------------------------------------------------------------
-- Register Enable signal
----------------------------------------------------------------
   REG_EN : PROCESS (ck_ipd)
   BEGIN
      IF (mode_reg = "IOREG") THEN
         IF (ck_ipd'event and ck_ipd = '1') THEN
            en_reg <= en_ipd;
         END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- INREG and IOREG read operation
----------------------------------------------------------------
   REG : PROCESS (ck_ipd, ar_int, br_int)
   BEGIN
      IF (mode_reg = "INREG" or mode_reg = "IOREG") THEN
         IF (ck_ipd'event and ck_ipd = '1') THEN
           IF (en_ipd = '1') THEN
              ar_reg <= ar_int;
              br_reg <= br_int;
           END IF;
         END IF;
      ELSE
         ar_reg <= ar_int;
         br_reg <= br_int;
      END IF;
   END PROCESS;

   p_int <= (ar_reg * br_reg);

----------------------------------------------------------------
-- OUTREG and IOREG read operation
----------------------------------------------------------------
   OUTREG_READ : PROCESS (ck_ipd, p_int)
   BEGIN
      IF (mode_reg = "IOREG") THEN
         IF (ck_ipd'event and ck_ipd = '1') THEN
           IF (en_reg = '1') THEN
              p_reg <= p_int;
           END IF;
         END IF;
      ELSIF (mode_reg = "OUTREG") THEN
         IF (ck_ipd'event and ck_ipd = '1') THEN
           IF (en_ipd = '1') THEN
              p_reg <= p_int;
           END IF;
         END IF;
      ELSE
         p_reg <= p_int;
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (p_reg)
     VARIABLE p_zd   : std_logic_vector(15 downto 0);

     -- timing check results
        VARIABLE tviol_a0     : x01 := '0';
        VARIABLE tviol_a1     : x01 := '0';
        VARIABLE tviol_a2     : x01 := '0';
        VARIABLE tviol_a3     : x01 := '0';
        VARIABLE tviol_a4     : x01 := '0';
        VARIABLE tviol_a5     : x01 := '0';
        VARIABLE tviol_a6     : x01 := '0';
        VARIABLE tviol_a7     : x01 := '0';
        VARIABLE tviol_b0     : x01 := '0';
        VARIABLE tviol_b1     : x01 := '0';
        VARIABLE tviol_b2     : x01 := '0';
        VARIABLE tviol_b3     : x01 := '0';
        VARIABLE tviol_b4     : x01 := '0';
        VARIABLE tviol_b5     : x01 := '0';
        VARIABLE tviol_b6     : x01 := '0';
        VARIABLE tviol_b7     : x01 := '0';
        VARIABLE tviol_en     : x01 := '0';

        VARIABLE a0_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a1_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a2_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a3_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a4_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a5_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a6_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE a7_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b0_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b1_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b2_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b3_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b4_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b5_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b6_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE b7_ck_TimingDatash     : VitalTimingDataType;
        VARIABLE en_ck_TimingDatash     : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE p0_GlitchData   :   VitalGlitchDataType;
        VARIABLE p1_GlitchData   :   VitalGlitchDataType;
        VARIABLE p2_GlitchData   :   VitalGlitchDataType;
        VARIABLE p3_GlitchData   :   VitalGlitchDataType;
        VARIABLE p4_GlitchData   :   VitalGlitchDataType;
        VARIABLE p5_GlitchData   :   VitalGlitchDataType;
        VARIABLE p6_GlitchData   :   VitalGlitchDataType;
        VARIABLE p7_GlitchData   :   VitalGlitchDataType;
        VARIABLE p8_GlitchData   :   VitalGlitchDataType;
        VARIABLE p9_GlitchData   :   VitalGlitchDataType;
        VARIABLE p10_GlitchData  :   VitalGlitchDataType;
        VARIABLE p11_GlitchData  :   VitalGlitchDataType;
        VARIABLE p12_GlitchData  :   VitalGlitchDataType;
        VARIABLE p13_GlitchData  :   VitalGlitchDataType;
        VARIABLE p14_GlitchData  :   VitalGlitchDataType;
        VARIABLE p15_GlitchData  :   VitalGlitchDataType;

    BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => a0_ipd,
                TestSignalName => "a0",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a0_ck_noedge_posedge,
                HoldHigh => thold_a0_ck_noedge_posedge,
                SetupLow => tsetup_a0_ck_noedge_posedge,
                HoldLow => thold_a0_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a0_ck_TimingDatash,
                Violation => tviol_a0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a1_ipd,
                TestSignalName => "a1",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a1_ck_noedge_posedge,
                HoldHigh => thold_a1_ck_noedge_posedge,
                SetupLow => tsetup_a1_ck_noedge_posedge,
                HoldLow => thold_a1_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a1_ck_TimingDatash,
                Violation => tviol_a1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a2_ipd,
                TestSignalName => "a2",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a2_ck_noedge_posedge,
                HoldHigh => thold_a2_ck_noedge_posedge,
                SetupLow => tsetup_a2_ck_noedge_posedge,
                HoldLow => thold_a2_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a2_ck_TimingDatash,
                Violation => tviol_a2,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a3_ipd,
                TestSignalName => "a3",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a3_ck_noedge_posedge,
                HoldHigh => thold_a3_ck_noedge_posedge,
                SetupLow => tsetup_a3_ck_noedge_posedge,
                HoldLow => thold_a3_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a3_ck_TimingDatash,
                Violation => tviol_a3,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a4_ipd,
                TestSignalName => "a4",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a4_ck_noedge_posedge,
                HoldHigh => thold_a4_ck_noedge_posedge,
                SetupLow => tsetup_a4_ck_noedge_posedge,
                HoldLow => thold_a4_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a4_ck_TimingDatash,
                Violation => tviol_a4,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a5_ipd,
                TestSignalName => "a5",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a5_ck_noedge_posedge,
                HoldHigh => thold_a5_ck_noedge_posedge,
                SetupLow => tsetup_a5_ck_noedge_posedge,
                HoldLow => thold_a5_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a5_ck_TimingDatash,
                Violation => tviol_a5,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a6_ipd,
                TestSignalName => "a6",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a6_ck_noedge_posedge,
                HoldHigh => thold_a6_ck_noedge_posedge,
                SetupLow => tsetup_a6_ck_noedge_posedge,
                HoldLow => thold_a6_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a6_ck_TimingDatash,
                Violation => tviol_a6,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => a7_ipd,
                TestSignalName => "a7",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_a7_ck_noedge_posedge,
                HoldHigh => thold_a7_ck_noedge_posedge,
                SetupLow => tsetup_a7_ck_noedge_posedge,
                HoldLow => thold_a7_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => a7_ck_TimingDatash,
                Violation => tviol_a7,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b0_ipd,
                TestSignalName => "b0",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b0_ck_noedge_posedge,
                HoldHigh => thold_b0_ck_noedge_posedge,
                SetupLow => tsetup_b0_ck_noedge_posedge,
                HoldLow => thold_b0_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b0_ck_TimingDatash,
                Violation => tviol_b0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b1_ipd,
                TestSignalName => "b1",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b1_ck_noedge_posedge,
                HoldHigh => thold_b1_ck_noedge_posedge,
                SetupLow => tsetup_b1_ck_noedge_posedge,
                HoldLow => thold_b1_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b1_ck_TimingDatash,
                Violation => tviol_b1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b2_ipd,
                TestSignalName => "b2",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b2_ck_noedge_posedge,
                HoldHigh => thold_b2_ck_noedge_posedge,
                SetupLow => tsetup_b2_ck_noedge_posedge,
                HoldLow => thold_b2_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b2_ck_TimingDatash,
                Violation => tviol_b2,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b3_ipd,
                TestSignalName => "b3",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b3_ck_noedge_posedge,
                HoldHigh => thold_b3_ck_noedge_posedge,
                SetupLow => tsetup_b3_ck_noedge_posedge,
                HoldLow => thold_b3_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b3_ck_TimingDatash,
                Violation => tviol_b3,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b4_ipd,
                TestSignalName => "b4",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b4_ck_noedge_posedge,
                HoldHigh => thold_b4_ck_noedge_posedge,
                SetupLow => tsetup_b4_ck_noedge_posedge,
                HoldLow => thold_b4_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b4_ck_TimingDatash,
                Violation => tviol_b4,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b5_ipd,
                TestSignalName => "b5",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b5_ck_noedge_posedge,
                HoldHigh => thold_b5_ck_noedge_posedge,
                SetupLow => tsetup_b5_ck_noedge_posedge,
                HoldLow => thold_b5_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b5_ck_TimingDatash,
                Violation => tviol_b5,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b6_ipd,
                TestSignalName => "b6",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b6_ck_noedge_posedge,
                HoldHigh => thold_b6_ck_noedge_posedge,
                SetupLow => tsetup_b6_ck_noedge_posedge,
                HoldLow => thold_b6_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b6_ck_TimingDatash,
                Violation => tviol_b6,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => b7_ipd,
                TestSignalName => "b7",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_b7_ck_noedge_posedge,
                HoldHigh => thold_b7_ck_noedge_posedge,
                SetupLow => tsetup_b7_ck_noedge_posedge,
                HoldLow => thold_b7_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => b7_ck_TimingDatash,
                Violation => tviol_b7,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => en_ipd,
                TestSignalName => "en",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_en_ck_noedge_posedge,
                HoldHigh => thold_en_ck_noedge_posedge,
                SetupLow => tsetup_en_ck_noedge_posedge,
                HoldLow => thold_en_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => en_ck_TimingDatash,
                Violation => tviol_en,
                MsgSeverity => warning);

   END IF;
   ------------------------
   -- functionality section
   ------------------------
        p_zd := p_reg;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => p0, OutSignalName => "p0", OutTemp => p_zd(0),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p0,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p0, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p0, TRUE)),
        GlitchData => p0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p1, OutSignalName => "p1", OutTemp => p_zd(1),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p1,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p1, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p1, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p1, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p1, TRUE)),
        GlitchData => p1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p2, OutSignalName => "p2", OutTemp => p_zd(2),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p2,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p2, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p2, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p2, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p2, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p2, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p2, TRUE)),
        GlitchData => p2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p3, OutSignalName => "p3", OutTemp => p_zd(3),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p3,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p3, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p3, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p3, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p3, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p3, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p3, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p3, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p3, TRUE)),
        GlitchData => p3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p4, OutSignalName => "p4", OutTemp => p_zd(4),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p4,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p4, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p4, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p4, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p4, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p4, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p4, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p4, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p4, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p4, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p4, TRUE)),
        GlitchData => p4_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p5, OutSignalName => "p5", OutTemp => p_zd(5),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p5,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p5, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p5, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p5, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p5, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p5, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p5, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p5, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p5, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p5, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p5, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p5, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p5, TRUE)),
        GlitchData => p5_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p6, OutSignalName => "p6", OutTemp => p_zd(6),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p6,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p6, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p6, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p6, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p6, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p6, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p6, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p6, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p6, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p6, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p6, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p6, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p6, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p6, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p6, TRUE)),
        GlitchData => p6_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p7, OutSignalName => "p7", OutTemp => p_zd(7),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p7,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p7, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p7, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p7, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p7, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p7, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p7, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p7, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p7, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p7, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p7, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p7, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p7, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p7, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p7, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p7, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p7, TRUE)),
        GlitchData => p7_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p8, OutSignalName => "p8", OutTemp => p_zd(8),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p8,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p8, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p8, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p8, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p8, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p8, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p8, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p8, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p8, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p8, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p8, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p8, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p8, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p8, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p8, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p8, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p8, TRUE)),
        GlitchData => p8_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p9, OutSignalName => "p9", OutTemp => p_zd(9),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p9,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p9, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p9, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p9, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p9, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p9, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p9, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p9, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p9, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p9, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p9, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p9, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p9, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p9, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p9, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p9, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p9, TRUE)),
        GlitchData => p9_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p10, OutSignalName => "p10", OutTemp => p_zd(10),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p10,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p10, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p10, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p10, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p10, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p10, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p10, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p10, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p10, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p10, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p10, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p10, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p10, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p10, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p10, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p10, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p10, TRUE)),
        GlitchData => p10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p11, OutSignalName => "p11", OutTemp => p_zd(11),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p11,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p11, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p11, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p11, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p11, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p11, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p11, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p11, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p11, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p11, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p11, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p11, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p11, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p11, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p11, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p11, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p11, TRUE)),
        GlitchData => p11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p12, OutSignalName => "p12", OutTemp => p_zd(12),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p12,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p12, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p12, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p12, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p12, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p12, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p12, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p12, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p12, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p12, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p12, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p12, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p12, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p12, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p12, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p12, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p12, TRUE)),
        GlitchData => p12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p13, OutSignalName => "p13", OutTemp => p_zd(13),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p13,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p13, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p13, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p13, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p13, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p13, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p13, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p13, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p13, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p13, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p13, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p13, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p13, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p13, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p13, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p13, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p13, TRUE)),
        GlitchData => p13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p14, OutSignalName => "p14", OutTemp => p_zd(14),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p14,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p14, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p14, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p14, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p14, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p14, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p14, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p14, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p14, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p14, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p14, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p14, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p14, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p14, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p14, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p14, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p14, TRUE)),
        GlitchData => p14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => p15, OutSignalName => "p15", OutTemp => p_zd(15),
        Paths      => (0 => (InputChangeTime => a0_ipd'last_event,
                             PathDelay => tpd_a0_p15,
                             PathCondition => TRUE),
                       1 => (ck_ipd'last_event, tpd_ck_p15, TRUE),
                       2 => (b0_ipd'last_event, tpd_b0_p15, TRUE),
                       3 => (a1_ipd'last_event, tpd_a1_p15, TRUE),
                       4 => (b1_ipd'last_event, tpd_b1_p15, TRUE),
                       5 => (a2_ipd'last_event, tpd_a2_p15, TRUE),
                       6 => (b2_ipd'last_event, tpd_b2_p15, TRUE),
                       7 => (a3_ipd'last_event, tpd_a3_p15, TRUE),
                       8 => (b3_ipd'last_event, tpd_b3_p15, TRUE),
                       9 => (a4_ipd'last_event, tpd_a4_p15, TRUE),
                      10 => (b4_ipd'last_event, tpd_b4_p15, TRUE),
                      11 => (a5_ipd'last_event, tpd_a5_p15, TRUE),
                      12 => (b5_ipd'last_event, tpd_b5_p15, TRUE),
                      13 => (a6_ipd'last_event, tpd_a6_p15, TRUE),
                      14 => (b6_ipd'last_event, tpd_b6_p15, TRUE),
                      15 => (a7_ipd'last_event, tpd_a7_p15, TRUE),
                      16 => (b7_ipd'last_event, tpd_b7_p15, TRUE)),
        GlitchData => p15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );

   END PROCESS;

END V;



--
-----cell cam2x256x16----
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.vital_timing.all;
use ieee.vital_primitives.all;
use ieee.std_logic_unsigned.all;
use work.mem3.all;

-- entity declaration --
ENTITY cam2x256x16 IS
   GENERIC (
        CAMMODE0                 : String  := "NOREG";
        CAMMODE1                 : String  := "NOREG";

        -- miscellaneous vital GENERICs
        TimingChecksOn  : boolean := TRUE;
        XOn             : boolean := FALSE;
        MsgOn           : boolean := TRUE;
        InstancePath    : string  := "cam2x256x16";

        -- input SIGNAL delays
        tipd_dw07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_cd0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_sm0  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm07 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm06 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm05 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm04 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm03 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm02 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm01 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm00 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr0 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dw10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ad10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_cd1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_sm1  : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_wre1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckw1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm17 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm16 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm15 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm14 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm13 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm12 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm11 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_dm10 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_rde1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
        tipd_ckr1 : VitalDelayType01 := (0.0 ns, 0.0 ns);

        -- propagation delays
        tpd_dm00_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm00_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm01_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm02_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm03_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm04_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm05_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm06_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm07_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q00       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q01       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q02       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q03       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q04       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q05       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q06       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q07       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q08       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q09       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q010      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q011      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q012      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q013      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q014      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr0_q015      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm10_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm11_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm12_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm13_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm14_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm15_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm16_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_dm17_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q10       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q11       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q12       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q13       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q14       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q15       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q16       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q17       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q18       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q19       : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q110      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q111      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q112      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q113      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q114      : VitalDelayType01 := (0.01 ns, 0.01 ns);
        tpd_ckr1_q115      : VitalDelayType01 := (0.01 ns, 0.01 ns);

        -- setup and hold constraints
        tsetup_dw00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw02_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw03_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw04_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw04_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw05_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw05_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw06_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw06_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw07_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw07_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_wre0_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre0_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad00_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad00_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad01_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad01_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad02_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad02_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad03_ckw0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad03_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_cd0_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_cd0_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_sm0_ckw0_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_sm0_ckw0_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_dm00_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm00_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm01_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm01_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm02_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm02_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm03_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm03_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm04_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm04_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm05_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm05_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm06_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm06_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm07_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm07_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde0_ckr0_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde0_ckr0_noedge_posedge  : VitalDelayType := 0.01 ns;

        tsetup_dw10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw12_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw13_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw14_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw14_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw15_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw15_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw16_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw16_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dw17_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dw17_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_wre1_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_wre1_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad10_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad10_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad11_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad11_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad12_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad12_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_ad13_ckw1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_ad13_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_cd1_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_cd1_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_sm1_ckw1_noedge_posedge  : VitalDelayType := 0.01 ns;
        thold_sm1_ckw1_noedge_posedge   : VitalDelayType := 0.01 ns;
        tsetup_dm10_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm10_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm11_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm11_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm12_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm12_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm13_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm13_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm14_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm14_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm15_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm15_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm16_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm16_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_dm17_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_dm17_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;
        tsetup_rde1_ckr1_noedge_posedge : VitalDelayType := 0.01 ns;
        thold_rde1_ckr1_noedge_posedge  : VitalDelayType := 0.01 ns;

        -- pulse width constraints
        tperiod_ckw0            : VitalDelayType := 0.01 ns;
        tpw_ckw0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr0            : VitalDelayType := 0.01 ns;
        tpw_ckr0_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr0_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckw1            : VitalDelayType := 0.01 ns;
        tpw_ckw1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckw1_negedge        : VitalDelayType := 0.01 ns;
        tperiod_ckr1            : VitalDelayType := 0.01 ns;
        tpw_ckr1_posedge        : VitalDelayType := 0.01 ns;
        tpw_ckr1_negedge        : VitalDelayType := 0.01 ns);

   PORT(
        dw17, dw16, dw15, dw14, dw13, dw12, dw11, dw10               : in std_logic ;
        ad13, ad12, ad11, ad10, cd1, sm1, wre1, ckw1                 : in std_logic ;
        dm17, dm16, dm15, dm14, dm13, dm12, dm11, dm10               : in std_logic ;
        rde1, ckr1                                                   : in std_logic ;
        dw07, dw06, dw05, dw04, dw03, dw02, dw01, dw00               : in std_logic ;
        ad03, ad02, ad01, ad00, cd0, sm0, wre0, ckw0                 : in std_logic ;
        dm07, dm06, dm05, dm04, dm03, dm02, dm01, dm00               : in std_logic ;
        rde0, ckr0                                                   : in std_logic ;

        q115, q114, q113, q112, q111, q110, q19, q18                 : out std_logic ;
        q17, q16, q15, q14, q13, q12, q11, q10                       : out std_logic ;
        q015, q014, q013, q012, q011, q010, q09, q08                 : out std_logic ;
        q07, q06, q05, q04, q03, q02, q01, q00                       : out std_logic );

      ATTRIBUTE Vital_Level0 OF cam2x256x16 : ENTITY IS TRUE;

END cam2x256x16;

-- ARCHITECTURE body --
ARCHITECTURE V OF cam2x256x16 IS
    ATTRIBUTE Vital_Level0 OF V : ARCHITECTURE IS TRUE;

--SIGNAL DECLARATIONS----
    SIGNAL mode0_reg   : String(CAMMODE0'length downto 1);
    SIGNAL mode1_reg   : String(CAMMODE1'length downto 1);

    SIGNAL dw07_ipd  : std_logic := 'X';
    SIGNAL dw06_ipd  : std_logic := 'X';
    SIGNAL dw05_ipd  : std_logic := 'X';
    SIGNAL dw04_ipd  : std_logic := 'X';
    SIGNAL dw03_ipd  : std_logic := 'X';
    SIGNAL dw02_ipd  : std_logic := 'X';
    SIGNAL dw01_ipd  : std_logic := 'X';
    SIGNAL dw00_ipd  : std_logic := 'X';
    SIGNAL ad03_ipd  : std_logic := 'X';
    SIGNAL ad02_ipd  : std_logic := 'X';
    SIGNAL ad01_ipd  : std_logic := 'X';
    SIGNAL ad00_ipd  : std_logic := 'X';
    SIGNAL cd0_ipd   : std_logic := 'X';
    SIGNAL sm0_ipd   : std_logic := 'X';
    SIGNAL wre0_ipd  : std_logic := 'X';
    SIGNAL ckw0_ipd  : std_logic := 'X';
    SIGNAL dm07_ipd  : std_logic := 'X';
    SIGNAL dm06_ipd  : std_logic := 'X';
    SIGNAL dm05_ipd  : std_logic := 'X';
    SIGNAL dm04_ipd  : std_logic := 'X';
    SIGNAL dm03_ipd  : std_logic := 'X';
    SIGNAL dm02_ipd  : std_logic := 'X';
    SIGNAL dm01_ipd  : std_logic := 'X';
    SIGNAL dm00_ipd  : std_logic := 'X';
    SIGNAL rde0_ipd  : std_logic := 'X';
    SIGNAL ckr0_ipd  : std_logic := 'X';
    SIGNAL dw17_ipd  : std_logic := 'X';
    SIGNAL dw16_ipd  : std_logic := 'X';
    SIGNAL dw15_ipd  : std_logic := 'X';
    SIGNAL dw14_ipd  : std_logic := 'X';
    SIGNAL dw13_ipd  : std_logic := 'X';
    SIGNAL dw12_ipd  : std_logic := 'X';
    SIGNAL dw11_ipd  : std_logic := 'X';
    SIGNAL dw10_ipd  : std_logic := 'X';
    SIGNAL ad13_ipd  : std_logic := 'X';
    SIGNAL ad12_ipd  : std_logic := 'X';
    SIGNAL ad11_ipd  : std_logic := 'X';
    SIGNAL ad10_ipd  : std_logic := 'X';
    SIGNAL cd1_ipd   : std_logic := 'X';
    SIGNAL sm1_ipd   : std_logic := 'X';
    SIGNAL wre1_ipd  : std_logic := 'X';
    SIGNAL ckw1_ipd  : std_logic := 'X';
    SIGNAL dm17_ipd  : std_logic := 'X';
    SIGNAL dm16_ipd  : std_logic := 'X';
    SIGNAL dm15_ipd  : std_logic := 'X';
    SIGNAL dm14_ipd  : std_logic := 'X';
    SIGNAL dm13_ipd  : std_logic := 'X';
    SIGNAL dm12_ipd  : std_logic := 'X';
    SIGNAL dm11_ipd  : std_logic := 'X';
    SIGNAL dm10_ipd  : std_logic := 'X';
    SIGNAL rde1_ipd  : std_logic := 'X';
    SIGNAL ckr1_ipd  : std_logic := 'X';

    SIGNAL memory1   : mem_type_6(0 to 255) := (others => "0000000000000000");
    SIGNAL memory2   : mem_type_6(0 to 255) := (others => "0000000000000000");
    SIGNAL aw0_tmp   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL aw1_tmp   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL aw0_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL aw1_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL ar0_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL ar1_int   : std_logic_vector(7 downto 0) := "XXXXXXXX";
    SIGNAL d0_int    : std_logic_vector(3 downto 0) := "0000";
    SIGNAL d1_int    : std_logic_vector(3 downto 0) := "0000";
    SIGNAL memchg1   : std_logic := '0';
    SIGNAL memchg2   : std_logic := '0';
    SIGNAL en0_reg   : std_logic := 'X';
    SIGNAL en1_reg   : std_logic := 'X';

    SIGNAL q0_int    : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL q1_int    : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL q0        : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL q1        : std_logic_vector(15 downto 0) := "0000000000000000";
    SIGNAL rad_reg_0 : Integer := 0;
    SIGNAL rad_reg_1 : Integer := 0;

BEGIN

   -----------------------
   -- input path delays
   -----------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay(dw07_ipd, dw07, tipd_dw07);
   VitalWireDelay(dw06_ipd, dw06, tipd_dw06);
   VitalWireDelay(dw05_ipd, dw05, tipd_dw05);
   VitalWireDelay(dw04_ipd, dw04, tipd_dw04);
   VitalWireDelay(dw03_ipd, dw03, tipd_dw03);
   VitalWireDelay(dw02_ipd, dw02, tipd_dw02);
   VitalWireDelay(dw01_ipd, dw01, tipd_dw01);
   VitalWireDelay(dw00_ipd, dw00, tipd_dw00);
   VitalWireDelay(ad03_ipd, ad03, tipd_ad03);
   VitalWireDelay(ad02_ipd, ad02, tipd_ad02);
   VitalWireDelay(ad01_ipd, ad01, tipd_ad01);
   VitalWireDelay(ad00_ipd, ad00, tipd_ad00);
   VitalWireDelay(cd0_ipd, cd0, tipd_cd0);
   VitalWireDelay(sm0_ipd, sm0, tipd_sm0);
   VitalWireDelay(wre0_ipd, wre0, tipd_wre0);
   VitalWireDelay(ckw0_ipd, ckw0, tipd_ckw0);
   VitalWireDelay(dm07_ipd, dm07, tipd_dm07);
   VitalWireDelay(dm06_ipd, dm06, tipd_dm06);
   VitalWireDelay(dm05_ipd, dm05, tipd_dm05);
   VitalWireDelay(dm04_ipd, dm04, tipd_dm04);
   VitalWireDelay(dm03_ipd, dm03, tipd_dm03);
   VitalWireDelay(dm02_ipd, dm02, tipd_dm02);
   VitalWireDelay(dm01_ipd, dm01, tipd_dm01);
   VitalWireDelay(dm00_ipd, dm00, tipd_dm00);
   VitalWireDelay(rde0_ipd, rde0, tipd_rde0);
   VitalWireDelay(ckr0_ipd, ckr0, tipd_ckr0);
   VitalWireDelay(dw17_ipd, dw17, tipd_dw17);
   VitalWireDelay(dw16_ipd, dw16, tipd_dw16);
   VitalWireDelay(dw15_ipd, dw15, tipd_dw15);
   VitalWireDelay(dw14_ipd, dw14, tipd_dw14);
   VitalWireDelay(dw13_ipd, dw13, tipd_dw13);
   VitalWireDelay(dw12_ipd, dw12, tipd_dw12);
   VitalWireDelay(dw11_ipd, dw11, tipd_dw11);
   VitalWireDelay(dw10_ipd, dw10, tipd_dw10);
   VitalWireDelay(ad13_ipd, ad13, tipd_ad13);
   VitalWireDelay(ad12_ipd, ad12, tipd_ad12);
   VitalWireDelay(ad11_ipd, ad11, tipd_ad11);
   VitalWireDelay(ad10_ipd, ad10, tipd_ad10);
   VitalWireDelay(cd1_ipd, cd1, tipd_cd1);
   VitalWireDelay(sm1_ipd, sm1, tipd_sm1);
   VitalWireDelay(wre1_ipd, wre1, tipd_wre1);
   VitalWireDelay(ckw1_ipd, ckw1, tipd_ckw1);
   VitalWireDelay(dm17_ipd, dm17, tipd_dm17);
   VitalWireDelay(dm16_ipd, dm16, tipd_dm16);
   VitalWireDelay(dm15_ipd, dm15, tipd_dm15);
   VitalWireDelay(dm14_ipd, dm14, tipd_dm14);
   VitalWireDelay(dm13_ipd, dm13, tipd_dm13);
   VitalWireDelay(dm12_ipd, dm12, tipd_dm12);
   VitalWireDelay(dm11_ipd, dm11, tipd_dm11);
   VitalWireDelay(dm10_ipd, dm10, tipd_dm10);
   VitalWireDelay(rde1_ipd, rde1, tipd_rde1);
   VitalWireDelay(ckr1_ipd, ckr1, tipd_ckr1);
   END BLOCK;

   mode0_reg <= CAMMODE0;
   mode1_reg <= CAMMODE1;

----------------------------------------------------------------
-- Port0 and Port1 clear write-address and data
----------------------------------------------------------------
   CLEAR_AD : PROCESS (cd0_ipd, aw0_tmp, aw1_tmp, cd1_ipd)
   BEGIN
        IF (cd0_ipd = '1') THEN
           aw0_int <= "00000000";
        ELSE
           aw0_int <= aw0_tmp;
        END IF;
        IF (cd1_ipd = '1') THEN
           aw1_int <= "00000000";
        ELSE
           aw1_int <= aw1_tmp;
        END IF;
   END PROCESS;

   aw0_tmp <= (dw07_ipd, dw06_ipd, dw05_ipd, dw04_ipd, dw03_ipd, dw02_ipd, dw01_ipd, dw00_ipd);
   aw1_tmp <= (dw17_ipd, dw16_ipd, dw15_ipd, dw14_ipd, dw13_ipd, dw12_ipd, dw11_ipd, dw10_ipd);
   ar0_int <= (dm07_ipd, dm06_ipd, dm05_ipd, dm04_ipd, dm03_ipd, dm02_ipd, dm01_ipd, dm00_ipd);
   ar1_int <= (dm17_ipd, dm16_ipd, dm15_ipd, dm14_ipd, dm13_ipd, dm12_ipd, dm11_ipd, dm10_ipd);
   d0_int <= (ad03_ipd, ad02_ipd, ad01_ipd, ad00_ipd);
   d1_int <= (ad13_ipd, ad12_ipd, ad11_ipd, ad10_ipd);

----------------------------------------------------------------
-- Port0 and Port1 write address and data latch and write
----------------------------------------------------------------
   WR : PROCESS (ckw0_ipd, ckw1_ipd)
   VARIABLE data0  : std_logic_vector(15 downto 0);
   VARIABLE data1  : std_logic_vector(15 downto 0);
   VARIABLE wad_0     : Integer;
   VARIABLE wad_1     : Integer;
   VARIABLE value0    : Integer;
   VARIABLE value1    : Integer;
   BEGIN
        IF (ckw0_ipd'event and ckw0_ipd = '1') THEN
          IF (wre0_ipd = '1') THEN
              wad_0 := conv_integer(aw0_int);
              value0 := conv_integer(d0_int);
              data0 := (others => '0');
              data0(value0) := '1';
              IF (sm0_ipd = '0') THEN
                 memory1(wad_0) <= (memory1(wad_0) or (data0));
              ELSIF (sm0_ipd = '1') THEN
                 memory1(wad_0) <= data0;
              END IF;
              memchg1 <= not memchg1;
          END IF;
        END IF;

        IF (ckw1_ipd'event and ckw1_ipd = '1') THEN
          IF (wre1_ipd = '1') THEN
              wad_1 := conv_integer(aw1_int);
              value1 := conv_integer(d1_int);
              data1 := (others => '0');
              data1(value1) := '1';
              IF (sm1_ipd = '0') THEN
                 memory2(wad_1) <= (memory2(wad_1) or (data1));
              ELSIF (sm1_ipd = '1') THEN
                 memory2(wad_1) <= data1;
              END IF;
              memchg2 <= not memchg2;
          END IF;
        END IF;
   END PROCESS;

----------------------------------------------------------------
-- Register Enable signal
----------------------------------------------------------------
   REG_EN : PROCESS (ckr0_ipd, ckr1_ipd)
   BEGIN
      IF (mode0_reg = "IOREG") THEN
         IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
            en0_reg <= rde0_ipd;
         END IF;
      END IF;
      IF (mode1_reg = "IOREG") THEN
         IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
            en1_reg <= rde1_ipd;
         END IF;
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- NOREG read operation
----------------------------------------------------------------

   NOREG_READ : PROCESS (rad_reg_0, rad_reg_1, memchg1, memchg2)
   BEGIN
       q0_int <= memory1(rad_reg_0);
       q1_int <= memory2(rad_reg_1);
   END PROCESS;

----------------------------------------------------------------
-- INREG and IOREG read operation
----------------------------------------------------------------
   INREG_READ : PROCESS (ckr0_ipd, ckr1_ipd, ar0_int, ar1_int)
   BEGIN
      IF (mode0_reg = "INREG" or mode0_reg = "IOREG") THEN
         IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
           IF (rde0_ipd = '1') THEN
              rad_reg_0 <= conv_integer(ar0_int);
           END IF;
         END IF;
      ELSE
         rad_reg_0 <= conv_integer(ar0_int);
      END IF;
      IF (mode1_reg = "INREG" or mode1_reg = "IOREG") THEN
         IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
           IF (rde1_ipd = '1') THEN
              rad_reg_1 <= conv_integer(ar1_int);
           END IF;
         END IF;
      ELSE
         rad_reg_1 <= conv_integer(ar1_int);
      END IF;
   END PROCESS;

----------------------------------------------------------------
-- OUTREG and IOREG read operation
----------------------------------------------------------------
   OUTREG_READ : PROCESS (ckr0_ipd, ckr1_ipd, q0_int, q1_int)
   BEGIN
      IF (mode0_reg = "IOREG") THEN
         IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
           IF (en0_reg = '1') THEN
              q0 <= q0_int;
           END IF;
         END IF;
      ELSIF (mode0_reg = "OUTREG") THEN
         IF (ckr0_ipd'event and ckr0_ipd = '1') THEN
           IF (rde0_ipd = '1') THEN
              q0 <= q0_int;
           END IF;
         END IF;
      ELSE
         q0 <= q0_int;
      END IF;

      IF (mode1_reg = "IOREG") THEN
         IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
           IF (en1_reg = '1') THEN
              q1 <= q1_int;
           END IF;
         END IF;
      ELSIF (mode1_reg = "OUTREG") THEN
         IF (ckr1_ipd'event and ckr1_ipd = '1') THEN
           IF (rde1_ipd = '1') THEN
              q1 <= q1_int;
           END IF;
         END IF;
      ELSE
         q1 <= q1_int;
      END IF;
   END PROCESS;

   VITAL_OUTPUT : PROCESS (q0, q1)
     VARIABLE q0_zd   : std_logic_vector(15 downto 0);
     VARIABLE q1_zd   : std_logic_vector(15 downto 0);

     -- timing check results
        VARIABLE tviol_dw00     : x01 := '0';
        VARIABLE tviol_dw01     : x01 := '0';
        VARIABLE tviol_dw02     : x01 := '0';
        VARIABLE tviol_dw03     : x01 := '0';
        VARIABLE tviol_dw04     : x01 := '0';
        VARIABLE tviol_dw05     : x01 := '0';
        VARIABLE tviol_dw06     : x01 := '0';
        VARIABLE tviol_dw07     : x01 := '0';
        VARIABLE tviol_wre0     : x01 := '0';
        VARIABLE tviol_ad00     : x01 := '0';
        VARIABLE tviol_ad01     : x01 := '0';
        VARIABLE tviol_ad02     : x01 := '0';
        VARIABLE tviol_ad03     : x01 := '0';
        VARIABLE tviol_cd0      : x01 := '0';
        VARIABLE tviol_sm0      : x01 := '0';
        VARIABLE tviol_dm00     : x01 := '0';
        VARIABLE tviol_dm01     : x01 := '0';
        VARIABLE tviol_dm02     : x01 := '0';
        VARIABLE tviol_dm03     : x01 := '0';
        VARIABLE tviol_dm04     : x01 := '0';
        VARIABLE tviol_dm05     : x01 := '0';
        VARIABLE tviol_dm06     : x01 := '0';
        VARIABLE tviol_dm07     : x01 := '0';
        VARIABLE tviol_rde0     : x01 := '0';
        VARIABLE tviol_dw10     : x01 := '0';
        VARIABLE tviol_dw11     : x01 := '0';
        VARIABLE tviol_dw12     : x01 := '0';
        VARIABLE tviol_dw13     : x01 := '0';
        VARIABLE tviol_dw14     : x01 := '0';
        VARIABLE tviol_dw15     : x01 := '0';
        VARIABLE tviol_dw16     : x01 := '0';
        VARIABLE tviol_dw17     : x01 := '0';
        VARIABLE tviol_wre1     : x01 := '0';
        VARIABLE tviol_ad10     : x01 := '0';
        VARIABLE tviol_ad11     : x01 := '0';
        VARIABLE tviol_ad12     : x01 := '0';
        VARIABLE tviol_ad13     : x01 := '0';
        VARIABLE tviol_cd1      : x01 := '0';
        VARIABLE tviol_sm1      : x01 := '0';
        VARIABLE tviol_dm10     : x01 := '0';
        VARIABLE tviol_dm11     : x01 := '0';
        VARIABLE tviol_dm12     : x01 := '0';
        VARIABLE tviol_dm13     : x01 := '0';
        VARIABLE tviol_dm14     : x01 := '0';
        VARIABLE tviol_dm15     : x01 := '0';
        VARIABLE tviol_dm16     : x01 := '0';
        VARIABLE tviol_dm17     : x01 := '0';
        VARIABLE tviol_rde1     : x01 := '0';

        VARIABLE dw00_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw01_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw02_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw03_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw04_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw05_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw06_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw07_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE wre0_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE ad00_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE ad01_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE ad02_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE ad03_ckw0_TimingDatash     : VitalTimingDataType;
        VARIABLE cd0_ckw0_TimingDatash      : VitalTimingDataType;
        VARIABLE sm0_ckw0_TimingDatash      : VitalTimingDataType;
        VARIABLE dm00_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm01_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm02_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm03_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm04_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm05_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm06_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dm07_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE rde0_ckr0_TimingDatash     : VitalTimingDataType;
        VARIABLE dw10_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw11_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw12_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw13_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw14_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw15_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw16_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE dw17_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE wre1_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE ad10_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE ad11_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE ad12_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE ad13_ckw1_TimingDatash     : VitalTimingDataType;
        VARIABLE cd1_ckw1_TimingDatash      : VitalTimingDataType;
        VARIABLE sm1_ckw1_TimingDatash      : VitalTimingDataType;
        VARIABLE dm10_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm11_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm12_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm13_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm14_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm15_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm16_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE dm17_ckr1_TimingDatash     : VitalTimingDataType;
        VARIABLE rde1_ckr1_TimingDatash     : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

     -- output glitch results
        VARIABLE q00_GlitchData   :   VitalGlitchDataType;
        VARIABLE q01_GlitchData   :   VitalGlitchDataType;
        VARIABLE q02_GlitchData   :   VitalGlitchDataType;
        VARIABLE q03_GlitchData   :   VitalGlitchDataType;
        VARIABLE q04_GlitchData   :   VitalGlitchDataType;
        VARIABLE q05_GlitchData   :   VitalGlitchDataType;
        VARIABLE q06_GlitchData   :   VitalGlitchDataType;
        VARIABLE q07_GlitchData   :   VitalGlitchDataType;
        VARIABLE q08_GlitchData   :   VitalGlitchDataType;
        VARIABLE q09_GlitchData   :   VitalGlitchDataType;
        VARIABLE q010_GlitchData  :   VitalGlitchDataType;
        VARIABLE q011_GlitchData  :   VitalGlitchDataType;
        VARIABLE q012_GlitchData  :   VitalGlitchDataType;
        VARIABLE q013_GlitchData  :   VitalGlitchDataType;
        VARIABLE q014_GlitchData  :   VitalGlitchDataType;
        VARIABLE q015_GlitchData  :   VitalGlitchDataType;
        VARIABLE q10_GlitchData   :   VitalGlitchDataType;
        VARIABLE q11_GlitchData   :   VitalGlitchDataType;
        VARIABLE q12_GlitchData   :   VitalGlitchDataType;
        VARIABLE q13_GlitchData   :   VitalGlitchDataType;
        VARIABLE q14_GlitchData   :   VitalGlitchDataType;
        VARIABLE q15_GlitchData   :   VitalGlitchDataType;
        VARIABLE q16_GlitchData   :   VitalGlitchDataType;
        VARIABLE q17_GlitchData   :   VitalGlitchDataType;
        VARIABLE q18_GlitchData   :   VitalGlitchDataType;
        VARIABLE q19_GlitchData   :   VitalGlitchDataType;
        VARIABLE q110_GlitchData  :   VitalGlitchDataType;
        VARIABLE q111_GlitchData  :   VitalGlitchDataType;
        VARIABLE q112_GlitchData  :   VitalGlitchDataType;
        VARIABLE q113_GlitchData  :   VitalGlitchDataType;
        VARIABLE q114_GlitchData  :   VitalGlitchDataType;
        VARIABLE q115_GlitchData  :   VitalGlitchDataType;

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => dw00_ipd,
                TestSignalName => "dw00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw00_ckw0_noedge_posedge,
                HoldHigh => thold_dw00_ckw0_noedge_posedge,
                SetupLow => tsetup_dw00_ckw0_noedge_posedge,
                HoldLow => thold_dw00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw00_ckw0_TimingDatash,
                Violation => tviol_dw00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw01_ipd,
                TestSignalName => "dw01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw01_ckw0_noedge_posedge,
                HoldHigh => thold_dw01_ckw0_noedge_posedge,
                SetupLow => tsetup_dw01_ckw0_noedge_posedge,
                HoldLow => thold_dw01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw01_ckw0_TimingDatash,
                Violation => tviol_dw01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw02_ipd,
                TestSignalName => "dw02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw02_ckw0_noedge_posedge,
                HoldHigh => thold_dw02_ckw0_noedge_posedge,
                SetupLow => tsetup_dw02_ckw0_noedge_posedge,
                HoldLow => thold_dw02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw02_ckw0_TimingDatash,
                Violation => tviol_dw02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw03_ipd,
                TestSignalName => "dw03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw03_ckw0_noedge_posedge,
                HoldHigh => thold_dw03_ckw0_noedge_posedge,
                SetupLow => tsetup_dw03_ckw0_noedge_posedge,
                HoldLow => thold_dw03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw03_ckw0_TimingDatash,
                Violation => tviol_dw03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw04_ipd,
                TestSignalName => "dw04",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw04_ckw0_noedge_posedge,
                HoldHigh => thold_dw04_ckw0_noedge_posedge,
                SetupLow => tsetup_dw04_ckw0_noedge_posedge,
                HoldLow => thold_dw04_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw04_ckw0_TimingDatash,
                Violation => tviol_dw04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw05_ipd,
                TestSignalName => "dw05",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw05_ckw0_noedge_posedge,
                HoldHigh => thold_dw05_ckw0_noedge_posedge,
                SetupLow => tsetup_dw05_ckw0_noedge_posedge,
                HoldLow => thold_dw05_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw05_ckw0_TimingDatash,
                Violation => tviol_dw05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw06_ipd,
                TestSignalName => "dw06",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw06_ckw0_noedge_posedge,
                HoldHigh => thold_dw06_ckw0_noedge_posedge,
                SetupLow => tsetup_dw06_ckw0_noedge_posedge,
                HoldLow => thold_dw06_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw06_ckw0_TimingDatash,
                Violation => tviol_dw06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw07_ipd,
                TestSignalName => "dw07",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_dw07_ckw0_noedge_posedge,
                HoldHigh => thold_dw07_ckw0_noedge_posedge,
                SetupLow => tsetup_dw07_ckw0_noedge_posedge,
                HoldLow => thold_dw07_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw07_ckw0_TimingDatash,
                Violation => tviol_dw07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => wre0_ipd,
                TestSignalName => "wre0",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_wre0_ckw0_noedge_posedge,
                HoldHigh => thold_wre0_ckw0_noedge_posedge,
                SetupLow => tsetup_wre0_ckw0_noedge_posedge,
                HoldLow => thold_wre0_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => wre0_ckw0_TimingDatash,
                Violation => tviol_wre0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad00_ipd,
                TestSignalName => "ad00",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_ad00_ckw0_noedge_posedge,
                HoldHigh => thold_ad00_ckw0_noedge_posedge,
                SetupLow => tsetup_ad00_ckw0_noedge_posedge,
                HoldLow => thold_ad00_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad00_ckw0_TimingDatash,
                Violation => tviol_ad00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad01_ipd,
                TestSignalName => "ad01",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_ad01_ckw0_noedge_posedge,
                HoldHigh => thold_ad01_ckw0_noedge_posedge,
                SetupLow => tsetup_ad01_ckw0_noedge_posedge,
                HoldLow => thold_ad01_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad01_ckw0_TimingDatash,
                Violation => tviol_ad01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad02_ipd,
                TestSignalName => "ad02",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_ad02_ckw0_noedge_posedge,
                HoldHigh => thold_ad02_ckw0_noedge_posedge,
                SetupLow => tsetup_ad02_ckw0_noedge_posedge,
                HoldLow => thold_ad02_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad02_ckw0_TimingDatash,
                Violation => tviol_ad02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad03_ipd,
                TestSignalName => "ad03",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_ad03_ckw0_noedge_posedge,
                HoldHigh => thold_ad03_ckw0_noedge_posedge,
                SetupLow => tsetup_ad03_ckw0_noedge_posedge,
                HoldLow => thold_ad03_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad03_ckw0_TimingDatash,
                Violation => tviol_ad03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => cd0_ipd,
                TestSignalName => "cd0",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_cd0_ckw0_noedge_posedge,
                HoldHigh => thold_cd0_ckw0_noedge_posedge,
                SetupLow => tsetup_cd0_ckw0_noedge_posedge,
                HoldLow => thold_cd0_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => cd0_ckw0_TimingDatash,
                Violation => tviol_cd0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => sm0_ipd,
                TestSignalName => "sm0",
                RefSignal => ckw0_ipd,
                RefSignalName => "ckw0",
                SetupHigh => tsetup_sm0_ckw0_noedge_posedge,
                HoldHigh => thold_sm0_ckw0_noedge_posedge,
                SetupLow => tsetup_sm0_ckw0_noedge_posedge,
                HoldLow => thold_sm0_ckw0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => sm0_ckw0_TimingDatash,
                Violation => tviol_sm0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm00_ipd,
                TestSignalName => "dm00",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm00_ckr0_noedge_posedge,
                HoldHigh => thold_dm00_ckr0_noedge_posedge,
                SetupLow => tsetup_dm00_ckr0_noedge_posedge,
                HoldLow => thold_dm00_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm00_ckr0_TimingDatash,
                Violation => tviol_dm00,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm01_ipd,
                TestSignalName => "dm01",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm01_ckr0_noedge_posedge,
                HoldHigh => thold_dm01_ckr0_noedge_posedge,
                SetupLow => tsetup_dm01_ckr0_noedge_posedge,
                HoldLow => thold_dm01_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm01_ckr0_TimingDatash,
                Violation => tviol_dm01,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm02_ipd,
                TestSignalName => "dm02",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm02_ckr0_noedge_posedge,
                HoldHigh => thold_dm02_ckr0_noedge_posedge,
                SetupLow => tsetup_dm02_ckr0_noedge_posedge,
                HoldLow => thold_dm02_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm02_ckr0_TimingDatash,
                Violation => tviol_dm02,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm03_ipd,
                TestSignalName => "dm03",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm03_ckr0_noedge_posedge,
                HoldHigh => thold_dm03_ckr0_noedge_posedge,
                SetupLow => tsetup_dm03_ckr0_noedge_posedge,
                HoldLow => thold_dm03_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm03_ckr0_TimingDatash,
                Violation => tviol_dm03,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm04_ipd,
                TestSignalName => "dm04",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm04_ckr0_noedge_posedge,
                HoldHigh => thold_dm04_ckr0_noedge_posedge,
                SetupLow => tsetup_dm04_ckr0_noedge_posedge,
                HoldLow => thold_dm04_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm04_ckr0_TimingDatash,
                Violation => tviol_dm04,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm05_ipd,
                TestSignalName => "dm05",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm05_ckr0_noedge_posedge,
                HoldHigh => thold_dm05_ckr0_noedge_posedge,
                SetupLow => tsetup_dm05_ckr0_noedge_posedge,
                HoldLow => thold_dm05_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm05_ckr0_TimingDatash,
                Violation => tviol_dm05,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm06_ipd,
                TestSignalName => "dm06",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm06_ckr0_noedge_posedge,
                HoldHigh => thold_dm06_ckr0_noedge_posedge,
                SetupLow => tsetup_dm06_ckr0_noedge_posedge,
                HoldLow => thold_dm06_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm06_ckr0_TimingDatash,
                Violation => tviol_dm06,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm07_ipd,
                TestSignalName => "dm07",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_dm07_ckr0_noedge_posedge,
                HoldHigh => thold_dm07_ckr0_noedge_posedge,
                SetupLow => tsetup_dm07_ckr0_noedge_posedge,
                HoldLow => thold_dm07_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm07_ckr0_TimingDatash,
                Violation => tviol_dm07,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => rde0_ipd,
                TestSignalName => "rde0",
                RefSignal => ckr0_ipd,
                RefSignalName => "ckr0",
                SetupHigh => tsetup_rde0_ckr0_noedge_posedge,
                HoldHigh => thold_rde0_ckr0_noedge_posedge,
                SetupLow => tsetup_rde0_ckr0_noedge_posedge,
                HoldLow => thold_rde0_ckr0_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => rde0_ckr0_TimingDatash,
                Violation => tviol_rde0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw10_ipd,
                TestSignalName => "dw10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw10_ckw1_noedge_posedge,
                HoldHigh => thold_dw10_ckw1_noedge_posedge,
                SetupLow => tsetup_dw10_ckw1_noedge_posedge,
                HoldLow => thold_dw10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw10_ckw1_TimingDatash,
                Violation => tviol_dw10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw11_ipd,
                TestSignalName => "dw11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw11_ckw1_noedge_posedge,
                HoldHigh => thold_dw11_ckw1_noedge_posedge,
                SetupLow => tsetup_dw11_ckw1_noedge_posedge,
                HoldLow => thold_dw11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw11_ckw1_TimingDatash,
                Violation => tviol_dw11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw12_ipd,
                TestSignalName => "dw12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw12_ckw1_noedge_posedge,
                HoldHigh => thold_dw12_ckw1_noedge_posedge,
                SetupLow => tsetup_dw12_ckw1_noedge_posedge,
                HoldLow => thold_dw12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw12_ckw1_TimingDatash,
                Violation => tviol_dw12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw13_ipd,
                TestSignalName => "dw13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw13_ckw1_noedge_posedge,
                HoldHigh => thold_dw13_ckw1_noedge_posedge,
                SetupLow => tsetup_dw13_ckw1_noedge_posedge,
                HoldLow => thold_dw13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw13_ckw1_TimingDatash,
                Violation => tviol_dw13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw14_ipd,
                TestSignalName => "dw14",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw14_ckw1_noedge_posedge,
                HoldHigh => thold_dw14_ckw1_noedge_posedge,
                SetupLow => tsetup_dw14_ckw1_noedge_posedge,
                HoldLow => thold_dw14_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw14_ckw1_TimingDatash,
                Violation => tviol_dw14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw15_ipd,
                TestSignalName => "dw15",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw15_ckw1_noedge_posedge,
                HoldHigh => thold_dw15_ckw1_noedge_posedge,
                SetupLow => tsetup_dw15_ckw1_noedge_posedge,
                HoldLow => thold_dw15_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw15_ckw1_TimingDatash,
                Violation => tviol_dw15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw16_ipd,
                TestSignalName => "dw16",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw16_ckw1_noedge_posedge,
                HoldHigh => thold_dw16_ckw1_noedge_posedge,
                SetupLow => tsetup_dw16_ckw1_noedge_posedge,
                HoldLow => thold_dw16_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw16_ckw1_TimingDatash,
                Violation => tviol_dw16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dw17_ipd,
                TestSignalName => "dw17",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_dw17_ckw1_noedge_posedge,
                HoldHigh => thold_dw17_ckw1_noedge_posedge,
                SetupLow => tsetup_dw17_ckw1_noedge_posedge,
                HoldLow => thold_dw17_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dw17_ckw1_TimingDatash,
                Violation => tviol_dw17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => wre1_ipd,
                TestSignalName => "wre1",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_wre1_ckw1_noedge_posedge,
                HoldHigh => thold_wre1_ckw1_noedge_posedge,
                SetupLow => tsetup_wre1_ckw1_noedge_posedge,
                HoldLow => thold_wre1_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => wre1_ckw1_TimingDatash,
                Violation => tviol_wre1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad10_ipd,
                TestSignalName => "ad10",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_ad10_ckw1_noedge_posedge,
                HoldHigh => thold_ad10_ckw1_noedge_posedge,
                SetupLow => tsetup_ad10_ckw1_noedge_posedge,
                HoldLow => thold_ad10_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad10_ckw1_TimingDatash,
                Violation => tviol_ad10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad11_ipd,
                TestSignalName => "ad11",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_ad11_ckw1_noedge_posedge,
                HoldHigh => thold_ad11_ckw1_noedge_posedge,
                SetupLow => tsetup_ad11_ckw1_noedge_posedge,
                HoldLow => thold_ad11_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad11_ckw1_TimingDatash,
                Violation => tviol_ad11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad12_ipd,
                TestSignalName => "ad12",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_ad12_ckw1_noedge_posedge,
                HoldHigh => thold_ad12_ckw1_noedge_posedge,
                SetupLow => tsetup_ad12_ckw1_noedge_posedge,
                HoldLow => thold_ad12_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad12_ckw1_TimingDatash,
                Violation => tviol_ad12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => ad13_ipd,
                TestSignalName => "ad13",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_ad13_ckw1_noedge_posedge,
                HoldHigh => thold_ad13_ckw1_noedge_posedge,
                SetupLow => tsetup_ad13_ckw1_noedge_posedge,
                HoldLow => thold_ad13_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ad13_ckw1_TimingDatash,
                Violation => tviol_ad13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => cd1_ipd,
                TestSignalName => "cd1",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_cd1_ckw1_noedge_posedge,
                HoldHigh => thold_cd1_ckw1_noedge_posedge,
                SetupLow => tsetup_cd1_ckw1_noedge_posedge,
                HoldLow => thold_cd1_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => cd1_ckw1_TimingDatash,
                Violation => tviol_cd1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => sm1_ipd,
                TestSignalName => "sm1",
                RefSignal => ckw1_ipd,
                RefSignalName => "ckw1",
                SetupHigh => tsetup_sm1_ckw1_noedge_posedge,
                HoldHigh => thold_sm1_ckw1_noedge_posedge,
                SetupLow => tsetup_sm1_ckw1_noedge_posedge,
                HoldLow => thold_sm1_ckw1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => sm1_ckw1_TimingDatash,
                Violation => tviol_sm1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm10_ipd,
                TestSignalName => "dm10",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm10_ckr1_noedge_posedge,
                HoldHigh => thold_dm10_ckr1_noedge_posedge,
                SetupLow => tsetup_dm10_ckr1_noedge_posedge,
                HoldLow => thold_dm10_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm10_ckr1_TimingDatash,
                Violation => tviol_dm10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm11_ipd,
                TestSignalName => "dm11",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm11_ckr1_noedge_posedge,
                HoldHigh => thold_dm11_ckr1_noedge_posedge,
                SetupLow => tsetup_dm11_ckr1_noedge_posedge,
                HoldLow => thold_dm11_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm11_ckr1_TimingDatash,
                Violation => tviol_dm11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm12_ipd,
                TestSignalName => "dm12",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm12_ckr1_noedge_posedge,
                HoldHigh => thold_dm12_ckr1_noedge_posedge,
                SetupLow => tsetup_dm12_ckr1_noedge_posedge,
                HoldLow => thold_dm12_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm12_ckr1_TimingDatash,
                Violation => tviol_dm12,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm13_ipd,
                TestSignalName => "dm13",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm13_ckr1_noedge_posedge,
                HoldHigh => thold_dm13_ckr1_noedge_posedge,
                SetupLow => tsetup_dm13_ckr1_noedge_posedge,
                HoldLow => thold_dm13_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm13_ckr1_TimingDatash,
                Violation => tviol_dm13,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm14_ipd,
                TestSignalName => "dm14",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm14_ckr1_noedge_posedge,
                HoldHigh => thold_dm14_ckr1_noedge_posedge,
                SetupLow => tsetup_dm14_ckr1_noedge_posedge,
                HoldLow => thold_dm14_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm14_ckr1_TimingDatash,
                Violation => tviol_dm14,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm15_ipd,
                TestSignalName => "dm15",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm15_ckr1_noedge_posedge,
                HoldHigh => thold_dm15_ckr1_noedge_posedge,
                SetupLow => tsetup_dm15_ckr1_noedge_posedge,
                HoldLow => thold_dm15_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm15_ckr1_TimingDatash,
                Violation => tviol_dm15,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm16_ipd,
                TestSignalName => "dm16",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm16_ckr1_noedge_posedge,
                HoldHigh => thold_dm16_ckr1_noedge_posedge,
                SetupLow => tsetup_dm16_ckr1_noedge_posedge,
                HoldLow => thold_dm16_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm16_ckr1_TimingDatash,
                Violation => tviol_dm16,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => dm17_ipd,
                TestSignalName => "dm17",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_dm17_ckr1_noedge_posedge,
                HoldHigh => thold_dm17_ckr1_noedge_posedge,
                SetupLow => tsetup_dm17_ckr1_noedge_posedge,
                HoldLow => thold_dm17_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => dm17_ckr1_TimingDatash,
                Violation => tviol_dm17,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => rde1_ipd,
                TestSignalName => "rde1",
                RefSignal => ckr1_ipd,
                RefSignalName => "ckr1",
                SetupHigh => tsetup_rde1_ckr1_noedge_posedge,
                HoldHigh => thold_rde1_ckr1_noedge_posedge,
                SetupLow => tsetup_rde1_ckr1_noedge_posedge,
                HoldLow => thold_rde1_ckr1_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => rde1_ckr1_TimingDatash,
                Violation => tviol_rde1,
                MsgSeverity => warning);

   END IF;

   ------------------------
   -- functionality section
   ------------------------
        q0_zd := q0;
        q1_zd := q1;

   ------------------------
   -- Path Delay section
   ------------------------

    VitalPathDelay01 (
        OutSignal  => q00, OutSignalName => "q00", OutTemp => q0_zd(0),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q00,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q00, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q00, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q00, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q00, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q00, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q00, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q00, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q00, TRUE)),
        GlitchData => q00_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q01, OutSignalName => "q01", OutTemp => q0_zd(1),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q01,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q01, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q01, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q01, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q01, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q01, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q01, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q01, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q01, TRUE)),
        GlitchData => q01_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q02, OutSignalName => "q02", OutTemp => q0_zd(2),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q02,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q02, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q02, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q02, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q02, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q02, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q02, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q02, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q02, TRUE)),
        GlitchData => q02_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q03, OutSignalName => "q03", OutTemp => q0_zd(3),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q03,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q03, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q03, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q03, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q03, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q03, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q03, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q03, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q03, TRUE)),
        GlitchData => q03_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q04, OutSignalName => "q04", OutTemp => q0_zd(4),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q04,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q04, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q04, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q04, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q04, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q04, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q04, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q04, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q04, TRUE)),
        GlitchData => q04_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q05, OutSignalName => "q05", OutTemp => q0_zd(5),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q05,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q05, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q05, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q05, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q05, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q05, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q05, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q05, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q05, TRUE)),
        GlitchData => q05_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q06, OutSignalName => "q06", OutTemp => q0_zd(6),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q06,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q06, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q06, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q06, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q06, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q06, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q06, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q06, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q06, TRUE)),
        GlitchData => q06_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q07, OutSignalName => "q07", OutTemp => q0_zd(7),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q07,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q07, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q07, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q07, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q07, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q07, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q07, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q07, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q07, TRUE)),
        GlitchData => q07_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q08, OutSignalName => "q08", OutTemp => q0_zd(8),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q08,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q08, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q08, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q08, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q08, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q08, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q08, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q08, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q08, TRUE)),
        GlitchData => q08_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q09, OutSignalName => "q09", OutTemp => q0_zd(9),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q09,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q09, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q09, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q09, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q09, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q09, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q09, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q09, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q09, TRUE)),
        GlitchData => q09_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q010, OutSignalName => "q010", OutTemp => q0_zd(10),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q010,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q010, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q010, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q010, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q010, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q010, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q010, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q010, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q010, TRUE)),
        GlitchData => q010_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q011, OutSignalName => "q011", OutTemp => q0_zd(11),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q011,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q011, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q011, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q011, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q011, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q011, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q011, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q011, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q011, TRUE)),
        GlitchData => q011_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q012, OutSignalName => "q012", OutTemp => q0_zd(12),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q012,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q012, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q012, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q012, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q012, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q012, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q012, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q012, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q012, TRUE)),
        GlitchData => q012_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q013, OutSignalName => "q013", OutTemp => q0_zd(13),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q013,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q013, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q013, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q013, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q013, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q013, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q013, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q013, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q013, TRUE)),
        GlitchData => q013_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q014, OutSignalName => "q014", OutTemp => q0_zd(14),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q014,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q014, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q014, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q014, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q014, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q014, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q014, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q014, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q014, TRUE)),
        GlitchData => q014_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q015, OutSignalName => "q015", OutTemp => q0_zd(15),
        Paths      => (0 => (InputChangeTime => dm00_ipd'last_event,
                             PathDelay => tpd_dm00_q015,
                             PathCondition => TRUE),
                       1 => (dm01_ipd'last_event, tpd_dm01_q015, TRUE),
                       2 => (dm02_ipd'last_event, tpd_dm02_q015, TRUE),
                       3 => (dm03_ipd'last_event, tpd_dm03_q015, TRUE),
                       4 => (dm04_ipd'last_event, tpd_dm04_q015, TRUE),
                       5 => (dm05_ipd'last_event, tpd_dm05_q015, TRUE),
                       6 => (dm06_ipd'last_event, tpd_dm06_q015, TRUE),
                       7 => (dm07_ipd'last_event, tpd_dm07_q015, TRUE),
                       8 => (ckr0_ipd'last_event, tpd_ckr0_q015, TRUE)),
        GlitchData => q015_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q10, OutSignalName => "q10", OutTemp => q1_zd(0),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q10,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q10, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q10, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q10, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q10, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q10, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q10, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q10, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q10, TRUE)),
        GlitchData => q10_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q11, OutSignalName => "q11", OutTemp => q1_zd(1),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q11,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q11, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q11, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q11, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q11, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q11, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q11, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q11, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q11, TRUE)),
        GlitchData => q11_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q12, OutSignalName => "q12", OutTemp => q1_zd(2),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q12,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q12, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q12, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q12, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q12, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q12, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q12, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q12, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q12, TRUE)),
        GlitchData => q12_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q13, OutSignalName => "q13", OutTemp => q1_zd(3),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q13,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q13, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q13, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q13, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q13, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q13, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q13, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q13, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q13, TRUE)),
        GlitchData => q13_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q14, OutSignalName => "q14", OutTemp => q1_zd(4),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q14,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q14, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q14, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q14, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q14, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q14, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q14, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q14, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q14, TRUE)),
        GlitchData => q14_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q15, OutSignalName => "q15", OutTemp => q1_zd(5),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q15,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q15, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q15, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q15, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q15, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q15, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q15, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q15, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q15, TRUE)),
        GlitchData => q15_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q16, OutSignalName => "q16", OutTemp => q1_zd(6),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q16,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q16, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q16, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q16, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q16, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q16, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q16, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q16, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q16, TRUE)),
        GlitchData => q16_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q17, OutSignalName => "q17", OutTemp => q1_zd(7),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q17,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q17, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q17, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q17, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q17, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q17, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q17, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q17, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q17, TRUE)),
        GlitchData => q17_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q18, OutSignalName => "q18", OutTemp => q1_zd(8),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q18,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q18, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q18, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q18, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q18, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q18, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q18, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q18, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q18, TRUE)),
        GlitchData => q18_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q19, OutSignalName => "q19", OutTemp => q1_zd(9),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q19,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q19, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q19, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q19, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q19, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q19, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q19, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q19, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q19, TRUE)),
        GlitchData => q19_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q110, OutSignalName => "q110", OutTemp => q1_zd(10),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q110,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q110, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q110, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q110, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q110, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q110, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q110, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q110, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q110, TRUE)),
        GlitchData => q110_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q111, OutSignalName => "q111", OutTemp => q1_zd(11),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q111,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q111, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q111, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q111, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q111, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q111, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q111, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q111, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q111, TRUE)),
        GlitchData => q111_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q112, OutSignalName => "q112", OutTemp => q1_zd(12),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q112,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q112, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q112, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q112, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q112, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q112, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q112, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q112, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q112, TRUE)),
        GlitchData => q112_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q113, OutSignalName => "q113", OutTemp => q1_zd(13),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q113,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q113, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q113, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q113, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q113, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q113, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q113, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q113, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q113, TRUE)),
        GlitchData => q113_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q114, OutSignalName => "q114", OutTemp => q1_zd(14),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q114,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q114, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q114, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q114, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q114, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q114, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q114, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q114, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q114, TRUE)),
        GlitchData => q114_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );
    VitalPathDelay01 (
        OutSignal  => q115, OutSignalName => "q115", OutTemp => q1_zd(15),
        Paths      => (0 => (InputChangeTime => dm10_ipd'last_event,
                             PathDelay => tpd_dm10_q115,
                             PathCondition => TRUE),
                       1 => (dm11_ipd'last_event, tpd_dm11_q115, TRUE),
                       2 => (dm12_ipd'last_event, tpd_dm12_q115, TRUE),
                       3 => (dm13_ipd'last_event, tpd_dm13_q115, TRUE),
                       4 => (dm14_ipd'last_event, tpd_dm14_q115, TRUE),
                       5 => (dm15_ipd'last_event, tpd_dm15_q115, TRUE),
                       6 => (dm16_ipd'last_event, tpd_dm16_q115, TRUE),
                       7 => (dm17_ipd'last_event, tpd_dm17_q115, TRUE),
                       8 => (ckr1_ipd'last_event, tpd_ckr1_q115, TRUE)),
        GlitchData => q115_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn
        );


   END PROCESS;

END V;

--
----- cell mux81 -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;


-- entity declaration --
ENTITY mux81 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "mux81";
      tpd_d0_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d1_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d2_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d3_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d4_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d5_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d6_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d7_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_sd1_z       : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_sd2_z       : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_sd3_z       : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tipd_d0         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d1         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d2         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d3         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d4         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d5         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d6         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d7         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_sd1        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_sd2        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_sd3        : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      d0              : IN    std_logic;
      d1              : IN    std_logic;
      d2              : IN    std_logic;
      d3              : IN    std_logic;
      d4              : IN    std_logic;
      d5              : IN    std_logic;
      d6              : IN    std_logic;
      d7              : IN    std_logic;
      sd1             : IN    std_logic;
      sd2             : IN    std_logic;
      sd3             : IN    std_logic;
      z               : OUT  std_logic);

   ATTRIBUTE Vital_Level0 OF mux81 : ENTITY IS TRUE;

END mux81;

-- architecture body --

LIBRARY ieee;
USE ieee.vital_primitives.all;
ARCHITECTURE v OF mux81 IS
   ATTRIBUTE Vital_Level1 OF v : ARCHITECTURE IS TRUE;

   SIGNAL d0_ipd         : std_logic := 'X';
   SIGNAL d1_ipd         : std_logic := 'X';
   SIGNAL d2_ipd         : std_logic := 'X';
   SIGNAL d3_ipd         : std_logic := 'X';
   SIGNAL d4_ipd         : std_logic := 'X';
   SIGNAL d5_ipd         : std_logic := 'X';
   SIGNAL d6_ipd         : std_logic := 'X';
   SIGNAL d7_ipd         : std_logic := 'X';
   SIGNAL sd1_ipd        : std_logic := 'X';
   SIGNAL sd2_ipd        : std_logic := 'X';
   SIGNAL sd3_ipd        : std_logic := 'X';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay (d0_ipd, d0, tipd_d0);
   VitalWireDelay (d1_ipd, d1, tipd_d1);
   VitalWireDelay (d2_ipd, d2, tipd_d2);
   VitalWireDelay (d3_ipd, d3, tipd_d3);
   VitalWireDelay (d4_ipd, d4, tipd_d4);
   VitalWireDelay (d5_ipd, d5, tipd_d5);
   VitalWireDelay (d6_ipd, d6, tipd_d6);
   VitalWireDelay (d7_ipd, d7, tipd_d7);
   VitalWireDelay (sd1_ipd, sd1, tipd_sd1);
   VitalWireDelay (sd2_ipd, sd2, tipd_sd2);
   VitalWireDelay (sd3_ipd, sd3, tipd_sd3);
   END BLOCK;
   --------------------
   --  behavior section
   --------------------
   VitalBehavior : PROCESS (d0_ipd, d1_ipd, d2_ipd, d3_ipd, d4_ipd, d5_ipd, d6_ipd, d7_ipd, sd1_ipd, sd2_ipd, sd3_ipd)


   -- functionality results
   VARIABLE results : std_logic_vector(1 to 1) := (others => 'X');
   ALIAS z_zd       : std_ulogic IS results(1);

   -- output glitch detection VARIABLEs
   VARIABLE z_GlitchData        : VitalGlitchDataType;

   BEGIN

      -------------------------
      --  functionality section
      -------------------------
      z_zd := vitalmux
                 (data => (d7_ipd, d6_ipd, d5_ipd, d4_ipd, d3_ipd, d2_ipd, d1_ipd, d0_ipd),
                  dselect => (sd3_ipd, sd2_ipd, sd1_ipd));

      ----------------------
      --  path delay section
      ----------------------
      VitalPathDelay01 (
       OutSignal => z,
       OutSignalName => "z",
       OutTemp => z_zd,
          Paths => (0 => (d0_ipd'last_event, tpd_d0_z, TRUE),
                 1 => (d1_ipd'last_event, tpd_d1_z, TRUE),
                 2 => (d2_ipd'last_event, tpd_d2_z, TRUE),
                 3 => (d3_ipd'last_event, tpd_d3_z, TRUE),
                 4 => (d4_ipd'last_event, tpd_d4_z, TRUE),
                 5 => (d5_ipd'last_event, tpd_d5_z, TRUE),
                 6 => (d6_ipd'last_event, tpd_d6_z, TRUE),
                 7 => (d7_ipd'last_event, tpd_d7_z, TRUE),
                 8 => (sd1_ipd'last_event, tpd_sd1_z, TRUE),
                 9 => (sd2_ipd'last_event, tpd_sd2_z, TRUE),
                10 => (sd3_ipd'last_event, tpd_sd3_z, TRUE)),

       GlitchData => z_GlitchData,
       Mode => OnDetect,
       XOn => XOn,
       MsgOn => MsgOn);


END PROCESS;

END v;

--
----- cell pfumx41 -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;


-- entity declaration --
ENTITY pfumx41 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "pfumx41";
      tpd_d0_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d1_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d2_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_d3_z        : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_sd1_z       : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tpd_sd2_z       : VitalDelayType01 := (0.1 ns, 0.1 ns);
      tipd_d0         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d1         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d2         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d3         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_sd1        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_sd2        : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      d0              : IN    std_logic;
      d1              : IN    std_logic;
      d2              : IN    std_logic;
      d3              : IN    std_logic;
      sd1             : IN    std_logic;
      sd2             : IN    std_logic;
      z               : OUT  std_logic);

   ATTRIBUTE Vital_Level0 OF pfumx41 : ENTITY IS TRUE;

END pfumx41;

-- architecture body --

LIBRARY ieee;
USE ieee.vital_primitives.all;
ARCHITECTURE v OF pfumx41 IS
   ATTRIBUTE Vital_Level1 OF v : ARCHITECTURE IS TRUE;

   SIGNAL d0_ipd         : std_logic := 'X';
   SIGNAL d1_ipd         : std_logic := 'X';
   SIGNAL d2_ipd         : std_logic := 'X';
   SIGNAL d3_ipd         : std_logic := 'X';
   SIGNAL sd1_ipd        : std_logic := 'X';
   SIGNAL sd2_ipd        : std_logic := 'X';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
   WireDelay : BLOCK
   BEGIN
   VitalWireDelay (d0_ipd, d0, tipd_d0);
   VitalWireDelay (d1_ipd, d1, tipd_d1);
   VitalWireDelay (d2_ipd, d2, tipd_d2);
   VitalWireDelay (d3_ipd, d3, tipd_d3);
   VitalWireDelay (sd1_ipd, sd1, tipd_sd1);
   VitalWireDelay (sd2_ipd, sd2, tipd_sd2);
   END BLOCK;
   --------------------
   --  behavior section
   --------------------
   VitalBehavior : PROCESS (d0_ipd, d1_ipd, d2_ipd, d3_ipd, sd1_ipd, sd2_ipd)


   -- functionality results
   VARIABLE results : std_logic_vector(1 to 1) := (others => 'X');
   ALIAS z_zd       : std_ulogic IS results(1);

   -- output glitch detection VARIABLEs
   VARIABLE z_GlitchData        : VitalGlitchDataType;

   BEGIN

      -------------------------
      --  functionality section
      -------------------------
      z_zd := vitalmux
                 (data => (d3_ipd, d2_ipd, d1_ipd, d0_ipd),
                  dselect => (sd2_ipd, sd1_ipd));

      ----------------------
      --  path delay section
      ----------------------
      VitalPathDelay01 (
       OutSignal => z,
       OutSignalName => "z",
       OutTemp => z_zd,
          Paths => (0 => (d0_ipd'last_event, tpd_d0_z, TRUE),
                 1 => (d1_ipd'last_event, tpd_d1_z, TRUE),
                 2 => (d2_ipd'last_event, tpd_d2_z, TRUE),
                 3 => (d3_ipd'last_event, tpd_d3_z, TRUE),
                 4 => (sd1_ipd'last_event, tpd_sd1_z, TRUE),
                 5 => (sd2_ipd'last_event, tpd_sd2_z, TRUE)),

       GlitchData => z_GlitchData,
       Mode => OnDetect,
       XOn => XOn,
       MsgOn => MsgOn);


END PROCESS;

END v;


--
----- cell iosr2 (Two-Input I/O shift register) -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY iosr2 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "iosr2";
      tpd_ck_inq0     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq1     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq0 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq1 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_outq : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tsetup_ind_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_ind_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_outd0_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd0_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd1_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd1_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_update_ck_noedge_posedge : VitalDelayType := 0.01 ns;
      thold_update_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      tipd_ind        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd0      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd1      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_update     : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      ind, outd0, outd1, ck, update       : IN std_logic;
      inq0, inq1, outq      : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF iosr2 : ENTITY IS TRUE;

END iosr2 ;

-- architecture body --
ARCHITECTURE v OF iosr2 IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL q0b          : std_logic := '0';
    SIGNAL q1b          : std_logic := '0';
    SIGNAL q0           : std_logic := '0';
    SIGNAL q1           : std_logic := '0';
    SIGNAL q0_zd          : std_logic := '0';
    SIGNAL q1_zd          : std_logic := '0';
    SIGNAL o_q1b          : std_logic := '0';
    SIGNAL o_q2b          : std_logic := '0';

    SIGNAL ind_ipd        : std_logic := '0';
    SIGNAL outd0_ipd      : std_logic := '0';
    SIGNAL outd1_ipd      : std_logic := '0';
    SIGNAL ck_ipd         : std_logic := '0';
    SIGNAL update_ipd     : std_logic := '0';
    SIGNAL update_int     : std_logic := '0';
    SIGNAL update_q2      : std_logic := '1';
    SIGNAL update_q1      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(ind_ipd, ind, tipd_ind);
       VitalWireDelay(outd0_ipd, outd0, tipd_outd0);
       VitalWireDelay(outd1_ipd, outd1, tipd_outd1);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
       VitalWireDelay(update_ipd, update, tipd_update);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------
   P1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         IF (update_ipd = '1') THEN
            update_q2 <= '1';
            update_q1 <= '0';
          ELSIF (update_ipd = '0') THEN
            update_q2 <= update_q1;
            update_q1 <= update_q2;
          END IF;
      END IF;
   END PROCESS;

   update_int <= not update_q2;

   VitalBehavior1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         q1b <= ind_ipd;
         q0b <= q1b;
         q0 <= o_q1b;
         q1 <= o_q2b;
      END IF;
   END PROCESS;

   VitalBehavior2 : PROCESS (ck_ipd, update_int)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         IF (update_int = '1') THEN
            q1_zd <= q1b;
            q0_zd <= q0b;
         END IF;
      END IF;
   END PROCESS;

   VitalBehavior3 : PROCESS (update_int, q1, outd0_ipd, outd1_ipd)
   BEGIN
      IF (update_int = '1') THEN
         o_q1b <= outd0_ipd;
         o_q2b <= outd1_ipd;
      ELSE
         o_q1b <= q1;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (q0_zd, q1_zd, q0)

   VARIABLE inq0_zd   : std_logic := 'X';
   VARIABLE inq1_zd   : std_logic := 'X';
   VARIABLE outq_zd   : std_logic := 'X';
   -- output glitch detection VARIABLEs
   VARIABLE inq0_GlitchData     : VitalGlitchDataType;
   VARIABLE inq1_GlitchData     : VitalGlitchDataType;
   VARIABLE outq_GlitchData     : VitalGlitchDataType;

     -- timing check results
        VARIABLE tviol_ind     : x01 := '0';
        VARIABLE tviol_outd0   : x01 := '0';
        VARIABLE tviol_outd1   : x01 := '0';
        VARIABLE tviol_update  : x01 := '0';

        VARIABLE ind_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd0_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd1_ck_TimingDatash : VitalTimingDataType;
        VARIABLE update_ck_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => ind_ipd,
                TestSignalName => "ind",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_ind_ck_noedge_posedge,
                setuplow => tsetup_ind_ck_noedge_posedge,
                HoldHigh => thold_ind_ck_noedge_posedge,
                Holdlow => thold_ind_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ind_ck_TimingDatash,
                Violation => tviol_ind,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd0_ipd,
                TestSignalName => "outd0",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd0_ck_noedge_posedge,
                setuplow => tsetup_outd0_ck_noedge_posedge,
                HoldHigh => thold_outd0_ck_noedge_posedge,
                Holdlow => thold_outd0_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd0_ck_TimingDatash,
                Violation => tviol_outd0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => outd1_ipd,
                TestSignalName => "outd1",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd1_ck_noedge_posedge,
                setuplow => tsetup_outd1_ck_noedge_posedge,
                HoldHigh => thold_outd1_ck_noedge_posedge,
                Holdlow => thold_outd1_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd1_ck_TimingDatash,
                Violation => tviol_outd1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => update_ipd,
                TestSignalName => "update",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_update_ck_noedge_posedge,
                setuplow => tsetup_update_ck_noedge_posedge,
                HoldHigh => thold_update_ck_noedge_posedge,
                Holdlow => thold_update_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => update_ck_TimingDatash,
                Violation => tviol_update,
                MsgSeverity => warning);

   END IF;
   
   inq0_zd := q0_zd;
   inq1_zd := q1_zd;
   outq_zd := q0;

    VitalPathDelay01 (
        OutSignal  => inq0, OutSignalName => "inq0", OutTemp => inq0_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq0,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq0, TRUE)),
        GlitchData => inq0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq1, OutSignalName => "inq1", OutTemp => inq1_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq1,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq1, TRUE)),
        GlitchData => inq1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => outq, OutSignalName => "outq", OutTemp => outq_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_outq,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_outq, TRUE)),
        GlitchData => outq_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);

   END PROCESS;
END v;


--
----- cell osr2x2 (Output dual two-bit shift register) -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY osr2x2 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "osr2x2";
      tpd_ck_q1     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_q2     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_q1 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_q2 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tsetup_d10_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d10_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_d11_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d11_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_d20_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d20_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_d21_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d21_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_update_ck_noedge_posedge : VitalDelayType := 0.01 ns;
      thold_update_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      tipd_d10      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d11      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d20      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d21      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_update     : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      d10, d11, d20, d21, ck, update       : IN std_logic;
      q1, q2      : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF osr2x2 : ENTITY IS TRUE;

END osr2x2 ;

-- architecture body --
ARCHITECTURE v OF osr2x2 IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL q1b          : std_logic := '0';
    SIGNAL q2b          : std_logic := '0';
    SIGNAL q10          : std_logic := '0';
    SIGNAL q20          : std_logic := '0';
    SIGNAL q10_mux      : std_logic := '0';
    SIGNAL q20_mux      : std_logic := '0';

    SIGNAL d10_ipd        : std_logic := '0';
    SIGNAL d11_ipd        : std_logic := '0';
    SIGNAL d20_ipd        : std_logic := '0';
    SIGNAL d21_ipd        : std_logic := '0';
    SIGNAL ck_ipd         : std_logic := '0';
    SIGNAL update_ipd     : std_logic := '0';
    SIGNAL update_int     : std_logic := '0';
    SIGNAL update_q2      : std_logic := '1';
    SIGNAL update_q1      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(d10_ipd, d10, tipd_d10);
       VitalWireDelay(d11_ipd, d11, tipd_d11);
       VitalWireDelay(d20_ipd, d20, tipd_d20);
       VitalWireDelay(d21_ipd, d21, tipd_d21);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
       VitalWireDelay(update_ipd, update, tipd_update);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------
   P1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         IF (update_ipd = '1') THEN
            update_q2 <= '1';
            update_q1 <= '0';
          ELSIF (update_ipd = '0') THEN
            update_q2 <= update_q1;
            update_q1 <= update_q2;
          END IF;
      END IF;
   END PROCESS;

   update_int <= not update_q2;

   VitalBehavior1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         q1b <= q10_mux;
         q10 <= d11_ipd;
         q2b <= q20_mux;
         q20 <= d21_ipd;
      END IF;
   END PROCESS;

   VitalBehavior3 : PROCESS (update_int, q10, q20, d10_ipd, d20_ipd)
   BEGIN
      IF (update_int = '1') THEN
         q10_mux <= d10_ipd;
         q20_mux <= d20_ipd;
      ELSIF (update_int = '0') THEN
         q10_mux <= q10;
         q20_mux <= q20;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (q1b, q2b)

   VARIABLE q1_zd   : std_logic := 'X';
   VARIABLE q2_zd   : std_logic := 'X';
   -- output glitch detection VARIABLEs
   VARIABLE q1_GlitchData     : VitalGlitchDataType;
   VARIABLE q2_GlitchData     : VitalGlitchDataType;

     -- timing check results
        VARIABLE tviol_d10     : x01 := '0';
        VARIABLE tviol_d11     : x01 := '0';
        VARIABLE tviol_d20     : x01 := '0';
        VARIABLE tviol_d21     : x01 := '0';
        VARIABLE tviol_update  : x01 := '0';

        VARIABLE d10_ck_TimingDatash : VitalTimingDataType;
        VARIABLE d11_ck_TimingDatash : VitalTimingDataType;
        VARIABLE d20_ck_TimingDatash : VitalTimingDataType;
        VARIABLE d21_ck_TimingDatash : VitalTimingDataType;
        VARIABLE update_ck_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => d10_ipd,
                TestSignalName => "d10",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d10_ck_noedge_posedge,
                setuplow => tsetup_d10_ck_noedge_posedge,
                HoldHigh => thold_d10_ck_noedge_posedge,
                Holdlow => thold_d10_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d10_ck_TimingDatash,
                Violation => tviol_d10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d11_ipd,
                TestSignalName => "d11",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d11_ck_noedge_posedge,
                setuplow => tsetup_d11_ck_noedge_posedge,
                HoldHigh => thold_d11_ck_noedge_posedge,
                Holdlow => thold_d11_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d11_ck_TimingDatash,
                Violation => tviol_d11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => d20_ipd,
                TestSignalName => "d20",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d20_ck_noedge_posedge,
                setuplow => tsetup_d20_ck_noedge_posedge,
                HoldHigh => thold_d20_ck_noedge_posedge,
                Holdlow => thold_d20_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d20_ck_TimingDatash,
                Violation => tviol_d20,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d21_ipd,
                TestSignalName => "d21",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d21_ck_noedge_posedge,
                setuplow => tsetup_d21_ck_noedge_posedge,
                HoldHigh => thold_d21_ck_noedge_posedge,
                Holdlow => thold_d21_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d21_ck_TimingDatash,
                Violation => tviol_d21,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => update_ipd,
                TestSignalName => "update",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_update_ck_noedge_posedge,
                setuplow => tsetup_update_ck_noedge_posedge,
                HoldHigh => thold_update_ck_noedge_posedge,
                Holdlow => thold_update_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => update_ck_TimingDatash,
                Violation => tviol_update,
                MsgSeverity => warning);

   END IF;
   
   q1_zd := q1b;
   q2_zd := q2b;

    VitalPathDelay01 (
        OutSignal  => q1, OutSignalName => "q1", OutTemp => q1_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_q1,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_q1, TRUE)),
        GlitchData => q1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => q2, OutSignalName => "q2", OutTemp => q2_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_q2,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_q2, TRUE)),
        GlitchData => q2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
   END PROCESS;
END v;



--
----- cell hosr2x2 (Output dual two-bit shift register) -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY hosr2x2 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "hosr2x2";
      tpd_ck_q1     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_q2     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_q1 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_q2 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tsetup_d10_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d10_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_d11_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d11_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_d20_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d20_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_d21_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_d21_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_update_ck_noedge_posedge : VitalDelayType := 0.01 ns;
      thold_update_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      tipd_d10      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d11      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d20      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_d21      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_update     : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      d10, d11, d20, d21, ck, update       : IN std_logic;
      q1, q2      : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF hosr2x2 : ENTITY IS TRUE;

END hosr2x2 ;

-- architecture body --
ARCHITECTURE v OF hosr2x2 IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL q1b          : std_logic := '0';
    SIGNAL q2b          : std_logic := '0';
    SIGNAL q10          : std_logic := '0';
    SIGNAL q20          : std_logic := '0';
    SIGNAL q10_mux      : std_logic := '0';
    SIGNAL q20_mux      : std_logic := '0';

    SIGNAL d10_ipd        : std_logic := '0';
    SIGNAL d11_ipd        : std_logic := '0';
    SIGNAL d20_ipd        : std_logic := '0';
    SIGNAL d21_ipd        : std_logic := '0';
    SIGNAL ck_ipd         : std_logic := '0';
    SIGNAL ck_int         : std_logic := '0';
    SIGNAL update_ipd     : std_logic := '0';
    SIGNAL update_int     : std_logic := '0';
    SIGNAL update_q2      : std_logic := '1';
    SIGNAL update_q1      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(d10_ipd, d10, tipd_d10);
       VitalWireDelay(d11_ipd, d11, tipd_d11);
       VitalWireDelay(d20_ipd, d20, tipd_d20);
       VitalWireDelay(d21_ipd, d21, tipd_d21);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
       VitalWireDelay(update_ipd, update, tipd_update);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------
   ck_int <= ck_ipd;

   P1 : PROCESS (ck_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         IF (update_ipd = '1') THEN
            update_q2 <= '1';
            update_q1 <= '0';
          ELSIF (update_ipd = '0') THEN
            update_q2 <= update_q1;
            update_q1 <= update_q2;
          END IF;
      END IF;
   END PROCESS;

   update_int <= not update_q2;

   VitalBehavior1 : PROCESS (ck_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         q1b <= q10_mux;
         q10 <= d11_ipd;
         q2b <= q20_mux;
         q20 <= d21_ipd;
      END IF;
   END PROCESS;

   VitalBehavior3 : PROCESS (update_int, q10, q20, d10_ipd, d20_ipd)
   BEGIN
      IF (update_int = '1') THEN
         q10_mux <= d10_ipd;
         q20_mux <= d20_ipd;
      ELSIF (update_int = '0') THEN
         q10_mux <= q10;
         q20_mux <= q20;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (q1b, q2b)

   VARIABLE q1_zd   : std_logic := 'X';
   VARIABLE q2_zd   : std_logic := 'X';
   -- output glitch detection VARIABLEs
   VARIABLE q1_GlitchData     : VitalGlitchDataType;
   VARIABLE q2_GlitchData     : VitalGlitchDataType;

     -- timing check results
        VARIABLE tviol_d10     : x01 := '0';
        VARIABLE tviol_d11     : x01 := '0';
        VARIABLE tviol_d20     : x01 := '0';
        VARIABLE tviol_d21     : x01 := '0';
        VARIABLE tviol_update  : x01 := '0';

        VARIABLE d10_ck_TimingDatash : VitalTimingDataType;
        VARIABLE d11_ck_TimingDatash : VitalTimingDataType;
        VARIABLE d20_ck_TimingDatash : VitalTimingDataType;
        VARIABLE d21_ck_TimingDatash : VitalTimingDataType;
        VARIABLE update_ck_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => d10_ipd,
                TestSignalName => "d10",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d10_ck_noedge_posedge,
                setuplow => tsetup_d10_ck_noedge_posedge,
                HoldHigh => thold_d10_ck_noedge_posedge,
                Holdlow => thold_d10_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d10_ck_TimingDatash,
                Violation => tviol_d10,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d11_ipd,
                TestSignalName => "d11",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d11_ck_noedge_posedge,
                setuplow => tsetup_d11_ck_noedge_posedge,
                HoldHigh => thold_d11_ck_noedge_posedge,
                Holdlow => thold_d11_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d11_ck_TimingDatash,
                Violation => tviol_d11,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => d20_ipd,
                TestSignalName => "d20",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d20_ck_noedge_posedge,
                setuplow => tsetup_d20_ck_noedge_posedge,
                HoldHigh => thold_d20_ck_noedge_posedge,
                Holdlow => thold_d20_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d20_ck_TimingDatash,
                Violation => tviol_d20,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => d21_ipd,
                TestSignalName => "d21",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_d21_ck_noedge_posedge,
                setuplow => tsetup_d21_ck_noedge_posedge,
                HoldHigh => thold_d21_ck_noedge_posedge,
                Holdlow => thold_d21_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => d21_ck_TimingDatash,
                Violation => tviol_d21,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => update_ipd,
                TestSignalName => "update",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_update_ck_noedge_posedge,
                setuplow => tsetup_update_ck_noedge_posedge,
                HoldHigh => thold_update_ck_noedge_posedge,
                Holdlow => thold_update_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => update_ck_TimingDatash,
                Violation => tviol_update,
                MsgSeverity => warning);

   END IF;
   
   q1_zd := q1b;
   q2_zd := q2b;

    VitalPathDelay01 (
        OutSignal  => q1, OutSignalName => "q1", OutTemp => q1_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_q1,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_q1, TRUE)),
        GlitchData => q1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => q2, OutSignalName => "q2", OutTemp => q2_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_q2,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_q2, TRUE)),
        GlitchData => q2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
   END PROCESS;
END v;



--
----- cell iosr4 (Four-Input I/O shift register) -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY iosr4 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "iosr4";
      tpd_ck_inq0     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq1     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq2     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq3     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq0 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq1 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq2 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq3 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_outq : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tsetup_ind_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_ind_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_outd0_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd0_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd1_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd1_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd2_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd2_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd3_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd3_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_update_ck_noedge_posedge : VitalDelayType := 0.01 ns;
      thold_update_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      tipd_ind        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd0      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd1      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd2      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd3      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_update     : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      ind, outd0, outd1, outd2, outd3, ck, update       : IN std_logic;
      inq0, inq1, inq2, inq3, outq      : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF iosr4 : ENTITY IS TRUE;

END iosr4 ;

-- architecture body --
ARCHITECTURE v OF iosr4 IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL q0b          : std_logic := '0';
    SIGNAL q1b          : std_logic := '0';
    SIGNAL q2b          : std_logic := '0';
    SIGNAL q3b          : std_logic := '0';
    SIGNAL q0           : std_logic := '0';
    SIGNAL q1           : std_logic := '0';
    SIGNAL q2           : std_logic := '0';
    SIGNAL q3           : std_logic := '0';
    SIGNAL q0_zd          : std_logic := '0';
    SIGNAL q1_zd          : std_logic := '0';
    SIGNAL q2_zd          : std_logic := '0';
    SIGNAL q3_zd          : std_logic := '0';
    SIGNAL o_q1b          : std_logic := '0';
    SIGNAL o_q2b          : std_logic := '0';
    SIGNAL o_q3b          : std_logic := '0';

    SIGNAL ind_ipd        : std_logic := '0';
    SIGNAL outd0_ipd      : std_logic := '0';
    SIGNAL outd1_ipd      : std_logic := '0';
    SIGNAL outd2_ipd      : std_logic := '0';
    SIGNAL outd3_ipd      : std_logic := '0';
    SIGNAL ck_ipd         : std_logic := '0';
    SIGNAL update_ipd     : std_logic := '0';
    SIGNAL update_int     : std_logic := '0';
    SIGNAL update_q4      : std_logic := '1';
    SIGNAL update_q3      : std_logic := '1';
    SIGNAL update_q2      : std_logic := '1';
    SIGNAL update_q1      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(ind_ipd, ind, tipd_ind);
       VitalWireDelay(outd0_ipd, outd0, tipd_outd0);
       VitalWireDelay(outd1_ipd, outd1, tipd_outd1);
       VitalWireDelay(outd2_ipd, outd2, tipd_outd2);
       VitalWireDelay(outd3_ipd, outd3, tipd_outd3);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
       VitalWireDelay(update_ipd, update, tipd_update);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------
   P1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         IF (update_ipd = '1') THEN
            update_q4 <= '1';
            update_q3 <= '1';
            update_q2 <= '1';
            update_q1 <= '0';
          ELSIF (update_ipd = '0') THEN
            update_q4 <= update_q3;
            update_q3 <= update_q2;
            update_q2 <= update_q1;
            update_q1 <= update_q4;
          END IF;
      END IF;
   END PROCESS;

   update_int <= not update_q4;

   VitalBehavior1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         q3b <= ind_ipd;
         q2b <= q3b;
         q1b <= q2b;
         q0b <= q1b;
         q3 <= outd3_ipd;
         q2 <= o_q3b;
         q1 <= o_q2b;
         q0 <= o_q1b;
      END IF;
   END PROCESS;

   VitalBehavior2 : PROCESS (ck_ipd, update_int)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         IF (update_int = '1') THEN
            q3_zd <= q3b;
            q2_zd <= q2b;
            q1_zd <= q1b;
            q0_zd <= q0b;
         END IF;
      END IF;
   END PROCESS;

   VitalBehavior3 : PROCESS (update_int, q0, q1, q2, q3, outd0_ipd, outd1_ipd, outd2_ipd)
   VARIABLE q_zd : std_logic;
   BEGIN
      IF (update_int = '1') THEN
         o_q3b <= outd2_ipd;
         o_q2b <= outd1_ipd;
         o_q1b <= outd0_ipd;
      ELSE
         o_q3b <= q3;
         o_q2b <= q2;
         o_q1b <= q1;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (q0_zd, q1_zd, q2_zd, q3_zd, q0)
   VARIABLE inq0_zd   : std_logic := 'X';
   VARIABLE inq1_zd   : std_logic := 'X';
   VARIABLE inq2_zd   : std_logic := 'X';
   VARIABLE inq3_zd   : std_logic := 'X';
   VARIABLE outq_zd   : std_logic := 'X';
   -- output glitch detection VARIABLEs
   VARIABLE inq0_GlitchData     : VitalGlitchDataType;
   VARIABLE inq1_GlitchData     : VitalGlitchDataType;
   VARIABLE inq2_GlitchData     : VitalGlitchDataType;
   VARIABLE inq3_GlitchData     : VitalGlitchDataType;
   VARIABLE outq_GlitchData     : VitalGlitchDataType;

     -- timing check results
        VARIABLE tviol_ind     : x01 := '0';
        VARIABLE tviol_outd0   : x01 := '0';
        VARIABLE tviol_outd1   : x01 := '0';
        VARIABLE tviol_outd2   : x01 := '0';
        VARIABLE tviol_outd3   : x01 := '0';
        VARIABLE tviol_update  : x01 := '0';

        VARIABLE ind_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd0_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd1_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd2_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd3_ck_TimingDatash : VitalTimingDataType;
        VARIABLE update_ck_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => ind_ipd,
                TestSignalName => "ind",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_ind_ck_noedge_posedge,
                setuplow => tsetup_ind_ck_noedge_posedge,
                HoldHigh => thold_ind_ck_noedge_posedge,
                Holdlow => thold_ind_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ind_ck_TimingDatash,
                Violation => tviol_ind,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd0_ipd,
                TestSignalName => "outd0",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd0_ck_noedge_posedge,
                setuplow => tsetup_outd0_ck_noedge_posedge,
                HoldHigh => thold_outd0_ck_noedge_posedge,
                Holdlow => thold_outd0_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd0_ck_TimingDatash,
                Violation => tviol_outd0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd1_ipd,
                TestSignalName => "outd1",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd1_ck_noedge_posedge,
                setuplow => tsetup_outd1_ck_noedge_posedge,
                HoldHigh => thold_outd1_ck_noedge_posedge,
                Holdlow => thold_outd1_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd1_ck_TimingDatash,
                Violation => tviol_outd1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd2_ipd,
                TestSignalName => "outd2",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd2_ck_noedge_posedge,
                setuplow => tsetup_outd2_ck_noedge_posedge,
                HoldHigh => thold_outd2_ck_noedge_posedge,
                Holdlow => thold_outd2_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd2_ck_TimingDatash,
                Violation => tviol_outd2,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd3_ipd,
                TestSignalName => "outd3",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd3_ck_noedge_posedge,
                setuplow => tsetup_outd3_ck_noedge_posedge,
                HoldHigh => thold_outd3_ck_noedge_posedge,
                Holdlow => thold_outd3_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd3_ck_TimingDatash,
                Violation => tviol_outd3,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => update_ipd,
                TestSignalName => "update",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_update_ck_noedge_posedge,
                setuplow => tsetup_update_ck_noedge_posedge,
                HoldHigh => thold_update_ck_noedge_posedge,
                Holdlow => thold_update_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => update_ck_TimingDatash,
                Violation => tviol_update,
                MsgSeverity => warning);

   END IF;

   inq0_zd := q0_zd;
   inq1_zd := q1_zd;
   inq2_zd := q2_zd;
   inq3_zd := q3_zd;
   outq_zd := q0;

    VitalPathDelay01 (
        OutSignal  => inq0, OutSignalName => "inq0", OutTemp => inq0_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq0,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq0, TRUE)),
        GlitchData => inq0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq1, OutSignalName => "inq1", OutTemp => inq1_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq1,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq1, TRUE)),
        GlitchData => inq1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq2, OutSignalName => "inq2", OutTemp => inq2_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq2,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq2, TRUE)),
        GlitchData => inq2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq3, OutSignalName => "inq3", OutTemp => inq3_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq3,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq3, TRUE)),
        GlitchData => inq3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => outq, OutSignalName => "outq", OutTemp => outq_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_outq,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_outq, TRUE)),
        GlitchData => outq_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);

   END PROCESS;

END v;



--
----- cell hiosr2 (Two-Input I/O shift register) -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY hiosr2 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "hiosr2";
      tpd_ck_inq0     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq1     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq0 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq1 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_outq : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tsetup_ind_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_ind_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_outd0_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd0_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd1_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd1_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_update_ck_noedge_posedge : VitalDelayType := 0.01 ns;
      thold_update_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      tipd_ind        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd0      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd1      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_update     : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      ind, outd0, outd1, ck, update       : IN std_logic;
      inq0, inq1, outq      : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF hiosr2 : ENTITY IS TRUE;

END hiosr2 ;

-- architecture body --
ARCHITECTURE v OF hiosr2 IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL q0b          : std_logic := '0';
    SIGNAL q1b          : std_logic := '0';
    SIGNAL q0           : std_logic := '0';
    SIGNAL q1           : std_logic := '0';
    SIGNAL q0_zd          : std_logic := '0';
    SIGNAL q1_zd          : std_logic := '0';
    SIGNAL o_q1b          : std_logic := '0';
    SIGNAL o_q2b          : std_logic := '0';

    SIGNAL ind_ipd        : std_logic := '0';
    SIGNAL outd0_ipd      : std_logic := '0';
    SIGNAL outd1_ipd      : std_logic := '0';
    SIGNAL ck_ipd         : std_logic := '0';
    SIGNAL ck_int         : std_logic := '0';
    SIGNAL update_ipd     : std_logic := '0';
    SIGNAL update_int     : std_logic := '0';
    SIGNAL update_q2      : std_logic := '1';
    SIGNAL update_q1      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(ind_ipd, ind, tipd_ind);
       VitalWireDelay(outd0_ipd, outd0, tipd_outd0);
       VitalWireDelay(outd1_ipd, outd1, tipd_outd1);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
       VitalWireDelay(update_ipd, update, tipd_update);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------
   ck_int <= not ck_ipd;

   P1 : PROCESS (ck_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         IF (update_ipd = '1') THEN
            update_q2 <= '1';
            update_q1 <= '0';
          ELSIF (update_ipd = '0') THEN
            update_q2 <= update_q1;
            update_q1 <= update_q2;
          END IF;
      END IF;
   END PROCESS;

   update_int <= not update_q2;

   VitalBehavior1 : PROCESS (ck_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         q1b <= ind_ipd;
         q0b <= q1b;
         q0 <= o_q1b;
         q1 <= o_q2b;
      END IF;
   END PROCESS;

   VitalBehavior2 : PROCESS (ck_int, update_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         IF (update_int = '1') THEN
            q1_zd <= q1b;
            q0_zd <= q0b;
         END IF;
      END IF;
   END PROCESS;

   VitalBehavior3 : PROCESS (update_int, q1, outd0_ipd, outd1_ipd)
   BEGIN
      IF (update_int = '1') THEN
         o_q1b <= outd0_ipd;
         o_q2b <= outd1_ipd;
      ELSE
         o_q1b <= q1;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (q0_zd, q1_zd, q0)

   VARIABLE inq0_zd   : std_logic := 'X';
   VARIABLE inq1_zd   : std_logic := 'X';
   VARIABLE outq_zd   : std_logic := 'X';
   -- output glitch detection VARIABLEs
   VARIABLE inq0_GlitchData     : VitalGlitchDataType;
   VARIABLE inq1_GlitchData     : VitalGlitchDataType;
   VARIABLE outq_GlitchData     : VitalGlitchDataType;

     -- timing check results
        VARIABLE tviol_ind     : x01 := '0';
        VARIABLE tviol_outd0   : x01 := '0';
        VARIABLE tviol_outd1   : x01 := '0';
        VARIABLE tviol_update  : x01 := '0';

        VARIABLE ind_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd0_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd1_ck_TimingDatash : VitalTimingDataType;
        VARIABLE update_ck_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => ind_ipd,
                TestSignalName => "ind",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_ind_ck_noedge_posedge,
                setuplow => tsetup_ind_ck_noedge_posedge,
                HoldHigh => thold_ind_ck_noedge_posedge,
                Holdlow => thold_ind_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ind_ck_TimingDatash,
                Violation => tviol_ind,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd0_ipd,
                TestSignalName => "outd0",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd0_ck_noedge_posedge,
                setuplow => tsetup_outd0_ck_noedge_posedge,
                HoldHigh => thold_outd0_ck_noedge_posedge,
                Holdlow => thold_outd0_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd0_ck_TimingDatash,
                Violation => tviol_outd0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => outd1_ipd,
                TestSignalName => "outd1",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd1_ck_noedge_posedge,
                setuplow => tsetup_outd1_ck_noedge_posedge,
                HoldHigh => thold_outd1_ck_noedge_posedge,
                Holdlow => thold_outd1_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd1_ck_TimingDatash,
                Violation => tviol_outd1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (  
                TestSignal => update_ipd,
                TestSignalName => "update",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_update_ck_noedge_posedge,
                setuplow => tsetup_update_ck_noedge_posedge,
                HoldHigh => thold_update_ck_noedge_posedge,
                Holdlow => thold_update_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => update_ck_TimingDatash,
                Violation => tviol_update,
                MsgSeverity => warning);

   END IF;
   
   inq0_zd := q0_zd;
   inq1_zd := q1_zd;
   outq_zd := q0;

    VitalPathDelay01 (
        OutSignal  => inq0, OutSignalName => "inq0", OutTemp => inq0_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq0,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq0, TRUE)),
        GlitchData => inq0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq1, OutSignalName => "inq1", OutTemp => inq1_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq1,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq1, TRUE)),
        GlitchData => inq1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => outq, OutSignalName => "outq", OutTemp => outq_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_outq,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_outq, TRUE)),
        GlitchData => outq_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);

   END PROCESS;
END v;


--
----- cell hiosr4 (Four-Input I/O shift register) -----
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY hiosr4 IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "hiosr4";
      tpd_ck_inq0     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq1     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq2     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_inq3     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq     : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq0 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq1 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq2 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_inq3 : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_update_outq : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tsetup_ind_ck_noedge_posedge    : VitalDelayType := 0.01 ns;
      thold_ind_ck_noedge_posedge     : VitalDelayType := 0.01 ns;
      tsetup_outd0_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd0_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd1_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd1_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd2_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd2_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_outd3_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      thold_outd3_ck_noedge_posedge   : VitalDelayType := 0.01 ns;
      tsetup_update_ck_noedge_posedge : VitalDelayType := 0.01 ns;
      thold_update_ck_noedge_posedge  : VitalDelayType := 0.01 ns;
      tipd_ind        : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd0      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd1      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd2      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_outd3      : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_update     : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      ind, outd0, outd1, outd2, outd3, ck, update       : IN std_logic;
      inq0, inq1, inq2, inq3, outq      : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF hiosr4 : ENTITY IS TRUE;

END hiosr4 ;

-- architecture body --
ARCHITECTURE v OF hiosr4 IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL q0b          : std_logic := '0';
    SIGNAL q1b          : std_logic := '0';
    SIGNAL q2b          : std_logic := '0';
    SIGNAL q3b          : std_logic := '0';
    SIGNAL q0           : std_logic := '0';
    SIGNAL q1           : std_logic := '0';
    SIGNAL q2           : std_logic := '0';
    SIGNAL q3           : std_logic := '0';
    SIGNAL q0_zd          : std_logic := '0';
    SIGNAL q1_zd          : std_logic := '0';
    SIGNAL q2_zd          : std_logic := '0';
    SIGNAL q3_zd          : std_logic := '0';
    SIGNAL o_q1b          : std_logic := '0';
    SIGNAL o_q2b          : std_logic := '0';
    SIGNAL o_q3b          : std_logic := '0';

    SIGNAL ind_ipd        : std_logic := '0';
    SIGNAL outd0_ipd      : std_logic := '0';
    SIGNAL outd1_ipd      : std_logic := '0';
    SIGNAL outd2_ipd      : std_logic := '0';
    SIGNAL outd3_ipd      : std_logic := '0';
    SIGNAL ck_ipd         : std_logic := '0';
    SIGNAL ck_int         : std_logic := '0';
    SIGNAL update_ipd     : std_logic := '0';
    SIGNAL update_int     : std_logic := '0';
    SIGNAL update_q4      : std_logic := '1';
    SIGNAL update_q3      : std_logic := '1';
    SIGNAL update_q2      : std_logic := '1';
    SIGNAL update_q1      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(ind_ipd, ind, tipd_ind);
       VitalWireDelay(outd0_ipd, outd0, tipd_outd0);
       VitalWireDelay(outd1_ipd, outd1, tipd_outd1);
       VitalWireDelay(outd2_ipd, outd2, tipd_outd2);
       VitalWireDelay(outd3_ipd, outd3, tipd_outd3);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
       VitalWireDelay(update_ipd, update, tipd_update);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------
   ck_int <= not ck_ipd;

   P1 : PROCESS (ck_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         IF (update_ipd = '1') THEN
            update_q4 <= '1';
            update_q3 <= '1';
            update_q2 <= '1';
            update_q1 <= '0';
          ELSIF (update_ipd = '0') THEN
            update_q4 <= update_q3;
            update_q3 <= update_q2;
            update_q2 <= update_q1;
            update_q1 <= update_q4;
          END IF;
      END IF;
   END PROCESS;

   update_int <= not update_q4;

   VitalBehavior1 : PROCESS (ck_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         q3b <= ind_ipd;
         q2b <= q3b;
         q1b <= q2b;
         q0b <= q1b;
         q3 <= outd3_ipd;
         q2 <= o_q3b;
         q1 <= o_q2b;
         q0 <= o_q1b;
      END IF;
   END PROCESS;

   VitalBehavior2 : PROCESS (ck_int, update_int)
   BEGIN
      IF (ck_int'event and ck_int = '1') THEN
         IF (update_int = '1') THEN
            q3_zd <= q3b;
            q2_zd <= q2b;
            q1_zd <= q1b;
            q0_zd <= q0b;
         END IF;
      END IF;
   END PROCESS;

   VitalBehavior3 : PROCESS (update_int, q0, q1, q2, q3, outd0_ipd, outd1_ipd, outd2_ipd)
   VARIABLE q_zd : std_logic;
   BEGIN
      IF (update_int = '1') THEN
         o_q3b <= outd2_ipd;
         o_q2b <= outd1_ipd;
         o_q1b <= outd0_ipd;
      ELSE
         o_q3b <= q3;
         o_q2b <= q2;
         o_q1b <= q1;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (q0_zd, q1_zd, q2_zd, q3_zd, q0)
   VARIABLE inq0_zd   : std_logic := 'X';
   VARIABLE inq1_zd   : std_logic := 'X';
   VARIABLE inq2_zd   : std_logic := 'X';
   VARIABLE inq3_zd   : std_logic := 'X';
   VARIABLE outq_zd   : std_logic := 'X';
   -- output glitch detection VARIABLEs
   VARIABLE inq0_GlitchData     : VitalGlitchDataType;
   VARIABLE inq1_GlitchData     : VitalGlitchDataType;
   VARIABLE inq2_GlitchData     : VitalGlitchDataType;
   VARIABLE inq3_GlitchData     : VitalGlitchDataType;
   VARIABLE outq_GlitchData     : VitalGlitchDataType;

     -- timing check results
        VARIABLE tviol_ind     : x01 := '0';
        VARIABLE tviol_outd0   : x01 := '0';
        VARIABLE tviol_outd1   : x01 := '0';
        VARIABLE tviol_outd2   : x01 := '0';
        VARIABLE tviol_outd3   : x01 := '0';
        VARIABLE tviol_update  : x01 := '0';

        VARIABLE ind_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd0_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd1_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd2_ck_TimingDatash : VitalTimingDataType;
        VARIABLE outd3_ck_TimingDatash : VitalTimingDataType;
        VARIABLE update_ck_TimingDatash : VitalTimingDataType;

     -- functionality results
        VARIABLE violation : x01 := '0';

   BEGIN

   -----------------------
   -- timing check section
   -----------------------
        IF (TimingChecksOn) THEN

           -- setup and hold checks
           VitalSetupHoldCheck (
                TestSignal => ind_ipd,
                TestSignalName => "ind",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_ind_ck_noedge_posedge,
                setuplow => tsetup_ind_ck_noedge_posedge,
                HoldHigh => thold_ind_ck_noedge_posedge,
                Holdlow => thold_ind_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => ind_ck_TimingDatash,
                Violation => tviol_ind,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd0_ipd,
                TestSignalName => "outd0",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd0_ck_noedge_posedge,
                setuplow => tsetup_outd0_ck_noedge_posedge,
                HoldHigh => thold_outd0_ck_noedge_posedge,
                Holdlow => thold_outd0_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd0_ck_TimingDatash,
                Violation => tviol_outd0,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd1_ipd,
                TestSignalName => "outd1",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd1_ck_noedge_posedge,
                setuplow => tsetup_outd1_ck_noedge_posedge,
                HoldHigh => thold_outd1_ck_noedge_posedge,
                Holdlow => thold_outd1_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd1_ck_TimingDatash,
                Violation => tviol_outd1,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd2_ipd,
                TestSignalName => "outd2",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd2_ck_noedge_posedge,
                setuplow => tsetup_outd2_ck_noedge_posedge,
                HoldHigh => thold_outd2_ck_noedge_posedge,
                Holdlow => thold_outd2_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd2_ck_TimingDatash,
                Violation => tviol_outd2,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => outd3_ipd,
                TestSignalName => "outd3",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_outd3_ck_noedge_posedge,
                setuplow => tsetup_outd3_ck_noedge_posedge,
                HoldHigh => thold_outd3_ck_noedge_posedge,
                Holdlow => thold_outd3_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => outd3_ck_TimingDatash,
                Violation => tviol_outd3,
                MsgSeverity => warning);
           VitalSetupHoldCheck (
                TestSignal => update_ipd,
                TestSignalName => "update",
                RefSignal => ck_ipd,
                RefSignalName => "ck",
                SetupHigh => tsetup_update_ck_noedge_posedge,
                setuplow => tsetup_update_ck_noedge_posedge,
                HoldHigh => thold_update_ck_noedge_posedge,
                Holdlow => thold_update_ck_noedge_posedge,
                CheckEnabled => TRUE,
                RefTransition => '/',
                MsgOn => MsgOn, XOn => XOn,
                HeaderMsg => InstancePath,
                TimingData => update_ck_TimingDatash,
                Violation => tviol_update,
                MsgSeverity => warning);

   END IF;

   inq0_zd := q0_zd;
   inq1_zd := q1_zd;
   inq2_zd := q2_zd;
   inq3_zd := q3_zd;
   outq_zd := q0;

    VitalPathDelay01 (
        OutSignal  => inq0, OutSignalName => "inq0", OutTemp => inq0_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq0,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq0, TRUE)),
        GlitchData => inq0_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq1, OutSignalName => "inq1", OutTemp => inq1_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq1,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq1, TRUE)),
        GlitchData => inq1_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq2, OutSignalName => "inq2", OutTemp => inq2_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq2,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq2, TRUE)),
        GlitchData => inq2_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => inq3, OutSignalName => "inq3", OutTemp => inq3_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_inq3,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_inq3, TRUE)),
        GlitchData => inq3_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => outq, OutSignalName => "outq", OutTemp => outq_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_outq,
                             PathCondition => TRUE),
                       1 => (update_ipd'last_event, tpd_update_outq, TRUE)),
        GlitchData => outq_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);

   END PROCESS;

END v;


--
----- cell iddr (I/O shift register in DDR mode)-----
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY iddr IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "iddr";
      tpd_ck_qp    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_qn    : VitalDelayType01 := (0.01 ns, 0.01 ns);
        -- input SIGNAL delays
      tipd_d       : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck      : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      d      : IN std_logic;
      ck     : IN std_logic;
      qp     : OUT std_logic;
      qn     : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF iddr : ENTITY IS TRUE;

END iddr ;

-- architecture body --
ARCHITECTURE v OF iddr IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL d_ipd        : std_logic := '0';
    SIGNAL ck_ipd       : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(d_ipd, d, tipd_d);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------

   VitalBehavior : PROCESS (ck_ipd, d_ipd)

   VARIABLE qp_zd   : std_logic := 'X';
   VARIABLE qn_zd   : std_logic := 'X';

   -- output glitch detection VARIABLEs
   VARIABLE qp_GlitchData     : VitalGlitchDataType;
   VARIABLE qn_GlitchData     : VitalGlitchDataType;

   BEGIN

    -----------------------------------
    -- functionality section.
    -----------------------------------

      IF (ck_ipd'event and ck_ipd = '1') THEN
         qp_zd := d_ipd;
      END IF;

      IF (ck_ipd'event and ck_ipd  = '0') THEN
         qn_zd := d_ipd;
      END IF;

    -----------------------------------
    -- path delay section.
    -----------------------------------
    VitalPathDelay01 (
        OutSignal  => qp, OutSignalName => "qp", OutTemp => qp_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_qp,
                             PathCondition => TRUE)),
        GlitchData => qp_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);
    VitalPathDelay01 (
        OutSignal  => qn, OutSignalName => "qn", OutTemp => qn_zd,
        Paths      => (0 => (InputChangeTime => ck_ipd'last_event,
                             PathDelay => tpd_ck_qn,
                             PathCondition => TRUE)),
        GlitchData => qn_GlitchData,
        Mode       => ondetect, XOn => XOn, MsgOn => MsgOn);

END PROCESS;

END v;


--
----- cell ioddr (I/O shift register in DDR mode)-----
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.vital_timing.all;
USE ieee.vital_primitives.all;

-- entity declaration --
ENTITY ioddr IS
   GENERIC(
      TimingChecksOn  : boolean := TRUE;
      XOn             : boolean := FALSE;
      MsgOn           : boolean := TRUE;
      InstancePath    : string := "ioddr";
      tpd_ck_in1q0    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in1q1    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in2q0    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in2q1    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in3q0    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in3q1    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in4q0    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_in4q1    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq0    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq1    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq2    : VitalDelayType01 := (0.01 ns, 0.01 ns);
      tpd_ck_outq3    : VitalDelayType01 := (0.01 ns, 0.01 ns);
        -- setup and hold constraints
      tsetup_ind0_cksr_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_ind0_cksr_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_ind1_cksr_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_ind1_cksr_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_ind2_cksr_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_ind2_cksr_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_ind3_cksr_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_ind3_cksr_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_ind0_cki_noedge_negedge       : VitalDelayType := 0.01 ns;
      thold_ind0_cki_noedge_negedge        : VitalDelayType := 0.01 ns;
      tsetup_ind1_cki_noedge_negedge       : VitalDelayType := 0.01 ns;
      thold_ind1_cki_noedge_negedge        : VitalDelayType := 0.01 ns;
      tsetup_ind2_cki_noedge_negedge       : VitalDelayType := 0.01 ns;
      thold_ind2_cki_noedge_negedge        : VitalDelayType := 0.01 ns;
      tsetup_ind3_cki_noedge_negedge       : VitalDelayType := 0.01 ns;
      thold_ind3_cki_noedge_negedge        : VitalDelayType := 0.01 ns;
      tsetup_out1d0_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out1d0_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out1d1_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out1d1_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out2d0_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out2d0_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out2d1_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out2d1_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out3d0_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out3d0_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out3d1_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out3d1_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out4d0_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out4d0_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
      tsetup_out4d1_ck_noedge_posedge      : VitalDelayType := 0.01 ns;
      thold_out4d1_ck_noedge_posedge       : VitalDelayType := 0.01 ns;
        -- input SIGNAL delays
      tipd_ind0       : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ind1       : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ind2       : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ind3       : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out1d0     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out1d1     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out2d0     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out2d1     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out3d0     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out3d1     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out4d0     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_out4d1     : VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_ck         : VitalDelayType01 := (0.0 ns, 0.0 ns));

   PORT(
      ind0      : IN std_logic;
      ind1      : IN std_logic;
      ind2      : IN std_logic;
      ind3      : IN std_logic;
      out1d0    : IN std_logic;
      out1d1    : IN std_logic;
      out2d0    : IN std_logic;
      out2d1    : IN std_logic;
      out3d0    : IN std_logic;
      out3d1    : IN std_logic;
      out4d0    : IN std_logic;
      out4d1    : IN std_logic;
      ck        : IN std_logic;
      in1q0     : OUT std_logic;
      in1q1     : OUT std_logic;
      in2q0     : OUT std_logic;
      in2q1     : OUT std_logic;
      in3q0     : OUT std_logic;
      in3q1     : OUT std_logic;
      in4q0     : OUT std_logic;
      in4q1     : OUT std_logic;
      outq0     : OUT std_logic;
      outq1     : OUT std_logic;
      outq2     : OUT std_logic;
      outq3     : OUT std_logic);

    ATTRIBUTE Vital_Level0 OF ioddr : ENTITY IS TRUE;

END ioddr ;

-- architecture body --
ARCHITECTURE v OF ioddr IS
    ATTRIBUTE Vital_Level0 OF v : ARCHITECTURE IS TRUE;

    SIGNAL ind0_ipd        : std_logic := '0';
    SIGNAL ind1_ipd        : std_logic := '0';
    SIGNAL ind2_ipd        : std_logic := '0';
    SIGNAL ind3_ipd        : std_logic := '0';
    SIGNAL out1d0_ipd      : std_logic := '0';
    SIGNAL out1d1_ipd      : std_logic := '0';
    SIGNAL out2d0_ipd      : std_logic := '0';
    SIGNAL out2d1_ipd      : std_logic := '0';
    SIGNAL out3d0_ipd      : std_logic := '0';
    SIGNAL out3d1_ipd      : std_logic := '0';
    SIGNAL out4d0_ipd      : std_logic := '0';
    SIGNAL out4d1_ipd      : std_logic := '0';
    SIGNAL ck_ipd          : std_logic := '0';

    SIGNAL out1d0_int      : std_logic := '0';
    SIGNAL out1d1_int      : std_logic := '0';
    SIGNAL out2d0_int      : std_logic := '0';
    SIGNAL out2d1_int      : std_logic := '0';
    SIGNAL out3d0_int      : std_logic := '0';
    SIGNAL out3d1_int      : std_logic := '0';
    SIGNAL out4d0_int      : std_logic := '0';
    SIGNAL out4d1_int      : std_logic := '0';

BEGIN

   ---------------------
   --  input path delays
   ---------------------
    WireDelay : BLOCK
    BEGIN
       VitalWireDelay(ind0_ipd, ind0, tipd_ind0);
       VitalWireDelay(ind1_ipd, ind1, tipd_ind1);
       VitalWireDelay(ind2_ipd, ind2, tipd_ind2);
       VitalWireDelay(ind3_ipd, ind3, tipd_ind3);
       VitalWireDelay(out1d0_ipd, out1d0, tipd_out1d0);
       VitalWireDelay(out1d1_ipd, out1d1, tipd_out1d1);
       VitalWireDelay(out2d0_ipd, out2d0, tipd_out2d0);
       VitalWireDelay(out2d1_ipd, out2d1, tipd_out2d1);
       VitalWireDelay(out3d0_ipd, out3d0, tipd_out3d0);
       VitalWireDelay(out3d1_ipd, out3d1, tipd_out3d1);
       VitalWireDelay(out4d0_ipd, out4d0, tipd_out4d0);
       VitalWireDelay(out4d1_ipd, out4d1, tipd_out4d1);
       VitalWireDelay(ck_ipd, ck, tipd_ck);
    END BLOCK;

   --------------------
   --  behavior section
   --------------------

   VitalBehavior1 : PROCESS (ck_ipd)
   BEGIN
      IF (ck_ipd'event and ck_ipd = '1') THEN
         out1d0_int <= out1d0_ipd;
         out1d1_int <= out1d1_ipd;
         out2d0_int <= out2d0_ipd;
         out2d1_int <= out2d1_ipd;
         out3d0_int <= out3d0_ipd;
         out3d1_int <= out3d1_ipd;
         out4d0_int <= out4d0_ipd;
         out4d1_int <= out4d1_ipd;
      END IF;
   END PROCESS;

   VitalBehavior : PROCESS (ck_ipd, ind0_ipd, ind1_ipd, ind2_ipd, ind3_ipd, out1d0_int, out1d1_int, out2d0_int, out2d1_int, out3d0_int, out3d1_int, out4d0_int, out4d1_int)

   VARIABLE tviol_ind0_sr     : X01 := '0';
   VARIABLE tviol_ind1_sr     : X01 := '0';
   VARIABLE tviol_ind2_sr     : X01 := '0';
   VARIABLE tviol_ind3_sr     : X01 := '0';
   VARIABLE tviol_ind0_i      : X01 := '0';
   VARIABLE tviol_ind1_i      : X01 := '0';
   VARIABLE tviol_ind2_i      : X01 := '0';
   VARIABLE tviol_ind3_i      : X01 := '0';
   VARIABLE tviol_out1d0      : X01 := '0';
   VARIABLE tviol_out1d1      : X01 := '0';
   VARIABLE tviol_out2d0      : X01 := '0';
   VARIABLE tviol_out2d1      : X01 := '0';
   VARIABLE tviol_out3d0      : X01 := '0';
   VARIABLE tviol_out3d1      : X01 := '0';
   VARIABLE tviol_out4d0      : X01 := '0';
   VARIABLE tviol_out4d1      : X01 := '0';
   VARIABLE ind0_cksr_TimingDatash  : VitalTimingDataType;
   VARIABLE ind1_cksr_TimingDatash  : VitalTimingDataType;
   VARIABLE ind2_cksr_TimingDatash  : VitalTimingDataType;
   VARIABLE ind3_cksr_TimingDatash  : VitalTimingDataType;
   VARIABLE ind0_cki_TimingDatash   : VitalTimingDataType;
   VARIABLE ind1_cki_TimingDatash   : VitalTimingDataType;
   VARIABLE ind2_cki_TimingDatash   : VitalTimingDataType;
   VARIABLE ind3_cki_TimingDatash   : VitalTimingDataType;
   VARIABLE out1d0_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out1d1_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out2d0_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out2d1_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out3d0_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out3d1_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out4d0_ck_TimingDatash  : VitalTimingDataType;
   VARIABLE out4d1_ck_TimingDatash  : VitalTimingDataType;

   VARIABLE in1q0_zd   : std_logic := 'X';
   VARIABLE in1q1_zd   : std_logic := 'X';
   VARIABLE in2q0_zd   : std_logic := 'X';
   VARIABLE in2q1_zd   : std_logic := 'X';
   VARIABLE in3q0_zd   : std_logic := 'X';
   VARIABLE in3q1_zd   : std_logic := 'X';
   VARIABLE in4q0_zd   : std_logic := 'X';
   VARIABLE in4q1_zd   : std_logic := 'X';
   VARIABLE outq0_zd   : std_logic := 'X';
   VARIABLE outq1_zd   : std_logic := 'X';
   VARIABLE outq2_zd   : std_logic := 'X';
   VARIABLE outq3_zd   : std_logic := 'X';

   -- output glitch detection VARIABLEs
   VARIABLE in1q0_GlitchData     : VitalGlitchDataType;
   VARIABLE in1q1_GlitchData     : VitalGlitchDataType;
   VARIABLE in2q0_GlitchData     : VitalGlitchDataType;
   VARIABLE in2q1_GlitchData     : VitalGlitchDataType;
   VARIABLE in3q0_GlitchData     : VitalGlitchDataType;
   VARIABLE in3q1_GlitchData     : VitalGlitchDataType;
   VARIABLE in4q0_GlitchData     : VitalGlitchDataType;
   VARIABLE in4q1_GlitchData     : VitalGlitchDataType;
   VARIABLE outq0_GlitchData     : VitalGlitchDataType;
   VARIABL